/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.CachingSemiGraph;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.PluginSetBuilder;
import com.intellij.ide.plugins.PluginSetBuilderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.lang.Java11Shim;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001a\u0010\u001e\u001a\u00020\u00182\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0!0 J\u0018\u0010\"\u001a\u00020\u00002\u0010\b\u0002\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010$J\u0016\u0010%\u001a\u00020&2\u000e\b\u0002\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040(J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0013\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0002\u00a2\u0006\u0002\u0010+JY\u0010,\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00042\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0004002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\n022\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020403H\u0000\u00a2\u0006\u0002\b5R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00040\u00040\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00066"}, d2={"Lcom/intellij/ide/plugins/PluginSetBuilder;", "", "unsortedPlugins", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "(Ljava/util/List;)V", "enabledModuleV2Ids", "Ljava/util/HashMap;", "", "enabledPluginIds", "Lcom/intellij/openapi/extensions/PluginId;", "graph", "Lcom/intellij/ide/plugins/CachingSemiGraph;", "sortedModules", "", "[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "topologicalComparator", "Ljava/util/Comparator;", "topologicalSorter", "Lcom/intellij/util/graph/DFSTBuilder;", "kotlin.jvm.PlatformType", "getUnsortedPlugins", "()Ljava/util/List;", "checkModules", "", "descriptor", "isDebugLogEnabled", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "checkPluginCycles", "errors", "", "Ljava/util/function/Supplier;", "computeEnabledModuleMap", "disabler", "Ljava/util/function/Predicate;", "createPluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "incompletePlugins", "", "getEnabledModules", "getSortedPlugins", "()[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "initEnableState", "idMap", "", "disabledRequired", "", "disabledPlugins", "", "", "Lcom/intellij/ide/plugins/PluginLoadingError;", "initEnableState$intellij_platform_core_impl", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginSetBuilder {
    private final CachingSemiGraph<IdeaPluginDescriptorImpl> graph;
    private final IdeaPluginDescriptorImpl[] sortedModules;
    private final DFSTBuilder<IdeaPluginDescriptorImpl> topologicalSorter;
    private final Comparator<IdeaPluginDescriptorImpl> topologicalComparator;
    private final HashMap<PluginId, IdeaPluginDescriptorImpl> enabledPluginIds;
    private final HashMap<String, IdeaPluginDescriptorImpl> enabledModuleV2Ids;
    @NotNull
    private final List<IdeaPluginDescriptorImpl> unsortedPlugins;

    /*
     * WARNING - void declaration
     */
    public final void checkPluginCycles(@NotNull List<Supplier<String>> errors2) {
        Intrinsics.checkNotNullParameter(errors2, (String)"errors");
        if (this.topologicalSorter.isAcyclic()) {
            return;
        }
        for (Collection component2 : this.topologicalSorter.getComponents()) {
            void $this$forEach$iv;
            if (component2.size() < 2) continue;
            Iterator iterator2 = component2.iterator();
            while (iterator2.hasNext()) {
                IdeaPluginDescriptorImpl plugin2;
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = plugin2 = (IdeaPluginDescriptorImpl)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"plugin");
                ideaPluginDescriptorImpl.setEnabled(false);
            }
            Collection collection = component2;
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"component");
            String pluginsString2 = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)", ", null, null, (int)0, null, (Function1)checkPluginCycles.pluginsString.1.INSTANCE, (int)30, null);
            errors2.add(PluginSetBuilderKt.access$message("plugin.loading.error.plugins.cannot.be.loaded.because.they.form.a.dependency.cycle", pluginsString2));
            StringBuilder detailedMessage = new StringBuilder();
            Function1 pluginToString2 = checkPluginCycles.pluginToString.1.INSTANCE;
            detailedMessage.append("Detected plugin dependencies cycle details (only related dependencies are included):\n");
            Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)component2), (Function1)((Function1)new Function1<IdeaPluginDescriptorImpl, Pair<? extends IdeaPluginDescriptorImpl, ? extends String>>(pluginToString2){
                final /* synthetic */ Function1 $pluginToString;

                @NotNull
                public final Pair<IdeaPluginDescriptorImpl, String> invoke(IdeaPluginDescriptorImpl it) {
                    IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"it");
                    return new Pair((Object)it, this.$pluginToString.invoke((Object)ideaPluginDescriptorImpl));
                }
                {
                    this.$pluginToString = function1;
                    super(1);
                }
            }));
            Comparator comparator2 = Comparator.comparing(checkPluginCycles.2.INSTANCE, StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
            Intrinsics.checkNotNullExpressionValue(comparator2, (String)"Comparator.comparing({ i\u2026g.CASE_INSENSITIVE_ORDER)");
            Sequence sequence2 = SequencesKt.sortedWith((Sequence)sequence, comparator2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                Pair it = (Pair)element$iv;
                boolean bl = false;
                detailedMessage.append("  ").append((String)it.getSecond()).append(" depends on:\n");
                Object object = it.getFirst();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.first");
                Sequence sequence3 = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.graph.getIn((IdeaPluginDescriptorImpl)object)), (Function1)((Function1)new Function1<IdeaPluginDescriptorImpl, Boolean>(this, detailedMessage, component2, pluginToString2){
                    final /* synthetic */ PluginSetBuilder this$0;
                    final /* synthetic */ StringBuilder $detailedMessage$inlined;
                    final /* synthetic */ Collection $component$inlined;
                    final /* synthetic */ Function1 $pluginToString$inlined;
                    {
                        this.this$0 = pluginSetBuilder;
                        this.$detailedMessage$inlined = stringBuilder;
                        this.$component$inlined = collection;
                        this.$pluginToString$inlined = function1;
                        super(1);
                    }

                    public final boolean invoke(@NotNull IdeaPluginDescriptorImpl o) {
                        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                        return this.$component$inlined.contains(o);
                    }
                })), (Function1)pluginToString2);
                Comparator comparator3 = String.CASE_INSENSITIVE_ORDER;
                Intrinsics.checkNotNullExpressionValue((Object)comparator3, (String)"java.lang.String.CASE_INSENSITIVE_ORDER");
                Sequence sequence4 = SequencesKt.sortedWith((Sequence)sequence3, (Comparator)comparator3);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String dep = (String)element$iv2;
                    boolean bl2 = false;
                    detailedMessage.append("    ").append(dep).append("\n");
                }
            }
            PluginManagerCore.getLogger().info(detailedMessage.toString());
        }
    }

    private final IdeaPluginDescriptorImpl[] getSortedPlugins() {
        Object2IntOpenHashMap pluginToNumber = new Object2IntOpenHashMap(this.unsortedPlugins.size());
        pluginToNumber.put((Object)PluginManagerCore.CORE_ID, 0);
        int number = 0;
        for (IdeaPluginDescriptorImpl module : this.sortedModules) {
            if (module.descriptorPath == null && !module.content.modules.isEmpty()) continue;
            pluginToNumber.putIfAbsent((Object)module.getPluginId(), number++);
        }
        Collection $this$toTypedArray$iv = this.unsortedPlugins;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = thisCollection$iv.toArray(new IdeaPluginDescriptorImpl[0]);
        if (ideaPluginDescriptorImplArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        IdeaPluginDescriptorImpl[] sorted = ideaPluginDescriptorImplArray;
        Arrays.sort(sorted, new Comparator(pluginToNumber){
            final /* synthetic */ Object2IntOpenHashMap $pluginToNumber;

            public final int compare(IdeaPluginDescriptorImpl o1, IdeaPluginDescriptorImpl o2) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = o1;
                Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"o1");
                int n = this.$pluginToNumber.getInt((Object)ideaPluginDescriptorImpl.getPluginId());
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl2 = o2;
                Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl2, (String)"o2");
                return n - this.$pluginToNumber.getInt((Object)ideaPluginDescriptorImpl2.getPluginId());
            }
            {
                this.$pluginToNumber = object2IntOpenHashMap;
            }
        });
        return sorted;
    }

    private final List<IdeaPluginDescriptorImpl> getEnabledModules() {
        ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>(this.sortedModules.length);
        for (IdeaPluginDescriptorImpl module : this.sortedModules) {
            if (!(module.moduleName == null ? module.isEnabled() : this.enabledModuleV2Ids.containsKey(module.moduleName))) continue;
            result2.add(module);
        }
        return result2;
    }

    @NotNull
    public final PluginSetBuilder computeEnabledModuleMap(@Nullable Predicate<IdeaPluginDescriptorImpl> disabler) {
        ArrayList<String> logMessages = new ArrayList<String>();
        block0: for (IdeaPluginDescriptorImpl module : this.sortedModules) {
            if (module.moduleName == null ? Intrinsics.areEqual((Object)module.getPluginId(), (Object)PluginManagerCore.CORE_ID) ^ true && (!module.isEnabled() || disabler != null && disabler.test(module)) : !this.enabledPluginIds.containsKey(module.getPluginId())) continue;
            for (ModuleDependenciesDescriptor.ModuleReference moduleReference : module.dependencies.modules) {
                if (this.enabledModuleV2Ids.containsKey(moduleReference.name)) continue;
                String string = module.moduleName;
                logMessages.add("Module " + (string != null ? (Comparable)((Object)string) : (Comparable)module.getPluginId()) + " is not enabled because dependency " + moduleReference.name + " is not available");
                continue block0;
            }
            for (ModuleDependenciesDescriptor.PluginReference pluginReference : module.dependencies.plugins) {
                if (this.enabledPluginIds.containsKey(pluginReference.id)) continue;
                String string = module.moduleName;
                logMessages.add("Module " + (string != null ? (Comparable)((Object)string) : (Comparable)module.getPluginId()) + " is not enabled because dependency " + pluginReference.id + " is not available");
                continue block0;
            }
            if (module.moduleName == null) {
                this.enabledPluginIds.put(module.getPluginId(), module);
                for (PluginId pluginId : module.modules) {
                    this.enabledPluginIds.put(pluginId, module);
                }
                if (module.packagePrefix == null) continue;
                this.enabledModuleV2Ids.put(module.getPluginId().getIdString(), module);
                continue;
            }
            this.enabledModuleV2Ids.put(module.moduleName, module);
        }
        if (!logMessages.isEmpty()) {
            PluginManagerCore.getLogger().info(CollectionsKt.joinToString$default((Iterable)logMessages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        return this;
    }

    public static /* synthetic */ PluginSetBuilder computeEnabledModuleMap$default(PluginSetBuilder pluginSetBuilder, Predicate predicate2, int n, Object object) {
        if ((n & 1) != 0) {
            predicate2 = null;
        }
        return pluginSetBuilder.computeEnabledModuleMap(predicate2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PluginSet createPluginSet(@NotNull Collection<IdeaPluginDescriptorImpl> incompletePlugins) {
        void destination$iv;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(incompletePlugins, (String)"incompletePlugins");
        Java11Shim java11Shim = Java11Shim.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)java11Shim, (String)"Java11Shim.INSTANCE");
        Java11Shim java11Shim2 = java11Shim;
        List allPlugins = null;
        Object[] sortedPlugins = this.getSortedPlugins();
        if (incompletePlugins.isEmpty()) {
            ImmutableList immutableList = ContainerUtil.immutableList((Object[])Arrays.copyOf(sortedPlugins, sortedPlugins.length));
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"ContainerUtil.immutableList(*sortedPlugins)");
            allPlugins = (List)immutableList;
        } else {
            ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>(sortedPlugins.length + incompletePlugins.size());
            CollectionsKt.addAll((Collection)result2, (Object[])sortedPlugins);
            result2.addAll(incompletePlugins);
            List list2 = java11Shim2.copyOfCollection((Collection)result2);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"java11Shim.copyOfCollection(result)");
            allPlugins = list2;
        }
        Object[] objectArray = sortedPlugins;
        Collection collection = new ArrayList(sortedPlugins.length);
        Java11Shim java11Shim3 = java11Shim2;
        boolean $i$f$filterTo = false;
        void var9_10 = $this$filterTo$iv;
        int n = ((void)var9_10).length;
        for (int j = 0; j < n; ++j) {
            void element$iv;
            void it = element$iv = var9_10[j];
            boolean bl = false;
            if (!it.isEnabled()) continue;
            destination$iv.add(element$iv);
        }
        void var16_16 = destination$iv;
        List list3 = java11Shim3.copyOfCollection((Collection)var16_16);
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"java11Shim.copyOfCollect\u2026.size)) { it.isEnabled })");
        List enabledPlugins = list3;
        IdentityHashMap moduleToSortedDirectDependencies = new IdentityHashMap(this.graph.moduleToDirectDependencies.size());
        this.graph.moduleToDirectDependencies.forEach(new BiConsumer(this, moduleToSortedDirectDependencies){
            final /* synthetic */ PluginSetBuilder this$0;
            final /* synthetic */ IdentityHashMap $moduleToSortedDirectDependencies;

            public final void accept(@NotNull IdeaPluginDescriptorImpl k, @NotNull List<IdeaPluginDescriptorImpl> v) {
                Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                Intrinsics.checkNotNullParameter(v, (String)"v");
                Collection $this$toTypedArray$iv = v;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = thisCollection$iv.toArray(new IdeaPluginDescriptorImpl[0]);
                if (ideaPluginDescriptorImplArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                IdeaPluginDescriptorImpl[] list2 = ideaPluginDescriptorImplArray;
                Arrays.sort(list2, PluginSetBuilder.access$getTopologicalComparator$p(this.this$0));
                this.$moduleToSortedDirectDependencies.put(k, list2);
            }
            {
                this.this$0 = pluginSetBuilder;
                this.$moduleToSortedDirectDependencies = identityHashMap;
            }
        });
        Map map2 = java11Shim2.copyOf((Map)this.enabledModuleV2Ids);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"java11Shim.copyOf(enabledModuleV2Ids)");
        Map map3 = java11Shim2.copyOf((Map)this.enabledPluginIds);
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"java11Shim.copyOf(enabledPluginIds)");
        List list4 = java11Shim2.copyOfCollection((Collection)this.getEnabledModules());
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"java11Shim.copyOfCollection(getEnabledModules())");
        Map map4 = java11Shim2.copyOf((Map)moduleToSortedDirectDependencies);
        Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"java11Shim.copyOf(module\u2026SortedDirectDependencies)");
        return new PluginSet(allPlugins, enabledPlugins, map2, map3, list4, map4);
    }

    public static /* synthetic */ PluginSet createPluginSet$default(PluginSetBuilder pluginSetBuilder, Collection collection, int n, Object object) {
        if ((n & 1) != 0) {
            List list2 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"Collections.emptyList()");
            collection = list2;
        }
        return pluginSetBuilder.createPluginSet(collection);
    }

    public final void checkModules(@NotNull IdeaPluginDescriptorImpl descriptor2, boolean isDebugLogEnabled, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        block0: for (PluginContentDescriptor.ModuleItem item : descriptor2.content.modules) {
            for (ModuleDependenciesDescriptor.ModuleReference moduleReference : item.requireDescriptor().dependencies.modules) {
                if (this.enabledModuleV2Ids.containsKey(moduleReference.name)) continue;
                if (!isDebugLogEnabled) continue block0;
                log.info("Module " + item.name + " is not enabled because dependency " + moduleReference.name + " is not available");
                continue block0;
            }
            for (ModuleDependenciesDescriptor.PluginReference pluginReference : item.requireDescriptor().dependencies.plugins) {
                if (this.enabledPluginIds.containsKey(pluginReference.id)) continue;
                if (!isDebugLogEnabled) continue block0;
                log.info("Module " + item.name + " is not enabled because dependency " + pluginReference.id + " is not available");
                continue block0;
            }
            this.enabledModuleV2Ids.put(item.name, descriptor2);
        }
    }

    public final boolean initEnableState$intellij_platform_core_impl(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Set<IdeaPluginDescriptorImpl> disabledRequired, @NotNull Set<PluginId> disabledPlugins, @NotNull Map<PluginId, PluginLoadingError> errors2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(idMap, (String)"idMap");
        Intrinsics.checkNotNullParameter(disabledRequired, (String)"disabledRequired");
        Intrinsics.checkNotNullParameter(disabledPlugins, (String)"disabledPlugins");
        Intrinsics.checkNotNullParameter(errors2, (String)"errors");
        boolean notifyUser2 = !descriptor2.isImplementationDetail();
        for (PluginId pluginId : descriptor2.incompatibilities) {
            if (!this.enabledPluginIds.containsKey(pluginId) || disabledPlugins.contains(pluginId)) continue;
            String string = pluginId.getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"incompatibleId.idString");
            String presentableName = string;
            errors2.put(descriptor2.getPluginId(), new PluginLoadingError(descriptor2, PluginSetBuilderKt.access$message("plugin.loading.error.long.ide.contains.conflicting.module", descriptor2.getName(), presentableName), PluginSetBuilderKt.access$message("plugin.loading.error.short.ide.contains.conflicting.module", presentableName), notifyUser2, null, 16, null));
            return false;
        }
        for (PluginDependency pluginDependency : descriptor2.pluginDependencies) {
            PluginId depId = pluginDependency.getPluginId();
            if (pluginDependency.isOptional() || this.enabledPluginIds.containsKey(depId)) continue;
            IdeaPluginDescriptorImpl dep = idMap.get(depId);
            if (dep != null && disabledPlugins.contains(depId)) {
                disabledRequired.add(dep);
            }
            PluginSetBuilderKt.access$addCannotLoadError(descriptor2, errors2, notifyUser2, depId, dep);
            return false;
        }
        for (ModuleDependenciesDescriptor.PluginReference pluginReference : descriptor2.dependencies.plugins) {
            if (this.enabledPluginIds.containsKey(pluginReference.id)) continue;
            IdeaPluginDescriptorImpl dep = idMap.get(pluginReference.id);
            if (dep != null && disabledPlugins.contains(pluginReference.id)) {
                disabledRequired.add(dep);
            }
            PluginSetBuilderKt.access$addCannotLoadError(descriptor2, errors2, notifyUser2, pluginReference.id, dep);
            return false;
        }
        for (ModuleDependenciesDescriptor.ModuleReference moduleReference : descriptor2.dependencies.modules) {
            if (this.enabledModuleV2Ids.containsKey(moduleReference.name)) continue;
            errors2.put(descriptor2.getPluginId(), new PluginLoadingError(descriptor2, PluginSetBuilderKt.access$message("plugin.loading.error.long.depends.on.not.installed.plugin", descriptor2.getName(), moduleReference.name), PluginSetBuilderKt.access$message("plugin.loading.error.short.depends.on.not.installed.plugin", moduleReference.name), notifyUser2, null, 16, null));
            return false;
        }
        return true;
    }

    @NotNull
    public final List<IdeaPluginDescriptorImpl> getUnsortedPlugins() {
        return this.unsortedPlugins;
    }

    public PluginSetBuilder(@NotNull List<IdeaPluginDescriptorImpl> unsortedPlugins) {
        Intrinsics.checkNotNullParameter(unsortedPlugins, (String)"unsortedPlugins");
        this.unsortedPlugins = unsortedPlugins;
        this.graph = CachingSemiGraph.Companion.createModuleGraph(this.unsortedPlugins);
        Collection $this$toTypedArray$iv = this.graph.nodes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = thisCollection$iv.toArray(new IdeaPluginDescriptorImpl[0]);
        if (ideaPluginDescriptorImplArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.sortedModules = ideaPluginDescriptorImplArray;
        this.topologicalSorter = new DFSTBuilder((Object[])this.sortedModules.clone(), null, true, (DFSTBuilder.DFSTBuilderAwareGraph)this.graph);
        this.topologicalComparator = CachingSemiGraph.Companion.getTopologicalComparator(this.topologicalSorter);
        this.enabledPluginIds = new HashMap(this.unsortedPlugins.size());
        this.enabledModuleV2Ids = new HashMap(this.unsortedPlugins.size() * 2);
        Arrays.sort(this.sortedModules, this.topologicalComparator);
    }

    public static final /* synthetic */ Comparator access$getTopologicalComparator$p(PluginSetBuilder $this) {
        return $this.topologicalComparator;
    }
}

