/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.ImplementationConflictException;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.BootstrapBundle;
import com.intellij.ide.plugins.PluginConflictReporter;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.Main;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StartupAbortedException
extends RuntimeException {
    public StartupAbortedException(@NotNull String message2, @NotNull Throwable cause) {
        if (message2 == null) {
            StartupAbortedException.$$$reportNull$$$0(0);
        }
        if (cause == null) {
            StartupAbortedException.$$$reportNull$$$0(1);
        }
        super(message2, cause);
    }

    public static void processException(@NotNull Throwable t) {
        if (t == null) {
            StartupAbortedException.$$$reportNull$$$0(2);
        }
        if (LoadingState.COMPONENTS_LOADED.isOccurred() && !(t instanceof StartupAbortedException)) {
            if (!(t instanceof ControlFlowException)) {
                PluginManagerCore.getLogger().error(t);
            }
            return;
        }
        StartupAbortedException.logAndExit(t, null);
    }

    public static void logAndExit(@NotNull Throwable t, @Nullable Logger log) {
        ImplementationConflictException conflictException;
        PluginException pluginException;
        PluginId pluginId;
        PluginManagerCore.EssentialPluginMissingException essentialPluginMissingException;
        if (t == null) {
            StartupAbortedException.$$$reportNull$$$0(3);
        }
        if ((essentialPluginMissingException = StartupAbortedException.findCause(t, PluginManagerCore.EssentialPluginMissingException.class)) != null && essentialPluginMissingException.pluginIds != null) {
            Main.showMessage((String)BootstrapBundle.message((String)"bootstrap.error.title.corrupted.installation", (Object[])new Object[0]), (String)BootstrapBundle.message((String)"bootstrap.error.message.missing.essential.plugins.0.1.please.reinstall.2", (Object[])new Object[]{essentialPluginMissingException.pluginIds.size(), essentialPluginMissingException.pluginIds.stream().sorted().collect(Collectors.joining("\n  ", "  ", "\n\n")), StartupAbortedException.getProductNameSafe()}), (boolean)true);
            System.exit(12);
        }
        PluginId pluginId2 = pluginId = (pluginException = StartupAbortedException.findCause(t, PluginException.class)) != null ? pluginException.getPluginId() : null;
        if ((log != null || Logger.isInitialized()) && !(t instanceof ProcessCanceledException)) {
            try {
                (log == null ? PluginManagerCore.getLogger() : log).error(t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (t instanceof StackOverflowError && "Nashorn AST Serializer".equals(Thread.currentThread().getName())) {
                return;
            }
        }
        if (LoadingState.COMPONENTS_REGISTERED.isOccurred() && (conflictException = StartupAbortedException.findCause(t, ImplementationConflictException.class)) != null) {
            PluginConflictReporter pluginConflictReporter = (PluginConflictReporter)ApplicationManager.getApplication().getService(PluginConflictReporter.class);
            pluginConflictReporter.reportConflict(conflictException.getConflictingPluginIds(), conflictException.isConflictWithPlatform());
        }
        if (pluginId != null && !ApplicationInfoImpl.getShadowInstance().isEssentialPlugin(pluginId)) {
            PluginManagerCore.disablePlugin(pluginId);
            StringWriter message2 = new StringWriter();
            message2.append(BootstrapBundle.message((String)"bootstrap.error.message.plugin.0.failed.to.initialize.and.will.be.disabled.please.restart.1", (Object[])new Object[]{pluginId.getIdString(), StartupAbortedException.getProductNameSafe()}));
            message2.append("\n\n");
            Throwable cause = pluginException.getCause();
            ((Throwable)Objects.requireNonNullElse(cause, pluginException)).printStackTrace(new PrintWriter(message2));
            Main.showMessage((String)BootstrapBundle.message((String)"bootstrap.error.title.plugin.error", (Object[])new Object[0]), (String)message2.toString(), (boolean)false);
            System.exit(8);
        } else {
            Main.showMessage((String)BootstrapBundle.message((String)"bootstrap.error.title.start.failed", (Object[])new Object[0]), (Throwable)t);
            System.exit(3);
        }
    }

    private static String getProductNameSafe() {
        try {
            return ApplicationNamesInfo.getInstance().getFullProductName();
        }
        catch (Throwable ignore) {
            return "the IDE";
        }
    }

    private static <T extends Throwable> T findCause(Throwable t, Class<T> clazz) {
        while (t != null) {
            if (clazz.isInstance(t)) {
                return (T)((Throwable)clazz.cast(t));
            }
            t = t.getCause();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/StartupAbortedException";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processException";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "logAndExit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

