/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"FULL_PLUGINS_XML_IDS_FILENAME", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getETagFile", "Ljava/nio/file/Path;", "file", "isNotModified", "", "urlConnection", "Ljava/net/URLConnection;", "loadETagForFile", "logWarnOrPrintIfDebug", "", "message", "throwable", "", "saveETagForFile", "eTag", "intellij.platform.ide.impl"})
public final class MarketplaceRequestsKt {
    private static final Logger LOG;
    private static final String FULL_PLUGINS_XML_IDS_FILENAME = "pluginsXMLIds.json";

    private static final String loadETagForFile(Path file2) {
        Path eTagFile = MarketplaceRequestsKt.getETagFile(file2);
        try {
            List<String> lines2 = Files.readAllLines(eTagFile);
            if (lines2.size() == 1) {
                String string = lines2.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lines[0]");
                return string;
            }
            LOG.warn("Can't load ETag from '" + eTagFile + "'. Unexpected number of lines: " + lines2.size());
            Files.deleteIfExists(eTagFile);
        }
        catch (NoSuchFileException lines2) {
        }
        catch (IOException e) {
            LOG.warn("Can't load ETag from '" + eTagFile + '\'', (Throwable)e);
        }
        return "";
    }

    private static final Path getETagFile(Path file2) {
        Path path2 = file2.getParent().resolve(file2.getFileName() + ".etag");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file.parent.resolve(\"${file.fileName}.etag\")");
        return path2;
    }

    private static final void saveETagForFile(Path file2, String eTag) {
        Path eTagFile = MarketplaceRequestsKt.getETagFile(file2);
        try {
            PathKt.write$default((Path)eTagFile, (CharSequence)eTag, null, (boolean)false, (int)6, null);
        }
        catch (IOException e) {
            LOG.warn("Can't save ETag to '" + eTagFile + '\'', (Throwable)e);
        }
    }

    private static final boolean isNotModified(URLConnection urlConnection, Path file2) {
        return file2 != null && PathKt.exists((Path)file2) && Files.size(file2) > 0L && urlConnection instanceof HttpURLConnection && ((HttpURLConnection)urlConnection).getResponseCode() == 304;
    }

    private static final void logWarnOrPrintIfDebug(String message2, Throwable throwable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message2, throwable);
        } else {
            LOG.warn(message2 + ": " + throwable.getMessage());
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MarketplaceRequests.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$logWarnOrPrintIfDebug(String message2, Throwable throwable) {
        MarketplaceRequestsKt.logWarnOrPrintIfDebug(message2, throwable);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ String access$loadETagForFile(Path file2) {
        return MarketplaceRequestsKt.loadETagForFile(file2);
    }

    public static final /* synthetic */ boolean access$isNotModified(URLConnection urlConnection, Path file2) {
        return MarketplaceRequestsKt.isNotModified(urlConnection, file2);
    }

    public static final /* synthetic */ void access$saveETagForFile(Path file2, String eTag) {
        MarketplaceRequestsKt.saveETagForFile(file2, eTag);
    }
}

