/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.certificates.PluginCertificateStore;
import com.intellij.ide.plugins.marketplace.PluginSignatureChecker;
import com.intellij.ide.plugins.marketplace.statistics.PluginManagerUsageCollector;
import com.intellij.ide.plugins.marketplace.statistics.enums.DialogAcceptanceResultEnum;
import com.intellij.ide.plugins.marketplace.statistics.enums.SignatureVerificationResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.signer.CertificateUtils;
import org.jetbrains.zip.signer.verifier.InvalidSignatureResult;
import org.jetbrains.zip.signer.verifier.MissingSignatureResult;
import org.jetbrains.zip.signer.verifier.SuccessfulVerificationResult;
import org.jetbrains.zip.signer.verifier.ZipVerificationResult;
import org.jetbrains.zip.signer.verifier.ZipVerifier;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000b\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0003J\b\u0010\u001a\u001a\u00020\u000bH\u0002J;\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u000b2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0 \"\u00020\rH\u0002\u00a2\u0006\u0002\u0010!J(\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0002J(\u0010$\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0002J\u001a\u0010%\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010&\u001a\u00020\bH\u0002J\"\u0010'\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u000bH\u0007J3\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u001d2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0 \"\u00020\rH\u0003\u00a2\u0006\u0002\u0010*R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rf\u0010\u0006\u001aZ\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000b \t*\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n \t*,\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000b \t*\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006+"}, d2={"Lcom/intellij/ide/plugins/marketplace/PluginSignatureChecker;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "jetBrainsCertificateRevokedCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "Ljava/util/Optional;", "", "jetbrainsCertificate", "Ljava/security/cert/Certificate;", "getJetbrainsCertificate", "()Ljava/security/cert/Certificate;", "jetbrainsCertificate$delegate", "Lkotlin/Lazy;", "getRevocationLists", "", "Ljava/security/cert/X509CRL;", "certs", "Ljava/security/cert/X509Certificate;", "getSignatureWarningMessage", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "isJetBrainsCertificateRevoked", "isSignedBy", "pluginFile", "Ljava/io/File;", "showAcceptDialog", "certificate", "", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptor;Ljava/io/File;Z[Ljava/security/cert/Certificate;)Z", "isSignedInBackground", "certificates", "isSignedInWithAcceptDialog", "processSignatureCheckerVerdict", "message", "verify", "verifyPluginAndGetErrorMessage", "file", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptor;Ljava/io/File;[Ljava/security/cert/Certificate;)Ljava/lang/String;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class PluginSignatureChecker {
    private static final Logger LOG;
    private static final Cache<String, Optional<Boolean>> jetBrainsCertificateRevokedCache;
    private static final Lazy jetbrainsCertificate$delegate;
    @NotNull
    public static final PluginSignatureChecker INSTANCE;

    private final Certificate getJetbrainsCertificate() {
        Lazy lazy = jetbrainsCertificate$delegate;
        PluginSignatureChecker pluginSignatureChecker = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Certificate)lazy.getValue();
    }

    @JvmStatic
    public static final boolean verify(@NotNull IdeaPluginDescriptor descriptor2, @NotNull File pluginFile, boolean showAcceptDialog) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        List list2 = PluginCertificateStore.INSTANCE.getCustomTrustManager().getCertificates();
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        List certificates = CollectionsKt.plus((Collection)list3, (Iterable)PluginCertificateStore.INSTANCE.getManagedTrustedCertificates());
        return showAcceptDialog ? INSTANCE.isSignedInWithAcceptDialog(descriptor2, pluginFile, certificates) : INSTANCE.isSignedInBackground(descriptor2, pluginFile, certificates);
    }

    public static /* synthetic */ boolean verify$default(IdeaPluginDescriptor ideaPluginDescriptor, File file2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return PluginSignatureChecker.verify(ideaPluginDescriptor, file2, bl);
    }

    private final boolean isSignedInBackground(IdeaPluginDescriptor descriptor2, File pluginFile, List<? extends Certificate> certificates) {
        Object object;
        Certificate certificate = this.getJetbrainsCertificate();
        if (certificate == null) {
            return false;
        }
        Certificate jbCert = certificate;
        PluginSignatureChecker pluginSignatureChecker = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            Object $this$runCatching = pluginSignatureChecker;
            boolean bl2 = false;
            $this$runCatching = ((PluginSignatureChecker)$this$runCatching).isJetBrainsCertificateRevoked();
            boolean bl3 = false;
            object = Result.constructor-impl((Object)$this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
        }
        pluginSignatureChecker = object;
        bl = false;
        Boolean bl5 = (Boolean)((Object)(Result.isFailure-impl((Object)pluginSignatureChecker) ? null : pluginSignatureChecker));
        if (bl5 == null) {
            return false;
        }
        boolean isRevoked = bl5;
        if (isRevoked) {
            LOG.info("Plugin " + pluginFile.getName() + " has revoked JetBrains certificate");
            return false;
        }
        List allCerts = CollectionsKt.plus((Collection)certificates, (Object)jbCert);
        Collection $this$toTypedArray$iv = allCerts;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Certificate[] certificateArray = thisCollection$iv.toArray(new Certificate[0]);
        if (certificateArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return this.isSignedBy(descriptor2, pluginFile, false, Arrays.copyOf(certificateArray, certificateArray.length));
    }

    static /* synthetic */ boolean isSignedInBackground$default(PluginSignatureChecker pluginSignatureChecker, IdeaPluginDescriptor ideaPluginDescriptor, File file2, List list2, int n, Object object) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return pluginSignatureChecker.isSignedInBackground(ideaPluginDescriptor, file2, list2);
    }

    private final boolean isSignedInWithAcceptDialog(IdeaPluginDescriptor descriptor2, File pluginFile, List<? extends Certificate> certificates) {
        boolean bl;
        Certificate certificate = this.getJetbrainsCertificate();
        if (certificate == null) {
            String string = IdeBundle.message((String)"jetbrains.certificate.not.found", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"jetbr\u2026s.certificate.not.found\")");
            return this.processSignatureCheckerVerdict(descriptor2, string);
        }
        Certificate jbCert = certificate;
        try {
            bl = this.isJetBrainsCertificateRevoked();
        }
        catch (IllegalArgumentException e) {
            String string = e.getMessage();
            if (string == null) {
                String string2 = IdeBundle.message((String)"jetbrains.certificate.invalid", (Object[])new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeBundle.message(\"jetbrains.certificate.invalid\")");
            }
            String message2 = string;
            return this.processSignatureCheckerVerdict(descriptor2, message2);
        }
        boolean isRevoked = bl;
        if (isRevoked) {
            LOG.info("Plugin " + pluginFile.getName() + " has revoked JetBrains certificate");
            String string = IdeBundle.message((String)"plugin.signature.checker.revoked.cert", (Object[])new Object[]{descriptor2.getName()});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"plugi\u2026d.cert\", descriptor.name)");
            String message3 = string;
            return this.processSignatureCheckerVerdict(descriptor2, message3);
        }
        List allCerts = CollectionsKt.plus((Collection)certificates, (Object)jbCert);
        Collection $this$toTypedArray$iv = allCerts;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Certificate[] certificateArray = thisCollection$iv.toArray(new Certificate[0]);
        if (certificateArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return this.isSignedBy(descriptor2, pluginFile, true, Arrays.copyOf(certificateArray, certificateArray.length));
    }

    static /* synthetic */ boolean isSignedInWithAcceptDialog$default(PluginSignatureChecker pluginSignatureChecker, IdeaPluginDescriptor ideaPluginDescriptor, File file2, List list2, int n, Object object) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return pluginSignatureChecker.isSignedInWithAcceptDialog(ideaPluginDescriptor, file2, list2);
    }

    private final boolean isJetBrainsCertificateRevoked() {
        List<X509CRL> lists;
        List cert509Lists;
        X509Certificate revokedCertificates;
        Boolean isRevokedCached;
        Optional optional = (Optional)jetBrainsCertificateRevokedCache.getIfPresent((Object)this.getClass().getName());
        Boolean bl = isRevokedCached = optional != null ? (Boolean)optional.get() : null;
        if (isRevokedCached != null) {
            return isRevokedCached;
        }
        Certificate certificate = this.getJetbrainsCertificate();
        if (!(certificate instanceof X509Certificate)) {
            certificate = null;
        }
        boolean isRevoked = (revokedCertificates = CertificateUtils.findRevokedCertificate((List)(cert509Lists = CollectionsKt.listOfNotNull((Object)((X509Certificate)certificate))), lists = this.getRevocationLists(cert509Lists))) != null;
        jetBrainsCertificateRevokedCache.put((Object)this.getClass().getName(), Optional.of(isRevoked));
        return isRevoked;
    }

    /*
     * WARNING - void declaration
     */
    private final List<X509CRL> getRevocationLists(List<? extends X509Certificate> certs) {
        void $this$mapNotNullTo$iv$iv;
        List<? extends X509Certificate> certsExceptCA = certs.subList(0, certs.size() - 1);
        Iterable $this$mapNotNull$iv = certsExceptCA;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            X509CRL x509CRL;
            InputStream inputStream2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            X509Certificate certificate = (X509Certificate)element$iv$iv;
            boolean bl2 = false;
            List crlUris = CertificateUtils.getCrlUris((X509Certificate)certificate);
            if (crlUris.isEmpty()) {
                LOG.error("CRL not found for certificate");
                throw (Throwable)new IllegalArgumentException("CRL not found for certificate");
            }
            if (crlUris.size() > 1) {
                LOG.error("Multiple CRL URI found in certificate");
                throw (Throwable)new IllegalArgumentException("Multiple CRL URI found in certificate");
            }
            URI crlURI = (URI)CollectionsKt.first((List)crlUris);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            CRL cRL = certificateFactory.generateCRL(inputStream2 = (InputStream)HttpRequests.request((String)crlURI.toURL().toExternalForm()).throwStatusCodeException(false).productNameAsUserAgent().connect((HttpRequests.RequestProcessor)getRevocationLists.1.inputStream.1.INSTANCE));
            if (!(cRL instanceof X509CRL)) {
                cRL = null;
            }
            if ((X509CRL)cRL == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            X509CRL it$iv$iv = x509CRL;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isSignedBy(IdeaPluginDescriptor descriptor2, File pluginFile, boolean showAcceptDialog, Certificate ... certificate) {
        String errorMessage = this.verifyPluginAndGetErrorMessage(descriptor2, pluginFile, Arrays.copyOf(certificate, certificate.length));
        if (errorMessage != null && showAcceptDialog) {
            return this.processSignatureCheckerVerdict(descriptor2, errorMessage);
        }
        return errorMessage == null;
    }

    static /* synthetic */ boolean isSignedBy$default(PluginSignatureChecker pluginSignatureChecker, IdeaPluginDescriptor ideaPluginDescriptor, File file2, boolean bl, Certificate[] certificateArray, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return pluginSignatureChecker.isSignedBy(ideaPluginDescriptor, file2, bl, certificateArray);
    }

    @Nls
    @ExperimentalUnsignedTypes
    private final String verifyPluginAndGetErrorMessage(IdeaPluginDescriptor descriptor2, File file2, Certificate ... certificates) {
        String string;
        ZipVerificationResult verificationResult = ZipVerifier.verify((File)file2);
        if (verificationResult instanceof InvalidSignatureResult) {
            PluginManagerUsageCollector.Companion.signatureCheckResult(descriptor2, SignatureVerificationResult.INVALID_SIGNATURE);
            string = IdeBundle.message((String)"plugin.invalid.signature.result", (Object[])new Object[]{descriptor2.getName(), ((InvalidSignatureResult)verificationResult).getErrorMessage()});
        } else if (verificationResult instanceof MissingSignatureResult) {
            PluginManagerUsageCollector.Companion.signatureCheckResult(descriptor2, SignatureVerificationResult.MISSING_SIGNATURE);
            string = this.getSignatureWarningMessage(descriptor2);
        } else if (verificationResult instanceof SuccessfulVerificationResult) {
            boolean isSigned;
            block9: {
                boolean bl;
                Certificate[] $this$any$iv = certificates;
                boolean $i$f$any = false;
                Certificate[] certificateArray = $this$any$iv;
                int n = certificateArray.length;
                for (int j = 0; j < n; ++j) {
                    Certificate element$iv;
                    Certificate certificate = element$iv = certificateArray[j];
                    boolean bl2 = false;
                    if (!(certificate instanceof X509Certificate && ((SuccessfulVerificationResult)verificationResult).isSignedBy((X509Certificate)certificate))) continue;
                    bl = true;
                    break block9;
                }
                bl = isSigned = false;
            }
            if (!isSigned) {
                PluginManagerUsageCollector.Companion.signatureCheckResult(descriptor2, SignatureVerificationResult.WRONG_SIGNATURE);
                string = this.getSignatureWarningMessage(descriptor2);
            } else {
                PluginManagerUsageCollector.Companion.signatureCheckResult(descriptor2, SignatureVerificationResult.SUCCESSFUL);
                string = null;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Nls
    private final String getSignatureWarningMessage(IdeaPluginDescriptor descriptor2) {
        CharSequence charSequence = descriptor2.getOrganization();
        boolean bl = false;
        boolean bl2 = false;
        String vendor = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? descriptor2.getVendor() : descriptor2.getOrganization();
        CharSequence charSequence2 = vendor;
        bl2 = false;
        boolean bl3 = false;
        String vendorMessage = charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2) ? vendor : IdeBundle.message((String)"jetbrains.certificate.vendor", (Object[])new Object[]{vendor});
        Object[] objectArray = new Object[4];
        objectArray[0] = descriptor2.getName();
        PluginId pluginId = descriptor2.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"descriptor.pluginId");
        objectArray[1] = pluginId.getIdString();
        objectArray[2] = descriptor2.getVersion();
        objectArray[3] = vendorMessage;
        String string = IdeBundle.message((String)"plugin.signature.not.signed", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\n     \u2026      vendorMessage\n    )");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean processSignatureCheckerVerdict(IdeaPluginDescriptor descriptor2, @Nls String message2) {
        void result2;
        String string = IdeBundle.message((String)"plugin.signature.checker.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"plugi\u2026signature.checker.title\")");
        String title2 = string;
        String string2 = IdeBundle.message((String)"plugin.signature.checker.yes", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeBundle.message(\"plugin.signature.checker.yes\")");
        String yesText = string2;
        String string3 = IdeBundle.message((String)"plugin.signature.checker.no", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IdeBundle.message(\"plugin.signature.checker.no\")");
        String noText = string3;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = -1;
        ApplicationManager.getApplication().invokeAndWait(new Runnable((Ref.IntRef)result2, message2, title2, yesText, noText){
            final /* synthetic */ Ref.IntRef $result;
            final /* synthetic */ String $message;
            final /* synthetic */ String $title;
            final /* synthetic */ String $yesText;
            final /* synthetic */ String $noText;

            public final void run() {
                this.$result.element = Messages.showYesNoDialog((String)this.$message, (String)this.$title, (String)this.$yesText, (String)this.$noText, (Icon)Messages.getWarningIcon());
            }
            {
                this.$result = intRef;
                this.$message = string;
                this.$title = string2;
                this.$yesText = string3;
                this.$noText = string4;
            }
        }, ModalityState.any());
        PluginManagerUsageCollector.Companion.signatureWarningShown(descriptor2, result2.element == 0 ? DialogAcceptanceResultEnum.ACCEPTED : DialogAcceptanceResultEnum.DECLINED);
        return result2.element == 0;
    }

    private PluginSignatureChecker() {
    }

    static {
        PluginSignatureChecker pluginSignatureChecker;
        INSTANCE = pluginSignatureChecker = new PluginSignatureChecker();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PluginSignatureChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        jetBrainsCertificateRevokedCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
        jetbrainsCertificate$delegate = LazyKt.lazy((Function0)jetbrainsCertificate.2.INSTANCE);
    }

    public static final /* synthetic */ Logger access$getLOG$p(PluginSignatureChecker $this) {
        PluginSignatureChecker pluginSignatureChecker = $this;
        return LOG;
    }
}

