/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.CustomPluginRepositoryService;
import com.intellij.ide.plugins.DynamicPluginEnabler;
import com.intellij.ide.plugins.DynamicPluginEnablerState;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginEnableDisableAction;
import com.intellij.ide.plugins.PluginEnabledState;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstallOperation;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.newui.BgProgressIndicator;
import com.intellij.ide.plugins.newui.InstallPluginInfo;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.ProjectDependentPluginEnabledState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MyPluginModel
extends InstalledPluginsTableModel
implements PluginEnabler {
    private static final Logger LOG = Logger.getInstance(MyPluginModel.class);
    private final List<ListPluginComponent> myInstalledPluginComponents = new ArrayList<ListPluginComponent>();
    private final Map<PluginId, List<ListPluginComponent>> myInstalledPluginComponentMap = new HashMap<PluginId, List<ListPluginComponent>>();
    private final Map<PluginId, List<ListPluginComponent>> myMarketplacePluginComponentMap = new HashMap<PluginId, List<ListPluginComponent>>();
    private final List<PluginsGroup> myEnabledGroups = new ArrayList<PluginsGroup>();
    private PluginsGroupComponent myInstalledPanel;
    private PluginsGroup myDownloaded;
    private PluginsGroup myInstalling;
    private Configurable.TopComponentController myTopController;
    private SortedSet<String> myVendors;
    private SortedSet<String> myTags;
    private static final Set<IdeaPluginDescriptor> myInstallingPlugins = new HashSet<IdeaPluginDescriptor>();
    private static final Set<IdeaPluginDescriptor> myInstallingWithUpdatesPlugins = new HashSet<IdeaPluginDescriptor>();
    static final Map<PluginId, InstallPluginInfo> myInstallingInfos = new HashMap<PluginId, InstallPluginInfo>();
    public boolean needRestart;
    public boolean createShutdownCallback = true;
    private boolean myInstallsRequiringRestart;
    private final List<PluginDetailsPageComponent> myDetailPanels = new ArrayList<PluginDetailsPageComponent>();
    @Nullable
    private final StatusBarEx myStatusBar;
    private PluginUpdatesService myPluginUpdatesService;
    private Runnable myInvalidFixCallback;
    private Consumer<? super IdeaPluginDescriptor> myCancelInstallCallback;
    private final Map<PluginId, PendingDynamicPluginInstall> myDynamicPluginsToInstall = new LinkedHashMap<PluginId, PendingDynamicPluginInstall>();
    private final Set<IdeaPluginDescriptorImpl> myDynamicPluginsToUninstall = new HashSet<IdeaPluginDescriptorImpl>();
    private final Set<IdeaPluginDescriptorImpl> myPluginsToRemoveOnCancel = new HashSet<IdeaPluginDescriptorImpl>();
    private final Map<PluginId, Set<PluginId>> myDependentToRequiredListMap = new HashMap<PluginId, Set<PluginId>>();
    private final Map<IdeaPluginDescriptor, Pair<PluginEnableDisableAction, PluginEnabledState>> myDiff = new HashMap<IdeaPluginDescriptor, Pair<PluginEnableDisableAction, PluginEnabledState>>();
    private final Map<PluginId, Boolean> myRequiredPluginsForProject = new HashMap<PluginId, Boolean>();
    private final Map<IdeaPluginDescriptorImpl, Boolean> myRequiresRestart = new HashMap<IdeaPluginDescriptorImpl, Boolean>();
    private final Set<IdeaPluginDescriptor> myUninstalled = new HashSet<IdeaPluginDescriptor>();
    private final Set<PluginId> myErrorPluginsToDisable = new HashSet<PluginId>();
    private final Map<String, Icon> myIcons = new HashMap<String, Icon>();

    public MyPluginModel(@Nullable Project project) {
        super(project);
        Window window = ProjectUtil.getActiveFrameOrWelcomeScreen();
        StatusBarEx statusBar2 = MyPluginModel.getStatusBar(window);
        this.myStatusBar = statusBar2 != null || window == null ? statusBar2 : MyPluginModel.getStatusBar(window.getOwner());
        this.updatePluginDependencies(null);
    }

    @Nullable
    private static StatusBarEx getStatusBar(@Nullable Window frame) {
        return frame instanceof IdeFrame && !(frame instanceof WelcomeFrame) ? (StatusBarEx)((IdeFrame)frame).getStatusBar() : null;
    }

    public boolean isModified() {
        return this.needRestart || !this.myDynamicPluginsToInstall.isEmpty() || !this.myDynamicPluginsToUninstall.isEmpty() || !this.myPluginsToRemoveOnCancel.isEmpty() || !this.myDiff.isEmpty();
    }

    public boolean apply(@Nullable JComponent parent) throws ConfigurationException {
        boolean changesAppliedWithoutRestart;
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = PluginManagerCore.buildPluginIdMap();
        this.updatePluginDependencies(pluginIdMap);
        this.assertCanApply(pluginIdMap);
        PluginEnabler pluginEnabler = PluginEnabler.getInstance();
        DynamicPluginEnablerState pluginEnablerState = pluginEnabler instanceof DynamicPluginEnabler ? (DynamicPluginEnablerState)((DynamicPluginEnabler)pluginEnabler).getState() : null;
        HashSet<Object> uninstallsRequiringRestart = new HashSet<Object>();
        for (IdeaPluginDescriptorImpl pluginDescriptor : this.myDynamicPluginsToUninstall) {
            this.myDiff.remove(pluginDescriptor);
            PluginId pluginId = pluginDescriptor.getPluginId();
            if (!PluginInstaller.uninstallDynamicPlugin(parent, pluginDescriptor, false)) {
                uninstallsRequiringRestart.add(pluginId);
            } else {
                this.getEnabledMap().remove(pluginId);
            }
            if (pluginEnablerState == null) continue;
            pluginEnablerState.stopTracking(List.of(pluginId));
        }
        boolean installsRequiringRestart = this.myInstallsRequiringRestart;
        ArrayList dynamicPluginsRequiringRestart = new ArrayList();
        for (PendingDynamicPluginInstall pendingPluginInstall : this.myDynamicPluginsToInstall.values()) {
            PluginId pluginId = pendingPluginInstall.getPluginDescriptor().getPluginId();
            if (!uninstallsRequiringRestart.contains(pluginId)) {
                InstalledPluginsState.getInstance().trackPluginInstallation(() -> {
                    if (!PluginInstaller.installAndLoadDynamicPlugin(pendingPluginInstall.getFile(), parent, pendingPluginInstall.getPluginDescriptor())) {
                        dynamicPluginsRequiringRestart.add(pluginId);
                    }
                });
                continue;
            }
            try {
                PluginInstaller.installAfterRestart(pendingPluginInstall.getFile(), !Registry.is((String)"ide.plugins.keep.archive", (boolean)true), null, pendingPluginInstall.getPluginDescriptor());
                installsRequiringRestart = true;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myDynamicPluginsToInstall.clear();
        this.myPluginsToRemoveOnCancel.clear();
        boolean enableDisableAppliedWithoutRestart = this.applyEnableDisablePlugins(pluginEnabler, parent);
        this.myDynamicPluginsToUninstall.clear();
        this.myDiff.clear();
        boolean bl = changesAppliedWithoutRestart = enableDisableAppliedWithoutRestart && uninstallsRequiringRestart.isEmpty() && !installsRequiringRestart && dynamicPluginsRequiringRestart.isEmpty();
        if (!changesAppliedWithoutRestart) {
            InstalledPluginsState.getInstance().setRestartRequired(true);
        }
        return changesAppliedWithoutRestart;
    }

    public void clear(@Nullable JComponent parentComponent) {
        this.cancel(parentComponent);
        this.updateAfterEnableDisable();
    }

    public void cancel(@Nullable JComponent parentComponent) {
        this.myDiff.forEach((key, value2) -> this.setEnabled(key.getPluginId(), (PluginEnabledState)((Object)((Object)value2.getSecond()))));
        this.myDiff.clear();
        this.myPluginsToRemoveOnCancel.forEach(pluginDescriptor -> PluginInstaller.uninstallDynamicPlugin(parentComponent, pluginDescriptor, false));
        this.myPluginsToRemoveOnCancel.clear();
    }

    private boolean applyEnableDisablePlugins(@NotNull PluginEnabler pluginEnabler, @Nullable JComponent parentComponent) {
        if (pluginEnabler == null) {
            MyPluginModel.$$$reportNull$$$0(0);
        }
        EnumMap<PluginEnableDisableAction, List> descriptorsByAction = new EnumMap<PluginEnableDisableAction, List>(PluginEnableDisableAction.class);
        for (Map.Entry<IdeaPluginDescriptor, Pair<PluginEnableDisableAction, PluginEnabledState>> entry2 : this.myDiff.entrySet()) {
            IdeaPluginDescriptor descriptor2 = entry2.getKey();
            PluginId pluginId = descriptor2.getPluginId();
            Pair<PluginEnableDisableAction, PluginEnabledState> pair = entry2.getValue();
            PluginEnabledState oldState = (PluginEnabledState)((Object)pair.getSecond());
            PluginEnabledState newState2 = this.getState(pluginId);
            if (MyPluginModel.isDeleted(descriptor2) || MyPluginModel.isHiddenImplementationDetail(descriptor2) && newState2.isDisabled() || !this.isLoaded(pluginId) || oldState == newState2 && (!newState2.isDisabled() || !this.myErrorPluginsToDisable.contains(pluginId))) continue;
            descriptorsByAction.computeIfAbsent((PluginEnableDisableAction)((Object)pair.getFirst()), __ -> new ArrayList()).add(descriptor2);
        }
        boolean appliedWithoutRestart = true;
        for (Map.Entry entry3 : descriptorsByAction.entrySet()) {
            PluginEnableDisableAction action2 = entry3.getKey();
            List descriptors = (List)entry3.getValue();
            appliedWithoutRestart &= pluginEnabler instanceof DynamicPluginEnabler ? ((DynamicPluginEnabler)pluginEnabler).updatePluginsState(descriptors, action2, this.getProject(), parentComponent) : (action2.isEnable() ? pluginEnabler.enable(descriptors) : pluginEnabler.disable(descriptors));
        }
        return appliedWithoutRestart;
    }

    public void pluginInstalledFromDisk(@NotNull PluginInstallCallbackData callbackData) {
        if (callbackData == null) {
            MyPluginModel.$$$reportNull$$$0(1);
        }
        this.appendOrUpdateDescriptor(callbackData.getPluginDescriptor(), callbackData.getRestartNeeded());
        if (!callbackData.getRestartNeeded()) {
            this.myDynamicPluginsToInstall.put(callbackData.getPluginDescriptor().getPluginId(), new PendingDynamicPluginInstall(callbackData.getFile(), callbackData.getPluginDescriptor()));
        }
    }

    public void addComponent(@NotNull ListPluginComponent component2) {
        if (component2 == null) {
            MyPluginModel.$$$reportNull$$$0(2);
        }
        IdeaPluginDescriptor descriptor2 = component2.getPluginDescriptor();
        PluginId pluginId = descriptor2.getPluginId();
        if (!component2.isMarketplace()) {
            if (myInstallingPlugins.contains(descriptor2) && (this.myInstalling == null || this.myInstalling.ui == null || this.myInstalling.ui.findComponent(pluginId) == null)) {
                return;
            }
            this.myInstalledPluginComponents.add(component2);
            List components = this.myInstalledPluginComponentMap.computeIfAbsent(pluginId, __ -> new ArrayList());
            components.add(component2);
        } else {
            List components = this.myMarketplacePluginComponentMap.computeIfAbsent(pluginId, __ -> new ArrayList());
            components.add(component2);
        }
    }

    public void removeComponent(@NotNull ListPluginComponent component2) {
        if (component2 == null) {
            MyPluginModel.$$$reportNull$$$0(3);
        }
        PluginId pluginId = component2.getPluginDescriptor().getPluginId();
        if (!component2.isMarketplace()) {
            this.myInstalledPluginComponents.remove(component2);
            List<ListPluginComponent> components = this.myInstalledPluginComponentMap.get(pluginId);
            if (components != null) {
                components.remove(component2);
                if (components.isEmpty()) {
                    this.myInstalledPluginComponentMap.remove(pluginId);
                }
            }
        } else {
            List<ListPluginComponent> components = this.myMarketplacePluginComponentMap.get(pluginId);
            if (components != null) {
                components.remove(component2);
                if (components.isEmpty()) {
                    this.myMarketplacePluginComponentMap.remove(pluginId);
                }
            }
        }
    }

    public void setTopController(@NotNull Configurable.TopComponentController topController) {
        if (topController == null) {
            MyPluginModel.$$$reportNull$$$0(4);
        }
        this.myTopController = topController;
        this.myTopController.showProject(false);
        for (InstallPluginInfo info2 : myInstallingInfos.values()) {
            info2.fromBackground(this);
        }
        if (!myInstallingInfos.isEmpty()) {
            this.myTopController.showProgress(true);
        }
    }

    public void setPluginUpdatesService(@NotNull PluginUpdatesService service) {
        if (service == null) {
            MyPluginModel.$$$reportNull$$$0(5);
        }
        this.myPluginUpdatesService = service;
    }

    @Nullable
    public PluginsGroup getDownloadedGroup() {
        return this.myDownloaded;
    }

    @NotNull
    public static Set<IdeaPluginDescriptor> getInstallingPlugins() {
        Set<IdeaPluginDescriptor> set2 = myInstallingPlugins;
        if (set2 == null) {
            MyPluginModel.$$$reportNull$$$0(6);
        }
        return set2;
    }

    static boolean isInstallingOrUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(7);
        }
        return myInstallingWithUpdatesPlugins.contains(descriptor2);
    }

    void installOrUpdatePlugin(@Nullable JComponent parentComponent, final @NotNull IdeaPluginDescriptor descriptor2, @Nullable IdeaPluginDescriptor updateDescriptor, final @NotNull ModalityState modalityState) {
        IdeaPluginDescriptor actionDescriptor;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(8);
        }
        if (modalityState == null) {
            MyPluginModel.$$$reportNull$$$0(9);
        }
        final boolean isUpdate = updateDescriptor != null;
        IdeaPluginDescriptor ideaPluginDescriptor = actionDescriptor = isUpdate ? updateDescriptor : descriptor2;
        if (!PluginManagerMain.checkThirdPartyPluginsAllowed(List.of(actionDescriptor))) {
            return;
        }
        final Ref allowInstallWithoutRestart = Ref.create((Object)true);
        if (isUpdate) {
            IdeaPluginDescriptorImpl installedPluginDescriptor = (IdeaPluginDescriptorImpl)descriptor2;
            if (!DynamicPlugins.allowLoadUnloadWithoutRestart(installedPluginDescriptor)) {
                allowInstallWithoutRestart.set((Object)false);
            } else if (!installedPluginDescriptor.isEnabled()) {
                try {
                    FileUtil.delete((Path)installedPluginDescriptor.getPluginPath());
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            } else if (DynamicPlugins.allowLoadUnloadSynchronously(installedPluginDescriptor)) {
                allowInstallWithoutRestart.set((Object)PluginInstaller.uninstallDynamicPlugin(parentComponent, installedPluginDescriptor, true));
            } else {
                this.performUninstall(installedPluginDescriptor);
            }
        }
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(this.getProject(), parentComponent, IdeBundle.message((String)"progress.title.loading.plugin.details", (Object[])new Object[0]), true, null){

            public void run(@NotNull ProgressIndicator indicator2) {
                PluginNode pluginNode;
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((pluginNode = this.toPluginNode(actionDescriptor, indicator2)) == null) {
                    return;
                }
                List<PluginNode> pluginsToInstall = List.of(pluginNode);
                ApplicationManager.getApplication().invokeAndWait(() -> PluginManagerMain.suggestToEnableInstalledDependantPlugins(MyPluginModel.this, pluginsToInstall), modalityState);
                InstallPluginInfo info2 = new InstallPluginInfo((BgProgressIndicator)indicator2, descriptor2, MyPluginModel.this, !isUpdate);
                ApplicationManager.getApplication().invokeLater(() -> MyPluginModel.this.prepareToInstall(info2), modalityState);
                PluginInstallOperation operation = new PluginInstallOperation(pluginsToInstall, MyPluginModel.this.getCustomRepoPlugins(), MyPluginModel.this, indicator2);
                operation.setAllowInstallWithoutRestart((Boolean)allowInstallWithoutRestart.get());
                MyPluginModel.this.runInstallOperation(operation, info2, modalityState);
            }

            @Nullable
            private PluginNode toPluginNode(@NotNull IdeaPluginDescriptor descriptor22, @NotNull ProgressIndicator indicator2) {
                if (descriptor22 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (descriptor22 instanceof PluginNode) {
                    PluginNode pluginNode = (PluginNode)descriptor22;
                    return pluginNode.detailsLoaded() ? pluginNode : MarketplaceRequests.getInstance().loadPluginDetails(pluginNode, indicator2);
                }
                PluginNode pluginNode = new PluginNode(descriptor22.getPluginId(), descriptor22.getName(), "-1");
                pluginNode.setDependencies(descriptor22.getDependencies());
                pluginNode.setRepositoryName("__unknown_repository__");
                return pluginNode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/plugins/newui/MyPluginModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toPluginNode";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (ProgressIndicator)new BgProgressIndicator());
    }

    private void runInstallOperation(@NotNull PluginInstallOperation operation, @NotNull InstallPluginInfo info2, @NotNull ModalityState modalityState) {
        if (operation == null) {
            MyPluginModel.$$$reportNull$$$0(10);
        }
        if (info2 == null) {
            MyPluginModel.$$$reportNull$$$0(11);
        }
        if (modalityState == null) {
            MyPluginModel.$$$reportNull$$$0(12);
        }
        boolean cancel = false;
        boolean success2 = true;
        boolean showErrors2 = true;
        boolean restartRequired = true;
        ArrayList<PendingDynamicPluginInstall> pluginsToInstallSynchronously = new ArrayList<PendingDynamicPluginInstall>();
        try {
            operation.run();
            for (PendingDynamicPluginInstall install2 : operation.getPendingDynamicPluginInstalls()) {
                if (DynamicPlugins.allowLoadUnloadSynchronously(install2.getPluginDescriptor())) {
                    pluginsToInstallSynchronously.add(install2);
                    this.myPluginsToRemoveOnCancel.add(install2.getPluginDescriptor());
                    continue;
                }
                this.myDynamicPluginsToInstall.put(install2.getPluginDescriptor().getPluginId(), install2);
            }
            success2 = operation.isSuccess();
            showErrors2 = !operation.isShownErrors();
            restartRequired = operation.isRestartRequired();
        }
        catch (ProcessCanceledException e) {
            cancel = true;
        }
        catch (Throwable e) {
            LOG.error(e);
            success2 = false;
        }
        boolean _success = success2;
        boolean _cancel = cancel;
        boolean _showErrors = showErrors2;
        boolean _restartRequired = restartRequired;
        ApplicationManager.getApplication().invokeLater(() -> {
            boolean dynamicRestartRequired = false;
            for (PendingDynamicPluginInstall install2 : pluginsToInstallSynchronously) {
                boolean installedWithoutRestart = PluginInstaller.installAndLoadDynamicPlugin(install2.getFile(), (JComponent)((Object)this.myInstalledPanel), install2.getPluginDescriptor());
                if (installedWithoutRestart) {
                    IdeaPluginDescriptor installedDescriptor = PluginManagerCore.getPlugin(info2.getDescriptor().getPluginId());
                    if (installedDescriptor == null) continue;
                    info2.setInstalledDescriptor((IdeaPluginDescriptorImpl)installedDescriptor);
                    continue;
                }
                dynamicRestartRequired = true;
            }
            info2.finish(_success, _cancel, _showErrors, _restartRequired || dynamicRestartRequired);
        }, modalityState);
    }

    public boolean toBackground() {
        boolean result2;
        for (InstallPluginInfo info2 : myInstallingInfos.values()) {
            info2.toBackground(this.myStatusBar);
        }
        boolean bl = result2 = !myInstallingInfos.isEmpty();
        if (result2) {
            InstallPluginInfo.showRestart();
        }
        return result2;
    }

    private void prepareToInstall(@NotNull InstallPluginInfo info2) {
        List<ListPluginComponent> listComponents;
        List<ListPluginComponent> gridComponents;
        if (info2 == null) {
            MyPluginModel.$$$reportNull$$$0(13);
        }
        IdeaPluginDescriptor descriptor2 = info2.getDescriptor();
        PluginId pluginId = descriptor2.getPluginId();
        myInstallingInfos.put(pluginId, info2);
        if (myInstallingWithUpdatesPlugins.isEmpty()) {
            this.myTopController.showProgress(true);
        }
        myInstallingWithUpdatesPlugins.add(descriptor2);
        if (info2.install) {
            myInstallingPlugins.add(descriptor2);
        }
        if (info2.install && this.myInstalling != null) {
            if (this.myInstalling.ui == null) {
                this.myInstalling.descriptors.add(descriptor2);
                this.myInstalledPanel.addGroup(this.myInstalling, 0);
            } else {
                this.myInstalledPanel.addToGroup(this.myInstalling, descriptor2);
            }
            this.myInstalling.titleWithCount();
            this.myInstalledPanel.doLayout();
        }
        if ((gridComponents = this.myMarketplacePluginComponentMap.get(pluginId)) != null) {
            for (ListPluginComponent gridComponent : gridComponents) {
                gridComponent.showProgress();
            }
        }
        if ((listComponents = this.myInstalledPluginComponentMap.get(pluginId)) != null) {
            for (ListPluginComponent listComponent : listComponents) {
                listComponent.showProgress();
            }
        }
        for (PluginDetailsPageComponent panel2 : this.myDetailPanels) {
            if (panel2.getPlugin() != descriptor2) continue;
            panel2.showProgress();
        }
    }

    void finishInstall(@NotNull IdeaPluginDescriptor descriptor2, @Nullable IdeaPluginDescriptorImpl installedDescriptor, boolean success2, boolean showErrors2, boolean restartRequired) {
        List<ListPluginComponent> installedComponents;
        PluginId pluginId;
        List<ListPluginComponent> marketplaceComponents;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(14);
        }
        InstallPluginInfo info2 = MyPluginModel.finishInstall(descriptor2);
        if (myInstallingWithUpdatesPlugins.isEmpty()) {
            this.myTopController.showProgress(false);
        }
        if ((marketplaceComponents = this.myMarketplacePluginComponentMap.get(pluginId = descriptor2.getPluginId())) != null) {
            for (ListPluginComponent listPluginComponent : marketplaceComponents) {
                if (installedDescriptor != null) {
                    listPluginComponent.setPluginDescriptor(installedDescriptor);
                }
                listPluginComponent.hideProgress(success2, restartRequired);
            }
        }
        if ((installedComponents = this.myInstalledPluginComponentMap.get(pluginId)) != null) {
            for (ListPluginComponent listComponent : installedComponents) {
                if (installedDescriptor != null) {
                    listComponent.setPluginDescriptor(installedDescriptor);
                }
                listComponent.hideProgress(success2, restartRequired);
                listComponent.updateErrors();
            }
        }
        for (PluginDetailsPageComponent panel2 : this.myDetailPanels) {
            if (!panel2.isShowingPlugin(descriptor2)) continue;
            panel2.setPlugin(installedDescriptor);
            panel2.hideProgress(success2);
        }
        if (info2.install) {
            if (this.myInstalling != null && this.myInstalling.ui != null) {
                this.clearInstallingProgress(descriptor2);
                if (myInstallingPlugins.isEmpty()) {
                    this.myInstalledPanel.removeGroup(this.myInstalling);
                } else {
                    this.myInstalledPanel.removeFromGroup(this.myInstalling, descriptor2);
                    this.myInstalling.titleWithCount();
                }
                this.myInstalledPanel.doLayout();
            }
            if (success2) {
                this.appendOrUpdateDescriptor(installedDescriptor != null ? installedDescriptor : descriptor2, restartRequired);
                this.appendDependsAfterInstall();
            } else if (this.myCancelInstallCallback != null) {
                this.myCancelInstallCallback.accept((IdeaPluginDescriptor)descriptor2);
            }
        } else if (success2) {
            ListPluginComponent listPluginComponent;
            if (this.myDownloaded != null && this.myDownloaded.ui != null && restartRequired && (listPluginComponent = this.myDownloaded.ui.findComponent(pluginId)) != null) {
                listPluginComponent.enableRestart();
            }
        } else {
            this.myPluginUpdatesService.finishUpdate();
        }
        info2.indicator.cancel();
        if (success2) {
            this.needRestart = true;
            this.myInstallsRequiringRestart |= restartRequired;
        }
        if (!success2 && showErrors2) {
            Messages.showErrorDialog((Project)this.getProject(), (String)IdeBundle.message((String)"plugins.configurable.plugin.installing.failed", (Object[])new Object[]{descriptor2.getName()}), (String)IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]));
        }
    }

    private void clearInstallingProgress(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(15);
        }
        if (myInstallingPlugins.isEmpty()) {
            for (ListPluginComponent listComponent : this.myInstalling.ui.plugins) {
                listComponent.clearProgress();
            }
        } else {
            for (ListPluginComponent listComponent : this.myInstalling.ui.plugins) {
                if (listComponent.getPluginDescriptor() != descriptor2) continue;
                listComponent.clearProgress();
                return;
            }
        }
    }

    @NotNull
    static InstallPluginInfo finishInstall(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(16);
        }
        InstallPluginInfo info2 = myInstallingInfos.remove(descriptor2.getPluginId());
        info2.close();
        myInstallingWithUpdatesPlugins.remove(descriptor2);
        if (info2.install) {
            myInstallingPlugins.remove(descriptor2);
        }
        InstallPluginInfo installPluginInfo = info2;
        if (installPluginInfo == null) {
            MyPluginModel.$$$reportNull$$$0(17);
        }
        return installPluginInfo;
    }

    static void addProgress(@NotNull IdeaPluginDescriptor descriptor2, @NotNull ProgressIndicatorEx indicator2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(18);
        }
        if (indicator2 == null) {
            MyPluginModel.$$$reportNull$$$0(19);
        }
        MyPluginModel.myInstallingInfos.get((Object)descriptor2.getPluginId()).indicator.addStateDelegate(indicator2);
    }

    static void removeProgress(@NotNull IdeaPluginDescriptor descriptor2, @NotNull ProgressIndicatorEx indicator2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(20);
        }
        if (indicator2 == null) {
            MyPluginModel.$$$reportNull$$$0(21);
        }
        MyPluginModel.myInstallingInfos.get((Object)descriptor2.getPluginId()).indicator.removeStateDelegate(indicator2);
    }

    public void addEnabledGroup(@NotNull PluginsGroup group2) {
        if (group2 == null) {
            MyPluginModel.$$$reportNull$$$0(22);
        }
        this.myEnabledGroups.add(group2);
    }

    public void setDownloadedGroup(@NotNull PluginsGroupComponent panel2, @NotNull PluginsGroup downloaded, @NotNull PluginsGroup installing) {
        if (panel2 == null) {
            MyPluginModel.$$$reportNull$$$0(23);
        }
        if (downloaded == null) {
            MyPluginModel.$$$reportNull$$$0(24);
        }
        if (installing == null) {
            MyPluginModel.$$$reportNull$$$0(25);
        }
        this.myInstalledPanel = panel2;
        this.myDownloaded = downloaded;
        this.myInstalling = installing;
    }

    private void appendDependsAfterInstall() {
        if (this.myDownloaded == null || this.myDownloaded.ui == null) {
            return;
        }
        block0: for (IdeaPluginDescriptor descriptor2 : InstalledPluginsState.getInstance().getInstalledPlugins()) {
            PluginId pluginId = descriptor2.getPluginId();
            if (this.myDownloaded.ui.findComponent(pluginId) != null) continue;
            this.appendOrUpdateDescriptor(descriptor2, true);
            String id2 = pluginId.getIdString();
            for (Map.Entry<PluginId, List<ListPluginComponent>> entry2 : this.myMarketplacePluginComponentMap.entrySet()) {
                if (!id2.equals(entry2.getKey().getIdString())) continue;
                for (ListPluginComponent component2 : entry2.getValue()) {
                    component2.hideProgress(true, true);
                }
                continue block0;
            }
        }
    }

    public void addDetailPanel(@NotNull PluginDetailsPageComponent detailPanel) {
        if (detailPanel == null) {
            MyPluginModel.$$$reportNull$$$0(26);
        }
        this.myDetailPanels.add(detailPanel);
    }

    private void appendOrUpdateDescriptor(@NotNull IdeaPluginDescriptor descriptor2) {
        int index2;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(27);
        }
        if ((index2 = this.view.indexOf(descriptor2)) < 0) {
            this.view.add(descriptor2);
        } else {
            this.view.set(index2, descriptor2);
        }
    }

    void appendOrUpdateDescriptor(@NotNull IdeaPluginDescriptor descriptor2, boolean restartNeeded) {
        PluginId id2;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(28);
        }
        if (!PluginManagerCore.isPluginInstalled(id2 = descriptor2.getPluginId())) {
            this.appendOrUpdateDescriptor(descriptor2);
            this.setEnabled(id2, PluginEnabledState.ENABLED);
        }
        if (restartNeeded) {
            this.myInstallsRequiringRestart = true;
            this.needRestart = true;
        }
        if (this.myDownloaded == null) {
            return;
        }
        this.myVendors = null;
        this.myTags = null;
        if (this.myDownloaded.ui == null) {
            this.myDownloaded.descriptors.add(descriptor2);
            this.myDownloaded.titleWithEnabled(this);
            this.myInstalledPanel.addGroup(this.myDownloaded, this.myInstalling == null || this.myInstalling.ui == null ? 0 : 1);
            this.myInstalledPanel.setSelection(this.myDownloaded.ui.plugins.get(0));
            this.myInstalledPanel.doLayout();
            this.addEnabledGroup(this.myDownloaded);
        } else {
            ListPluginComponent component2 = this.myDownloaded.ui.findComponent(id2);
            if (component2 != null) {
                this.myInstalledPanel.setSelection(component2);
                component2.enableRestart();
                return;
            }
            this.myInstalledPanel.addToGroup(this.myDownloaded, descriptor2);
            this.myDownloaded.titleWithEnabled(this);
            this.myInstalledPanel.doLayout();
        }
    }

    @NotNull
    public SortedSet<String> getVendors() {
        if (ContainerUtil.isEmpty(this.myVendors)) {
            Map<String, Integer> vendorsCount = MyPluginModel.getVendorsCount(this.getInstalledDescriptors());
            this.myVendors = new TreeSet<String>((v1, v2) -> {
                int result2 = (Integer)vendorsCount.get(v2) - (Integer)vendorsCount.get(v1);
                return result2 == 0 ? v2.compareToIgnoreCase((String)v1) : result2;
            });
            this.myVendors.addAll(vendorsCount.keySet());
        }
        SortedSet<String> sortedSet = Collections.unmodifiableSortedSet(this.myVendors);
        if (sortedSet == null) {
            MyPluginModel.$$$reportNull$$$0(29);
        }
        return sortedSet;
    }

    @NotNull
    public SortedSet<String> getTags() {
        if (ContainerUtil.isEmpty(this.myTags)) {
            this.myTags = new TreeSet<String>(String::compareToIgnoreCase);
            for (IdeaPluginDescriptor descriptor2 : this.getInstalledDescriptors()) {
                this.myTags.addAll(PluginManagerConfigurable.getTags(descriptor2));
            }
        }
        SortedSet<String> sortedSet = Collections.unmodifiableSortedSet(this.myTags);
        if (sortedSet == null) {
            MyPluginModel.$$$reportNull$$$0(30);
        }
        return sortedSet;
    }

    @NotNull
    public List<IdeaPluginDescriptor> getInstalledDescriptors() {
        assert (this.myInstalledPanel != null);
        List<IdeaPluginDescriptor> list2 = this.myInstalledPanel.getGroups().stream().flatMap(group2 -> group2.plugins.stream()).map(ListPluginComponent::getPluginDescriptor).collect(Collectors.toList());
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(31);
        }
        return list2;
    }

    @NotNull
    private static Map<String, Integer> getVendorsCount(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        if (descriptors == null) {
            MyPluginModel.$$$reportNull$$$0(32);
        }
        HashMap<String, Integer> vendors = new HashMap<String, Integer>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors) {
            String vendor = StringUtil.trim((String)ideaPluginDescriptor.getVendor());
            if (StringUtil.isEmptyOrSpaces((String)vendor)) continue;
            vendors.compute(vendor, (__, old) -> (old != null ? old : 0) + 1);
        }
        HashMap<String, Integer> hashMap = vendors;
        if (hashMap == null) {
            MyPluginModel.$$$reportNull$$$0(33);
        }
        return hashMap;
    }

    public static boolean isVendor(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Set<String> vendors) {
        String vendor;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(34);
        }
        if (vendors == null) {
            MyPluginModel.$$$reportNull$$$0(35);
        }
        if (StringUtil.isEmpty((String)(vendor = StringUtil.trim((String)descriptor2.getVendor())))) {
            return false;
        }
        for (String vendorToFind : vendors) {
            if (!vendor.equalsIgnoreCase(vendorToFind) && !StringUtil.containsIgnoreCase((String)vendor, (String)vendorToFind)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(36);
        }
        return !this.isDisabled(descriptor2.getPluginId());
    }

    @NotNull
    public PluginEnabledState getState(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(37);
        }
        PluginEnabledState pluginEnabledState = this.getState(descriptor2.getPluginId());
        if (pluginEnabledState == null) {
            MyPluginModel.$$$reportNull$$$0(38);
        }
        return pluginEnabledState;
    }

    @NotNull
    ProjectDependentPluginEnabledState getProjectDependentState(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(39);
        }
        PluginId pluginId = descriptor2.getPluginId();
        return new ProjectDependentPluginEnabledState(pluginId, this.getState(pluginId), this.getProject());
    }

    @NotNull
    PluginEnabledState getState(@NotNull PluginId pluginId) {
        PluginEnabledState state;
        if (pluginId == null) {
            MyPluginModel.$$$reportNull$$$0(40);
        }
        PluginEnabledState pluginEnabledState = (state = this.getEnabledMap().get(pluginId)) != null ? state : PluginEnabledState.ENABLED;
        if (pluginEnabledState == null) {
            MyPluginModel.$$$reportNull$$$0(41);
        }
        return pluginEnabledState;
    }

    boolean isRequiredPluginForProject(@NotNull PluginId pluginId) {
        Project project;
        if (pluginId == null) {
            MyPluginModel.$$$reportNull$$$0(42);
        }
        return (project = this.getProject()) != null && this.myRequiredPluginsForProject.computeIfAbsent(pluginId, id2 -> ContainerUtil.exists(MyPluginModel.getDependenciesOnPlugins(project), id2.getIdString()::equals)) != false;
    }

    boolean requiresRestart(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(43);
        }
        return this.myRequiresRestart.computeIfAbsent(descriptor2 instanceof IdeaPluginDescriptorImpl ? (IdeaPluginDescriptorImpl)descriptor2 : null, it -> it == null || DynamicPlugins.INSTANCE.checkCanUnloadWithoutRestart((IdeaPluginDescriptorImpl)it) != null);
    }

    boolean isUninstalled(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(44);
        }
        return this.myUninstalled.contains(descriptor2);
    }

    void addUninstalled(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(45);
        }
        this.myUninstalled.add(descriptor2);
    }

    public boolean setEnabledState(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors, @NotNull PluginEnableDisableAction action2) {
        if (descriptors == null) {
            MyPluginModel.$$$reportNull$$$0(46);
        }
        if (action2 == null) {
            MyPluginModel.$$$reportNull$$$0(47);
        }
        this.enableRows(descriptors, action2);
        this.updateAfterEnableDisable();
        this.runInvalidFixCallback();
        return true;
    }

    @Override
    public boolean isDisabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            MyPluginModel.$$$reportNull$$$0(48);
        }
        return !MyPluginModel.isEnabled(pluginId, this.getEnabledMap());
    }

    @Override
    public boolean enable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        if (descriptors == null) {
            MyPluginModel.$$$reportNull$$$0(49);
        }
        return this.setEnabledState(descriptors, PluginEnableDisableAction.ENABLE_GLOBALLY);
    }

    @Override
    public boolean disable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        if (descriptors == null) {
            MyPluginModel.$$$reportNull$$$0(50);
        }
        return this.setEnabledState(descriptors, PluginEnableDisableAction.DISABLE_GLOBALLY);
    }

    void enableRequiredPlugins(@NotNull IdeaPluginDescriptor descriptor2) {
        Set<PluginId> requiredPluginIds;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(51);
        }
        if ((requiredPluginIds = this.getRequiredPluginIds(descriptor2.getPluginId())).isEmpty()) {
            return;
        }
        HashSet<IdeaPluginDescriptor> requiredPlugins = new HashSet<IdeaPluginDescriptor>();
        for (PluginId pluginId : requiredPluginIds) {
            IdeaPluginDescriptor result2 = (IdeaPluginDescriptor)ContainerUtil.find((Iterable)this.view, d -> pluginId.equals((Object)d.getPluginId()));
            if (result2 == null && PluginManagerCore.isModuleDependency(pluginId) && (result2 = (IdeaPluginDescriptor)ContainerUtil.find((Iterable)this.view, d -> d instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)d).modules.contains(pluginId))) != null) {
                this.setEnabled(pluginId, PluginEnabledState.ENABLED);
            }
            if (result2 == null) continue;
            requiredPlugins.add(result2);
        }
        if (!requiredPlugins.isEmpty()) {
            this.enablePlugins(requiredPlugins);
        }
    }

    @Override
    protected void handleBeforeChangeEnableState(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Pair<PluginEnableDisableAction, PluginEnabledState> pair) {
        PluginEnabledState newState2;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(52);
        }
        if (pair == null) {
            MyPluginModel.$$$reportNull$$$0(53);
        }
        PluginId pluginId = descriptor2.getPluginId();
        Pair<PluginEnableDisableAction, PluginEnabledState> oldPair = this.myDiff.get(descriptor2);
        PluginEnabledState oldState = oldPair != null ? (PluginEnabledState)((Object)oldPair.getSecond()) : null;
        if (oldState != (newState2 = (PluginEnabledState)((Object)pair.getSecond()))) {
            PluginEnabledState state = oldState != null ? oldState : this.getState(pluginId);
            this.myDiff.put(descriptor2, (Pair<PluginEnableDisableAction, PluginEnabledState>)Pair.create((Object)((Object)((PluginEnableDisableAction)((Object)pair.getFirst()))), (Object)((Object)state)));
        } else {
            this.myDiff.remove(descriptor2);
        }
        this.myErrorPluginsToDisable.remove(pluginId);
        if (newState2.isEnabled() || descriptor2.isEnabled()) {
            return;
        }
        if (PluginManagerCore.isIncompatible(descriptor2) || PluginManagerCore.isBrokenPlugin(descriptor2) || this.hasProblematicDependencies(pluginId)) {
            this.myErrorPluginsToDisable.add(pluginId);
        }
    }

    private void runInvalidFixCallback() {
        if (this.myInvalidFixCallback != null) {
            ApplicationManager.getApplication().invokeLater(this.myInvalidFixCallback, ModalityState.any());
        }
    }

    public void setInvalidFixCallback(@Nullable Runnable invalidFixCallback) {
        this.myInvalidFixCallback = invalidFixCallback;
    }

    public void setCancelInstallCallback(@NotNull Consumer<? super IdeaPluginDescriptor> callback2) {
        if (callback2 == null) {
            MyPluginModel.$$$reportNull$$$0(54);
        }
        this.myCancelInstallCallback = callback2;
    }

    private void updateAfterEnableDisable() {
        for (ListPluginComponent component2 : this.myInstalledPluginComponents) {
            component2.updateEnabledState();
        }
        for (PluginDetailsPageComponent detailPanel : this.myDetailPanels) {
            detailPanel.updateEnabledState();
        }
        for (PluginsGroup group2 : this.myEnabledGroups) {
            group2.titleWithEnabled(this);
        }
    }

    public void runRestartButton(@NotNull Component component2) {
        if (component2 == null) {
            MyPluginModel.$$$reportNull$$$0(55);
        }
        if (PluginManagerConfigurable.showRestartDialog() == 0) {
            this.needRestart = true;
            this.createShutdownCallback = false;
            DialogWrapper settings = DialogWrapper.findInstance((Component)component2);
            if (settings instanceof SettingsDialog) {
                ((SettingsDialog)settings).applyAndClose(false);
            } else if (this.isModified()) {
                try {
                    this.apply(null);
                }
                catch (ConfigurationException e) {
                    LOG.error((Throwable)e);
                }
            }
            ApplicationManager.getApplication().exit(true, false, true);
        }
    }

    void uninstallAndUpdateUi(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(56);
        }
        boolean needRestartForUninstall = this.performUninstall((IdeaPluginDescriptorImpl)descriptor2);
        this.needRestart |= descriptor2.isEnabled() && needRestartForUninstall;
        this.myInstallsRequiringRestart |= needRestartForUninstall;
        List<ListPluginComponent> listComponents = this.myInstalledPluginComponentMap.get(descriptor2.getPluginId());
        if (listComponents != null) {
            for (ListPluginComponent listComponent : listComponents) {
                listComponent.updateAfterUninstall(needRestartForUninstall);
            }
        }
        for (ListPluginComponent component2 : this.myInstalledPluginComponents) {
            component2.updateErrors();
        }
        for (PluginDetailsPageComponent panel2 : this.myDetailPanels) {
            if (panel2.getPlugin() != descriptor2) continue;
            panel2.updateButtons();
        }
    }

    private boolean performUninstall(@NotNull IdeaPluginDescriptorImpl descriptorImpl) {
        if (descriptorImpl == null) {
            MyPluginModel.$$$reportNull$$$0(57);
        }
        boolean needRestartForUninstall = true;
        try {
            descriptorImpl.setDeleted(true);
            needRestartForUninstall = PluginInstaller.prepareToUninstall(descriptorImpl);
            InstalledPluginsState.getInstance().onPluginUninstall(descriptorImpl, needRestartForUninstall);
            if (!needRestartForUninstall) {
                this.myDynamicPluginsToUninstall.add(descriptorImpl);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return needRestartForUninstall;
    }

    private boolean hasProblematicDependencies(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            MyPluginModel.$$$reportNull$$$0(58);
        }
        return this.getRequiredPluginsById(pluginId).anyMatch(pair -> {
            IdeaPluginDescriptor descriptor2 = (IdeaPluginDescriptor)pair.getSecond();
            return descriptor2 != null && !this.isEnabled(descriptor2);
        });
    }

    public boolean hasErrors(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(59);
        }
        return !this.getErrors(descriptor2).isEmpty();
    }

    @NotNull
    public List<? extends HtmlChunk> getErrors(@NotNull IdeaPluginDescriptor descriptor2) {
        PluginId disabledDependency;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(60);
        }
        PluginId pluginId = descriptor2.getPluginId();
        if (MyPluginModel.isDeleted(descriptor2) || InstalledPluginsState.getInstance().wasUninstalledWithoutRestart(pluginId) || InstalledPluginsState.getInstance().wasInstalledWithoutRestart(pluginId)) {
            List list2 = List.of();
            if (list2 == null) {
                MyPluginModel.$$$reportNull$$$0(61);
            }
            return list2;
        }
        PluginLoadingError loadingError = PluginManagerCore.getLoadingError(pluginId);
        PluginId pluginId2 = disabledDependency = loadingError != null ? loadingError.disabledDependency : null;
        if (disabledDependency == null) {
            List<Object> list3 = loadingError != null ? List.of(MyPluginModel.createTextChunk(loadingError.getShortMessage())) : List.of();
            if (list3 == null) {
                MyPluginModel.$$$reportNull$$$0(62);
            }
            return list3;
        }
        HashMap requiredPlugins = new HashMap();
        this.getRequiredPluginsById(pluginId).filter(pair -> {
            IdeaPluginDescriptor requiredDescriptor = (IdeaPluginDescriptor)pair.getSecond();
            return requiredDescriptor == null || !requiredDescriptor.isEnabled();
        }).forEach(pair -> requiredPlugins.put((PluginId)pair.getFirst(), (IdeaPluginDescriptor)pair.getSecond()));
        if (requiredPlugins.isEmpty()) {
            List list4 = List.of();
            if (list4 == null) {
                MyPluginModel.$$$reportNull$$$0(63);
            }
            return list4;
        }
        ArrayList<HtmlChunk.Element> errors2 = new ArrayList<HtmlChunk.Element>();
        Set<String> pluginNamesOrIds = requiredPlugins.entrySet().stream().map(entry2 -> MyPluginModel.getPluginNameOrId((PluginId)entry2.getKey(), (IdeaPluginDescriptor)entry2.getValue())).collect(Collectors.toUnmodifiableSet());
        String message2 = IdeBundle.message((String)"new.plugin.manager.incompatible.deps.tooltip", (Object[])new Object[]{pluginNamesOrIds.size(), MyPluginModel.joinPluginNamesOrIds(pluginNamesOrIds)});
        errors2.add(MyPluginModel.createTextChunk(message2));
        if (requiredPlugins.entrySet().stream().noneMatch(entry2 -> {
            IdeaPluginDescriptor requiredDescriptor = (IdeaPluginDescriptor)entry2.getValue();
            return requiredDescriptor == null || PluginManagerCore.isIncompatible(requiredDescriptor);
        })) {
            String action2 = IdeBundle.message((String)"new.plugin.manager.incompatible.deps.action", (Object[])new Object[]{requiredPlugins.size()});
            errors2.add(HtmlChunk.link((String)"link", (String)action2));
        }
        List list5 = Collections.unmodifiableList(errors2);
        if (list5 == null) {
            MyPluginModel.$$$reportNull$$$0(64);
        }
        return list5;
    }

    @Override
    protected void updatePluginDependencies(@Nullable Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap) {
        this.myDependentToRequiredListMap.clear();
        InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
        for (IdeaPluginDescriptor rootDescriptor : this.view) {
            PluginId pluginId = rootDescriptor.getPluginId();
            this.myDependentToRequiredListMap.remove(pluginId);
            if (MyPluginModel.isDeleted(rootDescriptor) || this.isDisabled(pluginId)) continue;
            if (pluginIdMap == null) {
                pluginIdMap = PluginManagerCore.buildPluginIdMap();
            }
            boolean loaded = this.isLoaded(pluginId);
            if (rootDescriptor instanceof IdeaPluginDescriptorImpl) {
                PluginManagerCore.processAllNonOptionalDependencies((IdeaPluginDescriptorImpl)rootDescriptor, pluginIdMap, (depId, __) -> {
                    if (depId.equals((Object)pluginId)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!this.isLoaded((PluginId)depId) && !pluginsState.wasInstalled((PluginId)depId) && !pluginsState.wasUpdated((PluginId)depId) && !pluginsState.wasInstalledWithoutRestart((PluginId)depId) || this.isDisabled((PluginId)depId)) {
                        this.myDependentToRequiredListMap.putIfAbsent(pluginId, new HashSet());
                        this.myDependentToRequiredListMap.get(pluginId).add((PluginId)depId);
                    }
                    return FileVisitResult.CONTINUE;
                });
            }
            if (loaded || this.myDependentToRequiredListMap.containsKey(pluginId) || !PluginManagerCore.isCompatible(rootDescriptor)) continue;
            this.setEnabled(pluginId, PluginEnabledState.ENABLED);
        }
    }

    @NotNull
    private Set<PluginId> getRequiredPluginIds(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            MyPluginModel.$$$reportNull$$$0(65);
        }
        Set<PluginId> set2 = this.myDependentToRequiredListMap.getOrDefault(pluginId, Set.of());
        if (set2 == null) {
            MyPluginModel.$$$reportNull$$$0(66);
        }
        return set2;
    }

    private void assertCanApply(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap) throws ConfigurationException {
        if (pluginIdMap == null) {
            MyPluginModel.$$$reportNull$$$0(67);
        }
        ArrayList<IdeaPluginDescriptorImpl> descriptors = new ArrayList<IdeaPluginDescriptorImpl>();
        block0: for (Map.Entry<PluginId, Set<PluginId>> entry2 : this.myDependentToRequiredListMap.entrySet()) {
            PluginId pluginId = entry2.getKey();
            if (!this.isLoaded(pluginId)) continue;
            for (PluginId dependencyPluginId : entry2.getValue()) {
                if (PluginManagerCore.isModuleDependency(dependencyPluginId)) continue;
                IdeaPluginDescriptorImpl descriptor2 = pluginIdMap.get(pluginId);
                if (descriptor2 == null || MyPluginModel.isHidden(descriptor2)) continue block0;
                descriptors.add(descriptor2);
                continue block0;
            }
        }
        if (!descriptors.isEmpty()) {
            Set<String> pluginNames = MyPluginModel.getPluginNames(descriptors);
            String message2 = IdeBundle.message((String)"dialog.message.unable.to.apply.changes", (Object[])new Object[]{pluginNames.size(), MyPluginModel.joinPluginNamesOrIds(pluginNames)});
            throw new ConfigurationException(XmlStringUtil.wrapInHtml((CharSequence)message2));
        }
    }

    @NotNull
    private @NotNull Stream<Pair<@NotNull PluginId, @Nullable IdeaPluginDescriptorImpl>> getRequiredPluginsById(@NotNull PluginId pluginId) {
        Set<PluginId> pluginIds2;
        if (pluginId == null) {
            MyPluginModel.$$$reportNull$$$0(68);
        }
        if ((pluginIds2 = this.getRequiredPluginIds(pluginId)).isEmpty()) {
            Stream<Pair<PluginId, IdeaPluginDescriptorImpl>> stream = Stream.of(new Pair[0]);
            if (stream == null) {
                MyPluginModel.$$$reportNull$$$0(69);
            }
            return stream;
        }
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = PluginManagerCore.buildPluginIdMap();
        Stream<Pair<PluginId, IdeaPluginDescriptorImpl>> stream = pluginIds2.stream().map(requiredPluginId -> {
            IdeaPluginDescriptorImpl requiredDescriptor = (IdeaPluginDescriptorImpl)pluginIdMap.get(requiredPluginId);
            return Pair.create((Object)requiredPluginId, (Object)(requiredDescriptor == null && PluginManagerCore.isModuleDependency(requiredPluginId) ? PluginManagerCore.findPluginByModuleDependency(requiredPluginId) : requiredDescriptor));
        });
        if (stream == null) {
            MyPluginModel.$$$reportNull$$$0(70);
        }
        return stream;
    }

    @NotNull
    protected Collection<PluginNode> getCustomRepoPlugins() {
        Collection<PluginNode> collection = CustomPluginRepositoryService.getInstance().getCustomRepositoryPlugins();
        if (collection == null) {
            MyPluginModel.$$$reportNull$$$0(71);
        }
        return collection;
    }

    @NotNull
    public static Set<String> getPluginNames(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        if (descriptors == null) {
            MyPluginModel.$$$reportNull$$$0(72);
        }
        Set<String> set2 = Collections.unmodifiableSet(ContainerUtil.map2Set(descriptors, PluginDescriptor::getName));
        if (set2 == null) {
            MyPluginModel.$$$reportNull$$$0(73);
        }
        return set2;
    }

    @NotNull
    public static String joinPluginNamesOrIds(@NotNull Set<String> pluginNames) {
        if (pluginNames == null) {
            MyPluginModel.$$$reportNull$$$0(74);
        }
        String string = StringUtil.join(pluginNames, StringUtil::wrapWithDoubleQuote, (String)", ");
        if (string == null) {
            MyPluginModel.$$$reportNull$$$0(75);
        }
        return string;
    }

    @NotNull
    public static List<IdeaPluginDescriptorImpl> getDependents(@NotNull IdeaPluginDescriptor rootDescriptor, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap, @NotNull ApplicationInfoEx applicationInfo) {
        if (rootDescriptor == null) {
            MyPluginModel.$$$reportNull$$$0(76);
        }
        if (pluginIdMap == null) {
            MyPluginModel.$$$reportNull$$$0(77);
        }
        if (applicationInfo == null) {
            MyPluginModel.$$$reportNull$$$0(78);
        }
        PluginId rootId = rootDescriptor.getPluginId();
        ArrayList result2 = new ArrayList();
        for (Map.Entry<PluginId, IdeaPluginDescriptorImpl> entry2 : pluginIdMap.entrySet()) {
            PluginId pluginId = entry2.getKey();
            IdeaPluginDescriptorImpl descriptor2 = entry2.getValue();
            if (pluginId.equals((Object)rootId) || applicationInfo.isEssentialPlugin(pluginId) || descriptor2 == null || !descriptor2.isEnabled() || MyPluginModel.isHidden(descriptor2)) continue;
            PluginManagerCore.processAllNonOptionalDependencies(descriptor2, pluginIdMap, dependency -> {
                if (dependency.getPluginId().equals((Object)rootId)) {
                    result2.add(descriptor2);
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            });
        }
        List<IdeaPluginDescriptorImpl> list2 = Collections.unmodifiableList(result2);
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(79);
        }
        return list2;
    }

    @NotNull
    public Icon getIcon(@NotNull IdeaPluginDescriptor descriptor2, boolean big, boolean error, boolean disabled) {
        String key;
        Icon icon2;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(80);
        }
        if ((icon2 = this.myIcons.get(key = descriptor2.getPluginId().getIdString() + big + error + disabled)) == null && (icon2 = PluginLogo.getIcon(descriptor2, big, error, disabled)) != PluginLogo.getDefault().getIcon(big, error, disabled)) {
            this.myIcons.put(key, icon2);
        }
        Icon icon3 = icon2;
        if (icon3 == null) {
            MyPluginModel.$$$reportNull$$$0(81);
        }
        return icon3;
    }

    @NotNull
    private static List<String> getDependenciesOnPlugins(@NotNull Project project) {
        if (project == null) {
            MyPluginModel.$$$reportNull$$$0(82);
        }
        List list2 = ContainerUtil.map(ExternalDependenciesManager.getInstance(project).getDependencies(DependencyOnPlugin.class), DependencyOnPlugin::getPluginId);
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(83);
        }
        return list2;
    }

    @NotNull
    private static HtmlChunk.Element createTextChunk(@NotNull @Nls String message2) {
        if (message2 == null) {
            MyPluginModel.$$$reportNull$$$0(84);
        }
        HtmlChunk.Element element2 = HtmlChunk.span().addText(message2);
        if (element2 == null) {
            MyPluginModel.$$$reportNull$$$0(85);
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 17: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 38: 
            case 41: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 79: 
            case 81: 
            case 83: 
            case 85: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 17: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 38: 
            case 41: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 79: 
            case 81: 
            case 83: 
            case 85: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackData";
                break;
            }
            case 2: 
            case 3: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topController";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 6: 
            case 17: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 38: 
            case 41: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 79: 
            case 81: 
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/MyPluginModel";
                break;
            }
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 27: 
            case 28: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 52: 
            case 56: 
            case 59: 
            case 60: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloaded";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installing";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailPanel";
                break;
            }
            case 32: 
            case 46: 
            case 49: 
            case 50: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vendors";
                break;
            }
            case 40: 
            case 42: 
            case 48: 
            case 58: 
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorImpl";
                break;
            }
            case 67: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIdMap";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginNames";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationInfo";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/MyPluginModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallingPlugins";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "finishInstall";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getVendors";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledDescriptors";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getVendorsCount";
                break;
            }
            case 38: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredPluginIds";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredPluginsById";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomRepoPlugins";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginNames";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "joinPluginNamesOrIds";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependents";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependenciesOnPlugins";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextChunk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyEnableDisablePlugins";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "pluginInstalledFromDisk";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeComponent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTopController";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPluginUpdatesService";
                break;
            }
            case 6: 
            case 17: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 38: 
            case 41: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 79: 
            case 81: 
            case 83: 
            case 85: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInstallingOrUpdate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "installOrUpdatePlugin";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runInstallOperation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstall";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "finishInstall";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "clearInstallingProgress";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addProgress";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeProgress";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addEnabledGroup";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setDownloadedGroup";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addDetailPanel";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "appendOrUpdateDescriptor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getVendorsCount";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isVendor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 37: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDependentState";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isRequiredPluginForProject";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "requiresRestart";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isUninstalled";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addUninstalled";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "setEnabledState";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "enable";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "disable";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "enableRequiredPlugins";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "handleBeforeChangeEnableState";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setCancelInstallCallback";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "runRestartButton";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "uninstallAndUpdateUi";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "performUninstall";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "hasProblematicDependencies";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "hasErrors";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getErrors";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredPluginIds";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "assertCanApply";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredPluginsById";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getPluginNames";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "joinPluginNamesOrIds";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getDependents";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getDependenciesOnPlugins";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "createTextChunk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 17: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 38: 
            case 41: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 79: 
            case 81: 
            case 83: 
            case 85: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

