/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.LinkPanel;
import com.intellij.ide.plugins.MultiPanel;
import com.intellij.ide.plugins.PluginEnableDisableAction;
import com.intellij.ide.plugins.PluginInfoProvider;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.TagPanel;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.marketplace.statistics.PluginManagerUsageCollector;
import com.intellij.ide.plugins.newui.BaselinePanel;
import com.intellij.ide.plugins.newui.ChangeNotesPanel;
import com.intellij.ide.plugins.newui.EmptyCaret;
import com.intellij.ide.plugins.newui.ErrorComponent;
import com.intellij.ide.plugins.newui.InstallButton;
import com.intellij.ide.plugins.newui.LicensePanel;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.NewUiUtil;
import com.intellij.ide.plugins.newui.OneLineProgressIndicator;
import com.intellij.ide.plugins.newui.ProjectDependentPluginEnabledState;
import com.intellij.ide.plugins.newui.RestartButton;
import com.intellij.ide.plugins.newui.SearchWords;
import com.intellij.ide.plugins.newui.SelectionBasedPluginModelAction;
import com.intellij.ide.plugins.newui.Tags;
import com.intellij.ide.plugins.newui.TextHorizontalLayout;
import com.intellij.ide.plugins.newui.UpdateButton;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.ide.plugins.org.PluginManagerFilters;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginDetailsPageComponent
extends MultiPanel {
    private static final String MARKETPLACE_LINK = "/plugin/index?xmlId=";
    private final MyPluginModel myPluginModel;
    private final LinkListener<Object> mySearchListener;
    private final boolean myMarketplace;
    @NotNull
    private final AsyncProcessIcon myLoadingIcon;
    private JBPanelWithEmptyText myEmptyPanel;
    private OpaquePanel myRootPanel;
    private OpaquePanel myPanel;
    private JLabel myIconLabel;
    private final JEditorPane myNameComponent;
    private final BaselinePanel myNameAndButtons;
    private JButton myRestartButton;
    private InstallButton myInstallButton;
    private JButton myUpdateButton;
    private JComponent myGearButton;
    private ErrorComponent myErrorComponent;
    private JTextField myVersion;
    private JLabel myEnabledForProject;
    private JLabel myVersionSize;
    private TagPanel myTagPanel;
    private JLabel myDate;
    private JLabel myRating;
    private JLabel myDownloads;
    private JLabel mySize;
    private LinkPanel myAuthor;
    private BorderLayoutPanel myControlledByOrgNotification;
    private final LicensePanel myLicensePanel;
    private LinkPanel myHomePage;
    private JBScrollPane myBottomScrollPane;
    private JEditorPane myDescriptionComponent;
    private String myDescription;
    private ChangeNotesPanel myChangeNotesPanel;
    private OneLineProgressIndicator myIndicator;
    @Nullable
    private IdeaPluginDescriptor myPlugin;
    private boolean myIsPluginAllowed;
    private IdeaPluginDescriptor myUpdateDescriptor;
    private ListPluginComponent myShowComponent;

    public PluginDetailsPageComponent(@NotNull MyPluginModel pluginModel, @NotNull LinkListener<Object> searchListener, boolean marketplace) {
        if (pluginModel == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(0);
        }
        if (searchListener == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(1);
        }
        this.myLoadingIcon = new AsyncProcessIcon.BigCentered(IdeBundle.message((String)"progress.text.loading", (Object[])new Object[0]));
        this.myNameComponent = PluginDetailsPageComponent.createNameComponent();
        this.myNameAndButtons = new BaselinePanel();
        this.myLicensePanel = new LicensePanel(false);
        this.myPluginModel = pluginModel;
        this.mySearchListener = searchListener;
        this.myMarketplace = marketplace;
        this.createPluginPanel();
        this.select(1, true);
        this.setEmptyState(EmptyState.NONE_SELECTED);
    }

    @Nullable
    final IdeaPluginDescriptor getPlugin() {
        return this.myPlugin;
    }

    void setPlugin(@Nullable IdeaPluginDescriptor plugin2) {
        if (plugin2 != null) {
            this.myPlugin = plugin2;
        }
    }

    public boolean isShowingPlugin(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(2);
        }
        return this.myPlugin != null && this.myPlugin.getPluginId().equals((Object)pluginDescriptor.getPluginId());
    }

    @Override
    protected JComponent create(Integer key) {
        if (key == 0) {
            return this.myRootPanel;
        }
        if (key == 1) {
            if (this.myEmptyPanel == null) {
                this.myEmptyPanel = new JBPanelWithEmptyText();
                this.myEmptyPanel.setBorder((Border)new CustomLineBorder(PluginManagerConfigurable.SEARCH_FIELD_BORDER_COLOR, (Insets)JBUI.insets((int)1, (int)0, (int)0, (int)0)));
                this.myEmptyPanel.setOpaque(true);
                this.myEmptyPanel.setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
                this.myLoadingIcon.setOpaque(true);
                this.myLoadingIcon.setPaintPassiveIcon(false);
                this.myEmptyPanel.add((Component)this.myLoadingIcon);
            }
            return this.myEmptyPanel;
        }
        return super.create(key);
    }

    private void createPluginPanel() {
        this.myPanel = new OpaquePanel((LayoutManager)new BorderLayout(0, JBUIScale.scale((int)32)), PluginManagerConfigurable.MAIN_BG_COLOR);
        this.myPanel.setBorder((Border)new CustomLineBorder((Color)new JBColor(0xC5C5C5, 0x515151), (Insets)JBUI.insets((int)1, (int)0, (int)0, (int)0)){

            public Insets getBorderInsets(Component c) {
                return JBUI.insets((int)15, (int)20, (int)0, (int)0);
            }
        });
        this.createHeaderPanel().add(this.createCenterPanel());
        this.createBottomPanel();
        this.myRootPanel = new OpaquePanel((LayoutManager)new BorderLayout());
        this.myControlledByOrgNotification = new BorderLayoutPanel();
        Border customLine = JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)1, (int)0);
        this.myControlledByOrgNotification.setBorder(JBUI.Borders.merge((Border)JBUI.Borders.empty((int)10), (Border)customLine, (boolean)true));
        this.myControlledByOrgNotification.setBackground(JBUI.CurrentTheme.Notification.BACKGROUND);
        this.myControlledByOrgNotification.setForeground(JBUI.CurrentTheme.Notification.FOREGROUND);
        JBLabel notificationLabel = new JBLabel();
        notificationLabel.setIcon(AllIcons.General.Warning);
        notificationLabel.setVerticalTextPosition(1);
        notificationLabel.setText(HtmlChunk.html().addText(IdeBundle.message((String)"plugins.configurable.not.allowed", (Object[])new Object[0])).toString());
        this.myControlledByOrgNotification.addToCenter((Component)notificationLabel);
        this.myControlledByOrgNotification.setVisible(false);
        this.myRootPanel.add((Component)this.myControlledByOrgNotification, (Object)"North");
        this.myRootPanel.add((Component)this.myPanel, (Object)"Center");
    }

    @NotNull
    private JPanel createHeaderPanel() {
        NonOpaquePanel header2 = new NonOpaquePanel((LayoutManager)new BorderLayout(JBUIScale.scale((int)15), 0));
        header2.setBorder((Border)JBUI.Borders.emptyRight((int)20));
        this.myPanel.add((Component)header2, (Object)"North");
        this.myIconLabel = new JLabel();
        this.myIconLabel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.myIconLabel.setVerticalAlignment(1);
        this.myIconLabel.setOpaque(false);
        header2.add((Component)this.myIconLabel, "West");
        NonOpaquePanel nonOpaquePanel = header2;
        if (nonOpaquePanel == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(3);
        }
        return nonOpaquePanel;
    }

    @NotNull
    private JPanel createCenterPanel() {
        int offset = PluginManagerConfigurable.offset5();
        NonOpaquePanel centerPanel = new NonOpaquePanel((LayoutManager)((Object)new VerticalLayout(offset)));
        this.myNameAndButtons.setYOffset(JBUIScale.scale((int)3));
        this.myNameAndButtons.add(this.myNameComponent);
        this.createButtons();
        centerPanel.add((Component)((Object)this.myNameAndButtons), "fill_h");
        if (!this.myMarketplace) {
            this.myErrorComponent = new ErrorComponent();
            centerPanel.add((Component)this.myErrorComponent, "fill_h");
        }
        this.createMetricsPanel((JPanel)centerPanel);
        NonOpaquePanel nonOpaquePanel = centerPanel;
        if (nonOpaquePanel == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(4);
        }
        return nonOpaquePanel;
    }

    @NotNull
    private static JEditorPane createNameComponent() {
        JEditorPane editorPane = new JEditorPane(){
            JLabel myBaselineComponent;

            @Override
            public int getBaseline(int width, int height) {
                if (this.myBaselineComponent == null) {
                    this.myBaselineComponent = new JLabel();
                    this.myBaselineComponent.setFont(this.getFont());
                }
                this.myBaselineComponent.setText(this.getText());
                Dimension size = this.myBaselineComponent.getPreferredSize();
                return this.myBaselineComponent.getBaseline(size.width, size.height);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (size.height == 0) {
                    size.height = this.getMinimumSize().height;
                }
                return size;
            }
        };
        UIUtil.convertToLabel((JEditorPane)editorPane);
        editorPane.setCaret(EmptyCaret.INSTANCE);
        Font font = editorPane.getFont();
        if (font != null) {
            editorPane.setFont(font.deriveFont(1, 18.0f));
        }
        @NlsSafe String text2 = "<html><span>Foo</span></html>";
        editorPane.setText(text2);
        editorPane.setMinimumSize(editorPane.getPreferredSize());
        editorPane.setText(null);
        JEditorPane jEditorPane = editorPane;
        if (jEditorPane == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(5);
        }
        return jEditorPane;
    }

    private void createButtons() {
        this.myRestartButton = new RestartButton(this.myPluginModel);
        this.myNameAndButtons.addButtonComponent(this.myRestartButton);
        this.myUpdateButton = new UpdateButton();
        this.myNameAndButtons.addButtonComponent(this.myUpdateButton);
        this.myUpdateButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this, this.myPlugin, this.myUpdateDescriptor, ModalityState.stateForComponent((Component)this.myUpdateButton)));
        this.myInstallButton = new InstallButton(true);
        this.myNameAndButtons.addButtonComponent(this.myInstallButton);
        this.myInstallButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this, this.myPlugin, null, ModalityState.stateForComponent((Component)this.myInstallButton)));
        this.myGearButton = SelectionBasedPluginModelAction.createGearButton(this::createEnableDisableAction, this::createUninstallAction);
        this.myGearButton.setOpaque(false);
        this.myNameAndButtons.addButtonComponent(this.myGearButton);
        for (Component component2 : this.myNameAndButtons.getButtonComponents()) {
            component2.setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
        }
    }

    public void setOnlyUpdateMode() {
        this.myNameAndButtons.removeButtons();
        Container parent = this.myEnabledForProject.getParent();
        if (parent != null) {
            parent.remove(this.myEnabledForProject);
        }
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)15, (int)20, (int)0, (int)0));
        this.myEmptyPanel.setBorder(null);
    }

    private void createMetricsPanel(@NotNull JPanel centerPanel) {
        if (centerPanel == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(6);
        }
        this.myVersion = new JTextField();
        this.myVersion.putClientProperty("TextFieldWithoutMargins", Boolean.TRUE);
        this.myVersion.setEditable(false);
        PluginDetailsPageComponent.setFont(this.myVersion);
        this.myVersion.setBorder(null);
        this.myVersion.setOpaque(false);
        this.myVersion.setForeground(ListPluginComponent.GRAY_COLOR);
        this.myVersion.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                int caretPosition = PluginDetailsPageComponent.this.myVersion.getCaretPosition();
                PluginDetailsPageComponent.this.myVersion.setSelectionStart(caretPosition);
                PluginDetailsPageComponent.this.myVersion.setSelectionEnd(caretPosition);
            }
        });
        this.myVersionSize = new JLabel();
        PluginDetailsPageComponent.setFont(this.myVersionSize);
        int offset = JBUIScale.scale((int)10);
        NonOpaquePanel panel1 = new NonOpaquePanel((LayoutManager)((Object)new TextHorizontalLayout(offset)));
        centerPanel.add((Component)panel1);
        if (this.myMarketplace) {
            this.myDownloads = ListPluginComponent.createRatingLabel((JPanel)panel1, null, "", AllIcons.Plugins.Downloads, ListPluginComponent.GRAY_COLOR, true);
            this.myRating = ListPluginComponent.createRatingLabel((JPanel)panel1, null, "", AllIcons.Plugins.Rating, ListPluginComponent.GRAY_COLOR, true);
        }
        this.myAuthor = new LinkPanel((JPanel)panel1, false, true, null, "fix_label");
        this.myEnabledForProject = new JLabel();
        this.myEnabledForProject.add(PluginDetailsPageComponent.createDescriptionComponent(null));
        this.myEnabledForProject.setHorizontalTextPosition(2);
        this.myEnabledForProject.setForeground(ListPluginComponent.GRAY_COLOR);
        PluginDetailsPageComponent.setFont(this.myEnabledForProject);
        TextHorizontalLayout layout = this.myMarketplace ? new TextHorizontalLayout(offset){

            @Override
            public void layoutContainer(Container parent) {
                int baseline;
                super.layoutContainer(parent);
                if (PluginDetailsPageComponent.this.myTagPanel != null && PluginDetailsPageComponent.this.myTagPanel.isVisible() && (baseline = PluginDetailsPageComponent.this.myTagPanel.getBaseline(-1, -1)) != -1) {
                    Rectangle versionBounds = PluginDetailsPageComponent.this.myVersion.getBounds();
                    Dimension versionSize = PluginDetailsPageComponent.this.myVersion.getPreferredSize();
                    int versionY = PluginDetailsPageComponent.this.myTagPanel.getY() + baseline - PluginDetailsPageComponent.this.myVersion.getBaseline(versionSize.width, versionSize.height);
                    PluginDetailsPageComponent.this.myVersion.setBounds(versionBounds.x, versionY, versionBounds.width, versionBounds.height);
                    if (PluginDetailsPageComponent.this.myDate.isVisible()) {
                        Rectangle dateBounds = PluginDetailsPageComponent.this.myDate.getBounds();
                        Dimension dateSize = PluginDetailsPageComponent.this.myDate.getPreferredSize();
                        int dateY = PluginDetailsPageComponent.this.myTagPanel.getY() + baseline - PluginDetailsPageComponent.this.myDate.getBaseline(dateSize.width, dateSize.height);
                        PluginDetailsPageComponent.this.myDate.setBounds(dateBounds.x - JBUIScale.scale((int)4), dateY, dateBounds.width, dateBounds.height);
                    }
                }
            }
        } : new TextHorizontalLayout(JBUIScale.scale((int)7));
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)((Object)layout));
        panel2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.myTagPanel = new TagPanel(this.mySearchListener);
        panel2.add((Component)((Object)this.myTagPanel));
        (this.myMarketplace ? panel2 : panel1).add(this.myVersion);
        panel2.add(this.myEnabledForProject);
        this.myDate = ListPluginComponent.createRatingLabel((JPanel)panel2, "fix_label", "", null, ListPluginComponent.GRAY_COLOR, true);
        centerPanel.add((Component)panel2);
    }

    private void createBottomPanel() {
        OpaquePanel bottomPanel2 = new OpaquePanel((LayoutManager)((Object)new VerticalLayout(PluginManagerConfigurable.offset5())), PluginManagerConfigurable.MAIN_BG_COLOR);
        bottomPanel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)15, (int)20));
        this.myBottomScrollPane = new JBScrollPane((Component)bottomPanel2);
        this.myBottomScrollPane.getVerticalScrollBar().setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
        this.myBottomScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myPanel.add((Component)this.myBottomScrollPane);
        bottomPanel2.add((Component)((Object)this.myLicensePanel));
        this.myLicensePanel.setBorder((Border)JBUI.Borders.emptyBottom((int)20));
        if (this.myMarketplace) {
            this.myHomePage = new LinkPanel((JPanel)bottomPanel2, false);
            bottomPanel2.add(new JLabel());
        }
        Integer constraints2 = JBUIScale.scale((int)700);
        this.myDescriptionComponent = PluginDetailsPageComponent.createDescriptionComponent(view -> {
            float width = view.getPreferredSpan(0);
            if (width < 0.0f || width > (float)this.myBottomScrollPane.getWidth()) {
                this.myBottomScrollPane.setHorizontalScrollBarPolicy(32);
            }
        });
        bottomPanel2.add((Component)this.myDescriptionComponent, constraints2);
        this.myChangeNotesPanel = new ChangeNotesPanel((JPanel)bottomPanel2, constraints2, this.myDescriptionComponent);
        JLabel separator2 = new JLabel();
        separator2.setBorder((Border)JBUI.Borders.emptyTop((int)20));
        bottomPanel2.add(separator2);
        if (this.myMarketplace) {
            this.mySize = new JLabel();
            bottomPanel2.add(this.mySize);
        } else {
            this.myHomePage = new LinkPanel((JPanel)bottomPanel2, false);
        }
    }

    private static void setFont(@NotNull JComponent component2) {
        if (component2 == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(7);
        }
        component2.setFont(UIUtil.getLabelFont());
        PluginManagerConfigurable.setTinyFont(component2);
    }

    @NotNull
    public static JEditorPane createDescriptionComponent(final @Nullable Consumer<? super View> imageViewHandler) {
        JBHtmlEditorKit kit = new JBHtmlEditorKit(){
            private final ViewFactory myFactory = new JBHtmlEditorKit.JBHtmlFactory(){

                public View create(Element e) {
                    View view = super.create(e);
                    if (view instanceof ParagraphView) {
                        return new ParagraphView(e){
                            {
                                super(arg0);
                                super.setLineSpacing(0.3f);
                            }

                            @Override
                            protected void setLineSpacing(float ls) {
                            }
                        };
                    }
                    if (imageViewHandler != null && view instanceof ImageView) {
                        imageViewHandler.accept(view);
                    }
                    return view;
                }
            };

            public ViewFactory getViewFactory() {
                return this.myFactory;
            }
        };
        StyleSheet sheet = kit.getStyleSheet();
        sheet.addRule("ul { margin-left-ltr: 30; margin-right-rtl: 30; }");
        sheet.addRule("a { color: " + ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + "; }");
        sheet.addRule("h4 { font-weight: bold; }");
        sheet.addRule("strong { font-weight: bold; }");
        sheet.addRule("p { margin-bottom: 6px; }");
        Font font = UIUtil.getLabelFont();
        if (font != null) {
            int size = font.getSize();
            sheet.addRule("h3 { font-size: " + (size + 3) + "; font-weight: bold; }");
            sheet.addRule("h2 { font-size: " + (size + 5) + "; font-weight: bold; }");
            sheet.addRule("h1 { font-size: " + (size + 9) + "; font-weight: bold; }");
            sheet.addRule("h0 { font-size: " + (size + 12) + "; font-weight: bold; }");
        }
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setOpaque(false);
        editorPane.setBorder(null);
        editorPane.setContentType("text/html");
        editorPane.setEditorKit((EditorKit)kit);
        editorPane.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        JEditorPane jEditorPane = editorPane;
        if (jEditorPane == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(8);
        }
        return jEditorPane;
    }

    public final void showPlugins(@NotNull List<? extends ListPluginComponent> selection) {
        int size;
        if (selection == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(9);
        }
        this.showPlugin((size = selection.size()) == 1 ? selection.get(0) : null, size > 1);
    }

    public final void showPlugin(@Nullable ListPluginComponent component2) {
        this.showPlugin(component2, false);
    }

    private void showPlugin(@Nullable ListPluginComponent component2, boolean multiSelection) {
        if (this.myShowComponent == component2 && (component2 == null || this.myUpdateDescriptor == component2.myUpdateDescriptor)) {
            return;
        }
        this.myShowComponent = component2;
        if (this.myIndicator != null) {
            MyPluginModel.removeProgress(this.myPlugin, this.myIndicator);
            this.hideProgress(false, false);
        }
        if (component2 == null) {
            this.myUpdateDescriptor = null;
            this.myPlugin = null;
            this.select(1, true);
            this.setEmptyState(multiSelection ? EmptyState.MULTI_SELECT : EmptyState.NONE_SELECTED);
        } else {
            PluginNode node2;
            boolean syncLoading = true;
            IdeaPluginDescriptor descriptor2 = component2.getPluginDescriptor();
            if (descriptor2 instanceof PluginNode && !(node2 = (PluginNode)descriptor2).detailsLoaded()) {
                syncLoading = false;
                this.startLoading();
                ProcessIOExecutorService.INSTANCE.execute(() -> {
                    PluginNode pluginNode = MarketplaceRequests.getInstance().loadPluginDetails(node2);
                    if (pluginNode == null) {
                        return;
                    }
                    component2.setPluginDescriptor(pluginNode);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (this.myShowComponent == component2) {
                            this.stopLoading();
                            this.showPluginImpl(component2.getPluginDescriptor(), component2.myUpdateDescriptor);
                            PluginManagerUsageCollector.pluginCardOpened(component2.getPluginDescriptor(), component2.getGroup());
                        }
                    }, ModalityState.stateForComponent((Component)component2));
                });
            }
            if (syncLoading) {
                this.showPluginImpl(component2.getPluginDescriptor(), component2.myUpdateDescriptor);
                PluginManagerUsageCollector.pluginCardOpened(component2.getPluginDescriptor(), component2.getGroup());
            }
        }
    }

    public void showPluginImpl(@NotNull IdeaPluginDescriptor pluginDescriptor, @Nullable IdeaPluginDescriptor updateDescriptor) {
        if (pluginDescriptor == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(10);
        }
        this.myPlugin = pluginDescriptor;
        PluginManagerFilters org = PluginManagerFilters.getInstance();
        this.myUpdateDescriptor = updateDescriptor != null && org.isPluginAllowed(!this.myMarketplace, updateDescriptor) ? updateDescriptor : null;
        this.myIsPluginAllowed = org.isPluginAllowed(!this.myMarketplace, pluginDescriptor);
        this.showPlugin();
        this.select(0, true);
    }

    private void setEmptyState(EmptyState emptyState) {
        StatusText text2 = this.myEmptyPanel.getEmptyText();
        text2.clear();
        this.myLoadingIcon.setVisible(false);
        this.myLoadingIcon.suspend();
        switch (emptyState) {
            case MULTI_SELECT: {
                text2.setText(IdeBundle.message((String)"plugins.configurable.several.plugins", (Object[])new Object[0]));
                text2.appendSecondaryText(IdeBundle.message((String)"plugins.configurable.one.plugin.details", (Object[])new Object[0]), StatusText.DEFAULT_ATTRIBUTES, null);
                break;
            }
            case NONE_SELECTED: {
                text2.setText(IdeBundle.message((String)"plugins.configurable.plugin.details", (Object[])new Object[0]));
                break;
            }
            case PROGRESS: {
                this.myLoadingIcon.setVisible(true);
                this.myLoadingIcon.resume();
            }
        }
    }

    private void showPlugin() {
        String organization;
        @NlsSafe String text2 = "<html><span>" + this.myPlugin.getName() + "</span></html>";
        this.myNameComponent.setText(text2);
        this.myControlledByOrgNotification.setVisible(!this.myIsPluginAllowed);
        this.updateIcon();
        this.updateButtons();
        Object version2 = this.myPlugin.getVersion();
        if (this.myPlugin.isBundled() && !this.myPlugin.allowBundledUpdate()) {
            version2 = IdeBundle.message((String)"plugin.version.bundled", (Object[])new Object[0]) + (String)(StringUtil.isEmptyOrSpaces((String)version2) ? "" : " " + (String)version2);
        }
        if (this.myUpdateDescriptor != null) {
            version2 = NewUiUtil.getVersion(this.myPlugin, this.myUpdateDescriptor);
        }
        this.myVersion.setText((String)version2);
        this.myVersionSize.setText((String)version2);
        this.myVersion.setPreferredSize(new Dimension(this.myVersionSize.getPreferredSize().width + JBUIScale.scale((int)4), this.myVersionSize.getPreferredSize().height));
        this.myVersion.setVisible(!StringUtil.isEmptyOrSpaces((String)version2));
        this.myTagPanel.setTags(PluginManagerConfigurable.getTags(this.myPlugin));
        if (this.myMarketplace) {
            String rating = null;
            String downloads = null;
            String size = null;
            if (this.myPlugin instanceof PluginNode) {
                PluginNode pluginNode = (PluginNode)this.myPlugin;
                rating = pluginNode.getPresentableRating();
                downloads = pluginNode.getPresentableDownloads();
                size = pluginNode.getPresentableSize();
            }
            this.myRating.setText(rating);
            this.myRating.setVisible(rating != null);
            this.myDownloads.setText(downloads);
            this.myDownloads.setVisible(downloads != null);
            this.mySize.setText(IdeBundle.message((String)"plugins.configurable.size.0", (Object[])new Object[]{size}));
            this.mySize.setVisible(size != null);
        } else {
            this.updateEnabledForProject();
        }
        String vendor = this.myPlugin.isBundled() ? null : StringUtil.trim((String)this.myPlugin.getVendor());
        String string = organization = this.myPlugin.isBundled() ? null : StringUtil.trim((String)this.myPlugin.getOrganization());
        if (StringUtil.isEmptyOrSpaces((String)vendor)) {
            this.myAuthor.hide();
        } else if (StringUtil.isEmptyOrSpaces((String)organization)) {
            this.myAuthor.show(vendor, null);
        } else {
            this.myAuthor.show(organization, () -> this.mySearchListener.linkSelected(null, (Object)(SearchWords.ORGANIZATION.getValue() + (organization.indexOf(32) == -1 ? organization : StringUtil.wrapWithDoubleQuote((String)organization)))));
        }
        this.showLicensePanel();
        if (this.myPlugin.isBundled() && !this.myPlugin.allowBundledUpdate() || !this.isPluginFromMarketplace()) {
            this.myHomePage.hide();
        } else {
            this.myHomePage.show(IdeBundle.message((String)"plugins.configurable.plugin.homepage.link", (Object[])new Object[0]), () -> {
                @NlsSafe String url = ((ApplicationInfoEx)ApplicationInfo.getInstance()).getPluginManagerUrl() + MARKETPLACE_LINK + URLUtil.encodeURIComponent((String)this.myPlugin.getPluginId().getIdString());
                BrowserUtil.browse((String)IdeUrlTrackingParametersProvider.getInstance().augmentUrl(url));
            });
        }
        IdeaPluginDescriptor pluginNode = this.myUpdateDescriptor != null ? this.myUpdateDescriptor : this.myPlugin;
        String date = pluginNode instanceof PluginNode ? ((PluginNode)pluginNode).getPresentableDate() : null;
        this.myDate.setText(date);
        this.myDate.setVisible(date != null);
        this.myBottomScrollPane.setHorizontalScrollBarPolicy(31);
        String description = this.getDescription();
        if (description != null && !description.equals(this.myDescription)) {
            this.myDescription = description;
            this.myDescriptionComponent.setText(XmlStringUtil.wrapInHtml((CharSequence)description));
            if (this.myDescriptionComponent.getCaret() != null) {
                this.myDescriptionComponent.setCaretPosition(0);
            }
        }
        this.myDescriptionComponent.setVisible(description != null);
        this.myChangeNotesPanel.show(this.getChangeNotes());
        ApplicationManager.getApplication().invokeLater(() -> {
            IdeEventQueue.getInstance().flushQueue();
            ((JBScrollBar)this.myBottomScrollPane.getVerticalScrollBar()).setCurrentValue(0);
        }, ModalityState.any());
        if (MyPluginModel.isInstallingOrUpdate(this.myPlugin)) {
            this.showProgress();
        } else {
            this.fullRepaint();
        }
    }

    private boolean isPluginFromMarketplace() {
        assert (this.myPlugin != null);
        PluginInfoProvider provider2 = PluginInfoProvider.getInstance();
        Set marketplacePlugins = provider2.loadCachedPlugins();
        if (marketplacePlugins != null) {
            return marketplacePlugins.contains(this.myPlugin.getPluginId());
        }
        provider2.loadPlugins();
        return true;
    }

    private void showLicensePanel() {
        String productCode = this.myPlugin.getProductCode();
        if (this.myPlugin.isBundled() || LicensePanel.isEA2Product(productCode)) {
            this.myLicensePanel.hideWithChildren();
            return;
        }
        if (productCode == null) {
            if (this.myUpdateDescriptor != null && this.myUpdateDescriptor.getProductCode() != null && !LicensePanel.isEA2Product(this.myUpdateDescriptor.getProductCode())) {
                String message2 = this.myUpdateDescriptor instanceof PluginNode && ((PluginNode)this.myUpdateDescriptor).getTags().contains(Tags.Freemium.name()) ? IdeBundle.message((String)"label.next.plugin.version.is.freemium", (Object[])new Object[0]) : IdeBundle.message((String)"label.next.plugin.version.is.paid.use.the.trial.for.up.to.30.days.or", (Object[])new Object[0]);
                this.myLicensePanel.setText(message2, true, false);
                this.myLicensePanel.showBuyPlugin(() -> this.myUpdateDescriptor);
                this.myLicensePanel.setVisible(true);
            } else {
                this.myLicensePanel.hideWithChildren();
            }
        } else if (this.myMarketplace) {
            String message3 = this.myPlugin instanceof PluginNode && ((PluginNode)this.myPlugin).getTags().contains(Tags.Freemium.name()) ? IdeBundle.message((String)"label.install.a.limited.functionality.for.free", (Object[])new Object[0]) : IdeBundle.message((String)"label.use.the.trial.for.up.to.30.days.or", (Object[])new Object[0]);
            this.myLicensePanel.setText(message3, false, false);
            this.myLicensePanel.showBuyPlugin(() -> this.myPlugin);
            this.myLicensePanel.setVisible(true);
        } else {
            LicensingFacade instance2 = LicensingFacade.getInstance();
            if (instance2 == null) {
                this.myLicensePanel.hideWithChildren();
                return;
            }
            String stamp = instance2.getConfirmationStamp(productCode);
            if (stamp == null) {
                if (ApplicationManager.getApplication().isEAP()) {
                    this.myTagPanel.setFirstTagTooltip(IdeBundle.message((String)"tooltip.license.not.required.for.eap.version", (Object[])new Object[0]));
                    this.myLicensePanel.hideWithChildren();
                    return;
                }
                this.myLicensePanel.setText(IdeBundle.message((String)"label.text.plugin.no.license", (Object[])new Object[0]), true, false);
            } else {
                this.myLicensePanel.setTextFromStamp(stamp, instance2.getExpirationDate(productCode));
            }
            this.myTagPanel.setFirstTagTooltip(this.myLicensePanel.getMessage());
            this.myLicensePanel.setVisible(true);
        }
    }

    public void updateButtons() {
        if (!this.myIsPluginAllowed) {
            this.myRestartButton.setVisible(false);
            this.myInstallButton.setVisible(false);
            this.myUpdateButton.setVisible(false);
            this.myGearButton.setVisible(false);
            return;
        }
        boolean installedWithoutRestart = InstalledPluginsState.getInstance().wasInstalledWithoutRestart(this.myPlugin.getPluginId());
        if (this.myMarketplace) {
            boolean installed = InstalledPluginsState.getInstance().wasInstalled(this.myPlugin.getPluginId());
            this.myRestartButton.setVisible(installed);
            this.myInstallButton.setEnabled(PluginManagerCore.getPlugin(this.myPlugin.getPluginId()) == null && !installedWithoutRestart, IdeBundle.message((String)"plugins.configurable.installed", (Object[])new Object[0]));
            this.myInstallButton.setVisible(!installed);
            this.myUpdateButton.setVisible(false);
            this.myGearButton.setVisible(false);
        } else {
            this.myInstallButton.setVisible(false);
            boolean uninstalled = this.myPlugin instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)this.myPlugin).isDeleted();
            boolean uninstalledWithoutRestart = InstalledPluginsState.getInstance().wasUninstalledWithoutRestart(this.myPlugin.getPluginId());
            if (!uninstalled) {
                PluginId id2;
                InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
                boolean bl = uninstalled = pluginsState.wasInstalled(id2 = this.myPlugin.getPluginId()) || pluginsState.wasUpdated(id2);
            }
            if (uninstalled) {
                if (uninstalledWithoutRestart) {
                    this.myRestartButton.setVisible(false);
                    this.myInstallButton.setVisible(true);
                    this.myInstallButton.setEnabled(false, IdeBundle.message((String)"plugins.configurable.uninstalled", (Object[])new Object[0]));
                } else {
                    this.myRestartButton.setVisible(true);
                }
                this.myUpdateButton.setVisible(false);
            } else {
                this.myRestartButton.setVisible(false);
                this.updateEnabledForProject();
                this.myUpdateButton.setVisible(this.myUpdateDescriptor != null && !installedWithoutRestart);
            }
            this.myGearButton.setVisible(!uninstalled);
            this.updateEnableForNameAndIcon();
            this.updateErrors();
        }
    }

    private void updateIcon() {
        this.updateIcon(this.myPluginModel.getErrors(this.myPlugin));
    }

    private void updateIcon(@NotNull List<? extends HtmlChunk> errors2) {
        if (errors2 == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(11);
        }
        boolean hasErrors = !this.myMarketplace && !errors2.isEmpty();
        this.myIconLabel.setEnabled(this.myMarketplace || this.myPluginModel.isEnabled(this.myPlugin));
        this.myIconLabel.setIcon(this.myPluginModel.getIcon(this.myPlugin, true, hasErrors, false));
        this.myIconLabel.setDisabledIcon(this.myPluginModel.getIcon(this.myPlugin, true, hasErrors, true));
    }

    private void updateErrors() {
        @NotNull List<? extends HtmlChunk> errors2 = this.myPluginModel.getErrors(this.myPlugin);
        this.updateIcon(errors2);
        this.myErrorComponent.setErrors(errors2, this::handleErrors);
    }

    private void handleErrors() {
        this.myPluginModel.enableRequiredPlugins(this.myPlugin);
        this.updateIcon();
        this.updateEnabledState();
        this.fullRepaint();
    }

    public void showProgress() {
        this.myIndicator = new OneLineProgressIndicator(false);
        this.myIndicator.setCancelRunnable(() -> this.myPluginModel.finishInstall(this.myPlugin, null, false, false, true));
        this.myNameAndButtons.setProgressComponent(null, this.myIndicator.createBaselineWrapper());
        MyPluginModel.addProgress(this.myPlugin, this.myIndicator);
        this.fullRepaint();
    }

    private void fullRepaint() {
        this.doLayout();
        this.revalidate();
        this.repaint();
    }

    public void hideProgress(boolean success2) {
        this.hideProgress(success2, true);
    }

    private void hideProgress(boolean success2, boolean repaint) {
        this.myIndicator = null;
        this.myNameAndButtons.removeProgressComponent();
        if (success2) {
            this.updateButtons();
        }
        if (repaint) {
            this.fullRepaint();
        }
    }

    private void updateEnableForNameAndIcon() {
        boolean enabled = this.myPluginModel.isEnabled(this.myPlugin);
        this.myNameComponent.setForeground(enabled ? null : ListPluginComponent.DisabledColor);
        this.myIconLabel.setEnabled(enabled);
    }

    public void updateEnabledState() {
        if (this.myMarketplace || this.myPlugin == null) {
            return;
        }
        this.updateEnableForNameAndIcon();
        this.updateErrors();
        this.updateEnabledForProject();
        this.myUpdateButton.setVisible(this.myUpdateDescriptor != null);
        this.fullRepaint();
    }

    private void updateEnabledForProject() {
        ProjectDependentPluginEnabledState state = this.myPluginModel.getProjectDependentState(Objects.requireNonNull(this.myPlugin));
        this.myEnabledForProject.setText(state.toString());
        this.myEnabledForProject.setIcon(state.getIcon());
    }

    public void startLoading() {
        this.select(1, true);
        this.setEmptyState(EmptyState.PROGRESS);
        this.fullRepaint();
    }

    public void stopLoading() {
        this.myLoadingIcon.suspend();
        this.myLoadingIcon.setVisible(false);
        this.fullRepaint();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.updateIconLocation();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.updateIconLocation();
    }

    private void updateIconLocation() {
        if (this.myLoadingIcon.isVisible()) {
            this.myLoadingIcon.updateLocation((JComponent)this);
        }
    }

    @Nullable
    @Nls
    private String getDescription() {
        String description = this.myPlugin.getDescription();
        return StringUtil.isEmptyOrSpaces((String)description) ? null : description;
    }

    @Nullable
    @NlsSafe
    private String getChangeNotes() {
        String notes;
        if (this.myUpdateDescriptor != null && !StringUtil.isEmptyOrSpaces((String)(notes = this.myUpdateDescriptor.getChangeNotes()))) {
            return notes;
        }
        notes = this.myPlugin.getChangeNotes();
        return StringUtil.isEmptyOrSpaces((String)notes) ? null : notes;
    }

    @NotNull
    private SelectionBasedPluginModelAction.EnableDisableAction<PluginDetailsPageComponent> createEnableDisableAction(@NotNull PluginEnableDisableAction action2) {
        if (action2 == null) {
            PluginDetailsPageComponent.$$$reportNull$$$0(12);
        }
        return new SelectionBasedPluginModelAction.EnableDisableAction<PluginDetailsPageComponent>(this.myPluginModel, action2, false, List.of(this), PluginDetailsPageComponent::getPlugin);
    }

    @NotNull
    private SelectionBasedPluginModelAction.UninstallAction<PluginDetailsPageComponent> createUninstallAction() {
        return new SelectionBasedPluginModelAction.UninstallAction<PluginDetailsPageComponent>(this.myPluginModel, false, this, List.of(this), PluginDetailsPageComponent::getPlugin);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchListener";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginDetailsPageComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "centerPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginDetailsPageComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeaderPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNameComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptionComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isShowingPlugin";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMetricsPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setFont";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showPlugins";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showPluginImpl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateIcon";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createEnableDisableAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum EmptyState {
        NONE_SELECTED,
        MULTI_SELECT,
        PROGRESS;

    }
}

