/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginLogoIconProvider;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class PluginLogoIcon
implements PluginLogoIconProvider {
    static final Map<Icon, Icon> disabledIcons = ContainerUtil.createWeakMap((int)200);
    private final Icon myPluginLogo;
    private final Icon myPluginLogoError;
    private final Icon myPluginLogoDisabled;
    private final Icon myPluginLogoDisabledError;
    private final Icon myPluginLogoBig;
    private final Icon myPluginLogoErrorBig;
    private final Icon myPluginLogoDisabledBig;
    private final Icon myPluginLogoDisabledErrorBig;

    PluginLogoIcon(@NotNull Icon logo, @NotNull Icon logoDisabled, @NotNull Icon logoBig, @NotNull Icon logoDisabledBig) {
        if (logo == null) {
            PluginLogoIcon.$$$reportNull$$$0(0);
        }
        if (logoDisabled == null) {
            PluginLogoIcon.$$$reportNull$$$0(1);
        }
        if (logoBig == null) {
            PluginLogoIcon.$$$reportNull$$$0(2);
        }
        if (logoDisabledBig == null) {
            PluginLogoIcon.$$$reportNull$$$0(3);
        }
        this.myPluginLogo = logo;
        this.myPluginLogoError = PluginLogoIcon.setSouthWest(logo, AllIcons.Plugins.ModifierInvalid);
        this.myPluginLogoDisabled = logoDisabled;
        this.myPluginLogoDisabledError = PluginLogoIcon.setSouthWest(logoDisabled, AllIcons.Plugins.ModifierInvalid);
        Icon errorLogo2x = this.getErrorLogo2x();
        this.myPluginLogoBig = logoBig;
        this.myPluginLogoErrorBig = PluginLogoIcon.setSouthWest(logoBig, errorLogo2x);
        this.myPluginLogoDisabledBig = logoDisabledBig;
        this.myPluginLogoDisabledErrorBig = PluginLogoIcon.setSouthWest(logoDisabledBig, errorLogo2x);
    }

    @NotNull
    protected Icon getDisabledIcon(@NotNull Icon icon2, boolean base) {
        if (icon2 == null) {
            PluginLogoIcon.$$$reportNull$$$0(4);
        }
        return PluginLogoIcon.createDisabledIcon(icon2, base);
    }

    @NotNull
    protected static Icon createDisabledIcon(@NotNull Icon icon2, boolean base) {
        if (icon2 == null) {
            PluginLogoIcon.$$$reportNull$$$0(5);
        }
        return PluginLogoIcon.calculateDisabledIcon(icon2, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static Icon calculateDisabledIcon(@NotNull Icon icon2, boolean base) {
        if (icon2 == null) {
            PluginLogoIcon.$$$reportNull$$$0(6);
        }
        if (icon2 instanceof IconLoader.LazyIcon) {
            icon2 = ((IconLoader.LazyIcon)icon2).retrieveIcon();
        }
        Map<Icon, Icon> map2 = disabledIcons;
        // MONITORENTER : map2
        Icon disabledIcon = disabledIcons.get(icon2);
        if (disabledIcon == null) {
            disabledIcon = base ? IconLoader.filterIcon((Icon)icon2, () -> new UIUtil.GrayFilter(), null) : IconLoader.filterIcon((Icon)icon2, () -> new UIUtil.GrayFilter(JBColor.isBright() ? 20 : 19, 0, 100), null);
            disabledIcons.put(icon2, disabledIcon);
        }
        Icon icon3 = disabledIcon;
        // MONITOREXIT : map2
        if (icon3 != null) return icon3;
        PluginLogoIcon.$$$reportNull$$$0(7);
        return icon3;
    }

    @NotNull
    protected Icon getScaled2xIcon(@NotNull Icon icon2) {
        if (icon2 == null) {
            PluginLogoIcon.$$$reportNull$$$0(8);
        }
        Icon icon3 = IconUtil.scale(icon2, null, 2.0f);
        if (icon3 == null) {
            PluginLogoIcon.$$$reportNull$$$0(9);
        }
        return icon3;
    }

    @NotNull
    private static Icon setSouthWest(@NotNull Icon main2, @NotNull Icon southWest) {
        if (main2 == null) {
            PluginLogoIcon.$$$reportNull$$$0(10);
        }
        if (southWest == null) {
            PluginLogoIcon.$$$reportNull$$$0(11);
        }
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(main2, 0);
        layeredIcon.setIcon(southWest, 1, 6);
        LayeredIcon layeredIcon2 = layeredIcon;
        if (layeredIcon2 == null) {
            PluginLogoIcon.$$$reportNull$$$0(12);
        }
        return layeredIcon2;
    }

    @NotNull
    protected Icon getErrorLogo2x() {
        Icon icon2 = PluginLogo.reloadIcon(AllIcons.Plugins.ModifierInvalid, 20, 20, PluginLogo.LOG);
        if (icon2 == null) {
            PluginLogoIcon.$$$reportNull$$$0(13);
        }
        return icon2;
    }

    @Override
    @NotNull
    public Icon getIcon(boolean big, boolean error, boolean disabled) {
        if (error) {
            if (big) {
                Icon icon2 = disabled ? this.myPluginLogoDisabledErrorBig : this.myPluginLogoErrorBig;
                if (icon2 == null) {
                    PluginLogoIcon.$$$reportNull$$$0(14);
                }
                return icon2;
            }
            Icon icon3 = disabled ? this.myPluginLogoDisabledError : this.myPluginLogoError;
            if (icon3 == null) {
                PluginLogoIcon.$$$reportNull$$$0(15);
            }
            return icon3;
        }
        if (big) {
            Icon icon4 = disabled ? this.myPluginLogoDisabledBig : this.myPluginLogoBig;
            if (icon4 == null) {
                PluginLogoIcon.$$$reportNull$$$0(16);
            }
            return icon4;
        }
        Icon icon5 = disabled ? this.myPluginLogoDisabled : this.myPluginLogo;
        if (icon5 == null) {
            PluginLogoIcon.$$$reportNull$$$0(17);
        }
        return icon5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logoDisabled";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logoBig";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logoDisabledBig";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginLogoIcon";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "main";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "southWest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginLogoIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDisabledIcon";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScaled2xIcon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "setSouthWest";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorLogo2x";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDisabledIcon";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDisabledIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateDisabledIcon";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getScaled2xIcon";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setSouthWest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

