/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AttachableProjectViewPane
extends ProjectViewPane {
    private final DropAreaDecorator myDecorator = new DropAreaDecorator();

    public AttachableProjectViewPane(Project project) {
        super(project);
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = IdeBundle.message((String)"attachable.project.pane.name", (Object[])new Object[0]);
        if (string == null) {
            AttachableProjectViewPane.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected ProjectViewTree createTree(@NotNull DefaultTreeModel treeModel) {
        if (treeModel == null) {
            AttachableProjectViewPane.$$$reportNull$$$0(1);
        }
        ProjectViewTree tree = super.createTree(treeModel);
        tree.getEmptyText().setText(IdeBundle.message((String)"label.empty.text.attach.directories.with.right.click", (Object[])new Object[0]));
        ProjectViewTree projectViewTree = tree;
        if (projectViewTree == null) {
            AttachableProjectViewPane.$$$reportNull$$$0(2);
        }
        return projectViewTree;
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        JComponent jComponent = this.myDecorator.wrap(super.createComponent());
        if (jComponent == null) {
            AttachableProjectViewPane.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @Override
    protected void beforeDnDUpdate(DnDEvent event) {
        this.myDecorator.processDnD(event);
    }

    @Override
    protected void beforeDnDLeave() {
        this.myDecorator.processDnD(null);
    }

    @Override
    @NotNull
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new ProjectViewPane.ProjectViewPaneTreeStructure(){

            @Override
            protected AbstractTreeNode<?> createRoot(@NotNull Project project, @NotNull ViewSettings settings) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (settings == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new ProjectViewProjectNode(project, settings){

                    @Override
                    @NotNull
                    public Collection<AbstractTreeNode<?>> getChildren() {
                        Project project = Objects.requireNonNull(this.getProject());
                        LinkedHashSet result2 = new LinkedHashSet();
                        PsiManager psiManager = PsiManager.getInstance((Project)project);
                        for (VirtualFile virtualFile2 : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
                            PsiDirectory directory = psiManager.findDirectory(virtualFile2);
                            if (directory == null) continue;
                            result2.add((AbstractTreeNode<?>)new PsiDirectoryNode(this.getProject(), directory, this.getSettings()){

                                @Override
                                protected boolean shouldShowModuleName() {
                                    return false;
                                }
                            });
                        }
                        LinkedHashSet linkedHashSet = result2;
                        if (linkedHashSet == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return linkedHashSet;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/AttachableProjectViewPane$1$1", "getChildren"));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "settings";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/projectView/AttachableProjectViewPane$1";
                objectArray[2] = "createRoot";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected void processDroppedDirectories(@NotNull List<VirtualFile> dirs) {
        if (dirs == null) {
            AttachableProjectViewPane.$$$reportNull$$$0(4);
        }
        if (dirs.isEmpty()) {
            return;
        }
        Module[] modules2 = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (modules2.length == 0) {
            return;
        }
        Module module = modules2[0];
        ModuleRootModificationUtil.updateModel((Module)module, model2 -> {
            for (VirtualFile file2 : dirs) {
                model2.addContentEntry(file2);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/AttachableProjectViewPane";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/AttachableProjectViewPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDroppedDirectories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DropAreaDecorator
    extends JPanel
    implements DnDTargetChecker,
    DnDDropHandler {
        private JComponent myWrappee;
        private final JPanel myDropArea;
        private final JLabel myLabel;

        DropAreaDecorator() {
            super(new BorderLayout());
            this.myDropArea = new JPanel(new BorderLayout());
            this.myLabel = new JLabel(IdeBundle.message((String)"label.text.html.center.drop.here.to.attach.br.as.a.root.directory.center.html", (Object[])new Object[0]));
            this.myLabel.setHorizontalAlignment(0);
            this.myLabel.setForeground((Color)new JBColor(ColorUtil.fromHex((String)"8b98ad"), ColorUtil.fromHex((String)"6c7073")));
            this.myLabel.setBorder(JBUI.Borders.empty((int)25));
            this.myDropArea.setBackground((Color)new JBColor(ColorUtil.fromHex((String)"edf4ff"), ColorUtil.fromHex((String)"343638")));
            this.myDropArea.add((Component)this.myLabel, "Center");
        }

        @NotNull
        private List<VirtualFile> getDirectories(@NotNull DnDEvent event) {
            if (event == null) {
                DropAreaDecorator.$$$reportNull$$$0(0);
            }
            List list2 = ContainerUtil.filter(FileCopyPasteUtil.getVirtualFileListFromAttachedObject(event.getAttachedObject()), file2 -> file2.isDirectory());
            if (list2 == null) {
                DropAreaDecorator.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @NotNull
        private JComponent wrap(@NotNull JComponent wrappee) {
            if (wrappee == null) {
                DropAreaDecorator.$$$reportNull$$$0(2);
            }
            if (wrappee != this.myWrappee) {
                this.myWrappee = wrappee;
                this.init(wrappee);
            }
            DropAreaDecorator dropAreaDecorator = this;
            if (dropAreaDecorator == null) {
                DropAreaDecorator.$$$reportNull$$$0(3);
            }
            return dropAreaDecorator;
        }

        private void init(@NotNull JComponent wrappee) {
            if (wrappee == null) {
                DropAreaDecorator.$$$reportNull$$$0(4);
            }
            Runnable leaveCallback = () -> {
                if (!this.isOverComponent((JComponent)((Object)AttachableProjectViewPane.this.myTree)) && !this.isOverComponent(this.myLabel)) {
                    this.hideDropArea();
                }
            };
            DnDSupport.createBuilder((JComponent)this.myDropArea).enableAsNativeTarget().setCleanUpOnLeaveCallback(leaveCallback).setDropEndedCallback(() -> this.hideDropArea()).setTargetChecker((DnDTargetChecker)this).setDropHandler((DnDDropHandler)this).setDisposableParent((Disposable)AttachableProjectViewPane.this).install();
            this.hideDropArea();
            this.removeAll();
            this.add((Component)this.myDropArea, "South");
            this.add((Component)wrappee, "Center");
        }

        private void hideDropArea() {
            this.myLabel.setVisible(false);
        }

        public void drop(@NotNull DnDEvent event) {
            if (event == null) {
                DropAreaDecorator.$$$reportNull$$$0(5);
            }
            this.hideDropArea();
            AttachableProjectViewPane.this.processDroppedDirectories(this.getDirectories(event));
        }

        public boolean update(@NotNull DnDEvent event) {
            if (event == null) {
                DropAreaDecorator.$$$reportNull$$$0(6);
            }
            if (!this.isDroppable(event)) {
                this.hideDropArea();
                return false;
            }
            event.setHighlighting((Component)this.myLabel, 1);
            event.setDropPossible(true);
            this.myDropArea.setVisible(true);
            return false;
        }

        private boolean isDroppable(@NotNull DnDEvent event) {
            if (event == null) {
                DropAreaDecorator.$$$reportNull$$$0(7);
            }
            return FileCopyPasteUtil.isFileListFlavorAvailable(event);
        }

        private boolean isOverComponent(@Nullable JComponent component2) {
            if (component2 == null) {
                return false;
            }
            Point location = MouseInfo.getPointerInfo().getLocation();
            Point p = new Point(location);
            SwingUtilities.convertPointFromScreen(p, component2);
            return component2.getVisibleRect().contains(p);
        }

        private void processDnD(DnDEvent event) {
            if (event != null) {
                this.myLabel.setVisible(this.isDroppable(event));
            } else if (!this.isOverComponent(this.myLabel)) {
                this.hideDropArea();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/projectView/AttachableProjectViewPane$DropAreaDecorator";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappee";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/projectView/AttachableProjectViewPane$DropAreaDecorator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectories";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getDirectories";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "wrap";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "init";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "drop";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isDroppable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

