/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class MarkSourceRootAction
extends MarkRootActionBase {
    private static final Logger LOG = Logger.getInstance(MarkSourceRootAction.class);
    private final JpsModuleSourceRootType<?> myRootType;

    public MarkSourceRootAction(@NotNull JpsModuleSourceRootType<?> type) {
        if (type == null) {
            MarkSourceRootAction.$$$reportNull$$$0(0);
        }
        this.myRootType = type;
        Presentation presentation2 = this.getTemplatePresentation();
        ModuleSourceRootEditHandler<?> editHandler = ModuleSourceRootEditHandler.getEditHandler(type);
        LOG.assertTrue(editHandler != null);
        presentation2.setIcon(editHandler.getRootIcon());
        presentation2.setText(editHandler.getFullRootTypeName());
        presentation2.setDescription(ProjectBundle.messagePointer((String)"module.toggle.sources.action.description", (Object[])new Object[]{editHandler.getFullRootTypeName().toLowerCase(Locale.getDefault())}));
    }

    @Override
    protected void modifyRoots(@NotNull VirtualFile vFile, @NotNull ContentEntry entry2) {
        if (vFile == null) {
            MarkSourceRootAction.$$$reportNull$$$0(1);
        }
        if (entry2 == null) {
            MarkSourceRootAction.$$$reportNull$$$0(2);
        }
        entry2.addSourceFolder(vFile, this.myRootType);
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module) {
        ModuleType moduleType;
        if (selection == null) {
            MarkSourceRootAction.$$$reportNull$$$0(3);
        }
        if (module == null) {
            MarkSourceRootAction.$$$reportNull$$$0(4);
        }
        if (!(moduleType = ModuleType.get((Module)module)).isSupportedRootType(this.myRootType) || ModuleSourceRootEditHandler.getEditHandler(this.myRootType) == null || selection.myHaveSelectedFilesUnderSourceRoots && !moduleType.isMarkInnerSupportedFor(this.myRootType)) {
            return false;
        }
        if (!selection.mySelectedDirectories.isEmpty()) {
            return true;
        }
        for (SourceFolder root2 : selection.mySelectedRoots) {
            if (this.myRootType.equals((Object)root2.getRootType())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/actions/MarkSourceRootAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyRoots";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

