/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.AsyncProjectViewSupport;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.TreeBuilderUtil;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.stripe.ErrorStripe;
import com.intellij.ui.stripe.ErrorStripePainter;
import com.intellij.ui.stripe.TreeUpdater;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractProjectViewPSIPane
extends AbstractProjectViewPane {
    private AsyncProjectViewSupport myAsyncSupport;
    private JScrollPane myComponent;

    protected AbstractProjectViewPSIPane(@NotNull Project project) {
        if (project == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        if (this.myComponent != null) {
            SwingUtilities.updateComponentTreeUI(this.myComponent);
            JScrollPane jScrollPane = this.myComponent;
            if (jScrollPane == null) {
                AbstractProjectViewPSIPane.$$$reportNull$$$0(1);
            }
            return jScrollPane;
        }
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(null);
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.myTree = this.createTree(treeModel);
        this.enableDnD();
        this.myComponent = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree));
        if (Registry.is((String)"error.stripe.enabled")) {
            ErrorStripePainter painter = new ErrorStripePainter(true);
            Disposer.register((Disposable)this, (Disposable)new TreeUpdater<ErrorStripePainter>(painter, this.myComponent, (JTree)((Object)this.myTree)){

                @Override
                protected void update(ErrorStripePainter painter, int index2, Object object) {
                    if (object instanceof DefaultMutableTreeNode) {
                        DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)object;
                        object = node2.getUserObject();
                    }
                    super.update(painter, index2, AbstractProjectViewPSIPane.this.getStripe(object, AbstractProjectViewPSIPane.this.myTree.isExpanded(index2)));
                }
            });
        }
        this.myTreeStructure = this.createStructure();
        BaseProjectTreeBuilder treeBuilder = this.createBuilder(treeModel);
        if (treeBuilder != null) {
            this.installComparator(treeBuilder);
            this.setTreeBuilder(treeBuilder);
        } else {
            this.myAsyncSupport = new AsyncProjectViewSupport(this, this.myProject, this.myTreeStructure, this.createComparator());
            this.myAsyncSupport.setModelTo((JTree)((Object)this.myTree));
        }
        this.initTree();
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)((Object)this.myTree), new Activatable(){
            private boolean showing;

            public void showNotify() {
                if (!this.showing) {
                    this.showing = true;
                    AbstractProjectViewPSIPane.this.restoreExpandedPaths();
                }
            }

            public void hideNotify() {
                if (this.showing) {
                    this.showing = false;
                    AbstractProjectViewPSIPane.this.saveExpandedPaths();
                }
            }
        }));
        JScrollPane jScrollPane = this.myComponent;
        if (jScrollPane == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(2);
        }
        return jScrollPane;
    }

    @Override
    protected void installComparator(AbstractTreeBuilder builder2, @NotNull Comparator<? super NodeDescriptor<?>> comparator2) {
        if (comparator2 == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(3);
        }
        if (this.myAsyncSupport != null) {
            this.myAsyncSupport.setComparator(comparator2);
        }
        super.installComparator(builder2, comparator2);
    }

    @Override
    public final void dispose() {
        this.myAsyncSupport = null;
        this.myComponent = null;
        super.dispose();
    }

    private void initTree() {
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.getSelectionModel().addTreeSelectionListener(e -> this.onSelectionChanged());
        this.myTree.addFocusListener(new FocusListener(){

            void updateIfMultipleSelection() {
                if (AbstractProjectViewPSIPane.this.myTree != null && AbstractProjectViewPSIPane.this.myTree.getSelectionCount() > 1) {
                    AbstractProjectViewPSIPane.this.onSelectionChanged();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                this.updateIfMultipleSelection();
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.updateIfMultipleSelection();
            }
        });
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.expandPath(new TreePath(this.myTree.getModel().getRoot()));
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree));
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this.myTree));
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myTree));
        TreeUtil.installActions((JTree)((Object)this.myTree));
        new MySpeedSearch((JTree)((Object)this.myTree));
        this.myTree.addKeyListener(new PsiCopyPasteManager.EscapeHandler());
        CustomizationUtil.installPopupHandler((JComponent)((Object)this.myTree), "ProjectViewPopupMenu", "ProjectViewPopup");
    }

    protected void onSelectionChanged() {
        if (this.myTree != null && this.myTree.getSelectionModel() != null) {
            int count = this.myTree.getSelectionModel().getSelectionCount();
            String description = count > 1 && this.myTree.hasFocus() ? LangBundle.message((String)"project.view.elements.selected", (Object[])new Object[]{count}) : null;
            ActionMenu.showDescriptionInStatusBar(true, (Component)((Object)this.myTree), description);
        }
    }

    @Override
    @NotNull
    public final ActionCallback updateFromRoot(boolean restoreExpandedPaths) {
        Runnable afterUpdate;
        ActionCallback cb2 = new ActionCallback();
        AbstractTreeBuilder builder2 = this.getTreeBuilder();
        if (restoreExpandedPaths && builder2 != null) {
            ArrayList pathsToExpand = new ArrayList();
            ArrayList selectionPaths = new ArrayList();
            TreeBuilderUtil.storePaths((AbstractTreeBuilder)builder2, (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myTree.getModel().getRoot()), pathsToExpand, selectionPaths, (boolean)true);
            afterUpdate = () -> {
                if (this.myTree != null && !builder2.isDisposed()) {
                    this.myTree.clearSelection();
                    TreeBuilderUtil.restorePaths((AbstractTreeBuilder)builder2, (List)pathsToExpand, (List)selectionPaths, (boolean)true);
                }
                cb2.setDone();
            };
        } else {
            afterUpdate = cb2.createSetDoneRunnable();
        }
        if (builder2 != null) {
            builder2.addSubtreeToUpdate(builder2.getRootNode(), afterUpdate);
        } else if (this.myAsyncSupport != null) {
            this.myAsyncSupport.updateAll(afterUpdate);
        } else {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                AbstractProjectViewPSIPane.$$$reportNull$$$0(4);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = cb2;
        if (actionCallback == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(5);
        }
        return actionCallback;
    }

    @Override
    public void select(Object element2, VirtualFile file2, boolean requestFocus) {
        this.selectCB(element2, file2, requestFocus);
    }

    @NotNull
    public ActionCallback selectCB(Object element2, VirtualFile file2, boolean requestFocus) {
        if (file2 != null) {
            AbstractTreeBuilder builder2 = this.getTreeBuilder();
            if (builder2 instanceof BaseProjectTreeBuilder) {
                this.beforeSelect().doWhenDone(() -> UIUtil.invokeLaterIfNeeded(() -> {
                    if (!builder2.isDisposed()) {
                        ((BaseProjectTreeBuilder)builder2).selectAsync(element2, file2, requestFocus);
                    }
                }));
            } else if (this.myAsyncSupport != null) {
                ActionCallback actionCallback = this.myAsyncSupport.select((JTree)((Object)this.myTree), element2, file2);
                if (actionCallback == null) {
                    AbstractProjectViewPSIPane.$$$reportNull$$$0(6);
                }
                return actionCallback;
            }
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(7);
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback beforeSelect() {
        AbstractTreeBuilder builder2 = this.getTreeBuilder();
        if (builder2 == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                AbstractProjectViewPSIPane.$$$reportNull$$$0(8);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = builder2.getInitialized();
        if (actionCallback == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(9);
        }
        return actionCallback;
    }

    protected BaseProjectTreeBuilder createBuilder(@NotNull DefaultTreeModel treeModel) {
        if (treeModel == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(10);
        }
        return new ProjectTreeBuilder(this.myProject, (JTree)((Object)this.myTree), treeModel, null, (ProjectAbstractTreeStructureBase)this.myTreeStructure){

            protected AbstractTreeUpdater createUpdater() {
                return AbstractProjectViewPSIPane.this.createTreeUpdater(this);
            }
        };
    }

    @NotNull
    protected abstract ProjectAbstractTreeStructureBase createStructure();

    @NotNull
    protected abstract ProjectViewTree createTree(@NotNull DefaultTreeModel var1);

    @NotNull
    protected abstract AbstractTreeUpdater createTreeUpdater(@NotNull AbstractTreeBuilder var1);

    protected ErrorStripe getStripe(Object object, boolean expanded2) {
        if (expanded2 && object instanceof PsiDirectoryNode) {
            return null;
        }
        if (object instanceof PresentableNodeDescriptor) {
            Color color;
            PresentableNodeDescriptor node2 = (PresentableNodeDescriptor)object;
            TextAttributesKey key = node2.getPresentation().getTextAttributesKey();
            TextAttributes attributes2 = key == null ? null : EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getAttributes(key);
            Color color2 = color = attributes2 == null ? null : attributes2.getErrorStripeColor();
            if (color != null) {
                return ErrorStripe.create(color, 1);
            }
        }
        return null;
    }

    @Override
    AsyncProjectViewSupport getAsyncSupport() {
        return this.myAsyncSupport;
    }

    @ApiStatus.Internal
    @NotNull
    public AsyncProjectViewSupport createAsyncSupport(@NotNull Disposable parent, @NotNull Comparator<NodeDescriptor<?>> comparator2) {
        if (parent == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(11);
        }
        if (comparator2 == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(12);
        }
        return new AsyncProjectViewSupport(parent, this.myProject, this.createStructure(), comparator2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/AbstractProjectViewPSIPane";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractProjectViewPSIPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "updateFromRoot";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "selectCB";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeSelect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installComparator";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createAsyncSupport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class MySpeedSearch
    extends TreeSpeedSearch {
        MySpeedSearch(JTree tree) {
            super(tree);
        }

        @Override
        protected boolean isMatchingElement(Object element2, String pattern) {
            Object userObject = ((DefaultMutableTreeNode)((TreePath)element2).getLastPathComponent()).getUserObject();
            if (userObject instanceof PsiDirectoryNode) {
                String str = this.getElementText(element2);
                if (str == null) {
                    return false;
                }
                if (pattern.indexOf(46) >= 0) {
                    return this.compare(str, pattern);
                }
                StringTokenizer tokenizer = new StringTokenizer(str, ".");
                while (tokenizer.hasMoreTokens()) {
                    String token2 = tokenizer.nextToken();
                    if (!this.compare(token2, pattern)) continue;
                    return true;
                }
                return false;
            }
            return super.isMatchingElement(element2, pattern);
        }
    }
}

