/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectPaneSelectInTarget;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.ModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.PlatformUtils;
import java.awt.EventQueue;
import java.awt.Font;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectViewPane
extends AbstractProjectViewPSIPane {
    @NonNls
    public static final String ID = "ProjectPane";

    public ProjectViewPane(Project project) {
        super(project);
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = IdeBundle.message((String)"title.project", (Object[])new Object[0]);
        if (string == null) {
            ProjectViewPane.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon2 = AllIcons.General.ProjectTab;
        if (icon2 == null) {
            ProjectViewPane.$$$reportNull$$$0(1);
        }
        return icon2;
    }

    @Override
    @NotNull
    public SelectInTarget createSelectInTarget() {
        return new ProjectPaneSelectInTarget(this.myProject);
    }

    @Override
    @NotNull
    protected AbstractTreeUpdater createTreeUpdater(@NotNull AbstractTreeBuilder treeBuilder) {
        if (treeBuilder == null) {
            ProjectViewPane.$$$reportNull$$$0(2);
        }
        return new ProjectViewTreeUpdater(treeBuilder);
    }

    @Override
    @NotNull
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new ProjectViewPaneTreeStructure();
    }

    @Override
    @NotNull
    protected ProjectViewTree createTree(@NotNull DefaultTreeModel treeModel) {
        if (treeModel == null) {
            ProjectViewPane.$$$reportNull$$$0(3);
        }
        return new ProjectViewTree((TreeModel)treeModel){

            public String toString() {
                return ProjectViewPane.this.getTitle() + " " + super.toString();
            }

            public void setFont(Font font) {
                if (AdvancedSettings.getBoolean((String)"bigger.font.in.project.view")) {
                    font = font.deriveFont((float)font.getSize() + 1.0f);
                }
                super.setFont(font);
            }

            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = super.getAccessibleContext();
                    this.accessibleContext.setAccessibleName(IdeBundle.message((String)"project.structure.tree.accessible.name", (Object[])new Object[0]));
                }
                return this.accessibleContext;
            }
        };
    }

    @NotNull
    public String getComponentName() {
        return ID;
    }

    private boolean hasSeveralTopLevelModuleNodes() {
        Object root2;
        if (!EventQueue.isDispatchThread()) {
            return true;
        }
        TreeModel treeModel = this.myTree.getModel();
        int count = treeModel.getChildCount(root2 = treeModel.getRoot());
        if (count <= 1) {
            return false;
        }
        int moduleNodes = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            Object node2;
            Object child2 = treeModel.getChild(root2, i2);
            if (!(child2 instanceof DefaultMutableTreeNode) || !((node2 = ((DefaultMutableTreeNode)child2).getUserObject()) instanceof ProjectViewModuleNode || node2 instanceof PsiDirectoryNode ? ++moduleNodes > 1 : node2 instanceof ModuleGroupNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFileNestingEnabled() {
        return true;
    }

    @Override
    public int getWeight() {
        return 0;
    }

    @Override
    protected BaseProjectTreeBuilder createBuilder(@NotNull DefaultTreeModel model2) {
        if (model2 == null) {
            ProjectViewPane.$$$reportNull$$$0(4);
        }
        return null;
    }

    public static boolean canBeSelectedInProjectView(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            ProjectViewPane.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            ProjectViewPane.$$$reportNull$$$0(6);
        }
        VirtualFile archiveFile = file2.getFileSystem() instanceof ArchiveFileSystem ? ((ArchiveFileSystem)file2.getFileSystem()).getLocalByEntry(file2) : null;
        ProjectFileIndex index2 = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return archiveFile != null && index2.getContentRootForFile(archiveFile, false) != null || index2.getContentRootForFile(file2, false) != null || index2.isInLibrary(file2) || Comparing.equal((Object)file2.getParent(), (Object)project.getBaseDir()) || ScratchUtil.isScratch((VirtualFile)file2);
    }

    @Override
    public boolean supportsFlattenModules() {
        return PlatformUtils.isIntelliJ() && ModuleGrouperKt.isQualifiedModuleNamesEnabled((Project)this.myProject) && this.hasSeveralTopLevelModuleNodes();
    }

    @Override
    public boolean supportsShowExcludedFiles() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewPane";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewPane";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTreeUpdater";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canBeSelectedInProjectView";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class ProjectViewPaneTreeStructure
    extends ProjectTreeStructure
    implements ProjectViewSettings {
        protected ProjectViewPaneTreeStructure() {
            super(ProjectViewPane.this.myProject, ProjectViewPane.ID);
        }

        protected AbstractTreeNode<?> createRoot(@NotNull Project project, @NotNull ViewSettings settings) {
            if (project == null) {
                ProjectViewPaneTreeStructure.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                ProjectViewPaneTreeStructure.$$$reportNull$$$0(1);
            }
            return new ProjectViewProjectNode(project, settings);
        }

        @Override
        public boolean isShowExcludedFiles() {
            return ProjectView.getInstance(this.myProject).isShowExcludedFiles(ProjectViewPane.ID);
        }

        @Override
        public boolean isShowLibraryContents() {
            return true;
        }

        @Override
        public boolean isShowVisibilityIcons() {
            return ProjectView.getInstance(this.myProject).isShowVisibilityIcons(ProjectViewPane.ID);
        }

        @Override
        public boolean isUseFileNestingRules() {
            return ProjectView.getInstance(this.myProject).isUseFileNestingRules(ProjectViewPane.ID);
        }

        public boolean isToBuildChildrenInBackground(@NotNull Object element2) {
            if (element2 == null) {
                ProjectViewPaneTreeStructure.$$$reportNull$$$0(2);
            }
            return Registry.is((String)"ide.projectView.ProjectViewPaneTreeStructure.BuildChildrenInBackground");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewPane$ProjectViewPaneTreeStructure";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRoot";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isToBuildChildrenInBackground";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ProjectViewTreeUpdater
    extends AbstractTreeUpdater {
        private ProjectViewTreeUpdater(AbstractTreeBuilder treeBuilder) {
            super(treeBuilder);
        }

        public boolean addSubtreeToUpdateByElement(@NotNull Object element2) {
            if (element2 == null) {
                ProjectViewTreeUpdater.$$$reportNull$$$0(0);
            }
            if (element2 instanceof PsiDirectory && !ProjectViewPane.this.myProject.isDisposed()) {
                boolean addedOk;
                PsiDirectory dirToUpdateFrom;
                PsiDirectory dir = (PsiDirectory)element2;
                ProjectTreeStructure treeStructure = (ProjectTreeStructure)ProjectViewPane.this.myTreeStructure;
                if (!treeStructure.isFlattenPackages() && treeStructure.isHideEmptyMiddlePackages() && !DumbService.isDumb((Project)ProjectViewPane.this.myProject)) {
                    for (dirToUpdateFrom = dir; dirToUpdateFrom != null && ProjectViewDirectoryHelper.getInstance(ProjectViewPane.this.myProject).isEmptyMiddleDirectory(dirToUpdateFrom, true); dirToUpdateFrom = dirToUpdateFrom.getParentDirectory()) {
                    }
                }
                while (!(addedOk = super.addSubtreeToUpdateByElement(dirToUpdateFrom == null ? ProjectViewPane.this.myTreeStructure.getRootElement() : dirToUpdateFrom)) && dirToUpdateFrom != null) {
                    dirToUpdateFrom = dirToUpdateFrom.getParentDirectory();
                }
                return addedOk;
            }
            return super.addSubtreeToUpdateByElement(element2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/projectView/impl/ProjectViewPane$ProjectViewTreeUpdater", "addSubtreeToUpdateByElement"));
        }
    }
}

