/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.NodeSortOrder;
import com.intellij.ide.projectView.NodeSortSettings;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.LoadedModuleDescription;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.OptionalLong;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProjectNode
extends ProjectViewNode<Project> {
    protected AbstractProjectNode(Project project, @NotNull Project value2, ViewSettings viewSettings) {
        if (value2 == null) {
            AbstractProjectNode.$$$reportNull$$$0(0);
        }
        super(project, (Object)value2, viewSettings);
    }

    @NotNull
    protected Collection<AbstractTreeNode<?>> modulesAndGroups(@NotNull Collection<? extends ModuleDescription> modules2) {
        if (modules2 == null) {
            AbstractProjectNode.$$$reportNull$$$0(1);
        }
        if (this.getSettings().isFlattenModules()) {
            List list2 = ContainerUtil.mapNotNull(modules2, moduleDescription -> {
                try {
                    return this.createModuleNode((ModuleDescription)moduleDescription);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            });
            if (list2 == null) {
                AbstractProjectNode.$$$reportNull$$$0(2);
            }
            return list2;
        }
        LinkedHashSet<String> topLevelGroups = new LinkedHashSet<String>();
        LinkedHashSet<? extends ModuleDescription> nonGroupedModules = new LinkedHashSet<ModuleDescription>(modules2);
        List commonGroupsPath = null;
        for (ModuleDescription moduleDescription2 : modules2) {
            List list3 = ModuleGrouper.instanceFor((Project)this.myProject).getGroupPath(moduleDescription2);
            if (list3.isEmpty()) continue;
            String topLevelGroupName = (String)list3.get(0);
            topLevelGroups.add(topLevelGroupName);
            nonGroupedModules.remove(moduleDescription2);
            if (commonGroupsPath == null) {
                commonGroupsPath = list3;
                continue;
            }
            int commonPartLen = Math.min(commonGroupsPath.size(), list3.size());
            OptionalLong firstDifference = StreamEx.zip(commonGroupsPath.subList(0, commonPartLen), list3.subList(0, commonPartLen), String::equals).indexOf((Object)false);
            if (firstDifference.isPresent()) {
                commonGroupsPath = commonGroupsPath.subList(0, (int)firstDifference.getAsLong());
                continue;
            }
            if (commonPartLen >= commonGroupsPath.size()) continue;
            commonGroupsPath = commonGroupsPath.subList(0, commonPartLen);
        }
        ArrayList result2 = new ArrayList();
        try {
            if (modules2.size() > 1) {
                if (commonGroupsPath != null && !commonGroupsPath.isEmpty()) {
                    result2.add(this.createModuleGroupNode(new ModuleGroup(commonGroupsPath)));
                } else {
                    for (String string : topLevelGroups) {
                        result2.add(this.createModuleGroupNode(new ModuleGroup(Collections.singletonList(string))));
                    }
                }
                for (ModuleDescription moduleDescription3 : nonGroupedModules) {
                    ContainerUtil.addIfNotNull(result2, this.createModuleNode(moduleDescription3));
                }
            } else {
                ContainerUtil.addIfNotNull(result2, this.createModuleNode((ModuleDescription)ContainerUtil.getFirstItem(modules2)));
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw processCanceledException;
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            return new ArrayList();
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            AbstractProjectNode.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    protected abstract AbstractTreeNode<?> createModuleGroup(@NotNull Module var1) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException;

    @Nullable
    private AbstractTreeNode<?> createModuleNode(ModuleDescription moduleDescription) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        if (moduleDescription instanceof LoadedModuleDescription) {
            return this.createModuleGroup(((LoadedModuleDescription)moduleDescription).getModule());
        }
        if (moduleDescription instanceof UnloadedModuleDescription) {
            return this.createUnloadedModuleNode((UnloadedModuleDescription)moduleDescription);
        }
        return null;
    }

    protected AbstractTreeNode<?> createUnloadedModuleNode(UnloadedModuleDescription moduleDescription) {
        return null;
    }

    @NotNull
    protected abstract AbstractTreeNode<?> createModuleGroupNode(@NotNull ModuleGroup var1) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException;

    public void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            AbstractProjectNode.$$$reportNull$$$0(4);
        }
        presentation2.setIcon(PlatformIcons.PROJECT_ICON);
        presentation2.setPresentableText(this.getProject().getName());
    }

    public String getTestPresentation() {
        return "Project";
    }

    public boolean contains(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            AbstractProjectNode.$$$reportNull$$$0(5);
        }
        assert (this.myProject != null);
        return ProjectViewPane.canBeSelectedInProjectView(this.myProject, vFile);
    }

    @NotNull
    public NodeSortOrder getSortOrder(@NotNull NodeSortSettings settings) {
        if (settings == null) {
            AbstractProjectNode.$$$reportNull$$$0(6);
        }
        NodeSortOrder nodeSortOrder = NodeSortOrder.PROJECT_ROOT;
        if (nodeSortOrder == null) {
            AbstractProjectNode.$$$reportNull$$$0(7);
        }
        return nodeSortOrder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/AbstractProjectNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/AbstractProjectNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "modulesAndGroups";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "modulesAndGroups";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSortOrder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

