/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.NodeSortOrder;
import com.intellij.ide.projectView.NodeSortSettings;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.SyntheticLibraryElementNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ExternalLibrariesNode
extends ProjectViewNode<String> {
    private static final Logger LOG = Logger.getInstance(ExternalLibrariesNode.class);

    public ExternalLibrariesNode(@NotNull Project project, ViewSettings viewSettings) {
        if (project == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(0);
        }
        super(project, (Object)"External Libraries", viewSettings);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        Project project;
        ProjectFileIndex index2;
        if (file2 == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(1);
        }
        return (index2 = ProjectFileIndex.getInstance((Project)(project = Objects.requireNonNull(this.getProject())))).isInLibrary(file2) && this.someChildContainsFile(file2, false);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        Project project = Objects.requireNonNull(this.getProject());
        ArrayList<ProjectViewNode> children2 = new ArrayList<ProjectViewNode>();
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        Module[] modules2 = ModuleManager.getInstance((Project)project).getModules();
        HashMap<String, List> processedLibraries = new HashMap<String, List>();
        HashSet<Sdk> processedSdk = new HashSet<Sdk>();
        for (Module module : modules2) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
                JdkOrderEntry jdkOrderEntry;
                Sdk jdk;
                if (orderEntry instanceof LibraryOrderEntry) {
                    String libraryPresentableName;
                    List librariesWithSameName;
                    LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
                    Library library2 = libraryOrderEntry.getLibrary();
                    if (library2 == null || (librariesWithSameName = (List)processedLibraries.getOrDefault(libraryPresentableName = libraryOrderEntry.getPresentableName(), new ArrayList())).stream().anyMatch(processedLibrary -> processedLibrary.hasSameContent(library2))) continue;
                    librariesWithSameName.add(library2);
                    processedLibraries.put(libraryPresentableName, librariesWithSameName);
                    if (!ExternalLibrariesNode.hasExternalEntries(fileIndex, libraryOrderEntry)) continue;
                    String libraryName = library2.getName();
                    if (libraryName == null || libraryName.length() == 0) {
                        ExternalLibrariesNode.addLibraryChildren(libraryOrderEntry, children2, project, this);
                        continue;
                    }
                    children2.add(new NamedLibraryElementNode(project, new NamedLibraryElement(null, (LibraryOrSdkOrderEntry)libraryOrderEntry), this.getSettings()));
                    continue;
                }
                if (!(orderEntry instanceof JdkOrderEntry) || (jdk = (jdkOrderEntry = (JdkOrderEntry)orderEntry).getJdk()) == null || processedSdk.contains(jdk)) continue;
                processedSdk.add(jdk);
                children2.add(new NamedLibraryElementNode(project, new NamedLibraryElement(null, (LibraryOrSdkOrderEntry)jdkOrderEntry), this.getSettings()));
            }
        }
        for (Module module : (AdditionalLibraryRootsProvider[])AdditionalLibraryRootsProvider.EP_NAME.getExtensions()) {
            Collection libraries2 = module.getAdditionalProjectLibraries(project);
            for (SyntheticLibrary library3 : libraries2) {
                if (!library3.isShowInExternalLibrariesNode()) continue;
                if (!(library3 instanceof ItemPresentation)) {
                    LOG.warn("Synthetic library must implement ItemPresentation to be shown in External Libraries node: " + libraries2.getClass().getSimpleName());
                    continue;
                }
                children2.add(new SyntheticLibraryElementNode(project, library3, (ItemPresentation)library3, this.getSettings()));
            }
        }
        ArrayList<ProjectViewNode> arrayList = children2;
        if (arrayList == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public static void addLibraryChildren(LibraryOrderEntry entry2, List<? super AbstractTreeNode<?>> children2, Project project, ProjectViewNode node2) {
        VirtualFile[] files2;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile file2 : files2 = entry2.getRootFiles(OrderRootType.CLASSES)) {
            PsiDirectory psiDir = psiManager.findDirectory(file2);
            if (psiDir == null) continue;
            children2.add((AbstractTreeNode<?>)new PsiDirectoryNode(project, psiDir, node2.getSettings()));
        }
    }

    private static boolean hasExternalEntries(ProjectFileIndex index2, LibraryOrderEntry orderEntry) {
        for (VirtualFile file2 : LibraryGroupNode.getLibraryRoots(orderEntry)) {
            if (index2.isInContent(VfsUtil.getLocalFile((VirtualFile)file2))) continue;
            return true;
        }
        return false;
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(3);
        }
        presentation2.setPresentableText(IdeBundle.message((String)"node.projectview.external.libraries", (Object[])new Object[0]));
        presentation2.setIcon(PlatformIcons.LIBRARY_ICON);
    }

    @NotNull
    public NodeSortOrder getSortOrder(@NotNull NodeSortSettings settings) {
        if (settings == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(4);
        }
        NodeSortOrder nodeSortOrder = NodeSortOrder.LIBRARY_ROOT;
        if (nodeSortOrder == null) {
            ExternalLibrariesNode.$$$reportNull$$$0(5);
        }
        return nodeSortOrder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/ExternalLibrariesNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/ExternalLibrariesNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSortOrder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

