/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.FileIconProvider;
import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchImplUtil;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.PerFileMappingsBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighterProvider;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.LightDirectoryIndex;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

@State(name="ScratchFileService", storages={@Storage(value="scratches.xml", roamingType=RoamingType.DISABLED)})
public final class ScratchFileServiceImpl
extends ScratchFileService
implements PersistentStateComponent<Element>,
Disposable {
    private static final RootType NO_ROOT_TYPE = new RootType("", "NO_ROOT_TYPE"){};
    private final LightDirectoryIndex<RootType> myIndex;
    private final MyLanguages myScratchMapping = new MyLanguages();
    private final ConcurrentMap<String, String> myRootPaths = ConcurrentFactoryMap.createMap(ScratchFileServiceImpl::calcRootPath);

    private ScratchFileServiceImpl() {
        Disposer.register((Disposable)this, (Disposable)this.myScratchMapping);
        this.myIndex = new LightDirectoryIndex((Disposable)ApplicationManager.getApplication(), (Object)NO_ROOT_TYPE, index2 -> {
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (RootType r : RootType.getAllRootTypes()) {
                index2.putInfo(fileSystem.findFileByPath(this.getRootPath(r)), (Object)r);
            }
        });
        this.initFileOpenedListener();
    }

    public @SystemIndependent @NotNull String getRootPath(@NotNull RootType rootType) {
        if (rootType == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(0);
        }
        String string = (String)this.myRootPaths.get(rootType.getId());
        if (string == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static @SystemIndependent @NotNull String calcRootPath(@NotNull String rootId) {
        String path2;
        if (rootId == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(2);
        }
        if ((path2 = System.getProperty("idea.scratch.path/" + rootId)) != null && path2.length() > 2 && path2.charAt(0) == '\"') {
            path2 = StringUtil.unquoteString((String)path2);
        }
        Object object = path2 != null ? FileUtil.toSystemIndependentName((String)path2) : FileUtil.toSystemIndependentName((String)PathManager.getScratchPath()) + "/" + rootId;
        if (object == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(3);
        }
        return object;
    }

    @Nullable
    public RootType getRootType(@Nullable VirtualFile file2) {
        if (file2 == null || !file2.isInLocalFileSystem()) {
            return null;
        }
        VirtualFile directory = file2.isDirectory() ? file2 : file2.getParent();
        RootType result2 = (RootType)this.myIndex.getInfoForFile(directory);
        return result2 == NO_ROOT_TYPE ? null : result2;
    }

    private void initFileOpenedListener() {
        ScratchFileServiceImpl.processOpenFiles((file2, manager2) -> {
            RootType rootType = this.getRootType((VirtualFile)file2);
            if (rootType != null) {
                rootType.fileOpened(file2, manager2);
            }
        });
        MessageBusConnection messageBusConnection2 = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        messageBusConnection2.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                RootType rootType = ScratchFileServiceImpl.this.getRootType(file2);
                Document document = FileDocumentManager.getInstance().getDocument(file2);
                if (document == null || rootType == null || rootType.isHidden()) {
                    return;
                }
                rootType.fileOpened(file2, source);
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (Boolean.TRUE.equals(file2.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN))) {
                    return;
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    return;
                }
                if (!ScratchFileServiceImpl.this.isToBeDeletedOnClose(file2)) {
                    return;
                }
                Project project = source.getProject();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!file2.isValid() || source.isFileOpen(file2)) {
                        return;
                    }
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
                    if (psiFile == null) {
                        return;
                    }
                    DeleteHandler.deletePsiElement(new PsiElement[]{psiFile}, project, false);
                }, project.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/scratch/ScratchFileServiceImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        messageBusConnection2.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    return;
                }
                ArrayList psiFiles = new ArrayList();
                for (VirtualFile file2 : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
                    if (!ScratchFileServiceImpl.this.isToBeDeletedOnClose(file2)) continue;
                    ContainerUtil.addIfNotNull(psiFiles, (Object)PsiManager.getInstance((Project)project).findFile(file2));
                }
                if (!psiFiles.isEmpty()) {
                    DeleteHandler.deletePsiElement(PsiUtilCore.toPsiElementArray(psiFiles), project, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchFileServiceImpl$3", "projectClosing"));
            }
        });
        RootType.ROOT_EP.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<RootType>(){

            public void extensionAdded(@NotNull RootType rootType, @NotNull PluginDescriptor pluginDescriptor) {
                if (rootType == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(1);
                }
                ScratchFileServiceImpl.this.myIndex.resetIndex();
                ScratchFileServiceImpl.processOpenFiles((file2, manager2) -> {
                    if (ScratchFileServiceImpl.this.getRootType((VirtualFile)file2) == rootType) {
                        rootType.fileOpened(file2, manager2);
                    }
                });
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
                }
            }

            public void extensionRemoved(@NotNull RootType rootType, @NotNull PluginDescriptor pluginDescriptor) {
                if (rootType == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(3);
                }
                ScratchFileServiceImpl.this.myIndex.resetIndex();
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rootType";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/scratch/ScratchFileServiceImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    private boolean isToBeDeletedOnClose(@NotNull VirtualFile file2) {
        RootType rootType;
        if (file2 == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(4);
        }
        if ((rootType = this.getRootType(file2)) == null || rootType.isHidden()) {
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        return document != null && document.getTextLength() < 10240 && StringUtil.isEmptyOrSpaces((String)document.getText());
    }

    private static void processOpenFiles(@NotNull BiConsumer<? super VirtualFile, ? super FileEditorManager> consumer2) {
        if (consumer2 == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(5);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
            for (VirtualFile file2 : editorManager.getOpenFiles()) {
                if (!file2.isValid() || file2.isDirectory()) continue;
                consumer2.accept((VirtualFile)file2, (FileEditorManager)editorManager);
            }
        }
    }

    @NotNull
    public PerFileMappings<Language> getScratchesMapping() {
        return new PerFileMappings<Language>(){

            public void setMapping(@Nullable VirtualFile file2, @Nullable Language value2) {
                ScratchFileServiceImpl.this.myScratchMapping.setMapping(file2, value2 == null ? null : value2.getID());
            }

            @Nullable
            public Language getMapping(@Nullable VirtualFile file2) {
                return Language.findLanguageByID((String)((String)ScratchFileServiceImpl.this.myScratchMapping.getMapping(file2)));
            }
        };
    }

    @Nullable
    public Element getState() {
        return this.myScratchMapping.getState();
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(6);
        }
        this.myScratchMapping.loadState(state);
    }

    public void dispose() {
    }

    public VirtualFile findFile(@NotNull RootType rootType, @NotNull String pathName, @NotNull ScratchFileService.Option option2) throws IOException {
        if (rootType == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(7);
        }
        if (pathName == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(8);
        }
        if (option2 == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        String fullPath = this.getRootPath(rootType) + "/" + pathName;
        if (option2 != ScratchFileService.Option.create_new_always) {
            VirtualFile file2 = fileSystem.findFileByPath(fullPath);
            if (file2 != null && !file2.isDirectory()) {
                return file2;
            }
            if (option2 == ScratchFileService.Option.existing_only) {
                return null;
            }
        }
        String fileName = PathUtil.getFileName((String)pathName);
        return (VirtualFile)WriteAction.compute(() -> {
            VirtualFile dir = VfsUtil.createDirectories((String)PathUtil.getParentPath((String)fullPath));
            if (option2 == ScratchFileService.Option.create_new_always) {
                return dir.createChildData((Object)fileSystem, ScratchImplUtil.getNextAvailableName(dir, fileName));
            }
            if (option2 == ScratchFileService.Option.create_if_missing && rootType instanceof ScratchRootType && fileName.startsWith("buffer")) {
                VirtualFile file2 = ScratchImplUtil.findFileIgnoreExtension(dir, fileName);
                if (file2 != null && !file2.getName().equals(fileName)) {
                    file2.rename((Object)this, fileName);
                }
                return file2 != null ? file2 : dir.findOrCreateChildData((Object)fileSystem, fileName);
            }
            return dir.findOrCreateChildData((Object)fileSystem, fileName);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchFileServiceImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchFileServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootPath";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcRootPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isToBeDeletedOnClose";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processOpenFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class UsageTypeExtension
    implements UsageTypeProvider {
        private static final ConcurrentMap<RootType, UsageType> ourUsageTypes = ConcurrentFactoryMap.createMap(key -> new UsageType(LangBundle.messagePointer((String)"usage.type.usage.in.0", (Object[])new Object[]{key.getDisplayName()})));

        UsageTypeExtension() {
        }

        @Nullable
        public UsageType getUsageType(@NotNull PsiElement element2) {
            if (element2 == null) {
                UsageTypeExtension.$$$reportNull$$$0(0);
            }
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element2);
            RootType rootType = ScratchFileService.getInstance().getRootType(file2);
            return rootType == null ? null : (UsageType)ourUsageTypes.get(rootType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/scratch/ScratchFileServiceImpl$UsageTypeExtension", "getUsageType"));
        }
    }

    static final class UseScopeExtension
    extends UseScopeEnlarger {
        UseScopeExtension() {
        }

        @Nullable
        public SearchScope getAdditionalUseScope(@NotNull PsiElement element2) {
            SearchScope useScope;
            if (element2 == null) {
                UseScopeExtension.$$$reportNull$$$0(0);
            }
            if ((useScope = element2.getUseScope()) instanceof LocalSearchScope) {
                return null;
            }
            return ScratchesSearchScope.getScratchesScope(element2.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/scratch/ScratchFileServiceImpl$UseScopeExtension", "getAdditionalUseScope"));
        }
    }

    static final class NavBarExtension
    extends AbstractNavBarModelExtension {
        NavBarExtension() {
        }

        @Override
        @Nullable
        public Icon getIcon(Object object) {
            VirtualFile file2;
            VirtualFile virtualFile2 = file2 = object instanceof PsiFileSystemItem ? ((PsiFileSystemItem)object).getVirtualFile() : null;
            if (file2 == null) {
                return null;
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(file2);
            if (rootType == null) {
                return null;
            }
            Icon icon2 = rootType.substituteIcon(((PsiFileSystemItem)object).getProject(), file2);
            return icon2 == null && file2.isDirectory() ? AllIcons.Nodes.Folder : icon2;
        }

        @Override
        @Nullable
        public String getPresentableText(Object object) {
            PsiElement psi;
            PsiElement psiElement = psi = object instanceof PsiElement ? (PsiElement)object : null;
            if (psi == null || !psi.isValid()) {
                return null;
            }
            VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)psi);
            if (virtualFile2 == null || !virtualFile2.isValid()) {
                return null;
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(virtualFile2);
            if (rootType == null) {
                return null;
            }
            Project project = psi.getProject();
            if (virtualFile2.isDirectory() && this.additionalRoots(project).contains(virtualFile2)) {
                return rootType.getDisplayName();
            }
            return rootType.substituteName(project, virtualFile2);
        }

        @Override
        @NotNull
        public Collection<VirtualFile> additionalRoots(Project project) {
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            ScratchFileService app2 = ScratchFileService.getInstance();
            for (RootType r : RootType.getAllRootTypes()) {
                ContainerUtil.addIfNotNull(result2, (Object)fileSystem.findFileByPath(app2.getRootPath(r)));
            }
            LinkedHashSet<VirtualFile> linkedHashSet = result2;
            if (linkedHashSet == null) {
                NavBarExtension.$$$reportNull$$$0(0);
            }
            return linkedHashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileServiceImpl$NavBarExtension", "additionalRoots"));
        }
    }

    static final class AccessExtension
    implements NonProjectFileWritingAccessExtension {
        AccessExtension() {
        }

        @Override
        public boolean isWritable(@NotNull VirtualFile file2) {
            if (file2 == null) {
                AccessExtension.$$$reportNull$$$0(0);
            }
            return ScratchUtil.isScratch((VirtualFile)file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl$AccessExtension", "isWritable"));
        }
    }

    static final class FilePresentation
    implements FileIconProvider,
    EditorTabTitleProvider,
    ProjectViewNodeDecorator,
    DumbAware {
        FilePresentation() {
        }

        @Override
        public void decorate(ProjectViewNode<?> node2, PresentationData data2) {
            String text2;
            RootType rootType;
            Object value2 = node2.getValue();
            VirtualFile virtualFile2 = null;
            if (value2 instanceof RootType) {
                rootType = (RootType)value2;
            } else {
                virtualFile2 = node2.getVirtualFile();
                if (virtualFile2 == null || !virtualFile2.isValid()) {
                    return;
                }
                rootType = ScratchFileService.getInstance().getRootType(virtualFile2);
                if (rootType == null) {
                    return;
                }
            }
            ScratchFileService scratchFileService = ScratchFileService.getInstance();
            VirtualFile rootFile2 = LocalFileSystem.getInstance().findFileByPath(scratchFileService.getRootPath(rootType));
            Icon icon2 = null;
            if (virtualFile2 == null || virtualFile2.isDirectory() && virtualFile2.equals(rootFile2)) {
                text2 = rootType.getDisplayName();
            } else {
                Project project = Objects.requireNonNull(node2.getProject());
                text2 = rootType.substituteName(project, virtualFile2);
                icon2 = rootType.substituteIcon(project, virtualFile2);
            }
            if (text2 != null) {
                data2.clearText();
                data2.addText(text2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                data2.setPresentableText(text2);
            }
            if (icon2 != null) {
                data2.setIcon(icon2);
            }
        }

        @Override
        public void decorate(PackageDependenciesNode node2, ColoredTreeCellRenderer cellRenderer) {
        }

        @Nullable
        public Icon getIcon(@NotNull VirtualFile file2, @Iconable.IconFlags int flags, @Nullable Project project) {
            if (file2 == null) {
                FilePresentation.$$$reportNull$$$0(0);
            }
            if (project == null || file2.isDirectory()) {
                return null;
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(file2);
            if (rootType == null) {
                return null;
            }
            return (Icon)ObjectUtils.notNull((Object)rootType.substituteIcon(project, file2), (Object)AllIcons.FileTypes.Text);
        }

        @Override
        @Nullable
        public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file2) {
            RootType rootType;
            if (project == null) {
                FilePresentation.$$$reportNull$$$0(1);
            }
            if (file2 == null) {
                FilePresentation.$$$reportNull$$$0(2);
            }
            if ((rootType = ScratchFileService.getInstance().getRootType(file2)) == null) {
                return null;
            }
            return rootType.substituteName(project, file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/scratch/ScratchFileServiceImpl$FilePresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getIcon";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEditorTabTitle";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class Highlighter
    implements SyntaxHighlighterProvider {
        Highlighter() {
        }

        @Nullable
        public SyntaxHighlighter create(@NotNull FileType fileType, @Nullable Project project, @Nullable VirtualFile file2) {
            if (fileType == null) {
                Highlighter.$$$reportNull$$$0(0);
            }
            if (project == null || file2 == null) {
                return null;
            }
            if (!ScratchUtil.isScratch((VirtualFile)file2)) {
                return null;
            }
            Language language2 = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file2, (FileType)fileType);
            return language2 == null ? null : SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language2, (Project)project, (VirtualFile)file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/ide/scratch/ScratchFileServiceImpl$Highlighter", "create"));
        }
    }

    public static final class Substitutor
    extends LanguageSubstitutor {
        @Nullable
        public Language getLanguage(@NotNull VirtualFile file2, @NotNull Project project) {
            if (file2 == null) {
                Substitutor.$$$reportNull$$$0(0);
            }
            if (project == null) {
                Substitutor.$$$reportNull$$$0(1);
            }
            return Substitutor.substituteLanguage(project, file2);
        }

        @Nullable
        public static Language substituteLanguage(@NotNull Project project, @NotNull VirtualFile file2) {
            RootType rootType;
            if (project == null) {
                Substitutor.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                Substitutor.$$$reportNull$$$0(3);
            }
            if ((rootType = ScratchFileService.findRootType((VirtualFile)(file2 instanceof LightVirtualFile ? ((LightVirtualFile)file2).getOriginalFile() : file2))) == null) {
                return null;
            }
            return rootType.substituteLanguage(project, file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/scratch/ScratchFileServiceImpl$Substitutor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLanguage";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "substituteLanguage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Detector
    implements FileTypeRegistry.FileTypeDetector {
        @Nullable
        public FileType detect(@NotNull VirtualFile file2, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
            if (file2 == null) {
                Detector.$$$reportNull$$$0(0);
            }
            if (firstBytes == null) {
                Detector.$$$reportNull$$$0(1);
            }
            if (firstCharsIfText == null) {
                return null;
            }
            return (FileType)ProgressManager.getInstance().computeInNonCancelableSection(() -> {
                FileType byName = FileTypeManager.getInstance().getFileTypeByFileName(file2.getName());
                RootType rootType = byName != UnknownFileType.INSTANCE ? null : ScratchFileService.findRootType((VirtualFile)file2);
                return rootType != null ? PlainTextFileType.INSTANCE : null;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstBytes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/scratch/ScratchFileServiceImpl$Detector";
            objectArray[2] = "detect";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyLanguages
    extends PerFileMappingsBase<String> {
        private MyLanguages() {
        }

        @Override
        @NotNull
        public List<String> getAvailableValues() {
            List list2 = ContainerUtil.map((Collection)LanguageUtil.getFileLanguages(), Language::getID);
            if (list2 == null) {
                MyLanguages.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        @NotNull
        protected String serialize(@NotNull String languageID) {
            if (languageID == null) {
                MyLanguages.$$$reportNull$$$0(1);
            }
            String string = languageID;
            if (string == null) {
                MyLanguages.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        protected String handleUnknownMapping(VirtualFile file2, String value2) {
            String string = PlainTextLanguage.INSTANCE.getID();
            if (string == null) {
                MyLanguages.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        protected boolean isDefaultMapping(@NotNull VirtualFile file2, @NotNull String mapping2) {
            if (file2 == null) {
                MyLanguages.$$$reportNull$$$0(4);
            }
            if (mapping2 == null) {
                MyLanguages.$$$reportNull$$$0(5);
            }
            if (PlainTextLanguage.INSTANCE.getID().equals(mapping2)) {
                return true;
            }
            FileType byName = FileTypeManager.getInstance().getFileTypeByFileName(file2.getName());
            Language language2 = LanguageUtil.getFileTypeLanguage((FileType)byName);
            return language2 != null && language2.getID().equals(mapping2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchFileServiceImpl$MyLanguages";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageID";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAvailableValues";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchFileServiceImpl$MyLanguages";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "serialize";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "handleUnknownMapping";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "serialize";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isDefaultMapping";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

