/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.xml;

import com.intellij.ide.structureView.StructureViewBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.xml.AbstractXmlTagTreeElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagTreeElement
extends AbstractXmlTagTreeElement<XmlTag> {
    @NonNls
    private static final String ID_ATTR_NAME = "id";
    @NonNls
    private static final String NAME_ATTR_NAME = "name";

    public XmlTagTreeElement(XmlTag tag2) {
        super(tag2);
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        Collection<StructureViewTreeElement> collection = XmlTagTreeElement.getStructureViewTreeElements(((XmlTag)this.getElement()).getSubTags());
        if (collection == null) {
            XmlTagTreeElement.$$$reportNull$$$0(0);
        }
        return collection;
    }

    public String getPresentableText() {
        XmlTag element2 = (XmlTag)this.getElement();
        if (element2 == null) {
            return StructureViewBundle.message("node.structureview.invalid", new Object[0]);
        }
        String id2 = element2.getAttributeValue(ID_ATTR_NAME);
        if (id2 == null) {
            id2 = element2.getAttributeValue(NAME_ATTR_NAME);
        }
        return (id2 = XmlTagTreeElement.toCanonicalForm(id2)) != null ? id2 + ":" + element2.getLocalName() : element2.getName();
    }

    public String getLocationString() {
        StringBuilder buffer = new StringBuilder();
        XmlTag element2 = (XmlTag)this.getElement();
        assert (element2 != null);
        String id2 = element2.getAttributeValue(ID_ATTR_NAME);
        String usedAttrName = null;
        if (id2 == null) {
            id2 = element2.getAttributeValue(NAME_ATTR_NAME);
            if (id2 != null) {
                usedAttrName = NAME_ATTR_NAME;
            }
        } else {
            usedAttrName = ID_ATTR_NAME;
        }
        id2 = XmlTagTreeElement.toCanonicalForm(id2);
        for (XmlAttribute attribute : element2.getAttributes()) {
            if (buffer.length() != 0) {
                buffer.append(' ');
            }
            String name2 = attribute.getName();
            if (usedAttrName != null && id2 != null && usedAttrName.equals(name2)) continue;
            buffer.append(name2);
            buffer.append('=').append('\"').append(attribute.getValue()).append('\"');
        }
        return buffer.toString();
    }

    @Nullable
    public static String toCanonicalForm(@Nullable String id2) {
        if (id2 != null && (id2 = id2.trim()).isEmpty()) {
            return null;
        }
        return id2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/xml/XmlTagTreeElement", "getChildrenBase"));
    }
}

