/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.IdeaPluginDescriptorImplKt;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.NotABooleanOptionDescription;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.FileVisitResult;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PluginBooleanOptionDescriptor
extends BooleanOptionDescription
implements BooleanOptionDescription.RequiresRebuild,
NotABooleanOptionDescription {
    private static final AtomicReference<Notification> ourPreviousNotification = new AtomicReference();
    private final IdeaPluginDescriptor myDescriptor;

    PluginBooleanOptionDescriptor(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(0);
        }
        super(IdeBundle.message((String)"search.everywhere.command.plugins", (Object[])new Object[]{descriptor2.getName()}), "preferences.pluginManager");
        this.myDescriptor = descriptor2;
    }

    public boolean isOptionEnabled() {
        return !PluginEnabler.HEADLESS.isDisabled(this.myDescriptor.getPluginId());
    }

    public void setOptionState(boolean enable) {
        PluginBooleanOptionDescriptor.togglePluginState(List.of(this.myDescriptor), enable);
    }

    public static void togglePluginState(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors, boolean enable) {
        boolean appliedWithoutRestart;
        if (descriptors == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(1);
        }
        if (descriptors.isEmpty()) {
            return;
        }
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = PluginManagerCore.buildPluginIdMap();
        Collection<? extends IdeaPluginDescriptor> autoSwitchedDescriptors = enable ? PluginBooleanOptionDescriptor.getDependenciesToEnable(descriptors, pluginIdMap) : PluginBooleanOptionDescriptor.getDependentsToDisable(descriptors, pluginIdMap);
        PluginEnabler pluginEnabler = PluginEnabler.getInstance();
        boolean bl = appliedWithoutRestart = enable ? pluginEnabler.enable(autoSwitchedDescriptors) : pluginEnabler.disable(autoSwitchedDescriptors);
        if (autoSwitchedDescriptors.size() > descriptors.size()) {
            String content2 = IdeBundle.message((String)(enable ? "plugins.auto.enabled.notification.content" : "plugins.auto.disabled.notification.content"), (Object[])new Object[]{MyPluginModel.joinPluginNamesOrIds(MyPluginModel.getPluginNames(descriptors)), MyPluginModel.joinPluginNamesOrIds(MyPluginModel.getPluginNames(autoSwitchedDescriptors))});
            PluginBooleanOptionDescriptor.showAutoSwitchNotification(autoSwitchedDescriptors, pluginEnabler, content2, enable);
        }
        PluginBooleanOptionDescriptor.notifyIfRestartRequired(!appliedWithoutRestart);
    }

    private static void showAutoSwitchNotification(final @NotNull Collection<? extends IdeaPluginDescriptor> descriptors, final @NotNull PluginEnabler pluginEnabler, @NotNull @Nls String content2, final boolean enabled) {
        if (descriptors == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(2);
        }
        if (pluginEnabler == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(3);
        }
        if (content2 == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(4);
        }
        String title2 = IdeBundle.message((String)(enabled ? "plugins.auto.enabled.notification.title" : "plugins.auto.disabled.notification.title"), (Object[])new Object[0]);
        final Notification switchNotification = NotificationGroupManager.getInstance().getNotificationGroup("Plugins AutoSwitch").createNotification(content2, NotificationType.INFORMATION).setTitle(title2).addAction((AnAction)new NotificationAction(IdeBundle.message((String)"plugins.auto.switch.action.name", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    1.$$$reportNull$$$0(1);
                }
                boolean appliedWithoutRestart = enabled ? pluginEnabler.disable(descriptors) : pluginEnabler.enable(descriptors);
                notification.expire();
                PluginBooleanOptionDescriptor.notifyIfRestartRequired(!appliedWithoutRestart);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/ui/PluginBooleanOptionDescriptor$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        final Set<PluginId> pluginIds2 = IdeaPluginDescriptorImplKt.toPluginSet(descriptors);
        DisabledPluginsState.addDisablePluginListener(new Runnable(){

            @Override
            public void run() {
                Balloon balloon2;
                boolean notificationValid;
                Condition condition = pluginEnabler::isDisabled;
                boolean bl = enabled ? !ContainerUtil.exists((Iterable)pluginIds2, (Condition)condition) : (notificationValid = ContainerUtil.and((Iterable)pluginIds2, (Condition)condition));
                if (!notificationValid) {
                    switchNotification.expire();
                }
                if ((balloon2 = switchNotification.getBalloon()) == null || balloon2.isDisposed()) {
                    ApplicationManager.getApplication().invokeLater(() -> DisabledPluginsState.removeDisablePluginListener(this));
                }
            }
        });
        switchNotification.notify(null);
    }

    @NotNull
    private static Collection<? extends IdeaPluginDescriptor> getDependenciesToEnable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap) {
        if (descriptors == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(5);
        }
        if (pluginIdMap == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(6);
        }
        LinkedHashSet<IdeaPluginDescriptor> result2 = new LinkedHashSet<IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors) {
            result2.add(ideaPluginDescriptor);
            if (!(ideaPluginDescriptor instanceof IdeaPluginDescriptorImpl)) continue;
            PluginManagerCore.processAllNonOptionalDependencies((IdeaPluginDescriptorImpl)ideaPluginDescriptor, pluginIdMap, dependency -> PluginManagerCore.CORE_ID.equals((Object)dependency.getPluginId()) || dependency.isEnabled() || !result2.add((IdeaPluginDescriptor)dependency) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE);
        }
        Set set2 = Collections.unmodifiableSet(result2);
        if (set2 == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(7);
        }
        return set2;
    }

    @NotNull
    private static Collection<? extends IdeaPluginDescriptor> getDependentsToDisable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap) {
        if (descriptors == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(8);
        }
        if (pluginIdMap == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(9);
        }
        LinkedHashSet<IdeaPluginDescriptor> result2 = new LinkedHashSet<IdeaPluginDescriptor>();
        ApplicationInfoEx applicationInfo = ApplicationInfoEx.getInstanceEx();
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors) {
            result2.add(ideaPluginDescriptor);
            result2.addAll(MyPluginModel.getDependents(ideaPluginDescriptor, pluginIdMap, applicationInfo));
        }
        Set set2 = Collections.unmodifiableSet(result2);
        if (set2 == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(10);
        }
        return set2;
    }

    private static void notifyIfRestartRequired(boolean restartRequired) {
        if (!restartRequired) {
            return;
        }
        Notification notification = ourPreviousNotification.get();
        if (notification == null) {
            return;
        }
        Balloon balloon2 = notification.getBalloon();
        if (balloon2 != null && !balloon2.isDisposed()) {
            return;
        }
        Notification newNotification = NotificationGroupManager.getInstance().getNotificationGroup("Plugins updates").createNotification(IdeBundle.message((String)"plugins.changed.notification.content", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}), NotificationType.INFORMATION).setTitle(IdeBundle.message((String)"plugins.changed.notification.title", (Object[])new Object[0])).addAction((AnAction)new DumbAwareAction(IdeBundle.message((String)"ide.restart.action", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().restart();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/PluginBooleanOptionDescriptor$3", "actionPerformed"));
            }
        });
        if (ourPreviousNotification.compareAndSet(notification, newNotification)) {
            newNotification.notify(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIdMap";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/PluginBooleanOptionDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/PluginBooleanOptionDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependenciesToEnable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentsToDisable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "togglePluginState";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showAutoSwitchNotification";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDependenciesToEnable";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDependentsToDisable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

