/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredSideBorder;
import com.intellij.ui.plaf.beg.BegBorders;
import com.intellij.ui.plaf.beg.BegPopupMenuBorder;
import com.intellij.ui.plaf.beg.BegRadioButtonUI;
import com.intellij.ui.plaf.beg.BegTabbedPaneUI;
import com.intellij.ui.plaf.beg.BegTableUI;
import com.intellij.ui.plaf.beg.BegToggleButtonUI;
import com.intellij.ui.plaf.beg.BegTreeUI;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Insets;
import java.util.Map;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.jetbrains.annotations.Nullable;

public final class IdeaLaf
extends MetalLookAndFeel {
    public static final ColorUIResource TOOLTIP_BACKGROUND_COLOR = new ColorUIResource(255, 255, 231);
    private final Map<Object, Object> myCustomFontDefaults;

    public IdeaLaf(@Nullable Map<Object, Object> customFontDefaults) {
        this.myCustomFontDefaults = customFontDefaults;
    }

    @Override
    public void initComponentDefaults(UIDefaults defaults) {
        super.initComponentDefaults(defaults);
        StartupUiUtil.initInputMapDefaults((UIDefaults)defaults);
        IdeaLaf.initIdeaDefaults(defaults);
        if (this.myCustomFontDefaults != null) {
            defaults.putAll(this.myCustomFontDefaults);
        } else {
            Map.Entry systemFont = JBUIScale.getSystemFontData(() -> defaults);
            StartupUiUtil.initFontDefaults((UIDefaults)defaults, (FontUIResource)StartupUiUtil.getFontWithFallback((String)((String)systemFont.getKey()), (int)0, (int)((Integer)systemFont.getValue())));
        }
    }

    static void initIdeaDefaults(UIDefaults defaults) {
        defaults.put("Menu.maxGutterIconWidth", (Object)18);
        defaults.put("MenuItem.maxGutterIconWidth", (Object)18);
        defaults.put("MenuItem.acceleratorDelimiter", "-");
        defaults.put("TitledBorder.titleColor", new ColorUIResource(10, 36, 106));
        ColorUIResource col = new ColorUIResource(230, 230, 230);
        defaults.put("ScrollBar.background", col);
        defaults.put("ScrollBar.track", col);
        defaults.put("TextField.border", BegBorders.getTextFieldBorder());
        defaults.put("PasswordField.border", BegBorders.getTextFieldBorder());
        BegPopupMenuBorder popupMenuBorder = new BegPopupMenuBorder();
        defaults.put("PopupMenu.border", popupMenuBorder);
        defaults.put("ScrollPane.border", BegBorders.getScrollPaneBorder());
        defaults.put("ToggleButtonUI", BegToggleButtonUI.class.getName());
        defaults.put("RadioButtonUI", BegRadioButtonUI.class.getName());
        defaults.put("TabbedPaneUI", BegTabbedPaneUI.class.getName());
        defaults.put("TableUI", BegTableUI.class.getName());
        defaults.put("TreeUI", BegTreeUI.class.getName());
        defaults.put("TabbedPane.tabInsets", new Insets(0, 4, 0, 4));
        defaults.put("ToolTip.background", TOOLTIP_BACKGROUND_COLOR);
        defaults.put("ToolTip.border", new ColoredSideBorder(Color.gray, Color.gray, Color.black, Color.black, 1));
        defaults.put("Tree.ancestorInputMap", (Object)null);
        defaults.put("FileView.directoryIcon", AllIcons.Nodes.Folder);
        defaults.put("FileChooser.upFolderIcon", AllIcons.Nodes.UpFolder);
        defaults.put("FileChooser.newFolderIcon", AllIcons.Nodes.Folder);
        defaults.put("FileChooser.homeFolderIcon", AllIcons.Nodes.HomeFolder);
        defaults.put("OptionPane.errorIcon", AllIcons.General.ErrorDialog);
        defaults.put("OptionPane.informationIcon", AllIcons.General.InformationDialog);
        defaults.put("OptionPane.warningIcon", AllIcons.General.WarningDialog);
        defaults.put("OptionPane.questionIcon", AllIcons.General.QuestionDialog);
        defaults.put("Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "F2", "startEditing"}));
    }
}

