/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.labels.DropDownLink;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.SwingTextTrimmer;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import sun.swing.SwingUtilities2;

public class DarculaLabelUI
extends BasicLabelUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaLabelUI();
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        g.setColor(l.getForeground());
        SwingUtilities2.drawStringUnderlineCharAt(l, g, s, this.getMnemonicIndex(l), textX, textY);
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        g.setColor(UIManager.getColor("Label.disabledForeground"));
        SwingUtilities2.drawStringUnderlineCharAt(l, g, s, -1, textX, textY);
    }

    protected int getMnemonicIndex(JLabel l) {
        return DarculaLaf.isAltPressed() ? l.getDisplayedMnemonicIndex() : -1;
    }

    @Override
    protected String layoutCL(JLabel label2, FontMetrics fontMetrics, String text2, Icon icon2, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        SwingTextTrimmer trimmer;
        String result2 = super.layoutCL(label2, fontMetrics, text2, icon2, viewR, iconR, textR);
        if (!StringUtil.isEmpty((String)result2) && (trimmer = (SwingTextTrimmer)((Object)ComponentUtil.getClientProperty((JComponent)label2, SwingTextTrimmer.KEY))) != null && null == label2.getClientProperty("html") && !result2.equals(text2) && result2.endsWith("...")) {
            result2 = trimmer.trim(text2, fontMetrics, textR.width);
        }
        if (label2 instanceof DropDownLink) {
            iconR.y += JBUIScale.scale((int)1);
        }
        return result2;
    }
}

