/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.ide.ui.search.IndexedCharsInterner;
import com.intellij.ide.ui.search.MySearchableOptionProcessor;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchableOptionProcessor;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.CollectionFactory;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\r\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J>\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J$\u0010\u001b\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u001cJ&\u0010\u001e\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u001cH\u0002J6\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\b\u0010\"\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/intellij/ide/ui/search/MySearchableOptionProcessor;", "Lcom/intellij/ide/ui/search/SearchableOptionProcessor;", "stopWords", "", "", "(Ljava/util/Set;)V", "cache", "", "identifierTable", "Lcom/intellij/ide/ui/search/IndexedCharsInterner;", "getIdentifierTable", "()Lcom/intellij/ide/ui/search/IndexedCharsInterner;", "storage", "", "", "", "getStorage", "()Ljava/util/Map;", "addOptions", "", "text", "path", "hit", "configurableId", "configurableDisplayName", "applyStemming", "", "computeHighlightOptionToSynonym", "", "Lkotlin/Pair;", "loadSynonyms", "putOptionWithHelpId", "option", "id", "groupName", "intellij.platform.ide.impl"})
public final class MySearchableOptionProcessor
extends SearchableOptionProcessor {
    private final Set<String> cache;
    @NotNull
    private final Map<CharSequence, long[]> storage;
    @NotNull
    private final IndexedCharsInterner identifierTable;
    private final Set<String> stopWords;

    @NotNull
    public final Map<CharSequence, long[]> getStorage() {
        return this.storage;
    }

    @NotNull
    public final IndexedCharsInterner getIdentifierTable() {
        return this.identifierTable;
    }

    public void addOptions(@NotNull String text2, @Nullable String path2, @Nullable String hit, @NotNull String configurableId, @Nullable String configurableDisplayName, boolean applyStemming) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)configurableId, (String)"configurableId");
        this.cache.clear();
        if (applyStemming) {
            SearchableOptionsRegistrarImpl.collectProcessedWords(text2, this.cache, this.stopWords);
        } else {
            SearchableOptionsRegistrarImpl.collectProcessedWordsWithoutStemming(text2, this.cache, this.stopWords);
        }
        for (String word : this.cache) {
            this.putOptionWithHelpId(word, configurableId, configurableDisplayName, hit, path2);
        }
    }

    @NotNull
    public final Map<Pair<String, String>, Set<String>> computeHighlightOptionToSynonym() {
        Function1 fileNameFilter2 = computeHighlightOptionToSynonym.fileNameFilter.1.INSTANCE;
        Object object = fileNameFilter2;
        if (object != null) {
            Function1 function1 = object;
            object = new Predicate(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ boolean test(Object p0) {
                    Object object = this.function.invoke(p0);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                    return (Boolean)object;
                }
            };
        }
        SearchableOptionsRegistrarImpl.processSearchableOptions((Predicate)object, new BiConsumer(this){
            final /* synthetic */ MySearchableOptionProcessor this$0;

            public final void accept(String $noName_0, Element root2) {
                for (Element configurable2 : root2.getChildren("configurable")) {
                    if (configurable2.getAttributeValue("id") == null) {
                        continue;
                    }
                    String groupName = configurable2.getAttributeValue("configurable_name");
                    for (Element optionElement : configurable2.getChildren("option")) {
                        String id2;
                        String option2;
                        if (optionElement.getAttributeValue("name") == null) {
                            continue;
                        }
                        String path2 = optionElement.getAttributeValue("path");
                        String hit = optionElement.getAttributeValue("hit");
                        MySearchableOptionProcessor.access$putOptionWithHelpId(this.this$0, option2, id2, groupName, hit, path2);
                    }
                }
            }
            {
                this.this$0 = mySearchableOptionProcessor;
            }
        });
        return this.loadSynonyms();
    }

    private final Map<Pair<String, String>, Set<String>> loadSynonyms() {
        HashMap result2 = new HashMap();
        Element root2 = JDOMUtil.load((InputStream)ResourceUtil.getResourceAsStream((ClassLoader)SearchableOptionsRegistrar.class.getClassLoader(), (String)"/search/", (String)"synonyms.xml"));
        HashSet cache2 = new HashSet();
        for (Element configurable2 : root2.getChildren("configurable")) {
            String id2;
            if (configurable2.getAttributeValue("id") == null) {
                continue;
            }
            String groupName = configurable2.getAttributeValue("configurable_name");
            List synonyms = configurable2.getChildren("synonym");
            Iterator iterator2 = synonyms.iterator();
            while (iterator2.hasNext()) {
                String synonym;
                Element synonymElement;
                Element element2 = synonymElement = (Element)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"synonymElement");
                if (element2.getTextNormalize() == null) {
                    continue;
                }
                cache2.clear();
                SearchableOptionsRegistrarImpl.collectProcessedWords(synonym, cache2, this.stopWords);
                Iterator iterator3 = cache2.iterator();
                while (iterator3.hasNext()) {
                    String word;
                    String string = word = (String)iterator3.next();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"word");
                    this.putOptionWithHelpId(string, id2, groupName, synonym, null);
                }
            }
            for (Element optionElement : configurable2.getChildren("option")) {
                String option2 = optionElement.getAttributeValue("name");
                List list2 = optionElement.getChildren("synonym");
                Iterator iterator4 = list2.iterator();
                while (iterator4.hasNext()) {
                    String synonym;
                    Element synonymElement;
                    Element element3 = synonymElement = (Element)iterator4.next();
                    Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"synonymElement");
                    if (element3.getTextNormalize() == null) {
                        continue;
                    }
                    cache2.clear();
                    SearchableOptionsRegistrarImpl.collectProcessedWords(synonym, cache2, this.stopWords);
                    Iterator iterator5 = cache2.iterator();
                    while (iterator5.hasNext()) {
                        String word;
                        String string = word = (String)iterator5.next();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"word");
                        this.putOptionWithHelpId(string, id2, groupName, synonym, null);
                    }
                    ((Set)result2.computeIfAbsent(new Pair((Object)option2, (Object)id2), loadSynonyms.1.INSTANCE)).add(synonym);
                }
            }
        }
        return result2;
    }

    private final void putOptionWithHelpId(String option2, String id2, String groupName, String hit, String path2) {
        if (this.stopWords.contains(option2)) {
            return;
        }
        String stopWord = PorterStemmerUtil.stem(option2);
        if (stopWord == null || this.stopWords.contains(stopWord)) {
            return;
        }
        long[] configs = this.storage.get(option2);
        long packed = SearchableOptionsRegistrarImpl.pack(id2, hit, path2, groupName, this.identifierTable);
        if (configs == null) {
            configs = new long[]{packed};
        } else if (ArraysKt.indexOf((long[])configs, (long)packed) == -1) {
            configs = ArrayUtil.append((long[])configs, (long)packed);
        }
        Intrinsics.checkNotNull((Object)configs);
        this.storage.put(option2, configs);
    }

    public MySearchableOptionProcessor(@NotNull Set<String> stopWords) {
        Intrinsics.checkNotNullParameter(stopWords, (String)"stopWords");
        this.stopWords = stopWords;
        this.cache = new HashSet();
        Map map2 = CollectionFactory.createCharSequenceMap((int)20, (float)0.9f, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"CollectionFactory.create\u2026quenceMap(20, 0.9f, true)");
        this.storage = map2;
        this.identifierTable = new IndexedCharsInterner();
    }

    public static final /* synthetic */ void access$putOptionWithHelpId(MySearchableOptionProcessor $this, String option2, String id2, String groupName, String hit, String path2) {
        $this.putOptionWithHelpId(option2, id2, groupName, hit, path2);
    }
}

