/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.PlatformModuleRendererFactory;
import com.intellij.ide.util.PsiElementBackgroundListCellRenderer;
import com.intellij.ide.util.PsiElementRenderingInfo;
import com.intellij.lang.LangBundle;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.TargetPresentation;
import com.intellij.navigation.TargetPresentationBuilder;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.TextWithIcon;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DirtyUI
public abstract class PsiElementListCellRenderer<T extends PsiElement>
extends JPanel
implements ListCellRenderer<Object> {
    private static final Logger LOG = Logger.getInstance(PsiElementListCellRenderer.class);
    private static final String LEFT = "West";
    private static final Pattern CONTAINER_PATTERN = Pattern.compile("(\\(in |\\()?([^)]*)(\\))?");
    private static final SimpleTextAttributes DEFAULT_ERROR_ATTRIBUTES = new SimpleTextAttributes(8, UIUtil.getInactiveTextColor(), (Color)JBColor.RED);
    protected int myRightComponentWidth;
    private final ListCellRenderer<PsiElement> myBackgroundRenderer;
    private final boolean isGetRightCellRendererOverridden = ReflectionUtil.getMethodDeclaringClass(this.getClass(), (String)"getRightCellRenderer", (Class[])new Class[]{Object.class}) != PsiElementListCellRenderer.class;
    private final PsiElementRenderingInfo<T> myRenderingInfo = new PsiElementRenderingInfo<T>(){

        @Override
        @Nullable
        public Icon getIcon(@NotNull T element2) {
            if (element2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return PsiElementListCellRenderer.this.getIcon((PsiElement)element2);
        }

        @Override
        @NotNull
        public String getPresentableText(@NotNull T element2) {
            String elementText;
            if (element2 == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((elementText = PsiElementListCellRenderer.this.getElementText(element2)) == null) {
                LOG.error("Null name for PSI element " + element2.getClass() + " (by " + PsiElementListCellRenderer.this + ")");
                String string = LangBundle.message((String)"label.unknown", (Object[])new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = elementText;
            if (string == null) {
                1.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public String getContainerText(@NotNull T element2) {
            if (element2 == null) {
                1.$$$reportNull$$$0(4);
            }
            return PsiElementListCellRenderer.this.getContainerText(element2, this.getPresentableText(element2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/PsiElementListCellRenderer$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/PsiElementListCellRenderer$1";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentableText";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getContainerText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    protected PsiElementListCellRenderer() {
        super(new BorderLayout());
        this.myBackgroundRenderer = Registry.is((String)"psi.element.list.cell.renderer.background") && !ApplicationManager.getApplication().isHeadlessEnvironment() ? new PsiElementBackgroundListCellRenderer(this) : null;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new MyAccessibleContext();
        }
        return this.accessibleContext;
    }

    @Nullable
    protected TextAttributes getNavigationItemAttributes(Object value2) {
        return PsiElementListCellRenderer.getNavigationItemAttributesStatic(value2);
    }

    @Nullable
    private static TextAttributes getNavigationItemAttributesStatic(Object value2) {
        TextAttributes attributes2 = null;
        if (value2 instanceof NavigationItem) {
            TextAttributesKey attributesKey = null;
            ItemPresentation presentation2 = ((NavigationItem)value2).getPresentation();
            if (presentation2 instanceof ColoredItemPresentation) {
                attributesKey = ((ColoredItemPresentation)presentation2).getTextAttributesKey();
            }
            if (attributesKey != null) {
                attributes2 = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey);
            }
        }
        return attributes2;
    }

    @Override
    public Component getListCellRendererComponent(JList list2, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
        Component result2;
        JPanel spacer;
        JLabel locationComponent;
        TextWithIcon itemLocation;
        if (this.myBackgroundRenderer != null && value2 instanceof PsiElement) {
            return this.myBackgroundRenderer.getListCellRendererComponent(list2, (PsiElement)value2, index2, isSelected, cellHasFocus);
        }
        this.removeAll();
        this.myRightComponentWidth = 0;
        try (AccessToken ignore = SlowOperations.allowSlowOperations((String)"rendering");){
            itemLocation = this.getItemLocation(value2);
        }
        if (itemLocation == null) {
            locationComponent = null;
            spacer = null;
        } else {
            locationComponent = new JLabel(itemLocation.getText(), itemLocation.getIcon(), 4);
            locationComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, UIUtil.getListCellHPadding()));
            locationComponent.setHorizontalTextPosition(2);
            locationComponent.setForeground(isSelected ? UIUtil.getListSelectionForeground((boolean)true) : UIUtil.getInactiveTextColor());
            this.add((Component)locationComponent, "East");
            spacer = new JPanel();
            spacer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.add((Component)spacer, "Center");
            this.myRightComponentWidth = locationComponent.getPreferredSize().width;
            this.myRightComponentWidth += spacer.getPreferredSize().width;
        }
        LeftRenderer leftRenderer2 = new LeftRenderer(value2 == null ? new ItemMatchers(null, null) : this.getItemMatchers(list2, value2));
        try (AccessToken ignore = SlowOperations.allowSlowOperations((String)"rendering");){
            result2 = leftRenderer2.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
        }
        Component leftCellRendererComponent = result2;
        this.add(leftCellRendererComponent, LEFT);
        Color bg = isSelected ? UIUtil.getListSelectionBackground((boolean)true) : leftCellRendererComponent.getBackground();
        this.setBackground(bg);
        if (itemLocation != null) {
            locationComponent.setBackground(bg);
            spacer.setBackground(bg);
        }
        return this;
    }

    @NotNull
    protected SimpleTextAttributes getErrorAttributes() {
        SimpleTextAttributes simpleTextAttributes = DEFAULT_ERROR_ATTRIBUTES;
        if (simpleTextAttributes == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(0);
        }
        return simpleTextAttributes;
    }

    @NotNull
    public ItemMatchers getItemMatchers(@NotNull JList list2, @NotNull Object value2) {
        if (list2 == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(1);
        }
        if (value2 == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(2);
        }
        return new ItemMatchers(MatcherHolder.getAssociatedMatcher(list2), null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    protected final void setFocusBorderEnabled(boolean enabled) {
    }

    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer2, JList list2, Object value2, int index2, boolean selected2, boolean hasFocus) {
        return false;
    }

    @Nullable
    protected TextWithIcon getItemLocation(Object value2) {
        if (this.isGetRightCellRendererOverridden) {
            return ModuleRendererFactory.getTextWithIcon(this.getRightCellRenderer(value2), value2);
        }
        if (UISettings.getInstance().getShowIconInQuickNavigation()) {
            return PsiElementListCellRenderer.getModuleTextWithIcon(value2);
        }
        return null;
    }

    @Deprecated
    @Nullable
    protected DefaultListCellRenderer getRightCellRenderer(Object value2) {
        if (!UISettings.getInstance().getShowIconInQuickNavigation()) {
            return null;
        }
        DefaultListCellRenderer renderer2 = ModuleRendererFactory.findInstance(value2).getModuleRenderer();
        if (renderer2 instanceof PlatformModuleRendererFactory.PlatformModuleRenderer) {
            return null;
        }
        return renderer2;
    }

    @ApiStatus.Internal
    @Nullable
    public static TextWithIcon getModuleTextWithIcon(Object value2) {
        ModuleRendererFactory factory2 = ModuleRendererFactory.findInstance(value2);
        if (factory2 instanceof PlatformModuleRendererFactory) {
            return null;
        }
        return factory2.getModuleTextWithIcon(value2);
    }

    @NlsSafe
    public abstract String getElementText(T var1);

    @Nullable
    @NlsSafe
    protected abstract String getContainerText(T var1, String var2);

    @Nullable
    @NlsSafe
    protected String getContainerTextForLeftComponent(T element2, String name2, int maxWidth, FontMetrics fm) {
        return this.getContainerText(element2, name2);
    }

    @Iconable.IconFlags
    protected int getIconFlags() {
        return 0;
    }

    protected Icon getIcon(PsiElement element2) {
        return element2.getIcon(this.getIconFlags());
    }

    public Comparator<T> getComparator() {
        return Comparator.comparing(this::getComparingObject);
    }

    @NotNull
    public Comparable getComparingObject(T element2) {
        Comparable comparable = (Comparable)ReadAction.compute(() -> {
            String elementText = this.getElementText(element2);
            String containerText = this.getContainerText(element2, elementText);
            TextWithIcon moduleTextWithIcon = PsiElementListCellRenderer.getModuleTextWithIcon(element2);
            return (String)(containerText == null ? elementText : elementText + " " + containerText) + (moduleTextWithIcon != null ? moduleTextWithIcon.getText() : "");
        });
        if (comparable == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(3);
        }
        return comparable;
    }

    @Deprecated
    public void installSpeedSearch(PopupChooserBuilder<?> builder2) {
        this.installSpeedSearch((IPopupChooserBuilder)builder2);
    }

    public void installSpeedSearch(IPopupChooserBuilder builder2) {
        this.installSpeedSearch(builder2, false);
    }

    public void installSpeedSearch(IPopupChooserBuilder builder2, boolean includeContainerText) {
        builder2.setNamerForFiltering(o -> {
            if (o instanceof PsiElement) {
                String elementText = this.getElementText((PsiElement)o);
                if (includeContainerText) {
                    return elementText + " " + this.getContainerText((PsiElement)o, elementText);
                }
                return elementText;
            }
            return o.toString();
        });
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @RequiresReadLock
    @NotNull
    public final TargetPresentation computePresentation(@NotNull PsiElement psiElement) {
        void element2;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (element2 == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(4);
        }
        return PsiElementListCellRenderer.targetPresentation(element2, this.myRenderingInfo, this::getNavigationItemAttributes, this::getItemLocation, this::getErrorAttributes);
    }

    @NotNull
    static <T extends PsiElement> TargetPresentation targetPresentation(@NotNull T element2, @NotNull PsiElementRenderingInfo<? super T> renderingInfo) {
        if (element2 == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(5);
        }
        if (renderingInfo == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(6);
        }
        return PsiElementListCellRenderer.targetPresentation(element2, renderingInfo, PsiElementListCellRenderer::getNavigationItemAttributesStatic, PsiElementListCellRenderer::getModuleTextWithIcon, () -> DEFAULT_ERROR_ATTRIBUTES);
    }

    @NotNull
    private static <T extends PsiElement> TargetPresentation targetPresentation(@NotNull T element2, @NotNull PsiElementRenderingInfo<? super T> renderingInfo, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable TextAttributes> presentableAttributesProvider, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable TextWithIcon> locationProvider, @NotNull @NotNull Supplier<? extends @NotNull SimpleTextAttributes> errorAttributesSupplier) {
        TextWithIcon itemLocation;
        if (element2 == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(7);
        }
        if (renderingInfo == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(8);
        }
        if (presentableAttributesProvider == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(9);
        }
        if (locationProvider == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(10);
        }
        if (errorAttributesSupplier == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(11);
        }
        TargetPresentationBuilder builder2 = TargetPresentation.builder((String)renderingInfo.getPresentableText(element2));
        builder2 = builder2.icon(renderingInfo.getIcon(element2));
        TextAttributes elementAttributes = presentableAttributesProvider.apply(element2);
        VirtualFile vFile = PsiUtilCore.getVirtualFile(element2);
        if (vFile == null) {
            builder2 = builder2.presentableTextAttributes(elementAttributes);
        } else {
            Color color;
            Project project = element2.getProject();
            TextAttributes presentableAttributes = elementAttributes;
            if (presentableAttributes == null && (color = FileStatusManager.getInstance((Project)project).getStatus(vFile).getColor()) != null) {
                presentableAttributes = new SimpleTextAttributes(0, color).toTextAttributes();
            }
            if (WolfTheProblemSolver.getInstance((Project)project).isProblemFile(vFile)) {
                presentableAttributes = TextAttributes.merge((TextAttributes)errorAttributesSupplier.get().toTextAttributes(), (TextAttributes)presentableAttributes);
            }
            builder2 = builder2.presentableTextAttributes(presentableAttributes);
            builder2 = builder2.backgroundColor(VfsPresentationUtil.getFileBackgroundColor(project, vFile));
        }
        String containerText = renderingInfo.getContainerText(element2);
        if (containerText != null) {
            Matcher matcher = CONTAINER_PATTERN.matcher(containerText);
            builder2 = builder2.containerText(matcher.matches() ? matcher.group(2) : containerText);
        }
        if ((itemLocation = locationProvider.apply(element2)) != null) {
            builder2 = builder2.locationText(itemLocation.getText(), itemLocation.getIcon());
        }
        TargetPresentation targetPresentation = builder2.presentation();
        if (targetPresentation == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(12);
        }
        return targetPresentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/PsiElementListCellRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderingInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableAttributesProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorAttributesSupplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorAttributes";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/PsiElementListCellRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparingObject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "targetPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getItemMatchers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "targetPresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class LeftRenderer
    extends ColoredListCellRenderer<Object> {
        private final ItemMatchers myMatchers;

        LeftRenderer(ItemMatchers matchers) {
            if (matchers == null) {
                LeftRenderer.$$$reportNull$$$0(0);
            }
            this.myMatchers = matchers;
        }

        protected void customizeCellRenderer(@NotNull JList<?> list2, Object value2, int index2, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                LeftRenderer.$$$reportNull$$$0(1);
            }
            Color bgColor = UIUtil.getListBackground();
            Color color = list2.getForeground();
            PsiElement target2 = NavigationItemListCellRenderer.getPsiElement(value2);
            VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)target2);
            boolean isProblemFile = false;
            if (vFile != null) {
                Project project = target2.getProject();
                isProblemFile = WolfTheProblemSolver.getInstance((Project)project).isProblemFile(vFile);
                FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(vFile);
                color = status.getColor();
                Color fileBgColor = VfsPresentationUtil.getFileBackgroundColor(project, vFile);
                Color color2 = bgColor = fileBgColor == null ? bgColor : fileBgColor;
            }
            if (value2 instanceof PsiElement) {
                SimpleTextAttributes nameAttributes;
                PsiElement element2 = (PsiElement)value2;
                @NlsContexts.Label String name2 = ((PsiElement)value2).isValid() ? PsiElementListCellRenderer.this.getElementText(element2) : "INVALID";
                TextAttributes attributes2 = element2.isValid() ? PsiElementListCellRenderer.this.getNavigationItemAttributes(value2) : null;
                SimpleTextAttributes simpleTextAttributes = nameAttributes = attributes2 != null ? SimpleTextAttributes.fromTextAttributes(attributes2) : null;
                if (nameAttributes == null) {
                    nameAttributes = new SimpleTextAttributes(0, color);
                }
                if (name2 == null) {
                    LOG.error("Null name for PSI element " + element2.getClass() + " (by " + PsiElementListCellRenderer.this + ")");
                    name2 = LangBundle.message((String)"label.unknown", (Object[])new Object[0]);
                }
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)name2, (SimpleColoredComponent)this, (SimpleTextAttributes)nameAttributes, (com.intellij.util.text.Matcher)this.myMatchers.nameMatcher, (Color)bgColor, (boolean)selected2);
                if (!element2.isValid()) {
                    this.append(" " + LangBundle.message((String)"label.invalid", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
                    return;
                }
                this.setIcon(PsiElementListCellRenderer.this.getIcon(element2));
                FontMetrics fm = list2.getFontMetrics(list2.getFont());
                int maxWidth = list2.getWidth() - fm.stringWidth(name2) - 16 - PsiElementListCellRenderer.this.myRightComponentWidth - 20;
                String containerText = PsiElementListCellRenderer.this.getContainerTextForLeftComponent(element2, name2, maxWidth, fm);
                if (containerText != null) {
                    this.appendLocationText(selected2, bgColor, isProblemFile, containerText);
                }
            } else if (!PsiElementListCellRenderer.this.customizeNonPsiElementLeftRenderer(this, list2, value2, index2, selected2, hasFocus)) {
                this.setIcon(IconUtil.getEmptyIcon(false));
                @NlsSafe String text2 = value2 == null ? "" : value2.toString();
                this.append(text2, new SimpleTextAttributes(0, list2.getForeground()));
            }
            this.setBackground(selected2 ? UIUtil.getListSelectionBackground((boolean)true) : bgColor);
        }

        private void appendLocationText(boolean selected2, Color bgColor, boolean isProblemFile, @Nls String containerText) {
            SimpleTextAttributes locationAttrs = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            if (isProblemFile) {
                SimpleTextAttributes wavedAttributes = SimpleTextAttributes.merge(PsiElementListCellRenderer.this.getErrorAttributes(), locationAttrs);
                Matcher matcher = CONTAINER_PATTERN.matcher(containerText);
                if (matcher.matches()) {
                    String prefix = matcher.group(1);
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)(" " + (String)ObjectUtils.notNull((Object)prefix, (Object)"")), (SimpleColoredComponent)this, (SimpleTextAttributes)locationAttrs, (com.intellij.util.text.Matcher)this.myMatchers.locationMatcher, (Color)bgColor, (boolean)selected2);
                    String strippedContainerText = matcher.group(2);
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)((String)ObjectUtils.notNull((Object)strippedContainerText, (Object)"")), (SimpleColoredComponent)this, (SimpleTextAttributes)wavedAttributes, (com.intellij.util.text.Matcher)this.myMatchers.locationMatcher, (Color)bgColor, (boolean)selected2);
                    String suffix = matcher.group(3);
                    if (suffix != null) {
                        SpeedSearchUtil.appendColoredFragmentForMatcher((String)suffix, (SimpleColoredComponent)this, (SimpleTextAttributes)locationAttrs, (com.intellij.util.text.Matcher)this.myMatchers.locationMatcher, (Color)bgColor, (boolean)selected2);
                    }
                    return;
                }
                locationAttrs = wavedAttributes;
            }
            SpeedSearchUtil.appendColoredFragmentForMatcher((String)(" " + containerText), (SimpleColoredComponent)this, (SimpleTextAttributes)locationAttrs, (com.intellij.util.text.Matcher)this.myMatchers.locationMatcher, (Color)bgColor, (boolean)selected2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/PsiElementListCellRenderer$LeftRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ItemMatchers {
        @Nullable
        public final com.intellij.util.text.Matcher nameMatcher;
        @Nullable
        public final com.intellij.util.text.Matcher locationMatcher;

        public ItemMatchers(@Nullable com.intellij.util.text.Matcher nameMatcher, @Nullable com.intellij.util.text.Matcher locationMatcher) {
            this.nameMatcher = nameMatcher;
            this.locationMatcher = locationMatcher;
        }
    }

    private class MyAccessibleContext
    extends JPanel.AccessibleJPanel {
        private MyAccessibleContext() {
            super(PsiElementListCellRenderer.this);
        }

        @Override
        public String getAccessibleName() {
            LayoutManager lm = PsiElementListCellRenderer.this.getLayout();
            assert (lm instanceof BorderLayout);
            Component leftCellRendererComp = ((BorderLayout)lm).getLayoutComponent(PsiElementListCellRenderer.LEFT);
            return leftCellRendererComp instanceof Accessible ? leftCellRendererComp.getAccessibleContext().getAccessibleName() : super.getAccessibleName();
        }
    }
}

