/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TipsOfTheDayUsagesCollector;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipPanel;
import com.intellij.ide.util.TipsUsageManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TipDialog
extends DialogWrapper {
    private static TipDialog ourInstance;
    public static final Key<Boolean> DISABLE_TIPS_FOR_PROJECT;
    private final TipPanel myTipPanel;
    private final boolean myShowingOnStartup;

    TipDialog(@NotNull Window parent, @Nullable Project project) {
        if (parent == null) {
            TipDialog.$$$reportNull$$$0(0);
        }
        super((Component)parent, true);
        this.setModal(false);
        this.setTitle(IdeBundle.message((String)"title.tip.of.the.day", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.myTipPanel = new TipPanel(project);
        this.setDoNotAskOption(this.myTipPanel);
        this.myShowingOnStartup = this.myTipPanel.isToBeShown();
        this.setHorizontalStretch(1.33f);
        this.setVerticalStretch(1.25f);
        this.init();
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            TipDialog.$$$reportNull$$$0(1);
        }
        return dialogStyle;
    }

    protected JComponent createSouthPanel() {
        JComponent component2 = super.createSouthPanel();
        component2.setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        return component2;
    }

    public void doCancelAction() {
        super.doCancelAction();
        TipsOfTheDayUsagesCollector.triggerDialogClosed(this.myShowingOnStartup);
    }

    protected Action @NotNull [] createActions() {
        if (Registry.is((String)"ide.show.open.button.in.tip.dialog")) {
            Action[] actionArray = new Action[]{new OpenTipsAction(), this.myTipPanel.myPreviousTipAction, this.myTipPanel.myNextTipAction, this.getCancelAction()};
            if (actionArray == null) {
                TipDialog.$$$reportNull$$$0(2);
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.myTipPanel.myPreviousTipAction, this.myTipPanel.myNextTipAction, this.getCancelAction()};
        if (actionArray == null) {
            TipDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        return this.myTipPanel;
    }

    public static boolean canBeShownAutomaticallyNow(@NotNull Project project) {
        if (project == null) {
            TipDialog.$$$reportNull$$$0(4);
        }
        if (!GeneralSettings.getInstance().isShowTipsOnStartup() || ((Boolean)DISABLE_TIPS_FOR_PROJECT.get((UserDataHolder)project, (Object)false)).booleanValue() || ourInstance != null && ourInstance.isVisible()) {
            return false;
        }
        return !TipsUsageManager.getInstance().wereTipsShownToday();
    }

    public void dispose() {
        super.dispose();
    }

    public static void showForProject(@Nullable Project project) {
        Window w = WindowManagerEx.getInstanceEx().suggestParentWindow(project);
        if (w == null) {
            w = WindowManagerEx.getInstanceEx().findVisibleFrame();
        }
        if (ourInstance != null && ourInstance.isVisible()) {
            ourInstance.dispose();
        }
        ourInstance = new TipDialog(w, project);
        ourInstance.show();
    }

    public static void hideForProject(@Nullable Project project) {
        if (ourInstance != null) {
            ourInstance.dispose();
            ourInstance = null;
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPreferredFocusedComponent;
    }

    static {
        DISABLE_TIPS_FOR_PROJECT = Key.create((String)"DISABLE_TIPS_FOR_PROJECT");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/TipDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/TipDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canBeShownAutomaticallyNow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class OpenTipsAction
    extends AbstractAction {
        private static final String LAST_OPENED_TIP_PATH = "last.opened.tip.path";

        OpenTipsAction() {
            super(IdeBundle.message((String)"action.open.tip", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VirtualFile[] virtualFileArray;
            VirtualFile lastOpenedTip;
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, false, false, true).withFileFilter(file2 -> Comparing.equal((String)file2.getExtension(), (String)"html", (boolean)file2.isCaseSensitive()));
            String value2 = propertiesComponent.getValue(LAST_OPENED_TIP_PATH);
            VirtualFile virtualFile2 = lastOpenedTip = value2 != null ? LocalFileSystem.getInstance().findFileByPath(value2) : null;
            if (lastOpenedTip != null) {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = lastOpenedTip;
            } else {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
            }
            VirtualFile[] pathToSelect = virtualFileArray;
            VirtualFile[] choose = FileChooserFactory.getInstance().createFileChooser(descriptor2, null, (Component)TipDialog.this.myTipPanel).choose(null, pathToSelect);
            if (choose.length > 0) {
                ArrayList<TipAndTrickBean> tips = new ArrayList<TipAndTrickBean>();
                for (VirtualFile file3 : choose) {
                    TipAndTrickBean tip = new TipAndTrickBean();
                    tip.fileName = file3.getPath();
                    tip.featureId = null;
                    tips.add(tip);
                    propertiesComponent.setValue(LAST_OPENED_TIP_PATH, file3.getPath());
                }
                TipDialog.this.myTipPanel.setTips(tips);
            }
        }
    }
}

