/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ResourceUtil;
import com.intellij.util.SVGLoader;
import com.intellij.util.io.IOUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public final class TipUIUtil {
    private static final Logger LOG = Logger.getInstance(TipUIUtil.class);
    private static final Pattern SHORTCUT_PATTERN = Pattern.compile("&shortcut:([\\w.$]+?);");
    private static final List<TipEntity> ENTITIES = List.of(TipEntity.of("productName", ApplicationNamesInfo.getInstance().getFullProductName()), TipEntity.of("majorVersion", ApplicationInfo.getInstance().getMajorVersion()), TipEntity.of("minorVersion", ApplicationInfo.getInstance().getMinorVersion()), TipEntity.of("majorMinorVersion", ApplicationInfo.getInstance().getMajorVersion() + (String)("0".equals(ApplicationInfo.getInstance().getMinorVersion()) ? "" : "." + ApplicationInfo.getInstance().getMinorVersion())), TipEntity.of("settingsPath", CommonBundle.settingsActionPath()));

    private TipUIUtil() {
    }

    @NlsSafe
    @NotNull
    public static String getPoweredByText(@NotNull TipAndTrickBean tip) {
        PluginDescriptor descriptor2;
        if (tip == null) {
            TipUIUtil.$$$reportNull$$$0(0);
        }
        String string = (descriptor2 = tip.getPluginDescriptor()) == null || PluginManagerCore.CORE_ID.equals((Object)descriptor2.getPluginId()) ? "" : descriptor2.getName();
        if (string == null) {
            TipUIUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static TipAndTrickBean getTip(@Nullable FeatureDescriptor feature) {
        if (feature == null) {
            return null;
        }
        String tipFileName = feature.getTipFileName();
        if (tipFileName == null) {
            LOG.warn("No Tip of the day for feature " + feature.getId());
            return null;
        }
        TipAndTrickBean tip = TipAndTrickBean.findByFileName("neue-" + tipFileName);
        if (tip == null && StringUtil.isNotEmpty((String)tipFileName)) {
            tip = TipAndTrickBean.findByFileName(tipFileName);
        }
        if (tip == null && StringUtil.isNotEmpty((String)tipFileName)) {
            tip = new TipAndTrickBean();
            tip.fileName = tipFileName;
        }
        return tip;
    }

    @NlsSafe
    private static String getTipText(@Nullable TipAndTrickBean tip, Component component2) {
        if (tip == null) {
            return IdeBundle.message((String)"no.tip.of.the.day", (Object[])new Object[0]);
        }
        String cssFile = StartupUiUtil.isUnderDarcula() ? "css/tips_darcula.css" : "css/tips.css";
        try {
            StringBuilder text2 = new StringBuilder();
            String cssText = null;
            File tipFile = new File(tip.fileName);
            if (tipFile.isAbsolute() && tipFile.exists()) {
                text2.append(FileUtil.loadFile((File)tipFile, (Charset)StandardCharsets.UTF_8));
                TipUIUtil.updateImagesAndEntities(text2, null, tipFile.getParentFile().getAbsolutePath(), component2);
                cssText = FileUtil.loadFile((File)new File(tipFile.getParentFile(), cssFile));
            } else {
                String ideCode;
                PluginDescriptor langBundleLoader;
                ClassLoader fallbackLoader = TipUIUtil.class.getClassLoader();
                PluginDescriptor pluginDescriptor = tip.getPluginDescriptor();
                DynamicBundle.LanguageBundleEP langBundle = DynamicBundle.findLanguageBundle();
                ClassLoader tipLoader = null;
                if (langBundle != null && (langBundleLoader = langBundle.pluginDescriptor) != null) {
                    tipLoader = langBundleLoader.getPluginClassLoader();
                }
                if (tipLoader == null && pluginDescriptor != null && pluginDescriptor.getPluginClassLoader() != null) {
                    tipLoader = pluginDescriptor.getPluginClassLoader();
                }
                if (tipLoader == null) {
                    tipLoader = fallbackLoader;
                }
                if ((ideCode = ApplicationInfoEx.getInstanceEx().getApiVersionAsNumber().getProductCode().toLowerCase(Locale.ROOT)).contains("ic")) {
                    ideCode = "iu";
                }
                ArrayList<TipRetriever> retrievers = new ArrayList<TipRetriever>();
                retrievers.add(new TipRetriever(tipLoader, "tips", ideCode));
                retrievers.add(new TipRetriever(tipLoader, "tips", "misc"));
                retrievers.add(new TipRetriever(tipLoader, "tips", ""));
                retrievers.add(new TipRetriever(fallbackLoader, "tips", ""));
                String tipContent = null;
                for (TipRetriever retriever : retrievers) {
                    tipContent = retriever.getTipContent(tip.fileName);
                    if (tipContent == null) continue;
                    text2.append(tipContent);
                    String tipImagesLocation = String.format("/%s/%s", retriever.myPath, retriever.mySubPath.length() > 0 ? retriever.mySubPath + "/" : "");
                    TipUIUtil.updateImagesAndEntities(text2, retriever.myLoader, tipImagesLocation, component2);
                    InputStream cssResourceStream = ResourceUtil.getResourceAsStream((ClassLoader)retriever.myLoader, (String)retriever.myPath, (String)cssFile);
                    cssText = cssResourceStream != null ? ResourceUtil.loadText((InputStream)cssResourceStream) : "";
                    break;
                }
                if (tipContent == null) {
                    return TipUIUtil.getCantReadText(tip);
                }
            }
            String replaced = text2.toString();
            String inlinedCSS = cssText + "\nbody {background-color:#" + ColorUtil.toHex((Color)UIUtil.getTextFieldBackground()) + ";overflow:hidden;}";
            return replaced.replaceFirst("<link.*\\.css\">", "<style type=\"text/css\">\n" + inlinedCSS + "\n</style>");
        }
        catch (IOException e) {
            return TipUIUtil.getCantReadText(tip);
        }
    }

    public static void openTipInBrowser(@Nullable TipAndTrickBean tip, Browser browser2) {
        browser2.setText(TipUIUtil.getTipText(tip, browser2.getComponent()));
    }

    @NotNull
    private static String getCantReadText(@NotNull TipAndTrickBean bean) {
        if (bean == null) {
            TipUIUtil.$$$reportNull$$$0(2);
        }
        String plugin2 = TipUIUtil.getPoweredByText(bean);
        Object product = ApplicationNamesInfo.getInstance().getFullProductName();
        if (!plugin2.isEmpty()) {
            product = (String)product + " and " + plugin2 + " plugin";
        }
        String string = IdeBundle.message((String)"error.unable.to.read.tip.of.the.day", (Object[])new Object[]{bean.fileName, product});
        if (string == null) {
            TipUIUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void updateImagesAndEntities(StringBuilder text2, ClassLoader tipLoader, String tipPath, Component component2) {
        boolean dark = StartupUiUtil.isUnderDarcula();
        boolean hidpi = JBUI.isPixHiDPI((Component)component2);
        Document tipHtml = Jsoup.parse((String)text2.toString());
        tipHtml.outputSettings().prettyPrint(false);
        tipHtml.getElementsContainingOwnText("&").forEach(element2 -> {
            String textNodeText = element2.text();
            for (TipEntity entity : ENTITIES) {
                textNodeText = entity.inline(textNodeText);
            }
            element2.text(textNodeText);
        });
        tipHtml.getElementsMatchingOwnText(SHORTCUT_PATTERN).forEach(shortcut -> shortcut.text(SHORTCUT_PATTERN.matcher(shortcut.text()).replaceAll(result2 -> {
            Keymap defKeymap;
            Object shortcutText = null;
            String actionId = result2.group(1);
            if (actionId != null && (shortcutText = TipUIUtil.getShortcutText(actionId, KeymapManager.getInstance().getActiveKeymap())) == null && (defKeymap = KeymapManager.getInstance().getKeymap(DefaultKeymap.Companion.getInstance().getDefaultKeymapName())) != null && (shortcutText = TipUIUtil.getShortcutText(actionId, defKeymap)) != null) {
                shortcutText = (String)shortcutText + IdeBundle.message((String)"tips.of.the.day.shortcut.default.keymap", (Object[])new Object[0]);
            }
            if (shortcutText == null) {
                shortcutText = "\"" + actionId + "\" " + IdeBundle.message((String)"tips.of.the.day.shortcut.must.define", (Object[])new Object[0]);
            }
            return Matcher.quoteReplacement(shortcutText);
        })));
        tipHtml.getElementsByTag("img").forEach(img -> {
            String src = img.attributes().getIgnoreCase("src");
            TodImage originalImage = TodImage.of(src);
            TodImage baseImage = originalImage.base();
            ArrayList<TodImage> imagesToTryLight = new ArrayList<TodImage>();
            ArrayList<TodImage> imagesToTryDark = new ArrayList<TodImage>();
            imagesToTryLight.add(baseImage);
            imagesToTryLight.add(baseImage.retina());
            imagesToTryDark.add(baseImage.dark());
            imagesToTryDark.add(baseImage.dark().retina());
            if (hidpi) {
                Collections.reverse(imagesToTryLight);
                Collections.reverse(imagesToTryDark);
            }
            ArrayList<TodImage> imagesToTry = new ArrayList<TodImage>();
            if (dark) {
                imagesToTry.addAll(imagesToTryDark);
                imagesToTry.addAll(imagesToTryLight);
            } else {
                imagesToTry.addAll(imagesToTryLight);
                imagesToTry.addAll(imagesToTryDark);
            }
            try {
                BufferedImage image = null;
                boolean fallbackUpscale = false;
                boolean fallbackDownscale = false;
                URL actualURL = null;
                for (TodImage i2 : imagesToTry) {
                    try {
                        actualURL = new URL(TipUIUtil.getImageCanonicalPath(i2.toString(), tipLoader, tipPath));
                        image = TipUIUtil.read(actualURL);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (image == null) continue;
                    if (hidpi) {
                        fallbackUpscale = originalImage.isRetina() && !i2.isRetina();
                        break;
                    }
                    fallbackDownscale = !originalImage.isRetina() && i2.isRetina();
                    break;
                }
                int w = TipUIUtil.intValueOf(img.attributes().getIgnoreCase("width"), image.getWidth());
                if (hidpi) {
                    float k = 2.0f;
                    if (StartupUiUtil.isJreHiDPI((Component)component2)) {
                        k = JBUIScale.sysScale((Component)component2);
                    }
                    w = (int)((float)w / k);
                }
                int userScale = PaintUtil.RoundingMode.ROUND_FLOOR_BIAS.round((double)JBUIScale.scale((float)1.0f));
                w = userScale * w;
                if (fallbackUpscale) {
                    w *= 2;
                } else if (fallbackDownscale) {
                    w /= 2;
                }
                img.attr("src", actualURL.toExternalForm());
                img.attr("width", String.valueOf(w));
            }
            catch (Exception e) {
                LOG.warn("ToD: cannot load image [" + src + "]", (Throwable)e);
            }
        });
        text2.replace(0, text2.length(), tipHtml.outerHtml());
    }

    private static int intValueOf(String raw, int substitute) {
        try {
            return Integer.parseInt(raw);
        }
        catch (NumberFormatException numberFormatException) {
            return substitute;
        }
    }

    @NotNull
    private static String getImageCanonicalPath(@NotNull String path2, @Nullable ClassLoader tipLoader, @NotNull String tipPath) {
        String string;
        if (path2 == null) {
            TipUIUtil.$$$reportNull$$$0(4);
        }
        if (tipPath == null) {
            TipUIUtil.$$$reportNull$$$0(5);
        }
        try {
            URL url = tipLoader == null ? new File(tipPath, path2).toURI().toURL() : ResourceUtil.getResource((ClassLoader)tipLoader, (String)tipPath, (String)path2);
            string = url == null ? path2 : url.toExternalForm();
        }
        catch (MalformedURLException e) {
            String string2 = path2;
            if (string2 == null) {
                TipUIUtil.$$$reportNull$$$0(7);
            }
            return string2;
        }
        if (string == null) {
            TipUIUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static BufferedImage read(@NotNull URL url) throws IOException {
        if (url == null) {
            TipUIUtil.$$$reportNull$$$0(8);
        }
        try (InputStream stream = url.openStream();){
            BufferedImage image = ImageIO.read(stream);
            if (image == null) {
                throw new IOException("Cannot read image with ImageIO: " + url.toExternalForm());
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
    }

    @Nullable
    private static String getShortcutText(String actionId, Keymap keymap2) {
        for (Shortcut shortcut : keymap2.getShortcuts(actionId)) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            return KeymapUtil.getShortcutText((Shortcut)shortcut);
        }
        return null;
    }

    public static Browser createBrowser() {
        return new SwingBrowser();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tip";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/TipUIUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tipPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/TipUIUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPoweredByText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCantReadText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageCanonicalPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPoweredByText";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCantReadText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getImageCanonicalPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class TodImage {
        static final String RETINA_SUFFIX = "@2x";
        static final String DARK_SUFFIX = "_dark";
        private final String name;
        private final String extension;
        private final String defaultExtension;
        private final boolean dark;
        private final boolean retina;

        private TodImage(@NotNull String name2) {
            if (name2 == null) {
                TodImage.$$$reportNull$$$0(0);
            }
            CharSequence tempExtension = FileUtil.getExtension((CharSequence)name2, (String)"");
            this.extension = tempExtension.toString();
            this.defaultExtension = tempExtension.toString();
            String tempName = FileUtil.getNameWithoutExtension((String)name2);
            if (tempName.endsWith(DARK_SUFFIX)) {
                this.dark = true;
                tempName = StringUtil.substringBeforeLast((String)name2, (String)DARK_SUFFIX);
            } else {
                this.dark = false;
            }
            if (tempName.endsWith(RETINA_SUFFIX)) {
                this.retina = true;
                tempName = StringUtil.substringBeforeLast((String)name2, (String)RETINA_SUFFIX);
            } else {
                this.retina = false;
            }
            this.name = tempName;
        }

        private TodImage(String name2, String extension2, boolean dark, boolean retina) {
            this(name2, extension2, dark, retina, extension2);
        }

        private TodImage(String name2, String extension2, boolean dark, boolean retina, String defaultExtension) {
            this.name = name2;
            this.extension = extension2;
            this.defaultExtension = defaultExtension;
            this.dark = dark;
            this.retina = retina;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                TodImage.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getExtension() {
            String string = this.extension;
            if (string == null) {
                TodImage.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isDark() {
            return this.dark;
        }

        public boolean isRetina() {
            return this.retina;
        }

        @NotNull
        public TodImage dark() {
            return new TodImage(this.name, this.extension, true, this.retina);
        }

        @NotNull
        public TodImage nonDark() {
            return new TodImage(this.name, this.extension, false, this.retina);
        }

        @NotNull
        public TodImage retina() {
            return new TodImage(this.name, this.extension, this.dark, true);
        }

        @NotNull
        public TodImage nonRetina() {
            return new TodImage(this.name, this.extension, this.dark, false);
        }

        @NotNull
        public TodImage withExtension(@NotNull String extension2) {
            if (extension2 == null) {
                TodImage.$$$reportNull$$$0(3);
            }
            return new TodImage(this.name, extension2, this.dark, this.retina);
        }

        @NotNull
        public TodImage withName(@NotNull String name2) {
            if (name2 == null) {
                TodImage.$$$reportNull$$$0(4);
            }
            return new TodImage(name2, this.extension, this.dark, this.retina);
        }

        @NotNull
        public TodImage base() {
            return new TodImage(this.name, this.defaultExtension, false, false);
        }

        public String toString() {
            return this.name + (this.retina ? RETINA_SUFFIX : "") + (this.dark ? DARK_SUFFIX : "") + "." + this.extension;
        }

        @NotNull
        public static TodImage of(@NotNull String src) {
            if (src == null) {
                TodImage.$$$reportNull$$$0(5);
            }
            return new TodImage(src);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/TipUIUtil$TodImage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "src";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/TipUIUtil$TodImage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "withExtension";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "withName";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SwingBrowser
    extends JEditorPane
    implements Browser {
        SwingBrowser() {
            this.setEditable(false);
            this.setBackground(UIUtil.getTextFieldBackground());
            this.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        BrowserUtil.browse((URL)e.getURL());
                    }
                }
            });
            JBHtmlEditorKit kit = new JBHtmlEditorKit(false){
                private final ViewFactory myFactory;
                {
                    super(arg0);
                    this.myFactory = this.createViewFactory();
                }

                private ViewFactory createViewFactory() {
                    return new HTMLEditorKit.HTMLFactory(){

                        @Override
                        public View create(Element elem) {
                            String src;
                            View view = super.create(elem);
                            if (view instanceof ImageView && (src = (String)view.getElement().getAttributes().getAttribute(HTML.Attribute.SRC)) != null) {
                                try {
                                    final URL url = new URL(src);
                                    Dictionary cache2 = (Dictionary)elem.getDocument().getProperty("imageCache");
                                    if (cache2 == null) {
                                        cache2 = new Dictionary(){
                                            private final HashMap myMap = new HashMap();

                                            @Override
                                            public int size() {
                                                return this.myMap.size();
                                            }

                                            @Override
                                            public boolean isEmpty() {
                                                return this.size() == 0;
                                            }

                                            public Enumeration keys() {
                                                return Collections.enumeration(this.myMap.keySet());
                                            }

                                            public Enumeration elements() {
                                                return Collections.enumeration(this.myMap.values());
                                            }

                                            public Object get(Object key) {
                                                return this.myMap.get(key);
                                            }

                                            public Object put(Object key, Object value2) {
                                                return this.myMap.put(key, value2);
                                            }

                                            public Object remove(Object key) {
                                                return this.myMap.remove(key);
                                            }
                                        };
                                        elem.getDocument().putProperty("imageCache", cache2);
                                    }
                                    final Image image = src.endsWith(".svg") ? SVGLoader.load((URL)url, (float)(JBUI.isPixHiDPI((Component)null) ? 2.0f : 1.0f)) : Toolkit.getDefaultToolkit().createImage(url);
                                    cache2.put(url, image);
                                    if (src.endsWith(".svg")) {
                                        return new ImageView(elem){

                                            @Override
                                            public Image getImage() {
                                                return image;
                                            }

                                            @Override
                                            public URL getImageURL() {
                                                return url;
                                            }

                                            @Override
                                            public void paint(Graphics g, Shape a) {
                                                Rectangle bounds2 = a.getBounds();
                                                int width = (int)this.getPreferredSpan(0);
                                                int height = (int)this.getPreferredSpan(1);
                                                BufferedImage buffer = new BufferedImage(width, height, 2);
                                                Graphics2D graphics = buffer.createGraphics();
                                                super.paint(graphics, new Rectangle(buffer.getWidth(), buffer.getHeight()));
                                                UIUtil.drawImage((Graphics)g, (Image)ImageUtil.ensureHiDPI((Image)image, (ScaleContext)ScaleContext.create((Component)null)), (int)bounds2.x, (int)bounds2.y, null);
                                            }

                                            @Override
                                            public float getMaximumSpan(int axis) {
                                                return this.getPreferredSpan(axis);
                                            }

                                            @Override
                                            public float getMinimumSpan(int axis) {
                                                return this.getPreferredSpan(axis);
                                            }

                                            @Override
                                            public float getPreferredSpan(int axis) {
                                                return (float)(axis == 0 ? image.getWidth(null) : image.getHeight(null)) / JBUIScale.sysScale();
                                            }
                                        };
                                    }
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return view;
                        }
                    };
                }

                public ViewFactory getViewFactory() {
                    return this.myFactory;
                }
            };
            String fileName = StartupUiUtil.isUnderDarcula() ? "tips_darcula.css" : "tips.css";
            URL resource = TipUIUtil.class.getClassLoader().getResource("tips/css/" + fileName);
            kit.getStyleSheet().addStyleSheet(StartupUiUtil.loadStyleSheet((URL)resource));
            this.setEditorKit((EditorKit)kit);
        }

        @Override
        public void setText(String t) {
            super.setText(t);
            if (t != null && t.length() > 0) {
                this.setCaretPosition(0);
            }
        }

        @Override
        public void load(String url) throws IOException {
            @NlsSafe String text2 = IOUtil.readString((DataInput)new DataInputStream(new URL(url).openStream()));
            this.setText(text2);
        }

        @Override
        public JComponent getComponent() {
            return this;
        }
    }

    private static class TipRetriever {
        private final ClassLoader myLoader;
        private final String myPath;
        private final String mySubPath;

        private TipRetriever(ClassLoader loader, String path2, String subPath) {
            this.myLoader = loader;
            this.myPath = path2;
            this.mySubPath = subPath;
        }

        @Nullable
        String getTipContent(@Nullable String tipName) {
            String result2 = null;
            if (tipName != null) {
                String tipLocation = String.format("/%s/%s", this.myPath, this.mySubPath.length() > 0 ? this.mySubPath + "/" : "");
                InputStream tipStream = ResourceUtil.getResourceAsStream((ClassLoader)this.myLoader, (String)tipLocation, (String)tipName);
                if (tipStream == null && tipName.startsWith("neue-")) {
                    tipStream = ResourceUtil.getResourceAsStream((ClassLoader)this.myLoader, (String)tipLocation, (String)tipName.substring(5));
                }
                if (tipStream != null) {
                    try {
                        result2 = ResourceUtil.loadText((InputStream)tipStream);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return result2;
        }
    }

    private static class TipEntity {
        private final String name;
        private final String value;

        private TipEntity(String name2, String value2) {
            this.name = name2;
            this.value = value2;
        }

        String inline(String where) {
            return where.replace(String.format("&%s;", this.name), this.value);
        }

        static TipEntity of(String name2, String value2) {
            return new TipEntity(name2, value2);
        }
    }

    public static interface Browser
    extends TextAccessor {
        public void load(String var1) throws IOException;

        public JComponent getComponent();

        @Override
        public void setText(@Nls String var1);
    }
}

