/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ComputeVirtualFileNameStatAction
extends AnAction
implements DumbAware {
    Object2IntOpenHashMap<String> suffixes = new Object2IntOpenHashMap();
    Object2IntOpenHashMap<String> nameCount = new Object2IntOpenHashMap();

    public ComputeVirtualFileNameStatAction() {
        super(ActionsBundle.messagePointer((String)"action.ComputeVirtualFileNameStatAction.text", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] roots2;
        if (e == null) {
            ComputeVirtualFileNameStatAction.$$$reportNull$$$0(0);
        }
        long start2 = System.currentTimeMillis();
        this.suffixes.clear();
        this.nameCount.clear();
        for (VirtualFile root2 : roots2 = ManagingFS.getInstance().getRoots((NewVirtualFileSystem)LocalFileSystem.getInstance())) {
            this.compute(root2);
        }
        ArrayList<Pair> names2 = new ArrayList<Pair>(this.nameCount.size());
        for (Object2IntMap.Entry entry2 : this.nameCount.object2IntEntrySet()) {
            names2.add(new Pair((Object)((String)entry2.getKey()), (Object)entry2.getIntValue()));
        }
        names2.sort((o1, o2) -> (Integer)o2.second - (Integer)o1.second);
        System.out.println("Most frequent names (" + names2.size() + " total):");
        int saveByIntern = 0;
        for (Pair pair : names2) {
            int count = (Integer)pair.second;
            String name2 = (String)pair.first;
            System.out.println(name2 + " -> " + count);
            saveByIntern += count * name2.length();
            if (count != 1) continue;
            break;
        }
        System.out.println("Total save if names were interned: " + saveByIntern + "; ------------");
        System.out.println("Suffix counts:(" + this.suffixes.size() + " total)");
        ComputeVirtualFileNameStatAction.show(this.suffixes);
        Object2IntOpenHashMap save2 = new Object2IntOpenHashMap();
        for (Object2IntMap.Entry entry3 : this.suffixes.object2IntEntrySet()) {
            save2.put((Object)((String)entry3.getKey()), entry3.getIntValue() * ((String)entry3.getKey()).length());
        }
        System.out.println("Supposed save by stripping suffixes: (" + save2.size() + " total)");
        List<Pair<String, Integer>> saveSorted = ComputeVirtualFileNameStatAction.show((Object2IntMap<String>)save2);
        ArrayList<String> picked = new ArrayList<String>();
        while (picked.size() != 15) {
            Pair<String, Integer> cp = saveSorted.get(0);
            String candidate = (String)cp.first;
            picked.add(candidate);
            System.out.println("Candidate: '" + candidate + "', save = " + cp.second);
            picked.sort((o1, o2) -> o2.length() - o1.length());
            saveSorted.clear();
            for (Object2IntMap.Entry entry4 : this.suffixes.object2IntEntrySet()) {
                String s2 = (String)entry4.getKey();
                int count = entry4.getIntValue();
                for (int i2 = picked.size() - 1; i2 >= 0; --i2) {
                    String pick2 = (String)picked.get(i2);
                    if (!pick2.endsWith(s2)) continue;
                    count -= this.suffixes.getInt((Object)pick2);
                    break;
                }
                saveSorted.add((Pair<String, Integer>)Pair.create((Object)s2, (Object)(s2.length() * count)));
            }
            saveSorted.sort((o1, o2) -> ((Integer)o2.second).compareTo((Integer)o1.second));
        }
        System.out.println("Picked: " + StringUtil.join(picked, s -> "\"" + s + "\"", (String)","));
        picked.sort((o1, o2) -> o2.length() - o1.length());
        int saved = 0;
        for (int i3 = 0; i3 < picked.size(); ++i3) {
            String s3 = (String)picked.get(i3);
            int count = this.suffixes.getInt((Object)s3);
            for (int k = 0; k < i3; ++k) {
                String prev2 = (String)picked.get(k);
                if (!prev2.endsWith(s3)) continue;
                count -= this.suffixes.getInt((Object)prev2);
                break;
            }
            saved += count * s3.length();
        }
        System.out.println("total saved = " + saved);
        System.out.println("Time spent: " + (System.currentTimeMillis() - start2));
    }

    private static List<Pair<String, Integer>> show(Object2IntMap<String> prefixes) {
        ArrayList<Pair<String, Integer>> prefs = new ArrayList<Pair<String, Integer>>(prefixes.size());
        for (Object2IntMap.Entry entry2 : prefixes.object2IntEntrySet()) {
            prefs.add((Pair<String, Integer>)new Pair((Object)((String)entry2.getKey()), (Object)entry2.getIntValue()));
        }
        prefs.sort((o1, o2) -> ((Integer)o2.second).compareTo((Integer)o1.second));
        int i2 = 0;
        for (Pair pair : prefs) {
            Integer count = (Integer)pair.second;
            System.out.printf("%60.60s : %d\n", pair.first, count);
            if (i2++ <= 100) continue;
            System.out.println("\n.......<" + count + "...\n");
            break;
        }
        return prefs;
    }

    private void compute(VirtualFile root2) {
        String name2 = root2.getName();
        this.nameCount.addTo((Object)name2, 1);
        for (int i2 = 1; i2 <= name2.length(); ++i2) {
            String suffix = name2.substring(name2.length() - i2);
            this.suffixes.addTo((Object)suffix, 1);
        }
        Collection cachedChildren = ((VirtualFileSystemEntry)root2).getCachedChildren();
        for (VirtualFile cachedChild : cachedChildren) {
            this.compute(cachedChild);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/ComputeVirtualFileNameStatAction", "actionPerformed"));
    }
}

