/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef;

import com.intellij.application.options.RegistryManager;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefFpsMeter;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.NotNull;

public class JBCefOsrBrowserMeasureFpsAction
extends DumbAwareAction {
    @NotNull
    private static final String FPS_METER_ID = RegistryManager.getInstance().get("ide.browser.jcef.osr.measureFPS.id").asString();

    public void actionPerformed(@NotNull AnActionEvent e) {
        Component focusOwner;
        if (e == null) {
            JBCefOsrBrowserMeasureFpsAction.$$$reportNull$$$0(0);
        }
        if ((focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null || !focusOwner.getClass().getName().contains("JBCefOsrComponent")) {
            throw new IllegalStateException("No JCEF OSR browser is in focus");
        }
        Notification notification = ((NotificationGroup)JBCefApp.NOTIFICATION_GROUP.getValue()).createNotification(IdeBundle.message((String)"notification.title.jcef.measureFPS", (Object[])new Object[0]), IdeBundle.message((String)"notification.content.jcef.measureFPS", (Object[])new Object[0]), NotificationType.INFORMATION);
        notification.notify(null);
        final JBCefFpsMeter fpsMeter = JBCefFpsMeter.get((String)FPS_METER_ID);
        if (fpsMeter == null) {
            return;
        }
        focusOwner.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e1) {
                focusOwner.removeKeyListener(this);
                fpsMeter.setActive(false);
            }
        });
        focusOwner.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e1) {
                focusOwner.removeFocusListener(this);
                fpsMeter.setActive(false);
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Robot robot;
            try {
                robot = new Robot();
            }
            catch (AWTException ex) {
                ex.printStackTrace();
                return;
            }
            fpsMeter.setActive(true);
            boolean scroll = RegistryManager.getInstance().is("ide.browser.jcef.osr.measureFPS.scroll");
            while (fpsMeter.isActive()) {
                if (scroll) {
                    robot.mouseWheel(SystemInfo.isMac ? -1 : 1);
                }
                robot.delay(scroll ? 15 : 1000);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/jcef/JBCefOsrBrowserMeasureFpsAction", "actionPerformed"));
    }
}

