/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.internal.ml.BinaryFeature;
import com.intellij.internal.ml.CategoricalFeature;
import com.intellij.internal.ml.Feature;
import com.intellij.internal.ml.FeatureMapper;
import com.intellij.internal.ml.FeaturesInfo;
import com.intellij.internal.ml.FloatFeature;
import com.intellij.internal.ml.InconsistentMetadataException;
import com.intellij.internal.ml.ModelMetadata;
import com.intellij.internal.ml.ModelMetadataReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cBU\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0010R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/internal/ml/FeaturesInfo;", "Lcom/intellij/internal/ml/ModelMetadata;", "knownFeatures", "", "", "binaryFeatures", "", "Lcom/intellij/internal/ml/BinaryFeature;", "floatFeatures", "Lcom/intellij/internal/ml/FloatFeature;", "categoricalFeatures", "Lcom/intellij/internal/ml/CategoricalFeature;", "featuresOrder", "", "Lcom/intellij/internal/ml/FeatureMapper;", "version", "(Ljava/util/Set;Ljava/util/List;Ljava/util/List;Ljava/util/List;[Lcom/intellij/internal/ml/FeatureMapper;Ljava/lang/String;)V", "getBinaryFeatures", "()Ljava/util/List;", "getCategoricalFeatures", "getFeaturesOrder", "()[Lcom/intellij/internal/ml/FeatureMapper;", "[Lcom/intellij/internal/ml/FeatureMapper;", "getFloatFeatures", "getKnownFeatures", "()Ljava/util/Set;", "getVersion", "()Ljava/lang/String;", "Companion", "intellij.platform.ide.impl"})
public final class FeaturesInfo
implements ModelMetadata {
    @NotNull
    private final Set<String> knownFeatures;
    @NotNull
    private final List<BinaryFeature> binaryFeatures;
    @NotNull
    private final List<FloatFeature> floatFeatures;
    @NotNull
    private final List<CategoricalFeature> categoricalFeatures;
    @NotNull
    private final FeatureMapper[] featuresOrder;
    @Nullable
    private final String version;
    private static final Gson gson;
    private static final String DEFAULT = "default";
    private static final String USE_UNDEFINED = "use_undefined";
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public Set<String> getKnownFeatures() {
        return this.knownFeatures;
    }

    @Override
    @NotNull
    public List<BinaryFeature> getBinaryFeatures() {
        return this.binaryFeatures;
    }

    @Override
    @NotNull
    public List<FloatFeature> getFloatFeatures() {
        return this.floatFeatures;
    }

    @Override
    @NotNull
    public List<CategoricalFeature> getCategoricalFeatures() {
        return this.categoricalFeatures;
    }

    @Override
    @NotNull
    public FeatureMapper[] getFeaturesOrder() {
        return this.featuresOrder;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.version;
    }

    public FeaturesInfo(@NotNull Set<String> knownFeatures, @NotNull List<BinaryFeature> binaryFeatures, @NotNull List<FloatFeature> floatFeatures, @NotNull List<CategoricalFeature> categoricalFeatures, @NotNull FeatureMapper[] featuresOrder, @Nullable String version2) {
        Intrinsics.checkNotNullParameter(knownFeatures, (String)"knownFeatures");
        Intrinsics.checkNotNullParameter(binaryFeatures, (String)"binaryFeatures");
        Intrinsics.checkNotNullParameter(floatFeatures, (String)"floatFeatures");
        Intrinsics.checkNotNullParameter(categoricalFeatures, (String)"categoricalFeatures");
        Intrinsics.checkNotNullParameter((Object)featuresOrder, (String)"featuresOrder");
        this.knownFeatures = knownFeatures;
        this.binaryFeatures = binaryFeatures;
        this.floatFeatures = floatFeatures;
        this.categoricalFeatures = categoricalFeatures;
        this.featuresOrder = featuresOrder;
        this.version = version2;
    }

    static {
        Companion = new Companion(null);
        gson = new Gson();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000bH\u0002J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000bH\u0002J>\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J5\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0002JH\u0010!\u001a.\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020#0\"j\u0002`$\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020#0\"j\u0002`$0\"2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000bH\u0002J$\u0010%\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000bH\u0002J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000bH\u0002J\u0017\u0010&\u001a\u0002H'\"\u0004\b\u0000\u0010'*\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040**\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/internal/ml/FeaturesInfo$Companion;", "", "()V", "DEFAULT", "", "USE_UNDEFINED", "gson", "Lcom/google/gson/Gson;", "allowUndefined", "", "description", "", "binary", "Lcom/intellij/internal/ml/BinaryFeature;", "name", "buildFeaturesIndex", "Lcom/intellij/internal/ml/Feature;", "", "float", "Lcom/intellij/internal/ml/FloatFeature;", "categorical", "Lcom/intellij/internal/ml/CategoricalFeature;", "buildInfo", "Lcom/intellij/internal/ml/FeaturesInfo;", "reader", "Lcom/intellij/internal/ml/ModelMetadataReader;", "buildMappers", "", "Lcom/intellij/internal/ml/FeatureMapper;", "features", "order", "(Ljava/util/Map;Ljava/util/List;)[Lcom/intellij/internal/ml/FeatureMapper;", "categories", "extractBinaryValuesMappings", "Lkotlin/Pair;", "", "Lcom/intellij/internal/ml/ValueMapping;", "extractDefaultValue", "fromJson", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "withSafeWeighers", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private final Set<String> withSafeWeighers(List<String> $this$withSafeWeighers) {
            Set result2 = CollectionsKt.toMutableSet((Iterable)$this$withSafeWeighers);
            result2.add("prox_directoryType");
            result2.add("kt_prox_directoryType");
            result2.add("kotlin.unwantedElement");
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FeaturesInfo buildInfo(@NotNull ModelMetadataReader reader) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Feature feature;
            Collection collection;
            Object object;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Set<String> knownFeatures = this.withSafeWeighers((List)this.fromJson(reader.allKnown()));
            Map map2 = (Map)this.fromJson(reader.binaryFeatures());
            boolean $i$f$map22 = false;
            void var6_6 = $this$map$iv3;
            Collection destination$iv$iv = new ArrayList($this$map$iv3.size());
            boolean $i$f$mapTo = false;
            void var9_14 = $this$mapTo$iv$iv3;
            boolean bl = false;
            for (Map.Entry item$iv$iv : var9_14.entrySet()) {
                void it;
                object = item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                feature = Companion.binary((String)it.getKey(), (Map)it.getValue());
                collection.add(feature);
            }
            List binaryFactors = (List)destination$iv$iv;
            Map $i$f$map22 = (Map)this.fromJson(reader.floatFeatures());
            boolean $i$f$map32 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            void var10_18 = $this$mapTo$iv$iv2;
            boolean bl3 = false;
            Iterator iterator2 = var10_18.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry bl2 = item$iv$iv = iterator2.next();
                collection = destination$iv$iv2;
                boolean bl4 = false;
                feature = Companion.float((String)it.getKey(), (Map)it.getValue());
                collection.add(feature);
            }
            List doubleFactors = (List)destination$iv$iv2;
            Map $i$f$map32 = (Map)this.fromJson(reader.categoricalFeatures());
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo3 = false;
            void var11_22 = $this$mapTo$iv$iv;
            boolean bl5 = false;
            object = var11_22.entrySet().iterator();
            while (object.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry bl4 = item$iv$iv = (Map.Entry)object.next();
                collection = destination$iv$iv3;
                boolean bl6 = false;
                feature = Companion.categorical((String)it.getKey(), (List)it.getValue());
                collection.add(feature);
            }
            List categoricalFactors = (List)destination$iv$iv3;
            List<String> order = reader.featureOrderDirect();
            Map<String, Feature> featuresIndex = this.buildFeaturesIndex(binaryFactors, doubleFactors, categoricalFactors);
            return new FeaturesInfo(knownFeatures, binaryFactors, doubleFactors, categoricalFactors, this.buildMappers(featuresIndex, order), reader.extractVersion());
        }

        /*
         * WARNING - void declaration
         */
        private final BinaryFeature binary(String name2, Map<String, ? extends Object> description) {
            void first;
            Pair<Pair<String, Double>, Pair<String, Double>> pair = this.extractBinaryValuesMappings(description);
            Pair pair2 = (Pair)pair.component1();
            Pair second = (Pair)pair.component2();
            double d = this.extractDefaultValue(name2, description);
            return new BinaryFeature(name2, (Pair<String, Double>)first, (Pair<String, Double>)second, d, this.allowUndefined(description));
        }

        private final FloatFeature float(String name2, Map<String, ? extends Object> description) {
            double d = this.extractDefaultValue(name2, description);
            return new FloatFeature(name2, d, this.allowUndefined(description));
        }

        private final CategoricalFeature categorical(String name2, List<String> categories) {
            return new CategoricalFeature(name2, CollectionsKt.toSet((Iterable)categories));
        }

        private final <T> T fromJson(String $this$fromJson) {
            TypeToken typeToken2 = new TypeToken<T>(){};
            return (T)gson.fromJson($this$fromJson, typeToken2.getType());
        }

        private final Map<String, Feature> buildFeaturesIndex(List<BinaryFeature> binary, List<FloatFeature> list2, List<CategoricalFeature> categorical) {
            buildFeaturesIndex.1 $fun$addFeatures$1 = buildFeaturesIndex.1.INSTANCE;
            boolean bl = false;
            return $fun$addFeatures$1.invoke($fun$addFeatures$1.invoke($fun$addFeatures$1.invoke(new LinkedHashMap(), binary), list2), categorical);
        }

        private final boolean allowUndefined(Map<String, ? extends Object> description) {
            Object value2 = description.get(FeaturesInfo.USE_UNDEFINED);
            if (value2 instanceof Boolean) {
                return (Boolean)value2;
            }
            return true;
        }

        private final double extractDefaultValue(String name2, Map<String, ? extends Object> description) {
            Double d = StringsKt.toDoubleOrNull((String)String.valueOf(description.get(FeaturesInfo.DEFAULT)));
            if (d == null) {
                throw (Throwable)new InconsistentMetadataException("Default value not found. Feature name: " + name2);
            }
            return d;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Pair<String, Double>, Pair<String, Double>> extractBinaryValuesMappings(Map<String, ? extends Object> description) {
            boolean bl = false;
            List result2 = new ArrayList();
            Object object = description;
            boolean bl2 = false;
            Iterator<Map.Entry<String, ? extends Object>> iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                void name2;
                Map.Entry<String, ? extends Object> entry2;
                Map.Entry<String, ? extends Object> entry3 = entry2 = iterator2.next();
                boolean bl3 = false;
                object = entry3.getKey();
                entry3 = entry2;
                bl3 = false;
                Object value2 = entry3.getValue();
                if (Intrinsics.areEqual((Object)name2, (Object)FeaturesInfo.DEFAULT) || Intrinsics.areEqual((Object)name2, (Object)FeaturesInfo.USE_UNDEFINED)) continue;
                Double mappedValue = StringsKt.toDoubleOrNull((String)value2.toString());
                if (mappedValue == null) {
                    throw (Throwable)new InconsistentMetadataException("Mapped value for binary feature should be double");
                }
                Collection collection = result2;
                Pair pair = TuplesKt.to((Object)name2, (Object)mappedValue);
                boolean bl4 = false;
                collection.add(pair);
            }
            bl = result2.size() == 2;
            boolean bl5 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl6 = false;
                String string = "Binary feature must contains 2 values, but found " + result2;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            List $this$sortBy$iv = result2;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                boolean bl7 = false;
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Pair it = (Pair)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        String string = (String)it.getFirst();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                });
            }
            return new Pair(result2.get(0), result2.get(1));
        }

        private final FeatureMapper[] buildMappers(Map<String, ? extends Feature> features, List<String> order) {
            boolean bl = false;
            List mappers = new ArrayList();
            for (String arrayFeatureName : order) {
                String string;
                String name2 = StringsKt.substringBefore$default((String)arrayFeatureName, (char)'=', null, (int)2, null);
                int n = StringsKt.indexOf$default((CharSequence)arrayFeatureName, (char)'=', (int)0, (boolean)false, (int)6, null);
                boolean bl2 = false;
                boolean bl3 = false;
                int it = n;
                boolean bl4 = false;
                if (it == -1) {
                    string = null;
                } else {
                    String string2 = arrayFeatureName;
                    int n2 = it + 1;
                    boolean bl5 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n2);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                }
                String suffix = string;
                Object object = features.get(name2);
                if (object == null || (object = ((Feature)object).createMapper(suffix)) == null) {
                    throw (Throwable)new InconsistentMetadataException("Unexpected feature name in array: " + arrayFeatureName);
                }
                Object mapper2 = object;
                mappers.add(mapper2);
            }
            Collection $this$toTypedArray$iv = mappers;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            FeatureMapper[] featureMapperArray = thisCollection$iv.toArray(new FeatureMapper[0]);
            if (featureMapperArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return featureMapperArray;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

