/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.performance;

import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.internal.performance.LatenciometerKt;
import com.intellij.internal.performance.LatencyDistributionRecord;
import com.intellij.internal.performance.LatencyRecord;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010 \u001a\u00020\u0006H\u0002J\b\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/internal/performance/TypingLatencyReportDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "threadDumps", "", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "currentThreadDump", "", "nextThreadDumpButton", "Ljavax/swing/JButton;", "prevThreadDumpButton", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "createReportTree", "Lcom/intellij/ui/components/JBScrollPane;", "createThreadDumpBrowser", "formatHeader", "htmlStyle", "", "formatLatency", "action", "latencyRecord", "Lcom/intellij/internal/performance/LatencyRecord;", "details", "formatReportAsText", "updateCurrentThreadDump", "", "ExportToFileAction", "intellij.platform.lang.impl"})
public final class TypingLatencyReportDialog
extends DialogWrapper {
    private int currentThreadDump;
    private ConsoleView consoleView;
    private JButton prevThreadDumpButton;
    private JButton nextThreadDumpButton;
    private final Project project;
    private final List<String> threadDumps;

    @NotNull
    protected JComponent createCenterPanel() {
        JComponent panel2;
        JComponent jComponent;
        boolean bl;
        JBScrollPane jbScrollPane = this.createReportTree();
        JBSplitter jBSplitter = LatenciometerKt.getLatencyRecorderProperties();
        boolean bl2 = false;
        if (!jBSplitter.isEmpty()) {
            JLabel header2 = new JLabel(this.formatHeader(true));
            JBSplitter jBSplitter2 = new JBSplitter(true);
            bl = false;
            boolean bl3 = false;
            JBSplitter $this$apply = jBSplitter2;
            boolean bl4 = false;
            $this$apply.setResizeEnabled(false);
            this.setResizable(false);
            $this$apply.setProportion(0.01f);
            $this$apply.setFirstComponent((JComponent)header2);
            $this$apply.setSecondComponent((JComponent)jbScrollPane);
            jComponent = (JComponent)jBSplitter2;
        } else {
            jComponent = panel2 = (JComponent)jbScrollPane;
        }
        if (this.threadDumps.isEmpty()) {
            return panel2;
        }
        jBSplitter = new JBSplitter(true);
        boolean bl5 = false;
        bl = false;
        JBSplitter $this$apply = jBSplitter;
        boolean bl6 = false;
        $this$apply.setFirstComponent(panel2);
        $this$apply.setSecondComponent(this.createThreadDumpBrowser());
        return (JComponent)jBSplitter;
    }

    private final JBScrollPane createReportTree() {
        DefaultMutableTreeNode root2 = new DefaultMutableTreeNode();
        Iterable $this$sortedBy$iv = LatenciometerKt.getLatencyMap().values();
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        for (LatencyDistributionRecord row2 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                LatencyDistributionRecord it = (LatencyDistributionRecord)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getKey().getName());
                it = (LatencyDistributionRecord)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getKey().getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        })) {
            DefaultMutableTreeNode rowNode = new DefaultMutableTreeNode(row2);
            root2.add(rowNode);
            Iterable $this$sortedByDescending$iv = row2.getActionLatencyRecords().entrySet();
            boolean $i$f$sortedByDescending = false;
            boolean bl2 = false;
            Iterator iterator2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)b;
                    boolean bl2 = false;
                    Comparable comparable = Long.valueOf(((LatencyRecord)it.getValue()).getAverageLatency());
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Long l = ((LatencyRecord)it.getValue()).getAverageLatency();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            }).iterator();
            while (iterator2.hasNext()) {
                Map.Entry actionLatencyRecord;
                Map.Entry entry2 = actionLatencyRecord = (Map.Entry)iterator2.next();
                boolean bl3 = false;
                rowNode.add(new DefaultMutableTreeNode(new Pair(entry2.getKey(), entry2.getValue())));
            }
        }
        Tree reportList = new Tree((TreeModel)new DefaultTreeModel(root2));
        reportList.setRootVisible(false);
        reportList.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(this){
            final /* synthetic */ TypingLatencyReportDialog this$0;

            public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value2, boolean selected2, boolean expanded2, boolean leaf, int row2, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                if (value2 == null) {
                    return;
                }
                Object obj2 = ((DefaultMutableTreeNode)value2).getUserObject();
                if (obj2 instanceof LatencyDistributionRecord) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.append(TypingLatencyReportDialog.access$formatLatency(this.this$0, ((LatencyDistributionRecord)obj2).getKey().getName(), ((LatencyDistributionRecord)obj2).getTotalLatency(), ((LatencyDistributionRecord)obj2).getKey().getDetails())), (String)"append(formatLatency(obj\u2026atency, obj.key.details))");
                } else if (obj2 instanceof Pair) {
                    Object object = ((Pair)obj2).getFirst();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    Object object2 = ((Pair)obj2).getSecond();
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.internal.performance.LatencyRecord");
                    }
                    this.append(TypingLatencyReportDialog.formatLatency$default(this.this$0, (String)object, (LatencyRecord)object2, null, 4, null));
                }
            }
            {
                this.this$0 = this$0;
            }
        });
        TreeUtil.expandAll((JTree)((JTree)reportList));
        return new JBScrollPane((Component)reportList);
    }

    private final String formatLatency(String action2, LatencyRecord latencyRecord, String details2) {
        String result2 = action2 + " - avg " + latencyRecord.getAverageLatency() + " ms, max " + latencyRecord.getMaxLatency() + " ms, 90% percentile " + latencyRecord.percentile(90) + " ms";
        if (details2 != null) {
            return result2 + ", " + details2;
        }
        return result2;
    }

    static /* synthetic */ String formatLatency$default(TypingLatencyReportDialog typingLatencyReportDialog, String string, LatencyRecord latencyRecord, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return typingLatencyReportDialog.formatLatency(string, latencyRecord, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final String formatHeader(boolean htmlStyle) {
        String string;
        if (htmlStyle) {
            void $this$mapTo$iv$iv22;
            Map<String, String> $this$map$iv = LatenciometerKt.getLatencyRecorderProperties();
            boolean $i$f$map22 = false;
            Map<String, String> map2 = $this$map$iv;
            Object destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo22 = false;
            CharSequence charSequence = $this$mapTo$iv$iv22;
            boolean bl = false;
            Iterator iterator2 = charSequence.entrySet().iterator();
            while (iterator2.hasNext()) {
                void key;
                void $dstr$key$value;
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var13_30 = $dstr$key$value;
                boolean bl3 = false;
                String string2 = (String)var13_30.getKey();
                var13_30 = $dstr$key$value;
                bl3 = false;
                String value2 = (String)var13_30.getValue();
                String string3 = "- " + (String)key + ": " + value2;
                collection.add(string3);
            }
            Iterable iterable = (List)destination$iv$iv;
            $this$map$iv = null;
            CharSequence $i$f$map22 = null;
            int $this$mapTo$iv$iv22 = 0;
            destination$iv$iv = "</html>";
            CharSequence $i$f$mapTo22 = "<br/>";
            charSequence = "<html>Latency Recorder Properties<br/>";
            string = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)$i$f$mapTo22, (CharSequence)charSequence, (CharSequence)destination$iv$iv, (int)$this$mapTo$iv$iv22, $i$f$map22, $this$map$iv, (int)56, null);
        } else {
            Map<String, String> $this$map$iv = LatenciometerKt.getLatencyRecorderProperties();
            boolean $i$f$map = false;
            Map<String, String> $this$mapTo$iv$iv22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Object object = $this$mapTo$iv$iv22;
            boolean bl = false;
            Iterator<Map.Entry<String, String>> iterator3 = object.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry<String, String> item$iv$iv;
                Map.Entry<String, String> $dstr$key$value = item$iv$iv = iterator3.next();
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Map.Entry<String, String> entry3 = $dstr$key$value;
                boolean bl5 = false;
                String key = entry3.getKey();
                entry3 = $dstr$key$value;
                bl5 = false;
                String value3 = entry3.getValue();
                String string4 = "  - " + key + ": " + value3;
                collection.add(string4);
            }
            Function1 function1 = null;
            CharSequence charSequence = null;
            int n = 0;
            CharSequence charSequence2 = null;
            CharSequence charSequence3 = "\n";
            object = "Latency Recorder Properties\n";
            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)charSequence3, (CharSequence)object, charSequence2, (int)n, charSequence, function1, (int)60, null);
        }
        return string;
    }

    private final JComponent createThreadDumpBrowser() {
        JButton $this$apply;
        TextConsoleBuilder textConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)textConsoleBuilder, (String)"TextConsoleBuilderFactor\u2026().createBuilder(project)");
        TextConsoleBuilder builder2 = textConsoleBuilder;
        builder2.filters(AnalyzeStacktraceUtil.EP_NAME.getExtensions((AreaInstance)this.project));
        ConsoleView consoleView = builder2.getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"builder.console");
        this.consoleView = consoleView;
        Disposable disposable2 = this.getDisposable();
        ConsoleView consoleView2 = this.consoleView;
        if (consoleView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
        }
        Disposer.register((Disposable)disposable2, (Disposable)((Disposable)consoleView2));
        JBBox buttonsPanel = JBBox.createHorizontalBox();
        JButton jButton = new JButton("<<");
        boolean bl = false;
        boolean bl2 = false;
        JButton jButton2 = jButton;
        TypingLatencyReportDialog typingLatencyReportDialog = this;
        boolean bl3 = false;
        $this$apply.addActionListener(new ActionListener(this){
            final /* synthetic */ TypingLatencyReportDialog this$0;
            {
                this.this$0 = typingLatencyReportDialog;
            }

            public final void actionPerformed(ActionEvent it) {
                TypingLatencyReportDialog typingLatencyReportDialog = this.this$0;
                int n = TypingLatencyReportDialog.access$getCurrentThreadDump$p(typingLatencyReportDialog);
                TypingLatencyReportDialog.access$setCurrentThreadDump$p(typingLatencyReportDialog, n + -1);
                TypingLatencyReportDialog.access$updateCurrentThreadDump(this.this$0);
            }
        });
        Unit unit = Unit.INSTANCE;
        typingLatencyReportDialog.prevThreadDumpButton = jButton;
        jButton = new JButton(">>");
        bl = false;
        bl2 = false;
        $this$apply = jButton;
        typingLatencyReportDialog = this;
        boolean bl4 = false;
        $this$apply.addActionListener(new ActionListener(this){
            final /* synthetic */ TypingLatencyReportDialog this$0;
            {
                this.this$0 = typingLatencyReportDialog;
            }

            public final void actionPerformed(ActionEvent it) {
                TypingLatencyReportDialog typingLatencyReportDialog = this.this$0;
                int n = TypingLatencyReportDialog.access$getCurrentThreadDump$p(typingLatencyReportDialog);
                TypingLatencyReportDialog.access$setCurrentThreadDump$p(typingLatencyReportDialog, n + 1);
                TypingLatencyReportDialog.access$updateCurrentThreadDump(this.this$0);
            }
        });
        unit = Unit.INSTANCE;
        typingLatencyReportDialog.nextThreadDumpButton = jButton;
        JButton jButton3 = this.prevThreadDumpButton;
        if (jButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prevThreadDumpButton");
        }
        buttonsPanel.add((Component)jButton3);
        buttonsPanel.add(Box.createHorizontalGlue());
        JButton jButton4 = this.nextThreadDumpButton;
        if (jButton4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nextThreadDumpButton");
        }
        buttonsPanel.add((Component)jButton4);
        this.updateCurrentThreadDump();
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel();
        ConsoleView consoleView3 = this.consoleView;
        if (consoleView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
        }
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel.addToCenter((Component)consoleView3.getComponent()).addToBottom((Component)buttonsPanel);
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel2, (String)"JBUI.Panels.simplePanel(\u2026addToBottom(buttonsPanel)");
        return (JComponent)borderLayoutPanel2;
    }

    private final void updateCurrentThreadDump() {
        ConsoleView consoleView = this.consoleView;
        if (consoleView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
        }
        consoleView.clear();
        ConsoleView consoleView2 = this.consoleView;
        if (consoleView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
        }
        consoleView2.print(this.threadDumps.get(this.currentThreadDump), ConsoleViewContentType.NORMAL_OUTPUT);
        ConsoleView consoleView3 = this.consoleView;
        if (consoleView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
        }
        consoleView3.scrollTo(0);
        JButton jButton = this.prevThreadDumpButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prevThreadDumpButton");
        }
        jButton.setEnabled(this.currentThreadDump > 0);
        JButton jButton2 = this.nextThreadDumpButton;
        if (jButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nextThreadDumpButton");
        }
        jButton2.setEnabled(this.currentThreadDump < this.threadDumps.size() - 1);
    }

    private final String formatReportAsText() {
        Object row22;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        StringBuilder stringBuilder2 = $this$buildString;
        String string = this.formatHeader(false);
        boolean bl6 = false;
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        StringsKt.appendln((StringBuilder)$this$buildString);
        Object $this$sortedBy$iv = LatenciometerKt.getLatencyMap().values();
        boolean $i$f$sortedBy = false;
        boolean bl7 = false;
        for (Object row22 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                LatencyDistributionRecord it = (LatencyDistributionRecord)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getKey().getName());
                it = (LatencyDistributionRecord)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getKey().getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        })) {
            $this$sortedBy$iv = $this$buildString;
            Object object = this.formatLatency(((LatencyDistributionRecord)row22).getKey().getName(), ((LatencyDistributionRecord)row22).getTotalLatency(), ((LatencyDistributionRecord)row22).getKey().getDetails());
            bl7 = false;
            StringBuilder stringBuilder4 = ((StringBuilder)$this$sortedBy$iv).append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
            $this$sortedBy$iv = $this$buildString;
            object = "Actions:";
            bl7 = false;
            StringBuilder stringBuilder5 = ((StringBuilder)$this$sortedBy$iv).append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
            Iterable $this$sortedByDescending$iv = ((LatencyDistributionRecord)row22).getActionLatencyRecords().entrySet();
            boolean $i$f$sortedByDescending = false;
            boolean bl8 = false;
            for (Map.Entry actionLatencyRecord : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)b;
                    boolean bl2 = false;
                    Comparable comparable = Long.valueOf(((LatencyRecord)it.getValue()).getAverageLatency());
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Long l = ((LatencyRecord)it.getValue()).getAverageLatency();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            })) {
                StringBuilder stringBuilder6 = $this$buildString;
                String string2 = "  " + TypingLatencyReportDialog.formatLatency$default(this, (String)actionLatencyRecord.getKey(), (LatencyRecord)actionLatencyRecord.getValue(), null, 4, null);
                bl8 = false;
                StringBuilder stringBuilder7 = stringBuilder6.append(string2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder7);
            }
        }
        StringsKt.appendln((StringBuilder)$this$buildString);
        row22 = this.threadDumps;
        boolean bl9 = false;
        if (!row22.isEmpty()) {
            row22 = $this$buildString;
            String string3 = "Thread dumps:";
            boolean bl10 = false;
            StringBuilder stringBuilder8 = ((StringBuilder)row22).append(string3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder8);
            for (String threadDump : this.threadDumps) {
                StringBuilder stringBuilder9 = $this$buildString;
                boolean bl11 = false;
                StringBuilder stringBuilder10 = stringBuilder9.append(threadDump);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder10);
                stringBuilder9 = $this$buildString;
                String string4 = StringsKt.repeat((CharSequence)"-", (int)40);
                bl7 = false;
                StringBuilder stringBuilder11 = stringBuilder9.append(string4);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder11);
            }
        }
        String string5 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
        return string5;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[2];
        actionArray[0] = new ExportToFileAction();
        Action action2 = this.getOKAction();
        Intrinsics.checkNotNullExpressionValue((Object)action2, (String)"okAction");
        actionArray[1] = action2;
        return actionArray;
    }

    public TypingLatencyReportDialog(@NotNull Project project, @NotNull List<String> threadDumps) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(threadDumps, (String)"threadDumps");
        super(project);
        this.project = project;
        this.threadDumps = threadDumps;
        this.init();
        this.setTitle("Typing Latency Report");
    }

    public /* synthetic */ TypingLatencyReportDialog(Project project, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(project, list2);
    }

    public static final /* synthetic */ String access$formatLatency(TypingLatencyReportDialog $this, String action2, LatencyRecord latencyRecord, String details2) {
        return $this.formatLatency(action2, latencyRecord, details2);
    }

    public static final /* synthetic */ int access$getCurrentThreadDump$p(TypingLatencyReportDialog $this) {
        return $this.currentThreadDump;
    }

    public static final /* synthetic */ void access$setCurrentThreadDump$p(TypingLatencyReportDialog $this, int n) {
        $this.currentThreadDump = n;
    }

    public static final /* synthetic */ void access$updateCurrentThreadDump(TypingLatencyReportDialog $this) {
        $this.updateCurrentThreadDump();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/internal/performance/TypingLatencyReportDialog$ExportToFileAction;", "Ljavax/swing/AbstractAction;", "(Lcom/intellij/internal/performance/TypingLatencyReportDialog;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.platform.lang.impl"})
    private final class ExportToFileAction
    extends AbstractAction {
        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            FileSaverDescriptor descriptor2 = new FileSaverDescriptor("Export Typing Latency Report", "File name:", new String[]{"txt"});
            FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, (Component)TypingLatencyReportDialog.this.getContentPane());
            Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"FileChooserFactory.getIn\u2026(descriptor, contentPane)");
            FileSaverDialog dialog2 = fileSaverDialog;
            VirtualFileWrapper virtualFileWrapper = dialog2.save((Path)null, "typing-latency.txt");
            if (virtualFileWrapper == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileWrapper, (String)"dialog.save(null as Path\u2026g-latency.txt\") ?: return");
            VirtualFileWrapper virtualFileWrapper2 = virtualFileWrapper;
            FileUtil.writeToFile((File)virtualFileWrapper2.getFile(), (String)TypingLatencyReportDialog.this.formatReportAsText());
        }

        public ExportToFileAction() {
            super("Export to File");
        }
    }
}

