/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.os;

import com.intellij.internal.DebugAttachDetector;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.collectors.fus.os.SystemRuntimeCollector;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.system.CpuArch;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u001dH\u0002J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001dH\u0002J\b\u0010\u001f\u001a\u00020\tH\u0002J\b\u0010 \u001a\u00020\u0005H\u0002J\b\u0010!\u001a\u00020\u0010H\u0016J\u0016\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010#H\u0002J\b\u0010$\u001a\u00020\u0005H\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016J\u0014\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0#H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00150\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/os/SystemRuntimeCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "()V", "ARCHITECTURES", "", "", "COLLECTORS", "CORES", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "DEBUG_AGENT", "", "DISK_SIZE", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "GC", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "JVM", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "Lcom/intellij/openapi/util/Version;", "JVM_OPTION", "", "MEMORY_SIZE", "SWAP_SIZE", "SYSTEM_PROPERTIES", "SYSTEM_PROPERTY", "VENDORS", "VM_OPTIONS", "collectJvmOptions", "", "collectSystemProperties", "getCpuCoreCount", "getGcName", "getGroup", "getIndexVolumeSizeAndFreeSpace", "Lkotlin/Pair;", "getJavaVendor", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "getPhysicalMemoryAndSwapSize", "intellij.platform.ide.impl"})
public final class SystemRuntimeCollector
extends ApplicationUsagesCollector {
    private final List<String> COLLECTORS = CollectionsKt.listOf((Object[])new String[]{"Serial", "Parallel", "CMS", "G1", "Z", "Shenandoah", "Epsilon", "Other"});
    private final List<String> ARCHITECTURES = CollectionsKt.listOf((Object[])new String[]{"x86", "x86_64", "arm64", "other", "unknown"});
    private final List<String> VENDORS = CollectionsKt.listOf((Object[])new String[]{"JetBrains", "Apple", "Oracle", "Sun", "IBM", "Azul", "Other"});
    private final List<String> VM_OPTIONS = CollectionsKt.listOf((Object[])new String[]{"Xmx", "Xms", "SoftRefLRUPolicyMSPerMB", "ReservedCodeCacheSize"});
    private final List<String> SYSTEM_PROPERTIES = CollectionsKt.listOf((Object[])new String[]{"splash", "nosplash"});
    private final EventLogGroup GROUP = new EventLogGroup("system.runtime", 15);
    private final EventId1<Integer> CORES = this.GROUP.registerEvent("cores", (EventField)EventFields.Int((String)"value"));
    private final EventId1<Integer> MEMORY_SIZE = this.GROUP.registerEvent("memory.size", (EventField)EventFields.Int((String)"gigabytes"));
    private final EventId1<Integer> SWAP_SIZE = this.GROUP.registerEvent("swap.size", (EventField)EventFields.Int((String)"gigabytes"));
    private final EventId2<Integer, Integer> DISK_SIZE = this.GROUP.registerEvent("disk.size", (EventField)EventFields.Int((String)"index_partition_size"), (EventField)EventFields.Int((String)"index_partition_free"));
    private final EventId1<String> GC = this.GROUP.registerEvent("garbage.collector", (EventField)EventFields.String((String)"name", this.COLLECTORS));
    private final EventId3<Version, String, String> JVM = this.GROUP.registerEvent("jvm", (EventField)EventFields.VersionByObject, (EventField)EventFields.String((String)"arch", this.ARCHITECTURES), (EventField)EventFields.String((String)"vendor", this.VENDORS));
    private final EventId2<String, Long> JVM_OPTION = this.GROUP.registerEvent("jvm.option", (EventField)EventFields.String((String)"name", this.VM_OPTIONS), (EventField)EventFields.Long((String)"value"));
    private final EventId2<String, Boolean> SYSTEM_PROPERTY = this.GROUP.registerEvent("jvm.client.properties", (EventField)EventFields.String((String)"name", this.SYSTEM_PROPERTIES), (EventField)EventFields.Boolean((String)"value"));
    private final EventId1<Boolean> DEBUG_AGENT = this.GROUP.registerEvent("debug.agent", (EventField)EventFields.Enabled);

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<MetricEvent> getMetrics() {
        boolean bl;
        void physicalMemory;
        boolean bl2 = false;
        Set result2 = new LinkedHashSet();
        Collection collection = result2;
        MetricEvent metricEvent = this.CORES.metric((Object)this.getCpuCoreCount());
        boolean bl3 = false;
        collection.add(metricEvent);
        Object object = this.getPhysicalMemoryAndSwapSize();
        int n = ((Number)object.component1()).intValue();
        int swapSize = ((Number)object.component2()).intValue();
        object = result2;
        MetricEvent metricEvent2 = this.MEMORY_SIZE.metric((Object)((int)physicalMemory));
        boolean bl4 = false;
        object.add(metricEvent2);
        object = result2;
        MetricEvent n2 = this.SWAP_SIZE.metric((Object)swapSize);
        bl4 = false;
        object.add(n2);
        Pair<Integer, Integer> indexVolumeData = this.getIndexVolumeSizeAndFreeSpace();
        if (indexVolumeData != null) {
            Object object2 = indexVolumeData;
            int collection2 = ((Number)object2.component1()).intValue();
            int freeSpace = ((Number)object2.component2()).intValue();
            object2 = result2;
            MetricEvent metricEvent3 = this.DISK_SIZE.metric((Object)collection2, (Object)freeSpace);
            bl = false;
            object2.add(metricEvent3);
        }
        Collection collection2 = result2;
        Object object3 = this.GC.metric((Object)this.getGcName());
        boolean bl5 = false;
        collection2.add(object3);
        Collection collection3 = result2;
        Version version2 = new Version(1, JavaVersion.current().feature, 0);
        object3 = CpuArch.CURRENT.name();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        boolean bl6 = false;
        Object object4 = object3;
        if (object4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object4).toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase(locale)");
        object3 = this.JVM.metric((Object)version2, (Object)string, (Object)this.getJavaVendor());
        boolean bl7 = false;
        collection3.add(object3);
        Object object5 = this.collectJvmOptions();
        bl6 = false;
        for (Map.Entry entry2 : object5.entrySet()) {
            object5 = result2;
            MetricEvent metricEvent4 = this.JVM_OPTION.metric(entry2.getKey(), entry2.getValue());
            bl = false;
            object5.add(metricEvent4);
        }
        object5 = this.collectSystemProperties();
        boolean bl8 = false;
        for (Map.Entry entry3 : object5.entrySet()) {
            object5 = result2;
            String string2 = (String)entry3.getValue();
            bl = false;
            string2 = this.SYSTEM_PROPERTY.metric(entry3.getKey(), (Object)Boolean.parseBoolean(string2));
            bl = false;
            object5.add(string2);
        }
        Collection collection4 = result2;
        object3 = this.DEBUG_AGENT.metric((Object)DebugAttachDetector.isDebugEnabled());
        boolean bl9 = false;
        collection4.add(object3);
        return result2;
    }

    private final int getCpuCoreCount() {
        return StatisticsUtil.roundToUpperBound((int)Runtime.getRuntime().availableProcessors(), (int[])new int[]{1, 2, 4, 6, 8, 12, 16, 20, 24, 32, 64});
    }

    private final Pair<Integer, Integer> getPhysicalMemoryAndSwapSize() {
        getPhysicalMemoryAndSwapSize.1 $fun$GiB$1 = getPhysicalMemoryAndSwapSize.1.INSTANCE;
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemMXBean == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.sun.management.OperatingSystemMXBean");
        }
        com.sun.management.OperatingSystemMXBean bean = (com.sun.management.OperatingSystemMXBean)operatingSystemMXBean;
        int physicalMemory = StatisticsUtil.roundToUpperBound((int)$fun$GiB$1.invoke(bean.getTotalPhysicalMemorySize()), (int[])new int[]{1, 2, 4, 8, 12, 16, 24, 32, 48, 64, 128, 256});
        int n = $fun$GiB$1.invoke(bean.getTotalSwapSpaceSize());
        boolean bl = false;
        int swapSize = StatisticsUtil.roundToPowerOfTwo((int)Math.min(n, physicalMemory));
        return TuplesKt.to((Object)physicalMemory, (Object)swapSize);
    }

    private final Pair<Integer, Integer> getIndexVolumeSizeAndFreeSpace() {
        try {
            FileStore fileStore;
            FileStore fileStore2 = fileStore = Files.getFileStore(PathManager.getIndexRoot());
            Intrinsics.checkNotNullExpressionValue((Object)fileStore2, (String)"fileStore");
            long totalSpace = fileStore2.getTotalSpace();
            if (totalSpace > 0L) {
                int n = 16384;
                int n2 = StatisticsUtil.roundToPowerOfTwo((int)((int)(totalSpace >> 30)));
                boolean bl = false;
                int size = Math.min(n, n2);
                int freeSpace = (int)((double)fileStore.getUsableSpace() * 100.0 / (double)totalSpace);
                return TuplesKt.to((Object)size, (Object)freeSpace);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private final String getGcName() {
        Iterator<GarbageCollectorMXBean> iterator2 = ManagementFactory.getGarbageCollectorMXBeans().iterator();
        while (iterator2.hasNext()) {
            GarbageCollectorMXBean gc;
            GarbageCollectorMXBean garbageCollectorMXBean = gc = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)garbageCollectorMXBean, (String)"gc");
            if (Intrinsics.areEqual((Object)garbageCollectorMXBean.getName(), (Object)"MarkSweepCompact") || Intrinsics.areEqual((Object)gc.getName(), (Object)"Copy")) {
                return "Serial";
            }
            if (Intrinsics.areEqual((Object)gc.getName(), (Object)"PS MarkSweep") || Intrinsics.areEqual((Object)gc.getName(), (Object)"PS Scavenge")) {
                return "Parallel";
            }
            if (Intrinsics.areEqual((Object)gc.getName(), (Object)"ConcurrentMarkSweep") || Intrinsics.areEqual((Object)gc.getName(), (Object)"ParNew")) {
                return "CMS";
            }
            String string = gc.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gc.name");
            if (StringsKt.startsWith$default((String)string, (String)"G1 ", (boolean)false, (int)2, null)) {
                return "G1";
            }
            if (Intrinsics.areEqual((Object)gc.getName(), (Object)"ZGC")) {
                return "Z";
            }
            String string2 = gc.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gc.name");
            if (StringsKt.startsWith$default((String)string2, (String)"Shenandoah ", (boolean)false, (int)2, null)) {
                return "Shenandoah";
            }
            String string3 = gc.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"gc.name");
            if (!StringsKt.startsWith$default((String)string3, (String)"Epsilon ", (boolean)false, (int)2, null)) continue;
            return "Epsilon";
        }
        return "Other";
    }

    private final String getJavaVendor() {
        return SystemInfo.isJetBrainsJvm ? "JetBrains" : (SystemInfo.isOracleJvm ? "Oracle" : (SystemInfo.isIbmJvm ? "IBM" : (SystemInfo.isAzulJvm ? "Azul" : "Other")));
    }

    private final Map<String, Long> collectJvmOptions() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)runtimeMXBean, (String)"ManagementFactory.getRuntimeMXBean()");
        List<String> list2 = runtimeMXBean.getInputArguments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"ManagementFactory.getRun\u2026meMXBean().inputArguments");
        return MapsKt.toMap((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)collectJvmOptions.1.INSTANCE)));
    }

    private final Map<String, String> collectSystemProperties() {
        return MapsKt.toMap((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.SYSTEM_PROPERTIES), (Function1)collectSystemProperties.1.INSTANCE), (Function1)collectSystemProperties.2.INSTANCE));
    }
}

