/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.FloatEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.jdkEx.JdkEx;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

final class UiInfoUsageCollector
extends ApplicationUsagesCollector {
    private static final Logger LOG = Logger.getInstance(UiInfoUsageCollector.class);
    private static final EventLogGroup GROUP = new EventLogGroup("ui.info.features", 11);
    private static final EnumEventField<VisibilityType> orientationField = EventFields.Enum((String)"value", VisibilityType.class);
    private static final EventId1<NavBarType> NAV_BAR = GROUP.registerEvent("Nav.Bar", (EventField)EventFields.Enum((String)"value", NavBarType.class));
    private static final EventId1<VisibilityType> NAV_BAR_MEMBERS = GROUP.registerEvent("Nav.Bar.members", orientationField);
    private static final EventId1<VisibilityType> TOOLBAR = GROUP.registerEvent("Toolbar", orientationField);
    private static final EventId2<VisibilityType, VisibilityType> TOOLBAR_AND_NAV_BAR = GROUP.registerEvent("Toolbar.and.NavBar", (EventField)EventFields.Enum((String)"toolbar", VisibilityType.class), (EventField)EventFields.Enum((String)"navbar", VisibilityType.class));
    private static final EventId1<Boolean> RETINA = GROUP.registerEvent("Retina", (EventField)EventFields.Enabled);
    private static final EventId1<Boolean> SHOW_TOOLWINDOW = GROUP.registerEvent("QuickDoc.Show.Toolwindow", (EventField)EventFields.Enabled);
    private static final EventId1<Boolean> QUICK_DOC_AUTO_UPDATE = GROUP.registerEvent("QuickDoc.AutoUpdate", (EventField)EventFields.Enabled);
    private static final EventId1<String> LOOK_AND_FEEL = GROUP.registerEvent("Look.and.Feel", (EventField)EventFields.StringValidatedByEnum((String)"value", (String)"look_and_feel"));
    private static final EventId1<HidpiMode> HIDPI_MODE = GROUP.registerEvent("Hidpi.Mode", (EventField)EventFields.Enum((String)"value", HidpiMode.class));
    private static final EventId1<Boolean> SCREEN_READER = GROUP.registerEvent("Screen.Reader", (EventField)EventFields.Enabled);
    private static final EventId1<Integer> QUICK_LISTS_COUNT = GROUP.registerEvent("QuickListsCount", (EventField)EventFields.Int((String)"value"));
    private static final BooleanEventField SCALE_MODE_FIELD = EventFields.Boolean((String)"scale_mode");
    private static final FloatEventField SCALE_FIELD = EventFields.Float((String)"scale");
    private static final VarargEventId SCREEN_SCALE = GROUP.registerVarargEvent("Screen.Scale", new EventField[]{SCALE_MODE_FIELD, SCALE_FIELD});
    private static final EventId1<Integer> NUMBER_OF_MONITORS = GROUP.registerEvent("Number.Of.Monitors", (EventField)EventFields.Int((String)"value"));
    private static final StringEventField SCREEN_RESOLUTION_FIELD = new StringEventField("value"){
        private final List<String> rules = List.of("{regexp#integer}x{regexp#integer}_({regexp#integer}%)", "{regexp#integer}x{regexp#integer}");

        @NotNull
        public List<String> getValidationRule() {
            List<String> list2 = this.rules;
            if (list2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/collectors/fus/ui/UiInfoUsageCollector$1", "getValidationRule"));
        }
    };
    private static final EventId2<Integer, String> SCREEN_RESOLUTION = GROUP.registerEvent("Screen.Resolution", (EventField)EventFields.Int((String)"display_id"), (EventField)SCREEN_RESOLUTION_FIELD);

    UiInfoUsageCollector() {
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        return UiInfoUsageCollector.getDescriptors();
    }

    @NotNull
    public static Set<MetricEvent> getDescriptors() {
        HashSet<MetricEvent> set2 = new HashSet<MetricEvent>();
        set2.add(NAV_BAR.metric((Object)(UiInfoUsageCollector.navbar() ? NavBarType.visible : NavBarType.floating)));
        set2.add(NAV_BAR_MEMBERS.metric((Object)(UISettings.getInstance().getShowMembersInNavigationBar() ? VisibilityType.visible : VisibilityType.hidden)));
        set2.add(TOOLBAR.metric((Object)(UiInfoUsageCollector.toolbar() ? VisibilityType.visible : VisibilityType.hidden)));
        set2.add(TOOLBAR_AND_NAV_BAR.metric((Object)(UiInfoUsageCollector.toolbar() ? VisibilityType.visible : VisibilityType.hidden), (Object)(UiInfoUsageCollector.navbar() ? VisibilityType.visible : VisibilityType.hidden)));
        set2.add(RETINA.metric((Object)UIUtil.isRetina()));
        PropertiesComponent properties2 = PropertiesComponent.getInstance();
        set2.add(SHOW_TOOLWINDOW.metric((Object)properties2.isTrueValue("ShowDocumentationInToolWindow")));
        set2.add(QUICK_DOC_AUTO_UPDATE.metric((Object)properties2.getBoolean("DocumentationAutoUpdateEnabled", true)));
        UIManager.LookAndFeelInfo laf = LafManager.getInstance().getCurrentLookAndFeel();
        String value1 = StringUtil.notNullize((String)(laf != null ? laf.getName() : null), (String)"unknown");
        set2.add(LOOK_AND_FEEL.metric((Object)value1));
        HidpiMode value2 = JreHiDpiUtil.isJreHiDPIEnabled() ? HidpiMode.per_monitor_dpi : HidpiMode.system_dpi;
        set2.add(HIDPI_MODE.metric((Object)value2));
        set2.add(SCREEN_READER.metric((Object)ScreenReader.isActive()));
        set2.add(QUICK_LISTS_COUNT.metric((Object)QuickListsManager.getInstance().getAllQuickLists().length));
        UiInfoUsageCollector.addScreenScale(set2);
        UiInfoUsageCollector.addNumberOfMonitors(set2);
        UiInfoUsageCollector.addScreenResolutions(set2);
        HashSet<MetricEvent> hashSet = set2;
        if (hashSet == null) {
            UiInfoUsageCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static String getDeviceScreenInfo(GraphicsDevice device) {
        GraphicsConfiguration conf = device.getDefaultConfiguration();
        Rectangle rect = conf.getBounds();
        String info2 = rect.width + "x" + rect.height;
        float scale = JBUIScale.sysScale((GraphicsConfiguration)conf);
        if (scale != 1.0f) {
            info2 = info2 + " (" + (int)(scale * 100.0f) + "%)";
        }
        return info2;
    }

    private static void addScreenResolutions(Set<MetricEvent> set2) {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        for (int i2 = 0; i2 < devices.length; ++i2) {
            String info2 = UiInfoUsageCollector.getDeviceScreenInfo(devices[i2]);
            set2.add(SCREEN_RESOLUTION.metric((Object)i2, (Object)info2));
        }
    }

    private static void addNumberOfMonitors(Set<MetricEvent> set2) {
        int numberOfMonitors = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length;
        set2.add(NUMBER_OF_MONITORS.metric((Object)numberOfMonitors));
    }

    private static boolean toolbar() {
        return UISettings.getInstance().getShowMainToolbar();
    }

    private static boolean navbar() {
        return UISettings.getInstance().getShowNavigationBar();
    }

    private static void addScreenScale(Set<? super MetricEvent> set2) {
        int scaleBase;
        float scale = JBUIScale.sysScale();
        float scaleFract = scale - (float)(scaleBase = (int)Math.floor(scale));
        scaleFract = scaleFract == 0.0f ? 0.0f : (scaleFract < 0.375f ? 0.25f : (scaleFract < 0.625f ? 0.5f : 0.75f));
        scale = (float)scaleBase + scaleFract;
        Ref isScaleMode = new Ref();
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    DisplayMode dm = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
                    isScaleMode.set((Object)(dm != null && JdkEx.getDisplayModeEx().isDefault(dm) ? 1 : 0));
                });
            }
            catch (InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        ArrayList<EventPair> data2 = new ArrayList<EventPair>();
        data2.add(SCALE_FIELD.with((Object)Float.valueOf(scale)));
        if (!isScaleMode.isNull()) {
            data2.add(SCALE_MODE_FIELD.with((Object)((Boolean)isScaleMode.get())));
        }
        set2.add((MetricEvent)SCREEN_SCALE.metric(data2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/collectors/fus/ui/UiInfoUsageCollector", "getDescriptors"));
    }

    static enum HidpiMode {
        per_monitor_dpi,
        system_dpi;

    }

    static enum VisibilityType {
        visible,
        hidden;

    }

    static enum NavBarType {
        visible,
        floating;

    }
}

