/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.javaee.NameLocationPair;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.xml.XmlBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;

public class EditLocationDialog
extends DialogWrapper {
    private JTextField myTfUrl;
    private JTextField myTfPath;
    private FixedSizeButton myBtnBrowseLocalPath;
    private final Project myProject;
    private final boolean myShowPath;
    @NlsContexts.DialogTitle
    private final String myTitle;
    @Nls
    private final String myName;
    @Nls
    private final String myLocation;
    private boolean myTfShared = true;

    public EditLocationDialog(Project project, boolean showPath) {
        super(project, true);
        this.myProject = project;
        this.myShowPath = showPath;
        this.myTitle = XmlBundle.message((String)"xml.external.resource.dialog.title", (Object[])new Object[0]);
        this.myName = XmlBundle.message((String)"xml.external.resource.label.uri", (Object[])new Object[0]);
        this.myLocation = XmlBundle.message((String)"xml.external.resource.label.path", (Object[])new Object[0]);
        this.init();
    }

    public EditLocationDialog(Project project, boolean showPath, @NlsContexts.DialogTitle String title2, @Nls String name2, @Nls String location) {
        super(project, true);
        this.myProject = project;
        this.myShowPath = showPath;
        this.myTitle = title2;
        this.myName = name2;
        this.myLocation = location;
        this.init();
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)new JLabel(this.myName), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 3, 5), 0, 0));
        panel2.add((Component)this.myTfUrl, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.myTfUrl.setPreferredSize(new Dimension(350, this.myTfUrl.getPreferredSize().height));
        if (this.myShowPath) {
            panel2.add((Component)new JLabel(this.myLocation), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 3, 5), 0, 0));
            panel2.add((Component)this.myTfPath, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 10, 0), 0, 0));
            panel2.add((Component)this.myBtnBrowseLocalPath, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 5), 0, 0));
            ComponentWithBrowseButton.MyDoClickAction.addTo((FixedSizeButton)this.myBtnBrowseLocalPath, (JComponent)this.myTfPath);
            this.myBtnBrowseLocalPath.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ignored) {
                    FileChooserDescriptor descriptor2 = EditLocationDialog.this.getChooserDescriptor();
                    FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)EditLocationDialog.this.myProject, null, file2 -> EditLocationDialog.this.myTfPath.setText(file2.getPath().replace('/', File.separatorChar)));
                }
            });
        }
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTfUrl;
    }

    public NameLocationPair getPair() {
        String path2 = this.myTfPath.getText().trim();
        String url = this.myTfUrl.getText().trim();
        return new NameLocationPair(url, path2, this.myTfShared);
    }

    protected FileChooserDescriptor getChooserDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, true, false);
    }

    protected void init() {
        this.setTitle(this.myTitle);
        this.myTfUrl = new JTextField();
        this.myTfPath = new JTextField();
        this.myBtnBrowseLocalPath = new FixedSizeButton((JComponent)this.myTfPath);
        super.init();
    }

    public void init(NameLocationPair origin) {
        this.myTfUrl.setText(origin.myName);
        this.myTfPath.setText(origin.myLocation);
        this.myTfShared = origin.myShared;
    }
}

