/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.javaee.ExternalResourceListener;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.ImplicitNamespaceDescriptorProvider;
import com.intellij.javaee.ResourceRegistrar;
import com.intellij.javaee.ResourceRegistrarImpl;
import com.intellij.javaee.StandardResourceEP;
import com.intellij.javaee.StandardResourceProvider;
import com.intellij.javaee.XMLCatalogManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="ExternalResourceManagerImpl", storages={@Storage(value="javaeeExternalResources.xml")}, category=SettingsCategory.CODE)
public class ExternalResourceManagerExImpl
extends ExternalResourceManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(ExternalResourceManagerExImpl.class);
    @NonNls
    public static final String J2EE_1_3 = "http://java.sun.com/dtd/";
    @NonNls
    public static final String J2EE_1_2 = "http://java.sun.com/j2ee/dtds/";
    @NonNls
    public static final String J2EE_NS = "http://java.sun.com/xml/ns/j2ee/";
    @NonNls
    public static final String JAVAEE_NS = "http://java.sun.com/xml/ns/javaee/";
    @NonNls
    public static final String JCP_NS = "http://xmlns.jcp.org/xml/ns/javaee/";
    @NonNls
    public static final String JAKARTA_NS = "https://jakarta.ee/xml/ns/jakartaee/";
    private static final String CATALOG_PROPERTIES_ELEMENT = "CATALOG_PROPERTIES";
    private static final String XSD_1_1 = new Resource("/standardSchemas/XMLSchema-1_1/XMLSchema.xsd", ExternalResourceManagerExImpl.class, null).getResourceUrl();
    private final Map<String, Map<String, String>> myResources = new HashMap<String, Map<String, String>>();
    private final Set<String> myResourceLocations = new HashSet<String>();
    private final Set<String> myIgnoredResources = Collections.synchronizedSet(new TreeSet());
    private final Set<String> myStandardIgnoredResources = Collections.synchronizedSet(new TreeSet());
    private final ClearableLazyValue<Map<String, Map<String, Resource>>> myStandardResources = ClearableLazyValue.create(() -> this.computeStdResources());
    private final CachedValueProvider<MultiMap<String, String>> myUrlByNamespaceProvider = () -> {
        MultiMap result2 = new MultiMap();
        Collection values2 = ((Map)this.myStandardResources.getValue()).values();
        for (Map map2 : values2) {
            for (Map.Entry entry2 : map2.entrySet()) {
                String namespace;
                VirtualFile file2;
                String url = ((Resource)entry2.getValue()).getResourceUrl();
                if (url == null || (file2 = VfsUtilCore.findRelativeFile((String)url, null)) == null || (namespace = XmlNamespaceIndex.computeNamespace(file2)) == null) continue;
                result2.putValue((Object)namespace, (Object)((String)entry2.getKey()));
            }
        }
        return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{this});
    };
    private String myDefaultHtmlDoctype = "HTML5";
    private ExternalResourceManagerEx.XMLSchemaVersion myXMLSchemaVersion = ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_0;
    private String myCatalogPropertiesFile;
    private XMLCatalogManager myCatalogManager;
    private static final String HTML5_DOCTYPE_ELEMENT = "HTML5";
    @NonNls
    private static final String RESOURCE_ELEMENT = "resource";
    @NonNls
    private static final String URL_ATTR = "url";
    @NonNls
    private static final String LOCATION_ATTR = "location";
    @NonNls
    private static final String IGNORED_RESOURCE_ELEMENT = "ignored-resource";
    @NonNls
    private static final String HTML_DEFAULT_DOCTYPE_ELEMENT = "default-html-doctype";
    @NonNls
    private static final String XML_SCHEMA_VERSION = "xml-schema-version";
    private static final String DEFAULT_VERSION = "";

    protected Map<String, Map<String, Resource>> computeStdResources() {
        ResourceRegistrarImpl registrar = new ResourceRegistrarImpl();
        for (StandardResourceProvider provider2 : StandardResourceProvider.EP_NAME.getIterable()) {
            provider2.registerResources((ResourceRegistrar)registrar);
        }
        StandardResourceEP.EP_NAME.processWithPluginDescriptor((extension2, pluginDescriptor) -> registrar.addStdResource(extension2.url, extension2.version, extension2.resourcePath, null, pluginDescriptor.getPluginClassLoader()));
        this.myStandardIgnoredResources.clear();
        this.myStandardIgnoredResources.addAll(registrar.getIgnored());
        return registrar.getResources();
    }

    public ExternalResourceManagerExImpl() {
        StandardResourceProvider.EP_NAME.addChangeListener(this::dropCache, null);
        StandardResourceEP.EP_NAME.addChangeListener(this::dropCache, null);
    }

    private void dropCache() {
        this.myStandardResources.drop();
        this.incModificationCount();
    }

    @Override
    public boolean isStandardResource(VirtualFile file2) {
        VirtualFile parent = file2.getParent();
        return parent != null && parent.getName().equals("standardSchemas");
    }

    @Override
    public boolean isUserResource(VirtualFile file2) {
        return this.myResourceLocations.contains(file2.getUrl());
    }

    @Nullable
    private static <T> Map<String, T> getMap(@NotNull Map<String, Map<String, T>> resources, @Nullable String version2) {
        Map<String, T> map2;
        if (resources == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(0);
        }
        return (map2 = resources.get(version2 = Strings.notNullize((String)version2, (String)DEFAULT_VERSION))) == null && !version2.equals(DEFAULT_VERSION) ? resources.get(DEFAULT_VERSION) : map2;
    }

    @NotNull
    static <T> Map<String, T> getOrCreateMap(@NotNull Map<String, Map<String, T>> resources, @Nullable String version2) {
        if (resources == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(1);
        }
        version2 = Strings.notNullize((String)version2, (String)DEFAULT_VERSION);
        Map map2 = resources.computeIfAbsent(version2, __ -> new HashMap());
        if (map2 == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(2);
        }
        return map2;
    }

    public String getResourceLocation(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(3);
        }
        return this.getResourceLocation(url, DEFAULT_VERSION);
    }

    public String getResourceLocation(@NotNull @NonNls String url, @Nullable String version2) {
        String result2;
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(4);
        }
        if ((result2 = this.getUserResource(url, Strings.notNullize((String)version2, (String)DEFAULT_VERSION))) == null) {
            XMLCatalogManager manager2 = this.getCatalogManager();
            if (manager2 != null) {
                result2 = manager2.resolve(url);
            }
            if (result2 == null && (result2 = this.getStdResource(url, version2)) == null) {
                return url;
            }
        }
        return result2;
    }

    @Override
    @Nullable
    public String getUserResource(Project project, String url, String version2) {
        String resource = ExternalResourceManagerExImpl.getProjectResources(project).getUserResource(url, version2);
        return resource == null ? this.getUserResource(url, version2) : resource;
    }

    @Override
    @Nullable
    public String getStdResource(@NotNull String url, @Nullable String version2) {
        Map map2;
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(5);
        }
        if ((map2 = ExternalResourceManagerExImpl.getMap((Map)this.myStandardResources.getValue(), version2)) != null) {
            Resource resource = (Resource)map2.get(url);
            return resource == null ? null : resource.getResourceUrl();
        }
        return null;
    }

    @Nullable
    private String getUserResource(@NotNull String url, @Nullable String version2) {
        Map map2;
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(6);
        }
        return (map2 = ExternalResourceManagerExImpl.getMap(this.myResources, version2)) != null ? (String)map2.get(url) : null;
    }

    public String getResourceLocation(@NotNull @NonNls String url, @NotNull Project project) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(8);
        }
        return this.getResourceLocation(url, null, project);
    }

    private String getResourceLocation(@NonNls String url, String version2, @NotNull Project project) {
        ExternalResourceManagerExImpl projectResources;
        String location;
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(9);
        }
        if ((location = (projectResources = ExternalResourceManagerExImpl.getProjectResources(project)).getResourceLocation(url, version2)) == null || location.equals(url)) {
            if (projectResources.myXMLSchemaVersion == ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_1) {
                if ("http://www.w3.org/2001/XMLSchema".equals(url)) {
                    return XSD_1_1;
                }
                if ("http://www.w3.org/2001/XMLSchema.xsd".equals(url)) {
                    return XSD_1_1;
                }
            }
            return this.getResourceLocation(url, version2);
        }
        return location;
    }

    @Nullable
    public PsiFile getResourceLocation(@NotNull @NonNls String url, @NotNull PsiFile baseFile, String version2) {
        XmlFile schema2;
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(10);
        }
        if (baseFile == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(11);
        }
        if ((schema2 = XmlSchemaProvider.findSchema((String)url, (PsiFile)baseFile)) != null) {
            return schema2;
        }
        String location = this.getResourceLocation(url, version2, baseFile.getProject());
        return XmlUtil.findXmlFile(baseFile, location);
    }

    public String[] getResourceUrls(FileType fileType, boolean includeStandard) {
        return this.getResourceUrls(fileType, DEFAULT_VERSION, includeStandard);
    }

    public String[] getResourceUrls(@Nullable FileType fileType, @Nullable @NonNls String version2, boolean includeStandard) {
        LinkedList result2 = new LinkedList();
        ExternalResourceManagerExImpl.addResourcesFromMap(result2, version2, this.myResources);
        if (includeStandard) {
            ExternalResourceManagerExImpl.addResourcesFromMap(result2, version2, (Map)this.myStandardResources.getValue());
        }
        return ArrayUtilRt.toStringArray(result2);
    }

    private static <T> void addResourcesFromMap(@NotNull List<? super String> result2, @Nullable String version2, @NotNull Map<String, Map<String, T>> resourcesMap) {
        Map<String, T> resources;
        if (result2 == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(12);
        }
        if (resourcesMap == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(13);
        }
        if ((resources = ExternalResourceManagerExImpl.getMap(resourcesMap, version2)) != null) {
            result2.addAll(resources.keySet());
        }
    }

    public void addResource(@NotNull String url, String location) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(14);
        }
        this.addResource(url, DEFAULT_VERSION, location);
    }

    public void addResource(@NotNull @NonNls String url, @NonNls String version2, @NonNls String location) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.addSilently(url, version2, location);
        this.fireExternalResourceChanged();
    }

    private void addSilently(@NotNull String url, @Nullable String version2, String location) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(16);
        }
        ExternalResourceManagerExImpl.getOrCreateMap(this.myResources, version2).put(url, location);
        this.myResourceLocations.add(location);
        this.incModificationCount();
    }

    public void removeResource(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(17);
        }
        this.removeResource(url, DEFAULT_VERSION);
    }

    public void removeResource(@NotNull String url, @Nullable String version2) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Map map2 = ExternalResourceManagerExImpl.getMap(this.myResources, version2);
        if (map2 != null) {
            String location = (String)map2.remove(url);
            if (location != null) {
                this.myResourceLocations.remove(location);
            }
            this.incModificationCount();
            this.fireExternalResourceChanged();
        }
    }

    @Override
    public void removeResource(String url, @NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(19);
        }
        ExternalResourceManagerExImpl.getProjectResources(project).removeResource(url);
    }

    @Override
    public void addResource(@NonNls String url, @NonNls String location, @NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(20);
        }
        ExternalResourceManagerExImpl.getProjectResources(project).addResource(url, location);
    }

    @Override
    public String[] getAvailableUrls() {
        HashSet<String> urls = new HashSet<String>();
        for (Map<String, String> map2 : this.myResources.values()) {
            urls.addAll(map2.keySet());
        }
        return ArrayUtilRt.toStringArray(urls);
    }

    @Override
    public String[] getAvailableUrls(Project project) {
        return ExternalResourceManagerExImpl.getProjectResources(project).getAvailableUrls();
    }

    @Override
    public void clearAllResources() {
        this.myResources.clear();
        this.myIgnoredResources.clear();
    }

    @Override
    public void clearAllResources(Project project) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.clearAllResources();
        ExternalResourceManagerExImpl.getProjectResources(project).clearAllResources();
        this.incModificationCount();
        this.fireExternalResourceChanged();
    }

    @Override
    public void addIgnoredResource(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.addIgnoredSilently(url)) {
            this.fireExternalResourceChanged();
        }
    }

    @Override
    public void addIgnoredResources(@NotNull List<String> urls, @Nullable Disposable disposable2) {
        Application app2;
        if (urls == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(22);
        }
        if ((app2 = ApplicationManager.getApplication()).isWriteAccessAllowed()) {
            this.doAddIgnoredResources(urls, disposable2);
        } else {
            app2.runWriteAction(() -> this.doAddIgnoredResources(urls, disposable2));
        }
    }

    private void doAddIgnoredResources(@NotNull List<String> urls, @Nullable Disposable disposable2) {
        if (urls == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(23);
        }
        long modificationCount = this.getModificationCount();
        for (String url : urls) {
            this.addIgnoredSilently(url);
        }
        if (modificationCount != this.getModificationCount()) {
            if (disposable2 != null) {
                Disposer.register((Disposable)disposable2, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                    boolean isChanged = false;
                    for (String url : urls) {
                        if (!this.myIgnoredResources.remove(url)) continue;
                        isChanged = true;
                    }
                    if (isChanged) {
                        this.fireExternalResourceChanged();
                    }
                }));
            }
            this.fireExternalResourceChanged();
        }
    }

    private boolean addIgnoredSilently(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(24);
        }
        if (this.myStandardIgnoredResources.contains(url)) {
            return false;
        }
        if (this.myIgnoredResources.add(url)) {
            this.incModificationCount();
            return true;
        }
        return false;
    }

    @Override
    public boolean isIgnoredResource(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(25);
        }
        if (this.myIgnoredResources.contains(url)) {
            return true;
        }
        this.myStandardResources.getValue();
        return this.myStandardIgnoredResources.contains(url) || ExternalResourceManagerExImpl.isImplicitNamespaceDescriptor(url);
    }

    private static boolean isImplicitNamespaceDescriptor(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(26);
        }
        for (ImplicitNamespaceDescriptorProvider provider2 : ImplicitNamespaceDescriptorProvider.EP_NAME.getExtensionList()) {
            if (provider2.getNamespaceDescriptor(null, url, null) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getIgnoredResources() {
        this.myStandardResources.getValue();
        if (this.myIgnoredResources.isEmpty()) {
            return ArrayUtilRt.toStringArray(this.myStandardIgnoredResources);
        }
        HashSet<String> set2 = new HashSet<String>(this.myIgnoredResources.size() + this.myStandardIgnoredResources.size());
        set2.addAll(this.myIgnoredResources);
        set2.addAll(this.myStandardIgnoredResources);
        return ArrayUtilRt.toStringArray(set2);
    }

    @Override
    public long getModificationCount(@NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(27);
        }
        return ExternalResourceManagerExImpl.getProjectResources(project).getModificationCount();
    }

    @Nullable
    public Element getState() {
        Element e;
        Element element2 = new Element("state");
        TreeSet<String> urls = new TreeSet<String>();
        for (Map<String, String> map2 : this.myResources.values()) {
            urls.addAll(map2.keySet());
        }
        for (String url : urls) {
            String location;
            if (url == null || (location = this.getResourceLocation(url)) == null) continue;
            Element e2 = new Element(RESOURCE_ELEMENT);
            e2.setAttribute(URL_ATTR, url);
            e2.setAttribute(LOCATION_ATTR, location.replace(File.separatorChar, '/'));
            element2.addContent(e2);
        }
        this.myIgnoredResources.removeAll(this.myStandardIgnoredResources);
        for (String ignoredResource : this.myIgnoredResources) {
            Element e3 = new Element(IGNORED_RESOURCE_ELEMENT);
            e3.setAttribute(URL_ATTR, ignoredResource);
            element2.addContent(e3);
        }
        if (this.myDefaultHtmlDoctype != null && !HTML5_DOCTYPE_ELEMENT.equals(this.myDefaultHtmlDoctype)) {
            e = new Element(HTML_DEFAULT_DOCTYPE_ELEMENT);
            e.setText(this.myDefaultHtmlDoctype);
            element2.addContent(e);
        }
        if (this.myXMLSchemaVersion != ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_0) {
            e = new Element(XML_SCHEMA_VERSION);
            e.setText(this.myXMLSchemaVersion.toString());
            element2.addContent(e);
        }
        if (this.myCatalogPropertiesFile != null) {
            Element properties2 = new Element(CATALOG_PROPERTIES_ELEMENT);
            properties2.setText(this.myCatalogPropertiesFile);
            element2.addContent(properties2);
        }
        ReplacePathToMacroMap macroReplacements = new ReplacePathToMacroMap();
        PathMacrosImpl.getInstanceEx().addMacroReplacements(macroReplacements);
        macroReplacements.substitute(element2, SystemInfo.isFileSystemCaseSensitive);
        return element2;
    }

    public void loadState(@NotNull Element state) {
        Element catalogElement;
        Element schemaElement;
        if (state == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(28);
        }
        ExpandMacroToPathMap macroExpands = new ExpandMacroToPathMap();
        PathMacrosImpl.getInstanceEx().addMacroExpands(macroExpands);
        macroExpands.substitute(state, SystemInfo.isFileSystemCaseSensitive);
        this.incModificationCount();
        for (Element element2 : state.getChildren(RESOURCE_ELEMENT)) {
            String url = element2.getAttributeValue(URL_ATTR);
            if (Strings.isEmpty((String)url)) continue;
            this.addSilently(url, DEFAULT_VERSION, Objects.requireNonNull(element2.getAttributeValue(LOCATION_ATTR)).replace('/', File.separatorChar));
        }
        this.myIgnoredResources.clear();
        for (Element element2 : state.getChildren(IGNORED_RESOURCE_ELEMENT)) {
            this.addIgnoredSilently(element2.getAttributeValue(URL_ATTR));
        }
        Element child2 = state.getChild(HTML_DEFAULT_DOCTYPE_ELEMENT);
        if (child2 != null) {
            String text2 = child2.getText();
            if (FileUtil.toSystemIndependentName((String)text2).endsWith(".jar!/resources/html5-schema/html5.rnc")) {
                text2 = HTML5_DOCTYPE_ELEMENT;
            }
            this.myDefaultHtmlDoctype = text2;
        }
        if ((schemaElement = state.getChild(XML_SCHEMA_VERSION)) != null) {
            String text3 = schemaElement.getText();
            ExternalResourceManagerEx.XMLSchemaVersion xMLSchemaVersion = this.myXMLSchemaVersion = ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_1.toString().equals(text3) ? ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_1 : ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_0;
        }
        if ((catalogElement = state.getChild(CATALOG_PROPERTIES_ELEMENT)) != null) {
            this.myCatalogPropertiesFile = catalogElement.getTextTrim();
        }
    }

    private void fireExternalResourceChanged() {
        ((ExternalResourceListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ExternalResourceListener.TOPIC)).externalResourceChanged();
        this.incModificationCount();
    }

    @NotNull
    final Collection<Map<String, Resource>> getStandardResources() {
        Collection<Map<String, Resource>> collection = ((Map)this.myStandardResources.getValue()).values();
        if (collection == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(29);
        }
        return collection;
    }

    private static ExternalResourceManagerExImpl getProjectResources(@NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(30);
        }
        return (ExternalResourceManagerExImpl)((Object)project.getService(ExternalResourceManagerExImpl.class));
    }

    @Override
    @NotNull
    public String getDefaultHtmlDoctype(@NotNull Project project) {
        String doctype;
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(31);
        }
        if ("http://www.w3.org/1999/xhtml".equals(doctype = ExternalResourceManagerExImpl.getProjectResources((Project)project).myDefaultHtmlDoctype)) {
            String string = XmlUtil.XHTML4_SCHEMA_LOCATION;
            if (string == null) {
                ExternalResourceManagerExImpl.$$$reportNull$$$0(32);
            }
            return string;
        }
        if (HTML5_DOCTYPE_ELEMENT.equals(doctype)) {
            String string = Html5SchemaProvider.getHtml5SchemaLocation();
            if (string == null) {
                ExternalResourceManagerExImpl.$$$reportNull$$$0(33);
            }
            return string;
        }
        String string = doctype;
        if (string == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(34);
        }
        return string;
    }

    @Override
    public void setDefaultHtmlDoctype(@NotNull String defaultHtmlDoctype, @NotNull Project project) {
        if (defaultHtmlDoctype == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(35);
        }
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(36);
        }
        ExternalResourceManagerExImpl.getProjectResources(project).setDefaultHtmlDoctype(defaultHtmlDoctype);
    }

    @Override
    public ExternalResourceManagerEx.XMLSchemaVersion getXmlSchemaVersion(@NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(37);
        }
        return ExternalResourceManagerExImpl.getProjectResources((Project)project).myXMLSchemaVersion;
    }

    @Override
    public void setXmlSchemaVersion(ExternalResourceManagerEx.XMLSchemaVersion version2, @NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(38);
        }
        ExternalResourceManagerExImpl.getProjectResources((Project)project).myXMLSchemaVersion = version2;
        this.fireExternalResourceChanged();
    }

    @Override
    public String getCatalogPropertiesFile() {
        return this.myCatalogPropertiesFile;
    }

    @Override
    public void setCatalogPropertiesFile(String filePath) {
        this.myCatalogManager = null;
        this.myCatalogPropertiesFile = filePath;
        this.incModificationCount();
    }

    @Override
    public MultiMap<String, String> getUrlsByNamespace(Project project) {
        return (MultiMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, this.myUrlByNamespaceProvider);
    }

    @Nullable
    private XMLCatalogManager getCatalogManager() {
        if (this.myCatalogManager == null && this.myCatalogPropertiesFile != null) {
            this.myCatalogManager = new XMLCatalogManager(this.myCatalogPropertiesFile);
        }
        return this.myCatalogManager;
    }

    private void setDefaultHtmlDoctype(String defaultHtmlDoctype) {
        this.incModificationCount();
        this.myDefaultHtmlDoctype = Html5SchemaProvider.getHtml5SchemaLocation().equals(defaultHtmlDoctype) ? HTML5_DOCTYPE_ELEMENT : defaultHtmlDoctype;
        this.fireExternalResourceChanged();
    }

    @TestOnly
    public static void registerResourceTemporarily(String url, String location, Disposable disposable2) {
        Application app2 = ApplicationManager.getApplication();
        app2.runWriteAction(() -> ExternalResourceManagerExImpl.getInstance().addResource(url, location));
        Disposer.register((Disposable)disposable2, () -> app2.runWriteAction(() -> ExternalResourceManagerExImpl.getInstance().removeResource(url)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 29: 
            case 32: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 29: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 2: 
            case 29: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ExternalResourceManagerExImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = URL_ATTR;
                break;
            }
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 27: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcesMap";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHtmlDoctype";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ExternalResourceManagerExImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateMap";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardResources";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultHtmlDoctype";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateMap";
                break;
            }
            case 2: 
            case 29: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getResourceLocation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStdResource";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUserResource";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addResourcesFromMap";
                break;
            }
            case 14: 
            case 15: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addResource";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addSilently";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeResource";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoredResource";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoredResources";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doAddIgnoredResources";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoredSilently";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredResource";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitNamespaceDescriptor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getModificationCount";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getProjectResources";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultHtmlDoctype";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultHtmlDoctype";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getXmlSchemaVersion";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setXmlSchemaVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 29: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class Resource {
        private final String myFile;
        private final ClassLoader myClassLoader;
        private final Class myClass;
        private volatile String myResolvedResourcePath;

        Resource(String _file, Class _class, ClassLoader _classLoader) {
            this.myFile = _file;
            this.myClass = _class;
            this.myClassLoader = _classLoader;
        }

        Resource(String _file, Resource baseResource) {
            this(_file, baseResource.myClass, baseResource.myClassLoader);
        }

        String directoryName() {
            int i2 = this.myFile.lastIndexOf(47);
            return i2 > 0 ? this.myFile.substring(0, i2) : this.myFile;
        }

        @Nullable
        String getResourceUrl() {
            URL resource;
            String resolvedResourcePath = this.myResolvedResourcePath;
            if (resolvedResourcePath != null) {
                return resolvedResourcePath;
            }
            URL uRL = resource = this.myClass == null ? this.myClassLoader.getResource(this.myFile) : this.myClass.getResource(this.myFile);
            if (resource == null) {
                String message2 = "Cannot find standard resource. filename:" + this.myFile + " class=" + this.myClass + ", classLoader:" + this.myClassLoader;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.error(message2);
                } else {
                    LOG.warn(message2);
                }
                this.myResolvedResourcePath = null;
                return null;
            }
            String path2 = FileUtil.unquote((String)resource.toString());
            this.myResolvedResourcePath = path2 = path2.replace('\\', '/');
            return path2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Resource resource = (Resource)o;
            if (this.myClassLoader != resource.myClassLoader) {
                return false;
            }
            if (this.myClass != resource.myClass) {
                return false;
            }
            return !(this.myFile != null ? !this.myFile.equals(resource.myFile) : resource.myFile != null);
        }

        public int hashCode() {
            return this.myFile.hashCode();
        }

        public String toString() {
            return this.myFile + " for " + this.myClassLoader;
        }
    }
}

