/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonSpellcheckerStrategy
extends SpellcheckingStrategy {
    private final Tokenizer<JsonStringLiteral> ourStringLiteralTokenizer = new Tokenizer<JsonStringLiteral>(){

        @Override
        public void tokenize(@NotNull JsonStringLiteral element2, TokenConsumer consumer2) {
            if (element2 == null) {
                1.$$$reportNull$$$0(0);
            }
            PlainTextSplitter textSplitter = PlainTextSplitter.getInstance();
            if (element2.textContains('\\')) {
                List<Pair<TextRange, String>> fragments = element2.getTextFragments();
                for (Pair<TextRange, String> fragment2 : fragments) {
                    TextRange fragmentRange = (TextRange)fragment2.getFirst();
                    String escaped = (String)fragment2.getSecond();
                    if (escaped.length() != fragmentRange.getLength() || escaped.startsWith("\\")) continue;
                    consumer2.consumeToken(element2, escaped, false, fragmentRange.getStartOffset(), TextRange.allOf((String)escaped), textSplitter);
                }
            } else {
                consumer2.consumeToken(element2, textSplitter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/JsonSpellcheckerStrategy$1", "tokenize"));
        }
    };

    private static boolean matchesNameFromSchema(@NotNull JsonStringLiteral element2) {
        String value2;
        JsonProperty property2;
        VirtualFile file2;
        if (element2 == null) {
            JsonSpellcheckerStrategy.$$$reportNull$$$0(0);
        }
        if ((file2 = PsiUtilCore.getVirtualFile((PsiElement)element2)) == null) {
            return false;
        }
        Project project = element2.getProject();
        JsonSchemaService service = JsonSchemaService.Impl.get(project);
        if (!service.isApplicableToFile(file2)) {
            return false;
        }
        JsonSchemaObject rootSchema = service.getSchemaObject(element2.getContainingFile());
        if (rootSchema == null) {
            return false;
        }
        if (service.isSchemaFile(rootSchema) && (property2 = (JsonProperty)ObjectUtils.tryCast((Object)element2.getParent(), JsonProperty.class)) != null) {
            PsiElement grandParent;
            PsiElement parent;
            if ("x-intellij-language-injection".equals(property2.getName())) {
                return true;
            }
            if ("language".equals(property2.getName()) && (parent = property2.getParent()) instanceof JsonObject && (grandParent = parent.getParent()) instanceof JsonProperty && "x-intellij-language-injection".equals(((JsonProperty)grandParent).getName())) {
                return true;
            }
        }
        if (StringUtil.isEmpty((String)(value2 = element2.getValue()))) {
            return false;
        }
        JsonOriginalPsiWalker walker = JsonOriginalPsiWalker.INSTANCE;
        PsiElement checkable = walker.findElementToCheck(element2);
        if (checkable == null) {
            return false;
        }
        ThreeState isName = walker.isName(checkable);
        JsonPointerPosition position = walker.findPosition(checkable, isName == ThreeState.NO);
        if (position == null || position.isEmpty() && isName == ThreeState.NO) {
            return false;
        }
        Collection<JsonSchemaObject> schemas = new JsonSchemaResolver(project, rootSchema, position).resolve();
        if (schemas.isEmpty()) {
            return false;
        }
        return schemas.stream().anyMatch(s -> s.getProperties().containsKey(value2) || s.getMatchingPatternPropertySchema(value2) != null);
    }

    @Override
    @NotNull
    public Tokenizer getTokenizer(PsiElement element2) {
        if (element2 instanceof JsonStringLiteral) {
            Tokenizer<JsonStringLiteral> tokenizer = JsonSpellcheckerStrategy.matchesNameFromSchema((JsonStringLiteral)element2) ? EMPTY_TOKENIZER : this.ourStringLiteralTokenizer;
            if (tokenizer == null) {
                JsonSpellcheckerStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element2);
        if (tokenizer == null) {
            JsonSpellcheckerStrategy.$$$reportNull$$$0(2);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/JsonSpellcheckerStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/JsonSpellcheckerStrategy";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchesNameFromSchema";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

