/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.ui;

import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonFile;
import com.intellij.jsonpath.ui.JsonPathEvaluateView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J,\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0014J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateSnippetView;", "Lcom/intellij/jsonpath/ui/JsonPathEvaluateView;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "expressionHighlightingQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "sourceEditor", "Lcom/intellij/openapi/editor/Editor;", "dispose", "", "getJsonFile", "Lcom/intellij/json/psi/JsonFile;", "processKeyBinding", "", "ks", "Ljavax/swing/KeyStroke;", "e", "Ljava/awt/event/KeyEvent;", "condition", "", "pressed", "setSource", "json", "", "intellij.json"})
public final class JsonPathEvaluateSnippetView
extends JsonPathEvaluateView {
    private final MergingUpdateQueue expressionHighlightingQueue;
    private final Editor sourceEditor;

    public final void setSource(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        WriteAction.run((ThrowableRunnable)new ThrowableRunnable(this, json){
            final /* synthetic */ JsonPathEvaluateSnippetView this$0;
            final /* synthetic */ String $json;

            public final void run() {
                JsonPathEvaluateSnippetView.access$getSourceEditor$p(this.this$0).getDocument().setText((CharSequence)this.$json);
            }
            {
                this.this$0 = jsonPathEvaluateSnippetView;
                this.$json = string;
            }
        });
    }

    @Override
    @Nullable
    protected JsonFile getJsonFile() {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(this.sourceEditor.getDocument());
        if (!(psiFile instanceof JsonFile)) {
            psiFile = null;
        }
        return (JsonFile)psiFile;
    }

    protected boolean processKeyBinding(@Nullable KeyStroke ks, @Nullable KeyEvent e, int condition, boolean pressed) {
        if (pressed) {
            KeyEvent keyEvent = e;
            if (keyEvent != null) {
                if (keyEvent.getKeyCode() == 27) {
                    FocusManager focusManager = FocusManager.getCurrentManager();
                    Intrinsics.checkNotNullExpressionValue((Object)focusManager, (String)"FocusManager.getCurrentManager()");
                    Component focusOwner = focusManager.getFocusOwner();
                    if (SwingUtilities.isDescendingFrom(focusOwner, this.sourceEditor.getComponent())) {
                        this.getSearchTextField().requestFocus();
                        return true;
                    }
                }
            }
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    @Override
    public void dispose() {
        super.dispose();
        EditorFactory.getInstance().releaseEditor(this.sourceEditor);
    }

    public JsonPathEvaluateSnippetView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.expressionHighlightingQueue = new MergingUpdateQueue("JSONPATH_EVALUATE", 1000, true, null, (Disposable)this);
        this.sourceEditor = this.initJsonEditor("source.json", false, EditorKind.UNTYPED);
        BorderLayoutPanel sourcePanel = new BorderLayoutPanel();
        sourcePanel.addToTop((Component)this.getSearchWrapper());
        BorderLayoutPanel sourceWrapper = new BorderLayoutPanel();
        JBLabel sourceLabel = new JBLabel(JsonBundle.message("jsonpath.evaluate.input", new Object[0]));
        sourceLabel.setBorder((Border)JBUI.Borders.empty((int)3, (int)6));
        sourceWrapper.addToTop((Component)sourceLabel);
        sourceWrapper.addToCenter((Component)this.sourceEditor.getComponent());
        sourcePanel.addToCenter((Component)sourceWrapper);
        final OnePixelSplitter splitter2 = new OnePixelSplitter(0.5f);
        splitter2.setFirstComponent((JComponent)sourcePanel);
        splitter2.setSecondComponent((JComponent)this.getResultWrapper());
        this.setContent((JComponent)splitter2);
        this.setSource("{\n\n}");
        JComponent jComponent = this.sourceEditor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"sourceEditor.component");
        jComponent.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0));
        this.sourceEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                expressionHighlightingQueue.queue(Update.create((Object)((Object)this), (Runnable)new Runnable(this){
                    final /* synthetic */ 1 this$0;

                    public final void run() {
                        this.this$0.this.resetExpressionHighlighting();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
        });
        MessageBusConnection messageBusConnection2 = this.getProject().getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection2, (String)"this.project.messageBus.connect(this)");
        MessageBusConnection messageBusConnection3 = messageBusConnection2;
        messageBusConnection3.subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            @Override
            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                ToolWindow toolWindow2 = toolWindowManager.getToolWindow("JSONPathEvaluate");
                if (toolWindow2 != null) {
                    ToolWindowAnchor toolWindowAnchor = toolWindow2.getAnchor();
                    Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"toolWindow.anchor");
                    splitter2.setOrientation(!toolWindowAnchor.isHorizontal());
                }
            }
        });
        this.initToolbar();
    }

    public static final /* synthetic */ Editor access$getSourceEditor$p(JsonPathEvaluateSnippetView $this) {
        return $this.sourceEditor;
    }
}

