/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.customFolding;

import com.intellij.lang.LangBundle;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.openapi.util.text.StringUtil;

public class VisualStudioCustomFoldingProvider
extends CustomFoldingProvider {
    public boolean isCustomRegionStart(String elementText) {
        return elementText.contains("region") && elementText.matches("[/*#-]*\\s*region.*");
    }

    public boolean isCustomRegionEnd(String elementText) {
        return elementText.contains("endregion") && elementText.matches("[/*#-]*\\s*endregion.*");
    }

    public String getPlaceholderText(String elementText) {
        String textAfterMarker = elementText.replaceFirst("[/*#-]*\\s*region(.*)", "$1");
        String result2 = elementText.startsWith("/*") ? StringUtil.trimEnd((String)textAfterMarker, (String)"*/").trim() : textAfterMarker.trim();
        return result2.isEmpty() ? "..." : result2;
    }

    public String getDescription() {
        return LangBundle.message((String)"custom.folding.comments.vs.description", (Object[])new Object[0]);
    }

    public String getStartString() {
        return "region ?";
    }

    public String getEndString() {
        return "endregion";
    }
}

