/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.ide;

import com.intellij.lang.documentation.DocumentationTarget;
import com.intellij.lang.documentation.ide.impl.DocumentationBrowser;
import com.intellij.lang.documentation.ide.ui.DocumentationUI;
import com.intellij.lang.documentation.impl.DocumentationRequest;
import com.intellij.model.Pointer;
import com.intellij.navigation.TargetPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.EDT;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\r"}, d2={"documentationComponent", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lcom/intellij/lang/documentation/impl/DocumentationRequest;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "targetPointer", "Lcom/intellij/model/Pointer;", "Lcom/intellij/lang/documentation/DocumentationTarget;", "targetPresentation", "Lcom/intellij/navigation/TargetPresentation;", "intellij.platform.lang.impl"})
@JvmName(name="DocumentationUtil")
public final class DocumentationUtil {
    @ApiStatus.Experimental
    @NotNull
    public static final JComponent documentationComponent(@NotNull Project project, @NotNull Pointer<? extends DocumentationTarget> targetPointer, @NotNull TargetPresentation targetPresentation, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targetPointer, (String)"targetPointer");
        Intrinsics.checkNotNullParameter((Object)targetPresentation, (String)"targetPresentation");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        EDT.assertIsEdt();
        DocumentationRequest request2 = new DocumentationRequest(targetPointer, targetPresentation);
        return DocumentationUtil.documentationComponent(project, request2, parentDisposable);
    }

    @NotNull
    public static final JComponent documentationComponent(@NotNull Project project, @NotNull DocumentationRequest request2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        DocumentationBrowser browser2 = DocumentationBrowser.Companion.createBrowser(project, request2);
        DocumentationUI ui2 = new DocumentationUI(project, browser2);
        Disposer.register((Disposable)parentDisposable, (Disposable)ui2);
        return ui2.getScrollPane();
    }
}

