/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.symbol.impl;

import com.intellij.lang.documentation.DocumentationTarget;
import com.intellij.lang.documentation.symbol.DocumentationSymbol;
import com.intellij.lang.documentation.symbol.SymbolDocumentationTargetFactory;
import com.intellij.model.Symbol;
import com.intellij.model.psi.impl.TargetsKt;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0000\u001a\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a8\u0006\u000e"}, d2={"symbolDocumentationTarget", "Lcom/intellij/lang/documentation/DocumentationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "symbol", "Lcom/intellij/model/Symbol;", "symbolDocumentationTargets", "", "targetSymbols", "", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "intellij.platform.lang.impl"})
public final class ImplKt {
    @NotNull
    public static final List<DocumentationTarget> symbolDocumentationTargets(@NotNull PsiFile file2, int offset) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Collection<Symbol> symbols = TargetsKt.targetSymbols(file2, offset);
        Project project = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        return ImplKt.symbolDocumentationTargets(project, symbols);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<DocumentationTarget> symbolDocumentationTargets(@NotNull Project project, @NotNull Collection<? extends Symbol> targetSymbols) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targetSymbols, (String)"targetSymbols");
        Iterable iterable = targetSymbols;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            DocumentationTarget documentationTarget;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Symbol it = (Symbol)element$iv;
            boolean bl2 = false;
            if (ImplKt.symbolDocumentationTarget(project, it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            DocumentationTarget it$iv = documentationTarget;
            boolean bl5 = false;
            destination$iv.add(it$iv);
        }
        return CollectionsKt.toList((Iterable)((Iterable)var3_3));
    }

    private static final DocumentationTarget symbolDocumentationTarget(Project project, Symbol symbol) {
        ExtensionPointName<SymbolDocumentationTargetFactory> extensionPointName = SymbolDocumentationTargetFactory.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"SymbolDocumentationTargetFactory.EP_NAME");
        for (SymbolDocumentationTargetFactory factory2 : extensionPointName.getExtensionList()) {
            DocumentationTarget documentationTarget = factory2.documentationTarget(project, symbol);
            if (documentationTarget == null) {
                continue;
            }
            return documentationTarget;
        }
        if (symbol instanceof DocumentationSymbol) {
            return ((DocumentationSymbol)symbol).getDocumentationTarget();
        }
        if (symbol instanceof DocumentationTarget) {
            return (DocumentationTarget)symbol;
        }
        return null;
    }
}

