/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class XmlEnclosingTagUnwrapper
implements Unwrapper {
    @Override
    public boolean isApplicableTo(@NotNull PsiElement e) {
        if (e == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    public void collectElementsToIgnore(@NotNull PsiElement element2, @NotNull Set<PsiElement> result2) {
        if (element2 == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(2);
        }
    }

    @Override
    @NotNull
    public String getDescription(@NotNull PsiElement e) {
        if (e == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(3);
        }
        String string = XmlBundle.message((String)"xml.action.unwrap.enclosing.tag.name.description", (Object[])new Object[]{((XmlTag)e).getName()});
        if (string == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public PsiElement collectAffectedElements(@NotNull PsiElement element2, @NotNull List<PsiElement> toExtract) {
        if (element2 == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(5);
        }
        if (toExtract == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(6);
        }
        TextRange range2 = element2.getTextRange();
        ASTNode startTagNameEnd = XmlChildRole.START_TAG_END_FINDER.findChild(element2.getNode());
        ASTNode endTagNameStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(element2.getNode());
        int start2 = startTagNameEnd != null ? startTagNameEnd.getTextRange().getEndOffset() : range2.getStartOffset();
        int end = endTagNameStart != null ? endTagNameStart.getTextRange().getStartOffset() : range2.getEndOffset();
        for (PsiElement child2 : element2.getChildren()) {
            TextRange childRange = child2.getTextRange();
            if (childRange.getStartOffset() < start2 || childRange.getEndOffset() > end) continue;
            toExtract.add(child2);
        }
        return element2;
    }

    @Override
    @NotNull
    public List<PsiElement> unwrap(@NotNull Editor editor2, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (editor2 == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(7);
        }
        if (element2 == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(8);
        }
        TextRange range2 = element2.getTextRange();
        ASTNode startTagNameEnd = XmlChildRole.START_TAG_END_FINDER.findChild(element2.getNode());
        ASTNode endTagNameStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(element2.getNode());
        Project project = element2.getProject();
        PsiFile file2 = element2.getContainingFile();
        Document document = editor2.getDocument();
        RangeMarker marker = document.createRangeMarker(range2);
        if (endTagNameStart != null) {
            document.deleteString(endTagNameStart.getTextRange().getStartOffset(), range2.getEndOffset());
            document.deleteString(range2.getStartOffset(), startTagNameEnd.getTextRange().getEndOffset());
        } else {
            document.replaceString(range2.getStartOffset(), range2.getEndOffset(), (CharSequence)"");
        }
        this.deleteEmptyLine(document, marker.getStartOffset());
        this.deleteEmptyLine(document, marker.getEndOffset());
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        CodeStyleManager.getInstance((Project)project).adjustLineIndent(file2, new TextRange(marker.getStartOffset(), marker.getEndOffset()));
        List<PsiElement> list2 = Collections.emptyList();
        if (list2 == null) {
            XmlEnclosingTagUnwrapper.$$$reportNull$$$0(9);
        }
        return list2;
    }

    protected void deleteEmptyLine(Document document, int offset) {
        int line;
        int n = line = offset < document.getTextLength() ? document.getLineNumber(offset) : -1;
        if (line > 0 && DocumentUtil.isLineEmpty(document, line)) {
            int start2 = document.getLineStartOffset(line);
            int end = Math.min(document.getLineEndOffset(line) + 1, document.getTextLength() - 1);
            if (end == document.getTextLength() - 1) {
                document.deleteString(start2 - 1, end);
            } else if (start2 < end) {
                document.deleteString(start2, end);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/xml/XmlEnclosingTagUnwrapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExtract";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/xml/XmlEnclosingTagUnwrapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectElementsToIgnore";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedElements";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

