/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.notification.impl.NotificationComponent;
import com.intellij.notification.impl.NotificationOptionButton;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\b\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0015\u0010\u0019\u001a\u00020\u001a2\u000b\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\fJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0018\u0010#\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0011H\u0002J\u000e\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\fJ\u000e\u0010*\u001a\u00020 2\u0006\u0010)\u001a\u00020\fJ\b\u0010+\u001a\u00020 H\u0002R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0005j\b\u0012\u0004\u0012\u00020\n`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lcom/intellij/notification/impl/NotificationComponent;", "Ljavax/swing/JPanel;", "notification", "Lcom/intellij/notification/Notification;", "timeComponents", "Ljava/util/ArrayList;", "Ljavax/swing/JLabel;", "Lkotlin/collections/ArrayList;", "(Lcom/intellij/notification/Notification;Ljava/util/ArrayList;)V", "myBgComponents", "Ljava/awt/Component;", "myHoverState", "", "myIsNew", "myMoreButton", "myMorePopupVisible", "myRoundColor", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "getNotification", "()Lcom/intellij/notification/Notification;", "createAction", "Ljavax/swing/Action;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "createTextComponent", "Ljavax/swing/JTextPane;", "text", "", "Lorg/jetbrains/annotations/Nls;", "isHover", "paintComponent", "", "g", "Ljava/awt/Graphics;", "runAction", "component", "", "setColor", "color", "setHover", "state", "setNew", "updateColor", "Companion", "intellij.platform.ide.impl"})
final class NotificationComponent
extends JPanel {
    private final ArrayList<Component> myBgComponents;
    private boolean myIsNew;
    private boolean myHoverState;
    private final Component myMoreButton;
    private boolean myMorePopupVisible;
    private Color myRoundColor;
    @NotNull
    private final Notification notification;
    @NotNull
    private static final Color BG_COLOR;
    @NotNull
    private static final JBColor INFO_COLOR;
    @NotNull
    private static final JBColor NEW_COLOR;
    @NotNull
    private static final JBColor NEW_HOVER_COLOR;
    @NotNull
    private static final JBColor HOVER_COLOR;
    @NotNull
    public static final String TIME_KEY = "TimestampKey";
    @NotNull
    public static final Companion Companion;

    private final Action createAction(AnAction action2) {
        return new AbstractAction(this, action2, action2.getTemplateText()){
            final /* synthetic */ NotificationComponent this$0;
            final /* synthetic */ AnAction $action;

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = e.getSource();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.source");
                NotificationComponent.access$runAction(this.this$0, this.$action, object);
            }
            {
                this.this$0 = this$0;
                this.$action = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    private final void runAction(AnAction action2, Object component2) {
        NotificationCollector.getInstance().logNotificationActionInvoked(null, this.notification, action2, NotificationCollector.NotificationPlace.ACTION_CENTER);
        Object object = component2;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Component");
        }
        Notification.fire((Notification)this.notification, (AnAction)action2, (DataContext)DataManager.getInstance().getDataContext((Component)object));
    }

    private final JTextPane createTextComponent(String text2) {
        JTextPane component2 = new JTextPane();
        component2.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        component2.setContentType("text/html");
        component2.setOpaque(false);
        component2.setFocusable(false);
        component2.setBorder(null);
        UIUtil.JBWordWrapHtmlEditorKit kit = new UIUtil.JBWordWrapHtmlEditorKit();
        kit.getStyleSheet().addRule("a {color: " + ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + "}");
        component2.setEditorKit((EditorKit)kit);
        component2.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        component2.putClientProperty("AccessibleName", StringUtil.unescapeXmlEntities((String)StringUtil.stripHtml((String)text2, (String)" ")));
        component2.setText(text2);
        component2.setEditable(false);
        if (component2.getCaret() != null) {
            component2.setCaretPosition(0);
        }
        return component2;
    }

    public final boolean isHover() {
        return this.myHoverState;
    }

    public final void setNew(boolean state) {
        if (this.myIsNew != state) {
            this.myIsNew = state;
            this.updateColor();
        }
    }

    public final void setHover(boolean state) {
        this.myHoverState = state;
        if (this.myMoreButton != null && !this.myMorePopupVisible) {
            this.myMoreButton.setVisible(state);
        }
        this.updateColor();
    }

    private final void updateColor() {
        if (this.myHoverState) {
            if (this.myIsNew) {
                this.setColor((Color)NEW_HOVER_COLOR);
            } else {
                this.setColor((Color)HOVER_COLOR);
            }
        } else if (this.myIsNew) {
            this.setColor((Color)NEW_COLOR);
        } else {
            this.setColor(BG_COLOR);
        }
    }

    private final void setColor(Color color) {
        this.myRoundColor = color;
        Iterator<Component> iterator2 = this.myBgComponents.iterator();
        while (iterator2.hasNext()) {
            Component component2;
            Component component3 = component2 = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"component");
            component3.setBackground(color);
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        if (this.myRoundColor != BG_COLOR) {
            g.setColor(this.myRoundColor);
            GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
            g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 12, 12);
            config2.restore();
        }
    }

    @NotNull
    public final Notification getNotification() {
        return this.notification;
    }

    /*
     * WARNING - void declaration
     */
    public NotificationComponent(@NotNull Notification notification, @NotNull ArrayList<JLabel> timeComponents) {
        JPanel titlePanel;
        JPanel centerPanel;
        block8: {
            JPanel actionPanel;
            block11: {
                Object optionButton;
                List actions2;
                block9: {
                    int actionsSize;
                    block10: {
                        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                        Intrinsics.checkNotNullParameter(timeComponents, (String)"timeComponents");
                        super(new BorderLayout(JBUI.scale((int)7), 0));
                        this.notification = notification;
                        this.myBgComponents = new ArrayList();
                        this.myRoundColor = BG_COLOR;
                        this.setOpaque(true);
                        this.setBackground(BG_COLOR);
                        this.setBorder((Border)JBUI.Borders.empty((int)10, (int)10, (int)10, (int)0));
                        JPanel iconPanel = new JPanel(new BorderLayout());
                        iconPanel.setOpaque(false);
                        iconPanel.add((Component)new JBLabel(NotificationsUtil.getIcon(this.notification)), "North");
                        this.add((Component)iconPanel, "West");
                        centerPanel = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)8)));
                        centerPanel.setOpaque(false);
                        titlePanel = null;
                        if (this.notification.hasTitle()) {
                            String string = NotificationsUtil.buildHtml(this.notification, "white-space:nowrap;", false, null, null);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"NotificationsUtil.buildH\u2026rap;\", false, null, null)");
                            String titleContent = string;
                            JBLabel title2 = new JBLabel(titleContent);
                            if (this.notification.isSuggestionType()) {
                                centerPanel.add((Component)title2);
                            } else {
                                titlePanel = new JPanel(new BorderLayout());
                                titlePanel.setOpaque(false);
                                titlePanel.add((Component)title2, "West");
                                centerPanel.add(titlePanel);
                            }
                        }
                        if (this.notification.hasContent()) {
                            String string = NotificationsUtil.buildHtml(this.notification, null, true, null, null);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"NotificationsUtil.buildH\u2026, null, true, null, null)");
                            String textContent = string;
                            centerPanel.add(this.createTextComponent(textContent));
                        }
                        List list2 = this.notification.getActions();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"notification.actions");
                        actions2 = list2;
                        actionsSize = actions2.size();
                        if (actionsSize <= 0) break block8;
                        actionPanel = new JPanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)16)));
                        actionPanel.setOpaque(false);
                        if (!this.notification.isSuggestionType()) break block9;
                        if (actionsSize != 1) break block10;
                        Object e = actions2.get(0);
                        Intrinsics.checkNotNullExpressionValue(e, (String)"actions[0]");
                        JButton button4 = new JButton(((AnAction)e).getTemplateText());
                        button4.setOpaque(false);
                        button4.addActionListener(new ActionListener(){

                            @Override
                            public final void actionPerformed(ActionEvent it) {
                                Object e = actions2.get(0);
                                Intrinsics.checkNotNullExpressionValue(e, (String)"actions[0]");
                                AnAction anAction2 = (AnAction)e;
                                ActionEvent actionEvent = it;
                                Intrinsics.checkNotNullExpressionValue((Object)actionEvent, (String)"it");
                                Object object = actionEvent.getSource();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.source");
                                this.runAction(anAction2, object);
                            }
                        });
                        actionPanel.add(button4);
                        break block11;
                    }
                    if (actionsSize <= 1) break block11;
                    int n = actionsSize - 1;
                    Action[] actionArray = new Action[n];
                    int n2 = 0;
                    while (n2 < n) {
                        Action action2;
                        void i2;
                        int n3 = n2;
                        int n4 = n2++;
                        Action[] actionArray2 = actionArray;
                        boolean bl = false;
                        Object e = actions2.get((int)(i2 + true));
                        Intrinsics.checkNotNullExpressionValue(e, (String)"actions[i + 1]");
                        actionArray2[n4] = action2 = this.createAction((AnAction)e);
                    }
                    Action[] buttonActions = actionArray;
                    Object e = actions2.get(0);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"actions[0]");
                    optionButton = new NotificationOptionButton(this.createAction((AnAction)e), buttonActions);
                    optionButton.setBackground(BG_COLOR);
                    actionPanel.add((Component)optionButton);
                    this.myBgComponents.add((Component)optionButton);
                    break block11;
                }
                optionButton = actions2.iterator();
                while (optionButton.hasNext()) {
                    AnAction action3;
                    AnAction anAction2 = action3 = (AnAction)optionButton.next();
                    Intrinsics.checkNotNullExpressionValue((Object)anAction2, (String)"action");
                    String string = anAction2.getTemplateText();
                    Presentation presentation2 = action3.getTemplatePresentation();
                    Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"action.templatePresentation");
                    actionPanel.add((Component)new LinkLabel(string, presentation2.getIcon(), new LinkListener(){

                        public final void linkSelected(LinkLabel<Object> link2, Object $noName_1) {
                            AnAction anAction2 = action3;
                            Intrinsics.checkNotNullExpressionValue((Object)anAction2, (String)"action");
                            LinkLabel<Object> linkLabel = link2;
                            Intrinsics.checkNotNullExpressionValue(linkLabel, (String)"link");
                            this.runAction(anAction2, linkLabel);
                        }
                    }));
                }
            }
            centerPanel.add(actionPanel);
        }
        this.add(centerPanel);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setOpaque(false);
        if (this.notification.isSuggestionType()) {
            DefaultActionGroup group2 = new DefaultActionGroup();
            group2.setPopup(true);
            group2.add(new AnAction(IdeBundle.message((String)"notifications.toolwindow.remind.tomorrow", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    String string = "Not yet implemented";
                    boolean bl = false;
                    throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
                }
            });
            group2.add(new AnAction(IdeBundle.message((String)"notifications.toolwindow.dont.show.again.for.this.project", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    String string = "Not yet implemented";
                    boolean bl = false;
                    throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
                }
            });
            group2.add(new AnAction(IdeBundle.message((String)"notifications.toolwindow.dont.show.again", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    String string = "Not yet implemented";
                    boolean bl = false;
                    throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
                }
            });
            Presentation presentation3 = new Presentation();
            presentation3.setIcon(AllIcons.Actions.More);
            presentation3.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)Boolean.TRUE);
            ActionButton button5 = new ActionButton(this, group2, presentation3, (AnAction)group2, presentation3, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){
                final /* synthetic */ NotificationComponent this$0;
                final /* synthetic */ DefaultActionGroup $group;
                final /* synthetic */ Presentation $presentation;

                @NotNull
                protected JBPopup createAndShowActionGroupPopup(@NotNull ActionGroup actionGroup2, @NotNull AnActionEvent event) {
                    Intrinsics.checkNotNullParameter((Object)actionGroup2, (String)"actionGroup");
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    NotificationComponent.access$setMyMorePopupVisible$p(this.this$0, true);
                    JBPopup jBPopup = super.createAndShowActionGroupPopup(actionGroup2, event);
                    Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"super.createAndShowActio\u2026Popup(actionGroup, event)");
                    JBPopup popup2 = jBPopup;
                    popup2.addListener(new JBPopupListener(this){
                        final /* synthetic */ button.1 this$0;

                        public void onClosed(@NotNull LightweightWindowEvent event) {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            NotificationComponent.access$setMyMorePopupVisible$p(this.this$0.this$0, false);
                            this.this$0.setVisible(NotificationComponent.access$getMyHoverState$p(this.this$0.this$0));
                        }
                        {
                            this.this$0 = this$0;
                        }
                    });
                    return popup2;
                }
                {
                    this.this$0 = this$0;
                    this.$group = $captured_local_variable$1;
                    this.$presentation = $captured_local_variable$2;
                    super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
                }
            };
            button5.setBorder((Border)JBUI.Borders.emptyRight((int)5));
            button5.setVisible(false);
            this.myMoreButton = button5;
            panel2.add((Component)button5, "North");
        } else {
            JBLabel timeComponent = new JBLabel(DateFormatUtil.formatPrettyDateTime((long)this.notification.getTimestamp()));
            timeComponent.putClientProperty((Object)TIME_KEY, (Object)this.notification.getTimestamp());
            timeComponent.setToolTipText(DateFormatUtil.formatDateTime((long)this.notification.getTimestamp()));
            timeComponent.setBorder((Border)JBUI.Borders.emptyRight((int)10));
            timeComponent.setFont((Font)JBFont.small());
            timeComponent.setForeground((Color)INFO_COLOR);
            timeComponents.add((JLabel)timeComponent);
            JPanel jPanel2 = titlePanel;
            Intrinsics.checkNotNull((Object)jPanel2);
            jPanel2.add((Component)timeComponent, "East");
            this.myMoreButton = null;
        }
        this.add((Component)panel2, "East");
    }

    static {
        Companion = new Companion(null);
        Color color = UIUtil.getListBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"UIUtil.getListBackground()");
        BG_COLOR = color;
        JBColor jBColor = JBColor.namedColor((String)"Label.infoForeground", (Color)((Color)new JBColor((Color)Gray.x80, (Color)Gray.x8C)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.namedColor(\"Labe\u2026olor(Gray.x80, Gray.x8C))");
        INFO_COLOR = jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"NotificationsToolwindow.newNotification.background", (Color)((Color)new JBColor(15134455, 4540746)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"JBColor.namedColor(\"Noti\u2026olor(0xE6EEF7, 0x45494A))");
        NEW_COLOR = jBColor2;
        JBColor jBColor3 = JBColor.namedColor((String)"NotificationsToolwindow.newNotification.hoverBackground", (Color)((Color)new JBColor(15134455, 4540746)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor3, (String)"JBColor.namedColor(\"Noti\u2026olor(0xE6EEF7, 0x45494A))");
        NEW_HOVER_COLOR = jBColor3;
        JBColor jBColor4 = JBColor.namedColor((String)"NotificationsToolwindow.Notification.hoverBackground", (Color)BG_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor4, (String)"JBColor.namedColor(\"Noti\u2026verBackground\", BG_COLOR)");
        HOVER_COLOR = jBColor4;
    }

    public static final /* synthetic */ boolean access$getMyMorePopupVisible$p(NotificationComponent $this) {
        return $this.myMorePopupVisible;
    }

    public static final /* synthetic */ void access$setMyMorePopupVisible$p(NotificationComponent $this, boolean bl) {
        $this.myMorePopupVisible = bl;
    }

    public static final /* synthetic */ boolean access$getMyHoverState$p(NotificationComponent $this) {
        return $this.myHoverState;
    }

    public static final /* synthetic */ void access$setMyHoverState$p(NotificationComponent $this, boolean bl) {
        $this.myHoverState = bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00070\t\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u000e\u001a\u00070\t\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0016\u0010\u0010\u001a\u00070\t\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u000e\u0010\u0012\u001a\u00020\u0013X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/notification/impl/NotificationComponent$Companion;", "", "()V", "BG_COLOR", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "getBG_COLOR", "()Ljava/awt/Color;", "HOVER_COLOR", "Lcom/intellij/ui/JBColor;", "getHOVER_COLOR", "()Lcom/intellij/ui/JBColor;", "INFO_COLOR", "getINFO_COLOR", "NEW_COLOR", "getNEW_COLOR", "NEW_HOVER_COLOR", "getNEW_HOVER_COLOR", "TIME_KEY", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final Color getBG_COLOR() {
            return BG_COLOR;
        }

        @NotNull
        public final JBColor getINFO_COLOR() {
            return INFO_COLOR;
        }

        @NotNull
        public final JBColor getNEW_COLOR() {
            return NEW_COLOR;
        }

        @NotNull
        public final JBColor getNEW_HOVER_COLOR() {
            return NEW_HOVER_COLOR;
        }

        @NotNull
        public final JBColor getHOVER_COLOR() {
            return HOVER_COLOR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

