/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.MainMenuCollector;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.PoppedIcon;
import com.intellij.openapi.actionSystem.impl.actionholder.ActionRef;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBCheckBoxMenuItem;
import com.intellij.ui.mac.screenmenu.Menu;
import com.intellij.ui.mac.screenmenu.MenuItem;
import com.intellij.ui.plaf.beg.BegMenuItemUI;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.LafIconLookup;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionMenuItem
extends JBCheckBoxMenuItem {
    static final Icon EMPTY_ICON = EmptyIcon.create((int)16, (int)1);
    private final ActionRef<AnAction> myAction;
    private final Presentation myPresentation;
    private final String myPlace;
    private final boolean myInsideCheckedGroup;
    private final boolean myEnableMnemonics;
    private final boolean myToggleable;
    private final DataContext myContext;
    private boolean myToggled;
    private final boolean myUseDarkIcons;
    @Nullable
    private final MenuItem myScreenMenuItemPeer;

    public ActionMenuItem(@NotNull AnAction action2, @NotNull Presentation presentation2, @NotNull String place, @NotNull DataContext context2, boolean enableMnemonics, boolean unused, boolean insideCheckedGroup, boolean useDarkIcons) {
        if (action2 == null) {
            ActionMenuItem.$$$reportNull$$$0(0);
        }
        if (presentation2 == null) {
            ActionMenuItem.$$$reportNull$$$0(1);
        }
        if (place == null) {
            ActionMenuItem.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            ActionMenuItem.$$$reportNull$$$0(3);
        }
        this.myAction = ActionRef.fromAction(action2);
        this.myPresentation = presentation2;
        this.myPlace = place;
        this.myContext = context2;
        this.myEnableMnemonics = enableMnemonics;
        this.myToggleable = action2 instanceof Toggleable;
        this.myInsideCheckedGroup = insideCheckedGroup;
        this.myUseDarkIcons = useDarkIcons;
        ActionTransmitter actionTransmitter = new ActionTransmitter();
        this.addActionListener(actionTransmitter);
        this.setBorderPainted(false);
        if (Menu.isJbScreenMenuEnabled() && "MainMenu".equals(this.myPlace)) {
            this.myScreenMenuItemPeer = new MenuItem();
            this.myScreenMenuItemPeer.setActionDelegate(() -> {
                if (this.isToggleable()) {
                    this.myToggled = !this.myToggled;
                    this.myScreenMenuItemPeer.setState(this.myToggled);
                }
                ApplicationManager.getApplication().invokeLater(() -> actionTransmitter.performAction(0));
            });
        } else {
            this.myScreenMenuItemPeer = null;
        }
        this.updateUI();
        this.init();
    }

    @NotNull
    public AnAction getAnAction() {
        AnAction anAction2 = this.myAction.getAction();
        if (anAction2 == null) {
            ActionMenuItem.$$$reportNull$$$0(4);
        }
        return anAction2;
    }

    @NotNull
    public String getPlace() {
        String string = this.myPlace;
        if (string == null) {
            ActionMenuItem.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public MenuItem getScreenMenuItemPeer() {
        return this.myScreenMenuItemPeer;
    }

    private static boolean isEnterKeyStroke(KeyStroke keyStroke) {
        return keyStroke.getKeyCode() == 10 && keyStroke.getModifiers() == 0;
    }

    public void fireActionPerformed(ActionEvent event) {
        Application app2 = ApplicationManager.getApplication();
        if (!app2.isDisposed() && "MainMenu".equals(this.myPlace)) {
            MainMenuCollector.getInstance().record(this.myAction.getAction());
        }
        ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> super.fireActionPerformed(event));
    }

    private void init() {
        this.updateFromPresentation();
        AnAction action2 = this.myAction.getAction();
        String id2 = ActionManager.getInstance().getId(action2);
        if (id2 != null) {
            this.setAcceleratorFromShortcuts(KeymapUtil.getActiveKeymapShortcuts((String)id2).getShortcuts());
        } else {
            ShortcutSet shortcutSet = action2.getShortcutSet();
            this.setAcceleratorFromShortcuts(shortcutSet.getShortcuts());
        }
    }

    void updateFromPresentation() {
        this.setVisible(this.myPresentation.isVisible());
        this.setEnabled(this.myPresentation.isEnabled());
        this.setMnemonic(this.myPresentation.getMnemonic());
        this.setText(this.myPresentation.getText(this.myEnableMnemonics));
        this.setDisplayedMnemonicIndex(this.myPresentation.getDisplayedMnemonicIndex());
        this.updateIcon();
        if (this.myScreenMenuItemPeer != null) {
            this.myScreenMenuItemPeer.setLabel(this.getText(), this.getAccelerator());
            this.myScreenMenuItemPeer.setEnabled(this.isEnabled());
        }
    }

    public void setDisplayedMnemonicIndex(int index2) throws IllegalArgumentException {
        super.setDisplayedMnemonicIndex(this.myEnableMnemonics ? index2 : -1);
    }

    public void setMnemonic(int mnemonic) {
        super.setMnemonic(this.myEnableMnemonics ? mnemonic : 0);
    }

    private void setAcceleratorFromShortcuts(Shortcut @NotNull [] shortcuts) {
        if (shortcuts == null) {
            ActionMenuItem.$$$reportNull$$$0(6);
        }
        for (Shortcut shortcut : shortcuts) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyStroke firstKeyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            if (ActionMenuItem.isEnterKeyStroke(firstKeyStroke)) break;
            this.setAccelerator(firstKeyStroke);
            if (this.myScreenMenuItemPeer != null) {
                this.myScreenMenuItemPeer.setLabel(this.getText(), firstKeyStroke);
            }
            if (!KeymapUtil.isSimplifiedMacShortcuts()) break;
            String shortcutText = KeymapUtil.getPreferredShortcutText((Shortcut[])shortcuts);
            this.putClientProperty("accelerator.text", shortcutText);
            if (this.myScreenMenuItemPeer == null) break;
            this.myScreenMenuItemPeer.setAcceleratorText(shortcutText);
            break;
        }
    }

    public void updateUI() {
        this.setUI(BegMenuItemUI.createUI((JComponent)((Object)this)));
    }

    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
        ActionMenu.showDescriptionInStatusBar(isIncluded, (Component)((Object)this), this.myPresentation.getDescription());
    }

    @NlsSafe
    public String getFirstShortcutText() {
        return KeymapUtil.getFirstKeyboardShortcutText((AnAction)this.myAction.getAction());
    }

    private void updateIcon() {
        boolean bl = this.myToggled = this.isToggleable() && Toggleable.isSelected((Presentation)this.myPresentation);
        if (this.isToggleable() && (this.myPresentation.getIcon() == null || this.myInsideCheckedGroup || !UISettings.getInstance().getShowIconsInMenus())) {
            if ("MainMenu".equals(this.myPlace) && SystemInfo.isMacSystemMenu) {
                this.setState(this.myToggled);
                if (this.myScreenMenuItemPeer != null) {
                    this.myScreenMenuItemPeer.setState(this.myToggled);
                }
                this.setIcon(this.wrapNullIcon(this.getIcon()));
            } else if (this.myToggled) {
                this.setIcon(LafIconLookup.getIcon((String)"checkmark"));
                this.setSelectedIcon(LafIconLookup.getSelectedIcon((String)"checkmark"));
                this.setDisabledIcon(LafIconLookup.getDisabledIcon((String)"checkmark"));
            } else {
                this.setIcon(EmptyIcon.ICON_16);
                this.setSelectedIcon(EmptyIcon.ICON_16);
                this.setDisabledIcon(EmptyIcon.ICON_16);
            }
        } else if (UISettings.getInstance().getShowIconsInMenus()) {
            Icon selected2;
            Icon disabled;
            Icon icon2 = this.myPresentation.getIcon();
            if (this.isToggleable() && this.myToggled) {
                icon2 = new PoppedIcon(icon2, 16, 16);
            }
            if ((disabled = this.myPresentation.getDisabledIcon()) == null) {
                Icon icon3 = disabled = icon2 == null ? null : IconLoader.getDisabledIcon((Icon)icon2);
            }
            if ((selected2 = this.myPresentation.getSelectedIcon()) == null) {
                selected2 = icon2;
            }
            this.setIcon(this.wrapNullIcon(this.myPresentation.isEnabled() ? icon2 : disabled));
            this.setSelectedIcon(this.wrapNullIcon(selected2));
            this.setDisabledIcon(this.wrapNullIcon(disabled));
        }
    }

    private Icon wrapNullIcon(Icon icon2) {
        if (ActionMenu.isShowNoIcons()) {
            return null;
        }
        if (!ActionMenu.isAligned() || !ActionMenu.isAlignedInGroup()) {
            return icon2;
        }
        if (icon2 == null && SystemInfo.isMacSystemMenu && "MainMenu".equals(this.myPlace)) {
            return EMPTY_ICON;
        }
        return icon2;
    }

    public void setIcon(Icon icon2) {
        if (SystemInfo.isMacSystemMenu && "MainMenu".equals(this.myPlace) && icon2 != null) {
            icon2 = IconLoader.getMenuBarIcon((Icon)icon2, (boolean)this.myUseDarkIcons);
        }
        super.setIcon(icon2);
        if (this.myScreenMenuItemPeer != null) {
            this.myScreenMenuItemPeer.setIcon(icon2);
        }
    }

    public boolean isToggleable() {
        return this.myToggleable;
    }

    public boolean isSelected() {
        return this.myToggled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionMenuItem";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcuts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionMenuItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setAcceleratorFromShortcuts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ActionTransmitter
    implements ActionListener {
        private ActionTransmitter() {
        }

        void performAction(int modifiers) {
            IdeFocusManager focusManager = IdeFocusManager.findInstanceByContext((DataContext)ActionMenuItem.this.myContext);
            String id2 = ActionManager.getInstance().getId(ActionMenuItem.this.myAction.getAction());
            if (id2 != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("context.menu.click.stats." + id2.replace(' ', '.'));
            }
            focusManager.runOnOwnContext(ActionMenuItem.this.myContext, () -> {
                AWTEvent currentEvent = IdeEventQueue.getInstance().getTrueCurrentEvent();
                AnActionEvent event = new AnActionEvent(currentEvent instanceof InputEvent ? (InputEvent)currentEvent : null, ActionMenuItem.this.myContext, ActionMenuItem.this.myPlace, ActionMenuItem.this.myPresentation, ActionManager.getInstance(), modifiers, true, false);
                AnAction menuItemAction = ActionMenuItem.this.myAction.getAction();
                if (ActionUtil.lastUpdateAndCheckDumb((AnAction)menuItemAction, (AnActionEvent)event, (boolean)false)) {
                    ActionUtil.performActionDumbAwareWithCallbacks((AnAction)menuItemAction, (AnActionEvent)event);
                }
            });
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            if (e == null) {
                ActionTransmitter.$$$reportNull$$$0(0);
            }
            this.performAction(e.getModifiers());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/impl/ActionMenuItem$ActionTransmitter", "actionPerformed"));
        }
    }
}

