/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.Border;

public class ActionToolbarBorder
implements Border {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Rectangle rect = new Rectangle(x, y, width, height);
            JBInsets.removeFrom((Rectangle)rect, (Insets)JBUI.insets((int)1));
            g2.setColor(JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)false));
            float arc = DarculaUIUtil.BUTTON_ARC.getFloat();
            float lw = DarculaUIUtil.LW.getFloat();
            Path2D.Float border = new Path2D.Float(0);
            border.append(new RoundRectangle2D.Float(rect.x, rect.y, rect.width, rect.height, arc, arc), false);
            border.append(new RoundRectangle2D.Float((float)rect.x + lw, (float)rect.y + lw, (float)rect.width - lw * 2.0f, (float)rect.height - lw * 2.0f, arc - lw, arc - lw), false);
            g2.fill(border);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return JBUI.insets((int)2);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public static void setOutlined(ActionToolbar toolbar, boolean outlined) {
        toolbar.getComponent().setBorder(outlined ? new ActionToolbarBorder() : JBUI.Borders.empty((int)2));
    }
}

