/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionUpdateEdtExecutor {
    public static <T> T computeOnEdt(@NotNull Supplier<? extends T> supplier2) {
        if (supplier2 == null) {
            ActionUpdateEdtExecutor.$$$reportNull$$$0(0);
        }
        return ActionUpdateEdtExecutor.computeOnEdt(supplier2, null);
    }

    static <T> T computeOnEdt(@NotNull Supplier<? extends T> supplier2, @Nullable Consumer<Runnable> laterInvocator) {
        Application application;
        if (supplier2 == null) {
            ActionUpdateEdtExecutor.$$$reportNull$$$0(1);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread()) {
            return supplier2.get();
        }
        Semaphore semaphore = new Semaphore(1);
        ProgressIndicator indicator2 = ProgressIndicatorProvider.getGlobalProgressIndicator();
        Ref result2 = Ref.create();
        Ref error = Ref.create();
        Runnable runnable2 = () -> {
            try {
                if (indicator2 == null || !indicator2.isCanceled()) {
                    result2.set(supplier2.get());
                }
            }
            catch (Throwable ex) {
                error.set((Object)ex);
            }
            finally {
                semaphore.up();
            }
        };
        if (laterInvocator != null) {
            laterInvocator.accept(runnable2);
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.any());
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled(semaphore, indicator2);
        ExceptionUtil.rethrowAllAsUnchecked((Throwable)((Throwable)error.get()));
        ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled(indicator2);
        return (T)result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supplier", "com/intellij/openapi/actionSystem/impl/ActionUpdateEdtExecutor", "computeOnEdt"));
    }
}

