/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.InjectedDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.reference.SoftReference;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.keyFMap.KeyFMap;
import java.awt.Component;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EdtDataContext
implements DataContext,
UserDataHolder,
AnActionEvent.InjectedDataContextSupplier {
    private static final Logger LOG = Logger.getInstance(EdtDataContext.class);
    private int myEventCount;
    private final Reference<Component> myRef;
    private final Ref<KeyFMap> myUserData;
    private final DataManagerImpl myManager;
    private final Map<String, Object> myCachedData;
    private static final Set<String> ourSafeKeys = ContainerUtil.set((Object[])new String[]{CommonDataKeys.PROJECT.getName(), CommonDataKeys.EDITOR.getName(), PlatformCoreDataKeys.IS_MODAL_CONTEXT.getName(), PlatformCoreDataKeys.CONTEXT_COMPONENT.getName(), PlatformDataKeys.MODALITY_STATE.getName()});

    public EdtDataContext(@Nullable Component component2) {
        this.myEventCount = -1;
        this.myRef = component2 == null ? null : new WeakReference<Component>(component2);
        this.myCachedData = ContainerUtil.createWeakValueMap();
        this.myUserData = Ref.create((Object)KeyFMap.EMPTY_MAP);
        this.myManager = (DataManagerImpl)DataManager.getInstance();
    }

    private EdtDataContext(@Nullable Reference<Component> compRef, @NotNull Map<String, Object> cachedData, @NotNull Ref<KeyFMap> userData, @NotNull DataManagerImpl manager2, int eventCount) {
        if (cachedData == null) {
            EdtDataContext.$$$reportNull$$$0(0);
        }
        if (userData == null) {
            EdtDataContext.$$$reportNull$$$0(1);
        }
        if (manager2 == null) {
            EdtDataContext.$$$reportNull$$$0(2);
        }
        this.myRef = compRef;
        this.myCachedData = cachedData;
        this.myUserData = userData;
        this.myManager = manager2;
        this.myEventCount = eventCount;
    }

    @NotNull
    public DataContext getInjectedDataContext() {
        return this instanceof InjectedDataContext ? this : new InjectedDataContext(this.myRef, this.myCachedData, this.myUserData, this.myManager, this.myEventCount);
    }

    public void setEventCount(int eventCount) {
        assert (ReflectionUtil.getCallerClass((int)3) == IdeKeyEventDispatcher.class) : "This method might be accessible from " + IdeKeyEventDispatcher.class.getName() + " only";
        this.myCachedData.clear();
        this.myEventCount = eventCount;
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        Object answer;
        boolean cacheable;
        if (dataId == null) {
            EdtDataContext.$$$reportNull$$$0(3);
        }
        ProgressManager.checkCanceled();
        boolean bl = cacheable = Registry.is((String)"actionSystem.cache.data") || ourSafeKeys.contains(dataId);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            int currentEventCount = IdeEventQueue.getInstance().getEventCount();
            if (this.myEventCount != -1 && this.myEventCount != currentEventCount) {
                LOG.error("cannot share data context between Swing events; initial event count = " + this.myEventCount + "; current event count = " + currentEventCount);
                cacheable = false;
            }
        }
        Object object = answer = cacheable ? this.myCachedData.get(dataId) : null;
        if (answer != null) {
            return answer != NullResult.INSTANCE ? answer : null;
        }
        answer = this.doGetData(dataId);
        if (cacheable && !(answer instanceof Stream)) {
            this.myCachedData.put(dataId, answer == null ? NullResult.INSTANCE : answer);
        }
        return answer;
    }

    @Nullable
    private Object doGetData(@NotNull String dataId) {
        if (dataId == null) {
            EdtDataContext.$$$reportNull$$$0(4);
        }
        Component component2 = (Component)SoftReference.dereference(this.myRef);
        if (PlatformCoreDataKeys.IS_MODAL_CONTEXT.is(dataId)) {
            if (component2 == null) {
                return null;
            }
            return IdeKeyEventDispatcher.isModalContext(component2);
        }
        if (PlatformCoreDataKeys.CONTEXT_COMPONENT.is(dataId)) {
            return component2;
        }
        if (PlatformDataKeys.MODALITY_STATE.is(dataId)) {
            return component2 != null ? ModalityState.stateForComponent((Component)component2) : ModalityState.NON_MODAL;
        }
        Object data2 = this.calcData(dataId, component2);
        if (CommonDataKeys.EDITOR.is(dataId) || CommonDataKeys.HOST_EDITOR.is(dataId)) {
            return DataManagerImpl.validateEditor((Editor)data2, component2);
        }
        return data2;
    }

    @Nullable
    protected Object calcData(@NotNull String dataId, @Nullable Component component2) {
        if (dataId == null) {
            EdtDataContext.$$$reportNull$$$0(5);
        }
        GetDataRule rule = this.myManager.getDataRule(dataId);
        try (AccessToken ignored = ProhibitAWTEvents.start("getData");){
            for (Component c = component2; c != null; c = c.getParent()) {
                Object data2;
                DataProvider dataProvider = DataManagerImpl.getDataProviderEx(c);
                if (dataProvider == null || (data2 = this.myManager.getDataFromProvider(dataProvider, dataId, null, rule)) == null) continue;
                Object object = data2;
                return object;
            }
        }
        return null;
    }

    @Nullable
    Object getRawDataIfCached(@NotNull String dataId) {
        Object data2;
        if (dataId == null) {
            EdtDataContext.$$$reportNull$$$0(6);
        }
        return (data2 = this.myCachedData.get(dataId)) == NullResult.INSTANCE ? null : data2;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            EdtDataContext.$$$reportNull$$$0(7);
        }
        return (T)((KeyFMap)this.myUserData.get()).get(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            EdtDataContext.$$$reportNull$$$0(8);
        }
        KeyFMap map2 = (KeyFMap)this.myUserData.get();
        this.myUserData.set((Object)(value2 == null ? map2.minus(key) : map2.plus(key, value2)));
    }

    @NonNls
    public String toString() {
        return (this instanceof InjectedDataContext ? "injected:" : "") + "component=" + SoftReference.dereference(this.myRef);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/actionSystem/impl/EdtDataContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "calcData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getRawDataIfCached";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getUserData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "putUserData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InjectedDataContext
    extends EdtDataContext {
        InjectedDataContext(@Nullable Reference<Component> compRef, @NotNull Map<String, Object> cachedData, @NotNull Ref<KeyFMap> userData, @NotNull DataManagerImpl manager2, int eventCount) {
            if (cachedData == null) {
                InjectedDataContext.$$$reportNull$$$0(0);
            }
            if (userData == null) {
                InjectedDataContext.$$$reportNull$$$0(1);
            }
            if (manager2 == null) {
                InjectedDataContext.$$$reportNull$$$0(2);
            }
            super(compRef, cachedData, userData, manager2, eventCount);
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            String injectedId;
            if (dataId == null) {
                InjectedDataContext.$$$reportNull$$$0(3);
            }
            Object injected = (injectedId = InjectedDataKeys.injectedId((String)dataId)) != null ? super.getData(injectedId) : null;
            return injected != null ? injected : super.getData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cachedData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/actionSystem/impl/EdtDataContext$InjectedDataContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum NullResult {
        INSTANCE;

    }
}

