/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public final class PopupMenuPreloader
implements Runnable {
    private static final Logger LOG = Logger.getInstance(PopupMenuPreloader.class);
    private static int ourEditorContextMenuPreloadCount;
    private final Supplier<? extends ActionGroup> myGroupSupplier;
    private final String myPlace;
    private final WeakReference<JComponent> myComponentRef;
    private final WeakReference<PopupHandler> myPopupHandlerRef;
    private int myRetries;
    private boolean myDisposed;

    public static void install(final @NotNull JComponent component2, @NotNull String actionPlace, @Nullable PopupHandler popupHandler2, @NotNull Supplier<? extends ActionGroup> groupSupplier) {
        if (component2 == null) {
            PopupMenuPreloader.$$$reportNull$$$0(0);
        }
        if (actionPlace == null) {
            PopupMenuPreloader.$$$reportNull$$$0(1);
        }
        if (groupSupplier == null) {
            PopupMenuPreloader.$$$reportNull$$$0(2);
        }
        if (component2 instanceof EditorComponentImpl && ourEditorContextMenuPreloadCount > 4) {
            return;
        }
        final Runnable runnable2 = () -> {
            if (popupHandler2 != null && !ArrayUtil.contains((Object)popupHandler2, (Object[])component2.getMouseListeners()) || component2 instanceof EditorComponentImpl && !EditorUtil.isRealFileEditor(((EditorComponentImpl)component2).getEditor())) {
                return;
            }
            PopupMenuPreloader preloader = new PopupMenuPreloader(component2, actionPlace, popupHandler2, groupSupplier);
            IdeEventQueue.getInstance().addIdleListener(preloader, 2000);
        };
        UiNotifyConnector.doWhenFirstShown((JComponent)component2, (Runnable)runnable2);
        if (component2 instanceof JMenuBar) {
            return;
        }
        component2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                component2.removeFocusListener(this);
                runnable2.run();
            }
        });
    }

    private PopupMenuPreloader(@NotNull JComponent component2, @NotNull String actionPlace, @Nullable PopupHandler popupHandler2, @NotNull Supplier<? extends ActionGroup> groupSupplier) {
        if (component2 == null) {
            PopupMenuPreloader.$$$reportNull$$$0(3);
        }
        if (actionPlace == null) {
            PopupMenuPreloader.$$$reportNull$$$0(4);
        }
        if (groupSupplier == null) {
            PopupMenuPreloader.$$$reportNull$$$0(5);
        }
        this.myComponentRef = new WeakReference<JComponent>(component2);
        this.myPopupHandlerRef = popupHandler2 == null ? null : new WeakReference<PopupHandler>(popupHandler2);
        this.myGroupSupplier = groupSupplier;
        this.myPlace = actionPlace;
    }

    @Override
    public void run() {
        PopupHandler popupHandler2;
        JComponent component2 = (JComponent)this.myComponentRef.get();
        PopupHandler popupHandler3 = popupHandler2 = this.myPopupHandlerRef == null ? null : (PopupHandler)this.myPopupHandlerRef.get();
        if (component2 == null || !component2.isShowing() || this.myPopupHandlerRef != null && (popupHandler2 == null || !ArrayUtil.contains((Object)popupHandler2, (Object[])component2.getMouseListeners()))) {
            this.dispose(-1L);
            return;
        }
        ActionGroup actionGroup2 = this.myGroupSupplier.get();
        if (actionGroup2 == null) {
            this.dispose(-1L);
            return;
        }
        Component contextComponent = "MainMenu".equals(this.myPlace) ? IJSwingUtilities.getFocusedComponentInWindowOrSelf(component2) : component2;
        DataContext dataContext = Utils.wrapToAsyncDataContext(DataManager.getInstance().getDataContext(contextComponent));
        boolean isInModalContext = ModalityState.stateForComponent((Component)component2).dominates(ModalityState.NON_MODAL);
        long start2 = System.nanoTime();
        ++this.myRetries;
        CancellablePromise<List<AnAction>> promise = Utils.expandActionGroupAsync(isInModalContext, actionGroup2, new PresentationFactory(), dataContext, this.myPlace);
        promise.onSuccess(__ -> this.dispose(TimeoutUtil.getDurationMillis((long)start2)));
        promise.onError(__ -> {
            int retries = Math.max(1, Registry.intValue((String)"actionSystem.update.actions.max.retries", (int)20));
            if (this.myRetries > retries) {
                this.dispose(-1L);
            }
        });
    }

    private void dispose(long millis) {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        IdeEventQueue.getInstance().removeIdleListener(this);
        if (millis != -1L) {
            ActionGroup group2;
            if (this.myComponentRef.get() instanceof EditorComponentImpl) {
                ++ourEditorContextMenuPreloadCount;
            }
            String text2 = (group2 = this.myGroupSupplier.get()) == null ? null : group2.getTemplateText();
            LOG.info("Popup menu " + (String)(text2 == null ? "" : "'" + text2 + "' ") + "preloaded at '" + this.myPlace + "' in " + millis + " ms");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionPlace";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupSupplier";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/actionSystem/impl/PopupMenuPreloader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

