/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.impl.DataValidators;
import com.intellij.ide.impl.FreezingDataContext;
import com.intellij.ide.impl.dataRules.FileEditorRule;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.InjectedDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.AsyncDataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.keyFMap.KeyFMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreCachedDataContext
implements AsyncDataContext,
UserDataHolder,
AnActionEvent.InjectedDataContextSupplier,
FreezingDataContext {
    private static int ourPrevMapEventCount;
    private static final Map<Component, Map<String, Object>> ourPrevMaps;
    private final AtomicReference<KeyFMap> myUserData;
    private final Map<String, Object> myCachedData;
    private final Consumer<? super String> myMissedKeysIfFrozen;
    private static final GetDataRule ourFileEditorRule;

    PreCachedDataContext(@Nullable Component component2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myMissedKeysIfFrozen = null;
        this.myUserData = new AtomicReference<KeyFMap>(KeyFMap.EMPTY_MAP);
        try (AccessToken ignored = ProhibitAWTEvents.start("getData");){
            int count = IdeEventQueue.getInstance().getEventCount();
            if (ourPrevMapEventCount != count) {
                ourPrevMaps.clear();
            }
            if (component2 == null) {
                this.myCachedData = ContainerUtil.createConcurrentWeakValueMap();
                this.myCachedData.put(PlatformDataKeys.MODALITY_STATE.getName(), ModalityState.NON_MODAL);
                return;
            }
            Map<String, Object> prevMap = ourPrevMaps.get(component2);
            if (prevMap != null) {
                this.myCachedData = prevMap;
                return;
            }
            this.myCachedData = new ConcurrentHashMap<String, Object>();
            PreCachedDataContext.preGetAllData(component2, this.myCachedData);
            ourPrevMapEventCount = count;
            ourPrevMaps.put(component2, this.myCachedData);
        }
    }

    private PreCachedDataContext(@NotNull Map<String, Object> cachedData, @NotNull AtomicReference<KeyFMap> userData, @Nullable Consumer<? super String> missedKeys) {
        if (cachedData == null) {
            PreCachedDataContext.$$$reportNull$$$0(0);
        }
        if (userData == null) {
            PreCachedDataContext.$$$reportNull$$$0(1);
        }
        this.myCachedData = cachedData;
        this.myUserData = userData;
        this.myMissedKeysIfFrozen = missedKeys;
    }

    @NotNull
    final PreCachedDataContext frozenCopy(@Nullable Consumer<? super String> missedKeys) {
        Consumer<String> missedKeysNotNull = missedKeys == null ? s -> {} : missedKeys;
        return this instanceof InjectedDataContext ? new InjectedDataContext(this.myCachedData, this.myUserData, missedKeysNotNull) : new PreCachedDataContext(this.myCachedData, this.myUserData, missedKeysNotNull);
    }

    @NotNull
    public final DataContext getInjectedDataContext() {
        return this instanceof InjectedDataContext ? this : new InjectedDataContext(this.myCachedData, this.myUserData, this.myMissedKeysIfFrozen);
    }

    @Override
    public boolean isFrozenDataContext() {
        return this.myMissedKeysIfFrozen != null;
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            PreCachedDataContext.$$$reportNull$$$0(2);
        }
        ProgressManager.checkCanceled();
        Object answer = this.myCachedData.get(dataId);
        if (answer != null && answer != NullResult.Initial) {
            if (answer == NullResult.Final) {
                return null;
            }
            if ((answer = DataValidators.validOrNull(answer, dataId, this)) != null) {
                return answer;
            }
        } else if (answer == null) {
            return null;
        }
        if (this.myMissedKeysIfFrozen != null) {
            this.myMissedKeysIfFrozen.accept(dataId);
            return null;
        }
        DataManagerImpl dataManager = (DataManagerImpl)DataManager.getInstance();
        GetDataRule rule = dataManager.getDataRule(dataId);
        answer = rule == null ? null : dataManager.getDataFromProvider(dataId2 -> {
            Object o = dataId2 == dataId ? null : this.myCachedData.get(dataId2);
            return o == NullResult.Initial || o == NullResult.Final ? null : o;
        }, dataId, null, rule);
        this.myCachedData.put(dataId, answer == null || answer == NullResult.Initial ? NullResult.Final : answer);
        return answer;
    }

    @Nullable
    Object getRawDataIfCached(@NotNull String dataId) {
        Object data2;
        if (dataId == null) {
            PreCachedDataContext.$$$reportNull$$$0(3);
        }
        return (data2 = this.myCachedData.get(dataId)) == NullResult.Initial || data2 == NullResult.Final ? null : data2;
    }

    static void clearAllCaches() {
        for (Map<String, Object> map2 : ourPrevMaps.values()) {
            map2.clear();
        }
        ourPrevMaps.clear();
    }

    private static void preGetAllData(@NotNull Component component2, @NotNull Map<String, Object> cachedData) {
        long time;
        if (component2 == null) {
            PreCachedDataContext.$$$reportNull$$$0(4);
        }
        if (cachedData == null) {
            PreCachedDataContext.$$$reportNull$$$0(5);
        }
        long start2 = System.currentTimeMillis();
        DataManagerImpl dataManager = (DataManagerImpl)DataManager.getInstance();
        ArrayList slowProviders = new ArrayList();
        cachedData.put(PlatformCoreDataKeys.CONTEXT_COMPONENT.getName(), component2);
        cachedData.put(PlatformDataKeys.MODALITY_STATE.getName(), ModalityState.stateForComponent((Component)component2));
        cachedData.put(PlatformCoreDataKeys.IS_MODAL_CONTEXT.getName(), IdeKeyEventDispatcher.isModalContext(component2));
        cachedData.put(PlatformCoreDataKeys.SLOW_DATA_PROVIDERS.getName(), slowProviders);
        DataKey<?>[] keys2 = DataKey.allKeys();
        BitSet computed = new BitSet(keys2.length);
        for (Component c = component2; c != null; c = c.getParent()) {
            DataProvider dataProvider = DataManagerImpl.getDataProviderEx(c);
            if (dataProvider == null) continue;
            for (int i2 = 0; i2 < keys2.length; ++i2) {
                Object data2;
                DataKey<?> key = keys2[i2];
                if (key == PlatformCoreDataKeys.IS_MODAL_CONTEXT || key == PlatformCoreDataKeys.CONTEXT_COMPONENT || key == PlatformDataKeys.MODALITY_STATE) continue;
                boolean alreadyComputed = computed.get(i2);
                Object object = data2 = !alreadyComputed || key == PlatformCoreDataKeys.SLOW_DATA_PROVIDERS ? dataManager.getDataFromProvider(dataProvider, key.getName(), null, PreCachedDataContext.getFastDataRule(key)) : null;
                if (key == CommonDataKeys.EDITOR || key == CommonDataKeys.HOST_EDITOR) {
                    data2 = DataManagerImpl.validateEditor((Editor)data2, component2);
                }
                if (data2 == null) continue;
                computed.set(i2, true);
                if (key == PlatformCoreDataKeys.SLOW_DATA_PROVIDERS) {
                    ContainerUtil.addAll(slowProviders, (Iterable)((Iterable)data2));
                    continue;
                }
                cachedData.put(key.getName(), data2);
            }
        }
        for (int i3 = 0; i3 < keys2.length; ++i3) {
            DataKey<?> key = keys2[i3];
            if (computed.get(i3) || key == PlatformCoreDataKeys.IS_MODAL_CONTEXT || key == PlatformCoreDataKeys.CONTEXT_COMPONENT || key == PlatformDataKeys.MODALITY_STATE || key == PlatformCoreDataKeys.SLOW_DATA_PROVIDERS) continue;
            cachedData.put(key.getName(), (Object)NullResult.Initial);
        }
        if (cachedData.get(CommonDataKeys.PROJECT.getName()) == NullResult.Initial) {
            cachedData.put(CommonDataKeys.PROJECT.getName(), (Object)NullResult.Final);
        }
        if ((time = System.currentTimeMillis() - start2) > 200L) {
            // empty if block
        }
    }

    @Nullable
    private static GetDataRule getFastDataRule(@NotNull DataKey<?> key) {
        if (key == null) {
            PreCachedDataContext.$$$reportNull$$$0(6);
        }
        return key == PlatformCoreDataKeys.FILE_EDITOR ? ourFileEditorRule : null;
    }

    public String toString() {
        return (this instanceof InjectedDataContext ? "injected:" : "") + (this.myMissedKeysIfFrozen != null ? "frozen:" : "") + "component=" + this.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            PreCachedDataContext.$$$reportNull$$$0(7);
        }
        return (T)this.myUserData.get().get(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        KeyFMap map2;
        KeyFMap newMap;
        if (key == null) {
            PreCachedDataContext.$$$reportNull$$$0(8);
        }
        do {
            map2 = this.myUserData.get();
            KeyFMap keyFMap = newMap = value2 == null ? map2.minus(key) : map2.plus(key, value2);
        } while (newMap != map2 && !this.myUserData.compareAndSet(map2, newMap));
    }

    static {
        ourPrevMaps = ContainerUtil.createWeakKeySoftValueMap();
        for (KeyedLazyInstance instance2 : GetDataRule.EP_NAME.getExtensionList()) {
            DataKey.create(instance2.getKey());
        }
        ourFileEditorRule = new FileEditorRule();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userData";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/actionSystem/impl/PreCachedDataContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRawDataIfCached";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "preGetAllData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getFastDataRule";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getUserData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "putUserData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InjectedDataContext
    extends PreCachedDataContext {
        InjectedDataContext(@NotNull Map<String, Object> cachedData, @NotNull AtomicReference<KeyFMap> userData, @Nullable Consumer<? super String> missedKeys) {
            if (cachedData == null) {
                InjectedDataContext.$$$reportNull$$$0(0);
            }
            if (userData == null) {
                InjectedDataContext.$$$reportNull$$$0(1);
            }
            super(cachedData, userData, missedKeys);
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            String injectedId;
            if (dataId == null) {
                InjectedDataContext.$$$reportNull$$$0(2);
            }
            Object injected = (injectedId = InjectedDataKeys.injectedId((String)dataId)) != null ? super.getData(injectedId) : null;
            return injected != null ? injected : super.getData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cachedData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/actionSystem/impl/PreCachedDataContext$InjectedDataContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum NullResult {
        Initial,
        Final;

    }
}

