/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.impl.DataValidators;
import com.intellij.ide.impl.FreezingDataContext;
import com.intellij.ide.impl.dataRules.FileEditorRule;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.InjectedDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.AsyncDataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.reference.SoftReference;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.UnsafeWeakList;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreCachedDataContext2
implements AsyncDataContext,
UserDataHolder,
AnActionEvent.InjectedDataContextSupplier,
FreezingDataContext {
    private static int ourPrevMapEventCount;
    private static final Map<Component, FList<ProviderData>> ourPrevMaps;
    private static final Collection<PreCachedDataContext2> ourInstances;
    private static final Map<String, Integer> ourDataKeysIndices;
    private static final AtomicInteger ourDataKeysCount;
    private static final Object ourExplicitNull;
    private final ComponentRef myComponentRef;
    private final AtomicReference<KeyFMap> myUserData;
    private final FList<ProviderData> myCachedData;
    private final Consumer<? super String> myMissedKeysIfFrozen;
    private final int myDataKeysCount;
    private static final GetDataRule ourFileEditorRule;

    PreCachedDataContext2(@Nullable Component component2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myComponentRef = new ComponentRef(component2);
        this.myMissedKeysIfFrozen = null;
        this.myUserData = new AtomicReference<KeyFMap>(KeyFMap.EMPTY_MAP);
        if (component2 == null) {
            this.myCachedData = FList.emptyList();
            this.myDataKeysCount = 0;
            return;
        }
        try (AccessToken ignored = ProhibitAWTEvents.start("getData");){
            List components;
            int count = IdeEventQueue.getInstance().getEventCount();
            if (ourPrevMapEventCount != count) {
                ourPrevMaps.clear();
            }
            Component topParent = (components = ContainerUtil.reverse((List)UIUtil.uiParents((Component)component2, (boolean)false).takeWhile(o -> ourPrevMaps.get(o) == null).toList())).isEmpty() ? component2 : ((Component)components.get(0)).getParent();
            FList<ProviderData> initial = topParent == null ? FList.emptyList() : ourPrevMaps.get(topParent);
            DataKey<?>[] keys2 = DataKey.allKeys();
            this.myDataKeysCount = keys2.length;
            if (ourDataKeysIndices.size() < this.myDataKeysCount) {
                for (DataKey<?> key : keys2) {
                    ourDataKeysIndices.computeIfAbsent(key.getName(), __ -> ourDataKeysCount.getAndIncrement());
                }
            }
            if (components.isEmpty()) {
                this.myCachedData = initial;
            } else {
                this.myCachedData = PreCachedDataContext2.preGetAllData(components, initial, keys2);
                ourInstances.add(this);
            }
            ourPrevMapEventCount = count;
        }
    }

    private PreCachedDataContext2(@NotNull ComponentRef compRef, @NotNull FList<ProviderData> cachedData, @NotNull AtomicReference<KeyFMap> userData, @Nullable Consumer<? super String> missedKeys, int dataKeysCount) {
        if (compRef == null) {
            PreCachedDataContext2.$$$reportNull$$$0(0);
        }
        if (cachedData == null) {
            PreCachedDataContext2.$$$reportNull$$$0(1);
        }
        if (userData == null) {
            PreCachedDataContext2.$$$reportNull$$$0(2);
        }
        this.myComponentRef = compRef;
        this.myCachedData = cachedData;
        this.myUserData = userData;
        this.myMissedKeysIfFrozen = missedKeys;
        this.myDataKeysCount = dataKeysCount;
    }

    @NotNull
    final PreCachedDataContext2 frozenCopy(@Nullable Consumer<? super String> missedKeys) {
        Consumer<String> missedKeysNotNull = missedKeys == null ? s -> {} : missedKeys;
        return this instanceof InjectedDataContext ? new InjectedDataContext(this.myComponentRef, this.myCachedData, this.myUserData, missedKeysNotNull, this.myDataKeysCount) : new PreCachedDataContext2(this.myComponentRef, this.myCachedData, this.myUserData, missedKeysNotNull, this.myDataKeysCount);
    }

    @NotNull
    public final DataContext getInjectedDataContext() {
        return this instanceof InjectedDataContext ? this : new InjectedDataContext(this.myComponentRef, this.myCachedData, this.myUserData, this.myMissedKeysIfFrozen, this.myDataKeysCount);
    }

    @Override
    public boolean isFrozenDataContext() {
        return this.myMissedKeysIfFrozen != null;
    }

    @NotNull
    PreCachedDataContext2 prependProvider(@NotNull DataProvider dataProvider) {
        if (dataProvider == null) {
            PreCachedDataContext2.$$$reportNull$$$0(3);
        }
        DataKey<?>[] keys2 = DataKey.allKeys();
        DataManagerImpl dataManager = (DataManagerImpl)DataManager.getInstance();
        ProviderData cachedData = new ProviderData();
        Component component2 = (Component)SoftReference.dereference(this.myComponentRef.ref);
        PreCachedDataContext2.doPreGetAllData(dataProvider, cachedData, component2, dataManager, keys2, (Map)this.myCachedData.getHead());
        return new PreCachedDataContext2(this.myComponentRef, (FList<ProviderData>)this.myCachedData.prepend((Object)cachedData), new AtomicReference<KeyFMap>(KeyFMap.EMPTY_MAP), this.myMissedKeysIfFrozen, this.myDataKeysCount);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            PreCachedDataContext2.$$$reportNull$$$0(4);
        }
        if (PlatformCoreDataKeys.CONTEXT_COMPONENT.is(dataId)) {
            return SoftReference.dereference(this.myComponentRef.ref);
        }
        if (PlatformCoreDataKeys.IS_MODAL_CONTEXT.is(dataId)) {
            return this.myComponentRef.modalContext;
        }
        if (PlatformDataKeys.MODALITY_STATE.is(dataId)) {
            return this.myComponentRef.modalityState;
        }
        if (this.myCachedData.isEmpty()) {
            return null;
        }
        int keyIndex = ourDataKeysIndices.getOrDefault(dataId, -1);
        if (keyIndex == -1) {
            return null;
        }
        boolean rulesAllowed = this.myMissedKeysIfFrozen == null && !CommonDataKeys.PROJECT.is(dataId) && keyIndex < this.myDataKeysCount;
        DataManagerImpl dataManager = null;
        GetDataRule rule = null;
        Object answer = null;
        for (ProviderData map2 : this.myCachedData) {
            ProgressManager.checkCanceled();
            answer = map2.get(dataId);
            if (answer == ourExplicitNull) break;
            if (answer != null) {
                if ((answer = DataValidators.validOrNull(answer, dataId, this)) != null) break;
                map2.remove(dataId);
            }
            if (!rulesAllowed || map2.nullsByRules.get(keyIndex)) continue;
            if (dataManager == null) {
                dataManager = (DataManagerImpl)DataManager.getInstance();
                rule = dataManager.getDataRule(dataId);
            }
            Object object = answer = rule == null ? null : dataManager.getDataFromProvider(dataId2 -> {
                Object o = dataId2 == dataId ? null : map2.get(dataId2);
                return o == ourExplicitNull ? null : o;
            }, dataId, null, rule);
            if (answer == null) {
                map2.nullsByRules.set(keyIndex);
            } else {
                map2.put(dataId, answer);
            }
            if (answer == null) continue;
            break;
        }
        if (this.myMissedKeysIfFrozen != null && answer == null) {
            this.myMissedKeysIfFrozen.accept(dataId);
            return null;
        }
        return answer == ourExplicitNull ? null : answer;
    }

    @Nullable
    Object getRawDataIfCached(@NotNull String dataId) {
        if (dataId == null) {
            PreCachedDataContext2.$$$reportNull$$$0(5);
        }
        for (ProviderData map2 : this.myCachedData) {
            Object answer = map2.get(dataId);
            if (answer == null) continue;
            return answer;
        }
        return null;
    }

    static void clearAllCaches() {
        for (FList<ProviderData> list2 : ourPrevMaps.values()) {
            for (ProviderData map2 : list2) {
                map2.clear();
            }
        }
        ourPrevMaps.clear();
        for (PreCachedDataContext2 context2 : ourInstances) {
            for (ProviderData map2 : context2.myCachedData) {
                map2.clear();
            }
        }
        ourInstances.clear();
    }

    @NotNull
    private static FList<ProviderData> preGetAllData(@NotNull List<Component> components, @NotNull FList<ProviderData> initial, DataKey<?> @NotNull [] keys2) {
        if (components == null) {
            PreCachedDataContext2.$$$reportNull$$$0(6);
        }
        if (initial == null) {
            PreCachedDataContext2.$$$reportNull$$$0(7);
        }
        if (keys2 == null) {
            PreCachedDataContext2.$$$reportNull$$$0(8);
        }
        DataManagerImpl dataManager = (DataManagerImpl)DataManager.getInstance();
        FList result2 = initial;
        long start2 = System.currentTimeMillis();
        for (Component comp : components) {
            DataProvider dataProvider = DataManagerImpl.getDataProviderEx(comp);
            if (dataProvider == null && PreCachedDataContext2.hideEditor(comp)) {
                dataProvider = dataId -> null;
            }
            if (dataProvider == null) continue;
            ProviderData cachedData = new ProviderData();
            PreCachedDataContext2.doPreGetAllData(dataProvider, cachedData, comp, dataManager, keys2, (Map)result2.getHead());
            result2 = result2.prepend((Object)cachedData);
            ourPrevMaps.put(comp, (FList<ProviderData>)result2);
        }
        long time = System.currentTimeMillis() - start2;
        if (time > 200L) {
            // empty if block
        }
        FList fList = result2;
        if (fList == null) {
            PreCachedDataContext2.$$$reportNull$$$0(9);
        }
        return fList;
    }

    private static void doPreGetAllData(@NotNull DataProvider dataProvider, @NotNull ProviderData cachedData, @Nullable Component c, @NotNull DataManagerImpl dataManager, DataKey<?> @NotNull [] keys2, @Nullable Map<String, Object> parentMap) {
        if (dataProvider == null) {
            PreCachedDataContext2.$$$reportNull$$$0(10);
        }
        if (cachedData == null) {
            PreCachedDataContext2.$$$reportNull$$$0(11);
        }
        if (dataManager == null) {
            PreCachedDataContext2.$$$reportNull$$$0(12);
        }
        if (keys2 == null) {
            PreCachedDataContext2.$$$reportNull$$$0(13);
        }
        boolean hideEditor = PreCachedDataContext2.hideEditor(c);
        for (DataKey<?> key : keys2) {
            Object data2;
            if (key == PlatformCoreDataKeys.IS_MODAL_CONTEXT || key == PlatformCoreDataKeys.CONTEXT_COMPONENT || key == PlatformDataKeys.MODALITY_STATE || key == PlatformCoreDataKeys.SLOW_DATA_PROVIDERS) continue;
            Object object = data2 = hideEditor && (key == CommonDataKeys.EDITOR || key == CommonDataKeys.HOST_EDITOR) ? ourExplicitNull : dataManager.getDataFromProvider(dataProvider, key.getName(), null, PreCachedDataContext2.getFastDataRule(key));
            if (data2 == null) continue;
            cachedData.put(key.getName(), data2);
        }
        String slowProvidersKeyName = PlatformCoreDataKeys.SLOW_DATA_PROVIDERS.getName();
        Object slowProviders = dataManager.getDataFromProvider(dataProvider, slowProvidersKeyName, null, null);
        if (slowProviders != null) {
            Object parentProviders = parentMap == null ? null : parentMap.get(slowProvidersKeyName);
            cachedData.put(slowProvidersKeyName, parentProviders == null ? slowProviders : ContainerUtil.concat((Iterable)((Iterable)slowProviders), (Iterable)((Iterable)parentProviders)));
        }
    }

    @Nullable
    private static GetDataRule getFastDataRule(@NotNull DataKey<?> key) {
        if (key == null) {
            PreCachedDataContext2.$$$reportNull$$$0(14);
        }
        return key == PlatformCoreDataKeys.FILE_EDITOR ? ourFileEditorRule : null;
    }

    private static boolean hideEditor(@Nullable Component component2) {
        return component2 instanceof JComponent && ((JComponent)component2).getClientProperty("AuxEditorComponent") != null;
    }

    public String toString() {
        return (this instanceof InjectedDataContext ? "injected:" : "") + (this.myMissedKeysIfFrozen != null ? "frozen:" : "") + "component=" + this.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            PreCachedDataContext2.$$$reportNull$$$0(15);
        }
        return (T)this.myUserData.get().get(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        KeyFMap map2;
        KeyFMap newMap;
        if (key == null) {
            PreCachedDataContext2.$$$reportNull$$$0(16);
        }
        do {
            map2 = this.myUserData.get();
            KeyFMap keyFMap = newMap = value2 == null ? map2.minus(key) : map2.plus(key, value2);
        } while (newMap != map2 && !this.myUserData.compareAndSet(map2, newMap));
    }

    static {
        ourPrevMaps = ContainerUtil.createWeakKeySoftValueMap();
        ourInstances = new UnsafeWeakList();
        ourDataKeysIndices = new ConcurrentHashMap<String, Integer>();
        ourDataKeysCount = new AtomicInteger();
        ourExplicitNull = ObjectUtils.sentinel((String)"explicit.null");
        for (KeyedLazyInstance instance2 : GetDataRule.EP_NAME.getExtensionList()) {
            DataKey.create(instance2.getKey());
        }
        ourFileEditorRule = new FileEditorRule();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compRef";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userData";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/PreCachedDataContext2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataManager";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/PreCachedDataContext2";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "preGetAllData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prependProvider";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRawDataIfCached";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "preGetAllData";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doPreGetAllData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFastDataRule";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ComponentRef {
        final Reference<Component> ref;
        final ModalityState modalityState;
        final Boolean modalContext;

        ComponentRef(@Nullable Component component2) {
            this.ref = component2 == null ? null : new WeakReference<Component>(component2);
            this.modalityState = component2 == null ? ModalityState.NON_MODAL : ModalityState.stateForComponent((Component)component2);
            this.modalContext = component2 == null ? null : Boolean.valueOf(IdeKeyEventDispatcher.isModalContext(component2));
        }
    }

    private static class ProviderData
    extends ConcurrentHashMap<String, Object> {
        final ConcurrentBitSet nullsByRules = ConcurrentBitSet.create();

        private ProviderData() {
        }
    }

    private static class InjectedDataContext
    extends PreCachedDataContext2 {
        InjectedDataContext(@NotNull ComponentRef compRef, @NotNull FList<ProviderData> cachedData, @NotNull AtomicReference<KeyFMap> userData, @Nullable Consumer<? super String> missedKeys, int dataKeysCount) {
            if (compRef == null) {
                InjectedDataContext.$$$reportNull$$$0(0);
            }
            if (cachedData == null) {
                InjectedDataContext.$$$reportNull$$$0(1);
            }
            if (userData == null) {
                InjectedDataContext.$$$reportNull$$$0(2);
            }
            super(compRef, cachedData, userData, missedKeys, dataKeysCount);
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            String injectedId;
            if (dataId == null) {
                InjectedDataContext.$$$reportNull$$$0(3);
            }
            Object injected = (injectedId = InjectedDataKeys.injectedId((String)dataId)) != null ? super.getData(injectedId) : null;
            return injected != null ? injected : super.getData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compRef";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cachedData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/actionSystem/impl/PreCachedDataContext2$InjectedDataContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

