/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.client;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.client.ClientSessionImpl;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.serviceContainer.ContainerUtilKt;
import com.intellij.serviceContainer.PrecomputedExtensionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J/\u0010\b\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u000eJ'\u0010\u000f\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0016\u00a2\u0006\u0002\u0010\u0010J'\u0010\u0011\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0016\u00a2\u0006\u0002\u0010\u0010J.\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\t0\u0013\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\nH\u0014JB\u0010\u0017\u001a\u001e\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00190\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004H\u0016J:\u0010!\u001a\u00020\"2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010\u0013H\u0016J\u001e\u0010)\u001a\u00020\"2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00132\u0006\u0010,\u001a\u00020-H\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006."}, d2={"Lcom/intellij/openapi/client/ClientAwareComponentManager;", "Lcom/intellij/serviceContainer/ComponentManagerImpl;", "parent", "setExtensionsRootArea", "", "(Lcom/intellij/serviceContainer/ComponentManagerImpl;Z)V", "getParent$intellij_platform_ide_impl", "()Lcom/intellij/serviceContainer/ComponentManagerImpl;", "getFromSelfOrCurrentSession", "T", "", "serviceClass", "Ljava/lang/Class;", "createIfNeeded", "(Ljava/lang/Class;Z)Ljava/lang/Object;", "getService", "(Ljava/lang/Class;)Ljava/lang/Object;", "getServiceIfCreated", "getServices", "", "includeLocal", "isPreInitialized", "component", "preloadServices", "Lkotlin/Pair;", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "modules", "Lkotlin/sequences/Sequence;", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "activityPrefix", "", "onlyIfAwait", "registerComponents", "", "app", "Lcom/intellij/openapi/application/Application;", "precomputedExtensionModel", "Lcom/intellij/serviceContainer/PrecomputedExtensionModel;", "listenerCallbacks", "Ljava/lang/Runnable;", "unloadServices", "services", "Lcom/intellij/openapi/components/ServiceDescriptor;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public abstract class ClientAwareComponentManager
extends ComponentManagerImpl {
    @Nullable
    private final ComponentManagerImpl parent;

    @Override
    @Nullable
    public <T> T getService(@NotNull Class<T> serviceClass) {
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        return this.getFromSelfOrCurrentSession(serviceClass, true);
    }

    @Override
    @Nullable
    public <T> T getServiceIfCreated(@NotNull Class<T> serviceClass) {
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        return this.getFromSelfOrCurrentSession(serviceClass, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T> List<T> getServices(@NotNull Class<T> serviceClass, boolean includeLocal) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        ClientSessionsManager clientSessionsManager = super.getService(ClientSessionsManager.class);
        Intrinsics.checkNotNull((Object)clientSessionsManager);
        ClientSessionsManager sessionsManager = clientSessionsManager;
        Iterable iterable = sessionsManager.getSessions(includeLocal);
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object e;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ClientSession it = (ClientSession)element$iv$iv;
            boolean bl2 = false;
            ClientSession clientSession = it;
            if (!(clientSession instanceof ClientSessionImpl)) {
                clientSession = null;
            }
            ClientSessionImpl clientSessionImpl = (ClientSessionImpl)clientSession;
            if ((clientSessionImpl != null ? (Object)clientSessionImpl.doGetService(serviceClass, true, false) : null) == null) continue;
            e = e;
            boolean bl3 = false;
            boolean bl4 = false;
            Object it$iv$iv = e;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final <T> T getFromSelfOrCurrentSession(Class<T> serviceClass, boolean createIfNeeded) {
        ClientSessionImpl session2;
        ClientSessionsManager sessionsManager;
        ClientSessionsManager clientSessionsManager;
        T fromSelf;
        T t = fromSelf = createIfNeeded ? super.getService(serviceClass) : super.getServiceIfCreated(serviceClass);
        if (fromSelf != null) {
            return fromSelf;
        }
        if (this.getContainerState().get() == ComponentManagerImpl.ContainerState.DISPOSE_COMPLETED) {
            if (createIfNeeded) {
                String string = serviceClass.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serviceClass.name");
                ContainerUtilKt.throwAlreadyDisposedError(string, this, ProgressIndicatorProvider.getGlobalProgressIndicator());
            }
            clientSessionsManager = super.doGetService(ClientSessionsManager.class, false);
        } else {
            clientSessionsManager = super.getService(ClientSessionsManager.class);
        }
        ClientSessionsManager clientSessionsManager2 = sessionsManager = clientSessionsManager;
        Object v4 = clientSessionsManager2 != null ? clientSessionsManager2.getSession(ClientId.Companion.getCurrent()) : null;
        if (!(v4 instanceof ClientSessionImpl)) {
            v4 = null;
        }
        ClientSessionImpl clientSessionImpl = session2 = (ClientSessionImpl)v4;
        return clientSessionImpl != null ? (T)clientSessionImpl.doGetService(serviceClass, createIfNeeded, false) : null;
    }

    @Override
    public void registerComponents(@NotNull Sequence<IdeaPluginDescriptorImpl> modules2, @Nullable Application app2, @Nullable PrecomputedExtensionModel precomputedExtensionModel, @Nullable List<? extends Runnable> listenerCallbacks) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        super.registerComponents(modules2, app2, precomputedExtensionModel, listenerCallbacks);
        ClientSessionsManager clientSessionsManager = super.getService(ClientSessionsManager.class);
        Intrinsics.checkNotNull((Object)clientSessionsManager);
        ClientSessionsManager sessionsManager = clientSessionsManager;
        for (ClientSession session2 : sessionsManager.getSessions(true)) {
            ClientSession clientSession = session2;
            if (!(clientSession instanceof ClientSessionImpl)) {
                clientSession = null;
            }
            ClientSessionImpl clientSessionImpl = (ClientSessionImpl)clientSession;
            if (clientSessionImpl == null) continue;
            clientSessionImpl.registerComponents(modules2, app2, precomputedExtensionModel, listenerCallbacks);
        }
    }

    @Override
    public void unloadServices(@NotNull List<ServiceDescriptor> services, @NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter(services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        super.unloadServices(services, pluginId);
        ClientSessionsManager clientSessionsManager = super.getService(ClientSessionsManager.class);
        Intrinsics.checkNotNull((Object)clientSessionsManager);
        ClientSessionsManager sessionsManager = clientSessionsManager;
        for (ClientSession session2 : sessionsManager.getSessions(true)) {
            ClientSession clientSession = session2;
            if (!(clientSession instanceof ClientSessionImpl)) {
                clientSession = null;
            }
            ClientSessionImpl clientSessionImpl = (ClientSessionImpl)clientSession;
            if (clientSessionImpl == null) continue;
            clientSessionImpl.unloadServices(services, pluginId);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<CompletableFuture<Void>, CompletableFuture<Void>> preloadServices(@NotNull Sequence<IdeaPluginDescriptorImpl> modules2, @NotNull String activityPrefix, boolean onlyIfAwait) {
        void asyncPreloadFuture;
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        Intrinsics.checkNotNullParameter((Object)activityPrefix, (String)"activityPrefix");
        Pair<CompletableFuture<Void>, CompletableFuture<Void>> pair = super.preloadServices(modules2, activityPrefix, onlyIfAwait);
        CompletableFuture completableFuture = (CompletableFuture)pair.component1();
        CompletableFuture syncPreloadFuture = (CompletableFuture)pair.component2();
        ClientSessionsManager clientSessionsManager = super.getService(ClientSessionsManager.class);
        Intrinsics.checkNotNull((Object)clientSessionsManager);
        ClientSessionsManager sessionsManager = clientSessionsManager;
        boolean bl = false;
        List asyncPreloadFutures = new ArrayList();
        boolean bl2 = false;
        List syncPreloadFutures = new ArrayList();
        for (ClientSession session2 : sessionsManager.getSessions(true)) {
            void sessionAsyncPreloadFuture;
            ClientSession clientSession = session2;
            if (!(clientSession instanceof ClientSessionImpl)) {
                clientSession = null;
            }
            if ((ClientSessionImpl)clientSession == null) {
                continue;
            }
            Pair<CompletableFuture<Void>, CompletableFuture<Void>> pair2 = ((ClientSessionImpl)session2).preloadServices(modules2, activityPrefix, onlyIfAwait);
            CompletableFuture completableFuture2 = (CompletableFuture)pair2.component1();
            CompletableFuture sessionSyncPreloadFuture = (CompletableFuture)pair2.component2();
            asyncPreloadFutures.add(sessionAsyncPreloadFuture);
            syncPreloadFutures.add(sessionSyncPreloadFuture);
        }
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)asyncPreloadFuture);
        Collection $this$toTypedArray$iv = asyncPreloadFutures;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        if (completableFutureArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        spreadBuilder.addSpread((Object)completableFutureArray);
        CompletableFuture<Void> completableFuture3 = CompletableFuture.allOf((CompletableFuture[])spreadBuilder.toArray((Object[])new CompletableFuture[spreadBuilder.size()]));
        SpreadBuilder spreadBuilder2 = new SpreadBuilder(2);
        spreadBuilder2.add((Object)syncPreloadFuture);
        $this$toTypedArray$iv = syncPreloadFutures;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray2 = thisCollection$iv.toArray(new CompletableFuture[0]);
        if (completableFutureArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        spreadBuilder2.addSpread((Object)completableFutureArray2);
        return new Pair(completableFuture3, CompletableFuture.allOf((CompletableFuture[])spreadBuilder2.toArray((Object[])new CompletableFuture[spreadBuilder2.size()])));
    }

    @Override
    protected boolean isPreInitialized(@NotNull Object component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        return super.isPreInitialized(component2) || component2 instanceof ClientSessionsManager;
    }

    @Nullable
    public final ComponentManagerImpl getParent$intellij_platform_ide_impl() {
        return this.parent;
    }

    @JvmOverloads
    public ClientAwareComponentManager(@Nullable ComponentManagerImpl parent, boolean setExtensionsRootArea) {
        super(parent, setExtensionsRootArea);
        this.parent = parent;
    }

    public /* synthetic */ ClientAwareComponentManager(ComponentManagerImpl componentManagerImpl, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = componentManagerImpl == null;
        }
        this(componentManagerImpl, bl);
    }

    @JvmOverloads
    public ClientAwareComponentManager(@Nullable ComponentManagerImpl parent) {
        this(parent, false, 2, null);
    }
}

