/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;

class EditorAndState {
    private final FileEditorState myState;
    private final VirtualFile myVirtualFile;

    EditorAndState(FileEditor editor2, FileEditorState state) {
        this.myVirtualFile = editor2.getFile();
        this.myState = state;
    }

    public boolean canBeAppliedTo(FileEditor editor2) {
        if (editor2 == null) {
            return false;
        }
        if (!Objects.equals(this.myVirtualFile, editor2.getFile())) {
            return false;
        }
        if (this.myState == null) {
            return false;
        }
        FileEditorState currentState = editor2.getState(FileEditorStateLevel.UNDO);
        return this.myState.getClass() == currentState.getClass();
    }

    public FileEditorState getState() {
        return this.myState;
    }
}

