/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.DataManager;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandMerger;
import com.intellij.openapi.command.impl.DummyProject;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.MentionOnlyUndoableAction;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.SharedUndoRedoStacksHolder;
import com.intellij.openapi.command.impl.UndoProvider;
import com.intellij.openapi.command.impl.UndoRedo;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.DocumentReferenceProvider;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.CurrentEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.NonExtendable
public class UndoManagerImpl
extends UndoManager {
    private static final Logger LOG = Logger.getInstance(UndoManagerImpl.class);
    @TestOnly
    public static boolean ourNeverAskUser;
    private static final int COMMANDS_TO_KEEP_LIVE_QUEUES = 100;
    private static final int COMMAND_TO_RUN_COMPACT = 20;
    private static final int FREE_QUEUES_LIMIT = 30;
    @Nullable
    private final ProjectEx myProject;
    private CurrentEditorProvider myEditorProvider;
    private final SharedUndoRedoStacksHolder mySharedUndoStacksHolder = new SharedUndoRedoStacksHolder(true);
    private final SharedUndoRedoStacksHolder mySharedRedoStacksHolder = new SharedUndoRedoStacksHolder(false);

    public static boolean isRefresh() {
        return ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.class);
    }

    public static int getGlobalUndoLimit() {
        return Registry.intValue((String)"undo.globalUndoLimit");
    }

    public static int getDocumentUndoLimit() {
        return Registry.intValue((String)"undo.documentUndoLimit");
    }

    private UndoManagerImpl(@Nullable ComponentManager componentManager) {
        ProjectEx projectEx = this.myProject = componentManager instanceof ProjectEx ? (ProjectEx)componentManager : null;
        if (this.myProject != null && this.myProject.isDefault()) {
            return;
        }
        this.myEditorProvider = () -> ((CurrentEditorProvider)ApplicationManager.getApplication().getService(CurrentEditorProvider.class)).getCurrentEditor();
        MessageBus messageBus = this.myProject == null ? ApplicationManager.getApplication().getMessageBus() : this.myProject.getMessageBus();
        messageBus.connect().subscribe(CommandListener.TOPIC, (Object)new CommandListener(){
            private boolean myStarted;

            public void commandStarted(@NotNull CommandEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (UndoManagerImpl.this.myProject != null && UndoManagerImpl.this.myProject.isDisposed() || this.myStarted) {
                    return;
                }
                UndoManagerImpl.this.onCommandStarted(event.getProject(), event.getUndoConfirmationPolicy(), event.shouldRecordActionForOriginalDocument());
            }

            public void commandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (UndoManagerImpl.this.myProject != null && UndoManagerImpl.this.myProject.isDisposed() || this.myStarted) {
                    return;
                }
                UndoManagerImpl.this.onCommandFinished(event.getProject(), event.getCommandName(), event.getCommandGroupId());
            }

            public void undoTransparentActionStarted() {
                if (UndoManagerImpl.this.myProject != null && UndoManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (!UndoManagerImpl.this.isInsideCommand()) {
                    this.myStarted = true;
                    UndoManagerImpl.this.onCommandStarted(UndoManagerImpl.this.myProject, UndoConfirmationPolicy.DEFAULT, true);
                }
            }

            public void undoTransparentActionFinished() {
                if (UndoManagerImpl.this.myProject != null && UndoManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (this.myStarted) {
                    this.myStarted = false;
                    UndoManagerImpl.this.onCommandFinished(UndoManagerImpl.this.myProject, "", null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    private ClientState getClientState() {
        return (ClientState)this.getComponentManager().getService(ClientState.class);
    }

    private List<ClientState> getAllClientStates() {
        return this.getComponentManager().getServices(ClientState.class, true);
    }

    private ComponentManager getComponentManager() {
        return this.myProject != null ? this.myProject : ApplicationManager.getApplication();
    }

    private void invalidate(@NotNull ClientState state) {
        if (state == null) {
            UndoManagerImpl.$$$reportNull$$$0(0);
        }
        state.myMerger.flushCurrentCommand(state.nextCommandTimestamp(), state.myUndoStacksHolder);
        HashSet<DocumentReference> affected = new HashSet<DocumentReference>();
        state.myRedoStacksHolder.collectAllAffectedDocuments(affected);
        state.myRedoStacksHolder.clearStacks(true, affected);
        state.myUndoStacksHolder.collectAllAffectedDocuments(affected);
        state.myUndoStacksHolder.clearStacks(true, affected);
        this.mySharedRedoStacksHolder.trimStacks(affected);
        this.mySharedUndoStacksHolder.trimStacks(affected);
    }

    public boolean isActive() {
        ClientState state = this.getClientState();
        if (state == null) {
            return false;
        }
        return Comparing.equal((Object)this.myProject, (Object)state.myCurrentActionProject) || this.myProject == null && state.myCurrentActionProject.isDefault();
    }

    @ApiStatus.Internal
    public boolean isInsideCommand() {
        ClientState state = this.getClientState();
        if (state == null) {
            return false;
        }
        return state.myCommandLevel > 0;
    }

    @NotNull
    private List<UndoProvider> getUndoProviders() {
        List list2 = this.myProject == null ? UndoProvider.EP_NAME.getExtensionList() : UndoProvider.PROJECT_EP_NAME.getExtensionList((AreaInstance)this.myProject);
        if (list2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(1);
        }
        return list2;
    }

    private void onCommandStarted(Project project, UndoConfirmationPolicy undoConfirmationPolicy, boolean recordOriginalReference) {
        ClientState state = this.getClientState();
        if (state == null || state.myCommandLevel == 0) {
            for (UndoProvider undoProvider : this.getUndoProviders()) {
                undoProvider.commandStarted(project);
            }
            if (state != null) {
                state.myCurrentActionProject = project;
            }
        }
        this.commandStarted(undoConfirmationPolicy, this.myProject == project && recordOriginalReference);
        LOG.assertTrue(state == null || state.myCommandLevel == 0 || !(state.myCurrentActionProject instanceof DummyProject));
    }

    private void onCommandFinished(Project project, @NlsContexts.Command String commandName2, Object commandGroupId) {
        ClientState state = this.getClientState();
        this.commandFinished(commandName2, commandGroupId);
        if (state == null || state.myCommandLevel == 0) {
            for (UndoProvider undoProvider : this.getUndoProviders()) {
                undoProvider.commandFinished(project);
            }
            if (state != null) {
                state.myCurrentActionProject = DummyProject.getInstance();
            }
        }
        LOG.assertTrue(state == null || state.myCommandLevel == 0 || !(state.myCurrentActionProject instanceof DummyProject));
    }

    private void commandStarted(UndoConfirmationPolicy undoConfirmationPolicy, boolean recordOriginalReference) {
        ClientState state = this.getClientState();
        if (state == null) {
            return;
        }
        if (state.myCommandLevel == 0) {
            state.myCurrentMerger = new CommandMerger(this, CommandProcessor.getInstance().isUndoTransparentActionInProgress());
            if (recordOriginalReference && this.myProject != null) {
                Editor editor2 = null;
                Application application = ApplicationManager.getApplication();
                if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
                    editor2 = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext());
                } else {
                    FileEditor fileEditor = this.myEditorProvider.getCurrentEditor();
                    if (fileEditor instanceof TextEditor) {
                        editor2 = ((TextEditor)fileEditor).getEditor();
                    }
                }
                if (editor2 != null) {
                    Document document = editor2.getDocument();
                    VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
                    if (file2 != null && file2.isValid()) {
                        state.myOriginatorReference = DocumentReferenceManager.getInstance().create(file2);
                    }
                }
            }
        }
        LOG.assertTrue(state.myCurrentMerger != null, (Object)String.valueOf(state.myCommandLevel));
        state.myCurrentMerger.setBeforeState(this.getCurrentState());
        state.myCurrentMerger.mergeUndoConfirmationPolicy(undoConfirmationPolicy);
        ++state.myCommandLevel;
    }

    private void commandFinished(@NlsContexts.Command String commandName2, Object groupId2) {
        ClientState state = this.getClientState();
        if (state == null) {
            return;
        }
        if (state.myCommandLevel == 0) {
            return;
        }
        --state.myCommandLevel;
        if (state.myCommandLevel > 0) {
            return;
        }
        if (this.myProject != null && state.myCurrentMerger.hasActions() && !state.myCurrentMerger.isTransparent() && state.myCurrentMerger.isPhysical() && state.myOriginatorReference != null) {
            this.addDocumentAsAffected(state.myOriginatorReference);
        }
        state.myOriginatorReference = null;
        state.myCurrentMerger.setAfterState(this.getCurrentState());
        state.myMerger.commandFinished(commandName2, groupId2, state.myCurrentMerger);
        UndoManagerImpl.disposeCurrentMerger(state);
    }

    public void addDocumentAsAffected(@NotNull Document document) {
        if (document == null) {
            UndoManagerImpl.$$$reportNull$$$0(2);
        }
        this.addDocumentAsAffected(DocumentReferenceManager.getInstance().create(document));
    }

    private void addDocumentAsAffected(@NotNull DocumentReference documentReference) {
        ClientState state;
        if (documentReference == null) {
            UndoManagerImpl.$$$reportNull$$$0(3);
        }
        if ((state = this.getClientState()) == null || state.myCurrentMerger.hasChangesOf(documentReference, true)) {
            return;
        }
        DocumentReference[] refs = new DocumentReference[]{documentReference};
        state.myCurrentMerger.addAction(new MentionOnlyUndoableAction(refs));
    }

    private EditorAndState getCurrentState() {
        FileEditor editor2 = this.myEditorProvider.getCurrentEditor();
        if (editor2 == null) {
            return null;
        }
        if (!editor2.isValid()) {
            return null;
        }
        return new EditorAndState(editor2, editor2.getState(FileEditorStateLevel.UNDO));
    }

    private static void disposeCurrentMerger(@NotNull ClientState state) {
        if (state == null) {
            UndoManagerImpl.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(state.myCommandLevel == 0);
        if (state.myCurrentMerger != null) {
            state.myCurrentMerger = null;
        }
    }

    public void nonundoableActionPerformed(@NotNull DocumentReference ref, boolean isGlobal) {
        if (ref == null) {
            UndoManagerImpl.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsWriteThread();
        if (this.myProject != null && this.myProject.isDisposed()) {
            return;
        }
        this.undoableActionPerformed(new NonUndoableAction(ref, isGlobal));
    }

    public void undoableActionPerformed(@NotNull UndoableAction action2) {
        ClientState state;
        if (action2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(6);
        }
        if ((state = this.getClientState()) == null) {
            return;
        }
        ApplicationManager.getApplication().assertIsWriteThread();
        if (this.myProject != null && this.myProject.isDisposed() || state.myCurrentOperationState != OperationState.NONE) {
            return;
        }
        if (state.myCommandLevel == 0) {
            LOG.assertTrue(action2 instanceof NonUndoableAction, (Object)"Undoable actions allowed inside commands only (see com.intellij.openapi.command.CommandProcessor.executeCommand())");
            this.commandStarted(UndoConfirmationPolicy.DEFAULT, false);
            state.myCurrentMerger.addAction(action2);
            this.commandFinished("", null);
            return;
        }
        if (UndoManagerImpl.isRefresh()) {
            state.myOriginatorReference = null;
        }
        state.myCurrentMerger.addAction(action2);
    }

    public void markCurrentCommandAsGlobal() {
        ClientState state = this.getClientState();
        if (state == null) {
            return;
        }
        if (state.myCurrentMerger == null) {
            LOG.error("Must be called inside command");
            return;
        }
        state.myCurrentMerger.markAsGlobal();
    }

    void addAffectedDocuments(Document ... docs) {
        ClientState state;
        if (docs == null) {
            UndoManagerImpl.$$$reportNull$$$0(7);
        }
        if ((state = this.getClientState()) == null) {
            return;
        }
        if (!this.isInsideCommand()) {
            LOG.error("Must be called inside command");
            return;
        }
        ArrayList<DocumentReference> refs = new ArrayList<DocumentReference>(docs.length);
        for (Document each : docs) {
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(each);
            if (file2 != null && !file2.isValid()) continue;
            refs.add(DocumentReferenceManager.getInstance().create(each));
        }
        state.myCurrentMerger.addAdditionalAffectedDocuments(refs);
    }

    public void addAffectedFiles(VirtualFile ... files2) {
        ClientState state;
        if (files2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(8);
        }
        if ((state = this.getClientState()) == null) {
            return;
        }
        if (!this.isInsideCommand()) {
            LOG.error("Must be called inside command");
            return;
        }
        ArrayList<DocumentReference> refs = new ArrayList<DocumentReference>(files2.length);
        for (VirtualFile each : files2) {
            refs.add(DocumentReferenceManager.getInstance().create(each));
        }
        state.myCurrentMerger.addAdditionalAffectedDocuments(refs);
    }

    public void invalidateActionsFor(@NotNull DocumentReference ref) {
        if (ref == null) {
            UndoManagerImpl.$$$reportNull$$$0(9);
        }
        for (ClientState state : this.getAllClientStates()) {
            ApplicationManager.getApplication().assertIsWriteThread();
            state.myMerger.invalidateActionsFor(ref);
            if (state.myCurrentMerger != null) {
                state.myCurrentMerger.invalidateActionsFor(ref);
            }
            state.myUndoStacksHolder.invalidateActionsFor(ref);
            state.myRedoStacksHolder.invalidateActionsFor(ref);
        }
    }

    public void undo(@Nullable FileEditor editor2) {
        ApplicationManager.getApplication().assertIsWriteThread();
        LOG.assertTrue(this.isUndoAvailable(editor2));
        this.undoOrRedo(editor2, true);
    }

    public void redo(@Nullable FileEditor editor2) {
        ApplicationManager.getApplication().assertIsWriteThread();
        LOG.assertTrue(this.isRedoAvailable(editor2));
        this.undoOrRedo(editor2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoOrRedo(FileEditor editor2, boolean isUndo) {
        ClientState state = this.getClientState();
        if (state == null) {
            return;
        }
        state.myCurrentOperationState = isUndo ? OperationState.UNDO : OperationState.REDO;
        try {
            RuntimeException[] exception = new RuntimeException[1];
            Runnable executeUndoOrRedoAction = () -> {
                try {
                    CopyPasteManager.getInstance().stopKillRings();
                    state.myMerger.undoOrRedo(editor2, isUndo);
                }
                catch (RuntimeException ex) {
                    exception[0] = ex;
                }
            };
            String name2 = (String)this.getUndoOrRedoActionNameAndDescription((FileEditor)editor2, (boolean)this.isUndoInProgress()).second;
            CommandProcessor.getInstance().executeCommand((Project)this.myProject, executeUndoOrRedoAction, name2, null, state.myMerger.getUndoConfirmationPolicy());
            if (exception[0] != null) {
                throw exception[0];
            }
        }
        finally {
            state.myCurrentOperationState = OperationState.NONE;
        }
    }

    public boolean isUndoInProgress() {
        ClientState state = this.getClientState();
        if (state == null) {
            return false;
        }
        return state.myCurrentOperationState == OperationState.UNDO;
    }

    public boolean isRedoInProgress() {
        ClientState state = this.getClientState();
        if (state == null) {
            return false;
        }
        return state.myCurrentOperationState == OperationState.REDO;
    }

    public boolean isUndoAvailable(@Nullable FileEditor editor2) {
        return this.isUndoOrRedoAvailable(editor2, true);
    }

    public boolean isRedoAvailable(@Nullable FileEditor editor2) {
        return this.isUndoOrRedoAvailable(editor2, false);
    }

    boolean isUndoOrRedoAvailable(@Nullable FileEditor editor2, boolean undo) {
        ApplicationManager.getApplication().assertIsWriteThread();
        Collection<DocumentReference> refs = UndoManagerImpl.getDocRefs(editor2);
        return refs != null && this.isUndoOrRedoAvailable(refs, undo);
    }

    boolean isUndoOrRedoAvailable(@NotNull DocumentReference ref) {
        Set<DocumentReference> refs;
        if (ref == null) {
            UndoManagerImpl.$$$reportNull$$$0(10);
        }
        return this.isUndoOrRedoAvailable(refs = Collections.singleton(ref), true) || this.isUndoOrRedoAvailable(refs, false);
    }

    public boolean splitGlobalCommand(@NotNull UndoRedo undoRedo) {
        if (undoRedo == null) {
            UndoManagerImpl.$$$reportNull$$$0(11);
        }
        UndoableGroup group2 = undoRedo.myUndoableGroup;
        Collection<DocumentReference> refs = undoRedo.getDocRefs();
        if (refs == null || refs.size() != 1) {
            return false;
        }
        DocumentReference docRef = refs.iterator().next();
        ClientState clientState = this.getClientState();
        if (clientState == null) {
            return false;
        }
        UndoRedoStacksHolder stackHolder = UndoManagerImpl.getStackHolder(clientState, true);
        LinkedList<UndoableGroup> stack = stackHolder.getStack(docRef);
        if (stack.getLast() == group2) {
            Pair<List<UndoableAction>, List<UndoableAction>> actions2 = UndoManagerImpl.separateLocalAndNonLocalActions(group2.getActions(), docRef);
            if (((List)actions2.first).isEmpty()) {
                return false;
            }
            stack.removeLast();
            UndoableGroup replacingGroup = new UndoableGroup("Local " + group2.getCommandName(), false, group2.getCommandTimestamp(), group2.getStateBefore(), group2.getStateAfter(), (List)actions2.first, stackHolder, this.getProject(), group2.getConfirmationPolicy(), group2.isTransparent(), group2.isValid());
            stack.add(replacingGroup);
            UndoableGroup groupWithoutLocalChanges = new UndoableGroup(group2.getCommandName(), group2.isGlobal(), group2.getCommandTimestamp(), group2.getStateBefore(), group2.getStateAfter(), (List)actions2.second, stackHolder, this.getProject(), group2.getConfirmationPolicy(), group2.isTransparent(), group2.isValid());
            if (stackHolder.replaceOnStacks(group2, groupWithoutLocalChanges)) {
                replacingGroup.setOriginalContext(new UndoableGroup.UndoableGroupOriginalContext(group2, groupWithoutLocalChanges));
            }
            return true;
        }
        return false;
    }

    private static Pair<List<UndoableAction>, List<UndoableAction>> separateLocalAndNonLocalActions(@NotNull List<? extends UndoableAction> actions2, @NotNull DocumentReference affectedDocument) {
        if (actions2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(12);
        }
        if (affectedDocument == null) {
            UndoManagerImpl.$$$reportNull$$$0(13);
        }
        SmartList localActions = new SmartList();
        SmartList nonLocalActions = new SmartList();
        for (UndoableAction undoableAction : actions2) {
            DocumentReference[] affectedDocuments = undoableAction.getAffectedDocuments();
            if (affectedDocuments != null && affectedDocuments.length == 1 && affectedDocuments[0].equals(affectedDocument)) {
                localActions.add((Object)undoableAction);
                continue;
            }
            nonLocalActions.add((Object)undoableAction);
        }
        return new Pair((Object)localActions, (Object)nonLocalActions);
    }

    public void gatherGlobalCommand(@NotNull UndoRedo undoRedo) {
        UndoableGroup group2;
        UndoableGroup.UndoableGroupOriginalContext context2;
        if (undoRedo == null) {
            UndoManagerImpl.$$$reportNull$$$0(14);
        }
        if ((context2 = (group2 = undoRedo.myUndoableGroup).getGroupOriginalContext()) == null) {
            return;
        }
        Collection<DocumentReference> refs = undoRedo.getDocRefs();
        if (refs.size() > 1) {
            return;
        }
        DocumentReference docRef = refs.iterator().next();
        ClientState clientState = this.getClientState();
        if (clientState == null) {
            return;
        }
        UndoRedoStacksHolder stackHolder = UndoManagerImpl.getStackHolder(clientState, true);
        LinkedList<UndoableGroup> stack = stackHolder.getStack(docRef);
        if (stack.getLast() != group2) {
            return;
        }
        boolean shouldGatherGroup = stackHolder.replaceOnStacks(context2.getCurrentStackGroup(), context2.getOriginalGroup());
        if (!shouldGatherGroup) {
            return;
        }
        stack.removeLast();
        stack.add(context2.getOriginalGroup());
    }

    private boolean isUndoOrRedoAvailable(@NotNull Collection<? extends DocumentReference> refs, boolean isUndo) {
        ClientState state;
        if (refs == null) {
            UndoManagerImpl.$$$reportNull$$$0(15);
        }
        if ((state = this.getClientState()) == null) {
            return false;
        }
        if (isUndo && state.myMerger.isUndoAvailable(refs)) {
            return true;
        }
        UndoRedoStacksHolder stackHolder = UndoManagerImpl.getStackHolder(state, isUndo);
        return stackHolder.canBeUndoneOrRedone(refs);
    }

    private static Collection<DocumentReference> getDocRefs(@Nullable FileEditor editor2) {
        if (editor2 instanceof TextEditor && ((TextEditor)editor2).getEditor().isViewer()) {
            return null;
        }
        if (editor2 == null) {
            return Collections.emptyList();
        }
        return UndoManagerImpl.getDocumentReferences(editor2);
    }

    @NotNull
    static Collection<DocumentReference> getDocumentReferences(@NotNull FileEditor editor2) {
        Document[] documents;
        if (editor2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(16);
        }
        ArrayList<DocumentReference> result2 = new ArrayList<DocumentReference>();
        if (editor2 instanceof DocumentReferenceProvider) {
            result2.addAll(((DocumentReferenceProvider)editor2).getDocumentReferences());
            ArrayList<DocumentReference> arrayList = result2;
            if (arrayList == null) {
                UndoManagerImpl.$$$reportNull$$$0(17);
            }
            return arrayList;
        }
        for (Document each : documents = TextEditorProvider.getDocuments(editor2)) {
            Document original = UndoManagerImpl.getOriginal(each);
            VirtualFile f = FileDocumentManager.getInstance().getFile(each);
            if (f != null && !f.isValid()) continue;
            result2.add(DocumentReferenceManager.getInstance().create(original));
        }
        ArrayList<DocumentReference> arrayList = result2;
        if (arrayList == null) {
            UndoManagerImpl.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    private static UndoRedoStacksHolder getStackHolder(@NotNull ClientState state, boolean isUndo) {
        if (state == null) {
            UndoManagerImpl.$$$reportNull$$$0(19);
        }
        UndoRedoStacksHolder undoRedoStacksHolder = isUndo ? state.myUndoStacksHolder : state.myRedoStacksHolder;
        if (undoRedoStacksHolder == null) {
            UndoManagerImpl.$$$reportNull$$$0(20);
        }
        return undoRedoStacksHolder;
    }

    @NotNull
    public Pair<String, String> getUndoActionNameAndDescription(FileEditor editor2) {
        return this.getUndoOrRedoActionNameAndDescription(editor2, true);
    }

    @NotNull
    public Pair<String, String> getRedoActionNameAndDescription(FileEditor editor2) {
        return this.getUndoOrRedoActionNameAndDescription(editor2, false);
    }

    private @NotNull Pair<@NlsActions.ActionText String, @NlsActions.ActionDescription String> getUndoOrRedoActionNameAndDescription(@Nullable FileEditor editor2, boolean undo) {
        String desc;
        String string = desc = this.isUndoOrRedoAvailable(editor2, undo) ? this.doFormatAvailableUndoRedoAction(editor2, undo) : null;
        if (desc == null) {
            desc = "";
        }
        String shortActionName = StringUtil.first((String)desc, (int)30, (boolean)true);
        if (desc.isEmpty()) {
            desc = undo ? ActionsBundle.message((String)"action.undo.description.empty", (Object[])new Object[0]) : ActionsBundle.message((String)"action.redo.description.empty", (Object[])new Object[0]);
        }
        Pair pair = Pair.create((Object)(undo ? ActionsBundle.message((String)"action.undo.text", (Object[])new Object[]{shortActionName}) : ActionsBundle.message((String)"action.redo.text", (Object[])new Object[]{shortActionName})).trim(), (Object)(undo ? ActionsBundle.message((String)"action.undo.description", (Object[])new Object[]{desc}) : ActionsBundle.message((String)"action.redo.description", (Object[])new Object[]{desc})).trim());
        if (pair == null) {
            UndoManagerImpl.$$$reportNull$$$0(21);
        }
        return pair;
    }

    @Nullable
    private String doFormatAvailableUndoRedoAction(FileEditor editor2, boolean isUndo) {
        ClientState state = this.getClientState();
        if (state == null) {
            return null;
        }
        Collection<DocumentReference> refs = UndoManagerImpl.getDocRefs(editor2);
        if (refs == null) {
            return null;
        }
        if (isUndo && state.myMerger.isUndoAvailable(refs)) {
            return state.myMerger.getCommandName();
        }
        return UndoManagerImpl.getStackHolder(state, isUndo).getLastAction(refs).getCommandName();
    }

    @NotNull
    SharedUndoRedoStacksHolder getSharedUndoStacksHolder() {
        SharedUndoRedoStacksHolder sharedUndoRedoStacksHolder = this.mySharedUndoStacksHolder;
        if (sharedUndoRedoStacksHolder == null) {
            UndoManagerImpl.$$$reportNull$$$0(22);
        }
        return sharedUndoRedoStacksHolder;
    }

    @NotNull
    SharedUndoRedoStacksHolder getSharedRedoStacksHolder() {
        SharedUndoRedoStacksHolder sharedUndoRedoStacksHolder = this.mySharedRedoStacksHolder;
        if (sharedUndoRedoStacksHolder == null) {
            UndoManagerImpl.$$$reportNull$$$0(23);
        }
        return sharedUndoRedoStacksHolder;
    }

    @NotNull
    UndoRedoStacksHolder getUndoStacksHolder() {
        ClientState state = this.getClientState();
        LOG.assertTrue(state != null);
        UndoRedoStacksHolder undoRedoStacksHolder = state.myUndoStacksHolder;
        if (undoRedoStacksHolder == null) {
            UndoManagerImpl.$$$reportNull$$$0(24);
        }
        return undoRedoStacksHolder;
    }

    @NotNull
    UndoRedoStacksHolder getRedoStacksHolder() {
        ClientState state = this.getClientState();
        LOG.assertTrue(state != null);
        UndoRedoStacksHolder undoRedoStacksHolder = state.myRedoStacksHolder;
        if (undoRedoStacksHolder == null) {
            UndoManagerImpl.$$$reportNull$$$0(25);
        }
        return undoRedoStacksHolder;
    }

    int nextCommandTimestamp() {
        ClientState state = this.getClientState();
        LOG.assertTrue(state != null);
        return state.nextCommandTimestamp();
    }

    @NotNull
    private static Document getOriginal(@NotNull Document document) {
        Document result2;
        if (document == null) {
            UndoManagerImpl.$$$reportNull$$$0(26);
        }
        Document document2 = (result2 = (Document)document.getUserData(ORIGINAL_DOCUMENT)) == null ? document : result2;
        if (document2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(27);
        }
        return document2;
    }

    static boolean isCopy(@NotNull Document d) {
        if (d == null) {
            UndoManagerImpl.$$$reportNull$$$0(28);
        }
        return d.getUserData(ORIGINAL_DOCUMENT) != null;
    }

    protected void compact() {
        ClientState state = this.getClientState();
        if (state != null && state.myCurrentOperationState == OperationState.NONE && state.myCommandTimestamp % 20 == 0) {
            this.doCompact(state);
        }
    }

    private void doCompact(@NotNull ClientState state) {
        DocumentReference each;
        if (state == null) {
            UndoManagerImpl.$$$reportNull$$$0(29);
        }
        Collection<DocumentReference> refs = UndoManagerImpl.collectReferencesWithoutMergers(state);
        HashSet<DocumentReference> openDocs = new HashSet<DocumentReference>();
        for (DocumentReference each2 : refs) {
            VirtualFile file2 = each2.getFile();
            if (file2 == null) {
                Document document = each2.getDocument();
                if (document == null || !EditorFactory.getInstance().editors(document, (Project)this.myProject).findFirst().isPresent()) continue;
                openDocs.add(each2);
                continue;
            }
            if (this.myProject == null || !FileEditorManager.getInstance((Project)this.myProject).isFileOpen(file2)) continue;
            openDocs.add(each2);
        }
        refs.removeAll(openDocs);
        if (refs.size() <= 30) {
            return;
        }
        DocumentReference[] backSorted = refs.toArray(DocumentReference.EMPTY_ARRAY);
        Arrays.sort(backSorted, Comparator.comparingInt(ref -> UndoManagerImpl.getLastCommandTimestamp(state, ref)));
        for (int i2 = 0; i2 < backSorted.length - 30 && UndoManagerImpl.getLastCommandTimestamp(state, each = backSorted[i2]) + 100 <= state.myCommandTimestamp; ++i2) {
            this.clearUndoRedoQueue(state, each);
        }
    }

    private static int getLastCommandTimestamp(@NotNull ClientState state, @NotNull DocumentReference ref) {
        if (state == null) {
            UndoManagerImpl.$$$reportNull$$$0(30);
        }
        if (ref == null) {
            UndoManagerImpl.$$$reportNull$$$0(31);
        }
        return Math.max(state.myUndoStacksHolder.getLastCommandTimestamp(ref), state.myRedoStacksHolder.getLastCommandTimestamp(ref));
    }

    @NotNull
    private static Collection<DocumentReference> collectReferencesWithoutMergers(@NotNull ClientState state) {
        if (state == null) {
            UndoManagerImpl.$$$reportNull$$$0(32);
        }
        HashSet<DocumentReference> result2 = new HashSet<DocumentReference>();
        state.myUndoStacksHolder.collectAllAffectedDocuments(result2);
        state.myRedoStacksHolder.collectAllAffectedDocuments(result2);
        HashSet<DocumentReference> hashSet = result2;
        if (hashSet == null) {
            UndoManagerImpl.$$$reportNull$$$0(33);
        }
        return hashSet;
    }

    private void clearUndoRedoQueue(@NotNull ClientState state, @NotNull DocumentReference docRef) {
        if (state == null) {
            UndoManagerImpl.$$$reportNull$$$0(34);
        }
        if (docRef == null) {
            UndoManagerImpl.$$$reportNull$$$0(35);
        }
        state.myMerger.flushCurrentCommand();
        UndoManagerImpl.disposeCurrentMerger(state);
        Set<DocumentReference> set2 = Collections.singleton(docRef);
        state.myUndoStacksHolder.clearStacks(false, set2);
        state.myRedoStacksHolder.clearStacks(false, set2);
        this.mySharedUndoStacksHolder.trimStacks(set2);
        this.mySharedRedoStacksHolder.trimStacks(set2);
    }

    @TestOnly
    public void setEditorProvider(@NotNull CurrentEditorProvider p) {
        if (p == null) {
            UndoManagerImpl.$$$reportNull$$$0(36);
        }
        this.myEditorProvider = p;
    }

    @TestOnly
    @NotNull
    public CurrentEditorProvider getEditorProvider() {
        CurrentEditorProvider currentEditorProvider = this.myEditorProvider;
        if (currentEditorProvider == null) {
            UndoManagerImpl.$$$reportNull$$$0(37);
        }
        return currentEditorProvider;
    }

    @TestOnly
    public void dropHistoryInTests() {
        ClientState state = this.getClientState();
        if (state == null) {
            return;
        }
        this.flushMergers();
        LOG.assertTrue(state.myCommandLevel == 0, (Object)state.myCommandLevel);
        state.myUndoStacksHolder.clearAllStacksInTests();
        state.myRedoStacksHolder.clearAllStacksInTests();
    }

    @TestOnly
    private void flushMergers() {
        assert (this.myProject == null || !this.myProject.isDisposed()) : this.myProject;
        CommandProcessor.getInstance().executeCommand((Project)this.myProject, EmptyRunnable.getInstance(), "Dummy", null);
    }

    @TestOnly
    public void flushCurrentCommandMerger() {
        ClientState state = this.getClientState();
        if (state == null) {
            return;
        }
        state.myMerger.flushCurrentCommand();
    }

    @TestOnly
    public void clearUndoRedoQueueInTests(@NotNull VirtualFile file2) {
        ClientState state;
        if (file2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(38);
        }
        if ((state = this.getClientState()) == null) {
            return;
        }
        this.clearUndoRedoQueue(state, DocumentReferenceManager.getInstance().create(file2));
    }

    @TestOnly
    public void clearUndoRedoQueueInTests(@NotNull Document document) {
        ClientState state;
        if (document == null) {
            UndoManagerImpl.$$$reportNull$$$0(39);
        }
        if ((state = this.getClientState()) == null) {
            return;
        }
        this.clearUndoRedoQueue(state, DocumentReferenceManager.getInstance().create(document));
    }

    @ApiStatus.Internal
    public void clearDocumentReferences(@NotNull Document document) {
        if (document == null) {
            UndoManagerImpl.$$$reportNull$$$0(40);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (ClientState state : this.getAllClientStates()) {
            state.myUndoStacksHolder.clearDocumentReferences(document);
            state.myRedoStacksHolder.clearDocumentReferences(document);
            state.myMerger.clearDocumentReferences(document);
        }
        this.mySharedUndoStacksHolder.clearDocumentReferences(document);
        this.mySharedRedoStacksHolder.clearDocumentReferences(document);
    }

    public String toString() {
        return "UndoManager for " + ObjectUtils.notNull((Object)this.myProject, (Object)"application");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 33: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 33: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoManagerImpl";
                break;
            }
            case 2: 
            case 26: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentReference";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoRedo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedDocument";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docRef";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoProviders";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentReferences";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackHolder";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoOrRedoActionNameAndDescription";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedUndoStacksHolder";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedRedoStacksHolder";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoStacksHolder";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedoStacksHolder";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginal";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReferencesWithoutMergers";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 1: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 33: 
            case 37: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentAsAffected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "disposeCurrentMerger";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "nonundoableActionPerformed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "undoableActionPerformed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAffectedDocuments";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addAffectedFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invalidateActionsFor";
                break;
            }
            case 10: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isUndoOrRedoAvailable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "splitGlobalCommand";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "separateLocalAndNonLocalActions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "gatherGlobalCommand";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentReferences";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStackHolder";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getOriginal";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isCopy";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doCompact";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommandTimestamp";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "collectReferencesWithoutMergers";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "clearUndoRedoQueue";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setEditorProvider";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "clearUndoRedoQueueInTests";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "clearDocumentReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 33: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum OperationState {
        NONE,
        UNDO,
        REDO;

    }

    public static class ClientState
    implements Disposable {
        private final UndoRedoStacksHolder myUndoStacksHolder;
        private final UndoRedoStacksHolder myRedoStacksHolder;
        private final CommandMerger myMerger;
        private final UndoManagerImpl myManager;
        private CommandMerger myCurrentMerger;
        private Project myCurrentActionProject;
        private int myCommandTimestamp;
        private int myCommandLevel;
        private OperationState myCurrentOperationState;
        private DocumentReference myOriginatorReference;

        private ClientState() {
            this.myUndoStacksHolder = new UndoRedoStacksHolder(true);
            this.myRedoStacksHolder = new UndoRedoStacksHolder(false);
            this.myCurrentActionProject = DummyProject.getInstance();
            this.myCommandTimestamp = 1;
            this.myCurrentOperationState = OperationState.NONE;
            this.myManager = ClientState.getUndoManager((ComponentManager)ApplicationManager.getApplication());
            this.myMerger = new CommandMerger(this.myManager);
        }

        private ClientState(@NotNull Project project) {
            if (project == null) {
                ClientState.$$$reportNull$$$0(0);
            }
            this.myUndoStacksHolder = new UndoRedoStacksHolder(true);
            this.myRedoStacksHolder = new UndoRedoStacksHolder(false);
            this.myCurrentActionProject = DummyProject.getInstance();
            this.myCommandTimestamp = 1;
            this.myCurrentOperationState = OperationState.NONE;
            this.myManager = ClientState.getUndoManager((ComponentManager)project);
            this.myMerger = new CommandMerger(this.myManager);
        }

        @NotNull
        private static UndoManagerImpl getUndoManager(@NotNull ComponentManager manager2) {
            if (manager2 == null) {
                ClientState.$$$reportNull$$$0(1);
            }
            UndoManagerImpl undoManagerImpl = (UndoManagerImpl)((Object)manager2.getComponent(UndoManager.class));
            if (undoManagerImpl == null) {
                ClientState.$$$reportNull$$$0(2);
            }
            return undoManagerImpl;
        }

        private int nextCommandTimestamp() {
            return ++this.myCommandTimestamp;
        }

        public void dispose() {
            this.myManager.invalidate(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/command/impl/UndoManagerImpl$ClientState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/command/impl/UndoManagerImpl$ClientState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUndoManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUndoManager";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

