/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.Strings;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DirectoryStorageUtil {
    private static final Logger LOG = Logger.getInstance(DirectoryStorageUtil.class);

    /*
     * Loose catch block
     */
    @NotNull
    public static Map<String, Element> loadFrom(@NotNull Path dir, @Nullable PathMacroSubstitutor pathMacroSubstitutor) throws IOException {
        HashMap<String, Element> hashMap;
        DirectoryStream<Path> files2;
        block18: {
            if (dir == null) {
                DirectoryStorageUtil.$$$reportNull$$$0(0);
            }
            files2 = Files.newDirectoryStream(dir);
            HashMap<String, Element> fileToState = new HashMap<String, Element>();
            for (Path file2 : files2) {
                if (!Strings.endsWithIgnoreCase((CharSequence)file2.toString(), (String)".xml")) continue;
                try {
                    Element state;
                    if (Files.size(file2) == 0L) {
                        LOG.warn("Ignore empty file " + file2);
                        continue;
                    }
                    Element element2 = JDOMUtil.load((Path)file2);
                    String componentName = FileStorageCoreUtil.getComponentNameIfValid(element2);
                    if (componentName == null) continue;
                    if (!element2.getName().equals("component")) {
                        LOG.error("Incorrect root tag name (" + element2.getName() + ") in " + file2);
                        continue;
                    }
                    List elementChildren = element2.getChildren();
                    if (elementChildren.isEmpty() || JDOMUtil.isEmpty((Element)(state = ((Element)elementChildren.get(0)).detach()))) continue;
                    if (pathMacroSubstitutor != null) {
                        pathMacroSubstitutor.expandPaths(state);
                        if (pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor) {
                            ((TrackingPathMacroSubstitutor)pathMacroSubstitutor).addUnknownMacros(componentName, PathMacrosCollector.getMacroNames(state));
                        }
                    }
                    fileToState.put(file2.getFileName().toString(), state);
                }
                catch (Throwable e) {
                    LOG.warn("Unable to load state from " + file2, e);
                }
            }
            hashMap = fileToState;
            if (files2 == null) break block18;
            files2.close();
        }
        Object object = hashMap;
        if (object == null) {
            DirectoryStorageUtil.$$$reportNull$$$0(1);
        }
        return object;
        {
            catch (Throwable throwable) {
                try {
                    if (files2 != null) {
                        try {
                            files2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException | NotDirectoryException ignore) {
                    Map<String, Element> map2 = Collections.emptyMap();
                    if (map2 == null) {
                        DirectoryStorageUtil.$$$reportNull$$$0(2);
                    }
                    return map2;
                }
            }
        }
    }

    @Nullable
    public static Element getCompositeState(@NotNull Map<String, Element> fileToState, @NotNull StateSplitterEx splitter2) {
        if (fileToState == null) {
            DirectoryStorageUtil.$$$reportNull$$$0(3);
        }
        if (splitter2 == null) {
            DirectoryStorageUtil.$$$reportNull$$$0(4);
        }
        Element state = new Element("component");
        if (fileToState.isEmpty()) {
            return state;
        }
        for (String fileName : fileToState.keySet()) {
            Element subState = fileToState.get(fileName);
            if (subState == null) {
                return null;
            }
            splitter2.mergeStateInto(state, subState);
        }
        return state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/stores/DirectoryStorageUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/stores/DirectoryStorageUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadFrom";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCompositeState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

