/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.lib.base85xjava.Base85x;
import com.intellij.openapi.vcs.VcsBundle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterInputStream;
import java.util.zip.Inflater;
import org.jetbrains.annotations.NotNull;

public final class BinaryEncoder {
    private static char getCharForLineSize(int lineSize) throws BinaryPatchException, Base85x.Base85FormatException {
        BinaryEncoder.checkLenIsValid(lineSize, VcsBundle.message((String)"patch.binary.decoder.line.error", (Object[])new Object[0]));
        return Base85x.encodeChar(Base85x.decodeChar('A') + lineSize - 1);
    }

    private static int getLineSizeFromChar(char charSize) throws BinaryPatchException, Base85x.Base85FormatException {
        int result2 = Base85x.decodeChar(charSize) - Base85x.decodeChar('A') + 1;
        BinaryEncoder.checkLenIsValid(result2, VcsBundle.message((String)"patch.binary.decoder.char.error", (Object[])new Object[0]));
        return result2;
    }

    private static void checkLenIsValid(int len, @NotNull String errorMessage) throws BinaryPatchException {
        if (errorMessage == null) {
            BinaryEncoder.$$$reportNull$$$0(0);
        }
        if (len < 0 || len > 52) {
            throw new BinaryPatchException(errorMessage);
        }
    }

    public static void encode(@NotNull InputStream input, @NotNull Writer writer) throws IOException, BinaryPatchException {
        if (input == null) {
            BinaryEncoder.$$$reportNull$$$0(1);
        }
        if (writer == null) {
            BinaryEncoder.$$$reportNull$$$0(2);
        }
        int maxLineSize = 52;
        byte[] deflated = new byte[maxLineSize];
        try (DeflaterInputStream deflaterStream = new DeflaterInputStream(input);){
            int lineSize;
            while ((lineSize = deflaterStream.read(deflated, 0, maxLineSize)) > 0) {
                writer.append(BinaryEncoder.getCharForLineSize(lineSize));
                int newSize = (lineSize + 3) / 4 * 4;
                Arrays.fill(deflated, lineSize, newSize, (byte)0);
                writer.append(new String(Base85x.encode(deflated, newSize)));
                writer.append('\n');
            }
        }
        catch (Base85x.Base85FormatException e) {
            throw new BinaryPatchException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void decode(@NotNull ListIterator<String> input, long size, @NotNull ByteArrayOutputStream byteArrayOutputStream) throws BinaryPatchException {
        if (input == null) {
            BinaryEncoder.$$$reportNull$$$0(3);
        }
        if (byteArrayOutputStream == null) {
            BinaryEncoder.$$$reportNull$$$0(4);
        }
        Inflater inflater = new Inflater();
        byte[] inflated = new byte[1024];
        try {
            int count;
            void output2;
            String line = input.next();
            while (line != null && line.length() > 0) {
                int len = BinaryEncoder.getLineSizeFromChar(line.charAt(0));
                byte[] toInflate = Base85x.decode(line.substring(1));
                inflater.setInput(toInflate, 0, len);
                while (!inflater.needsInput()) {
                    int resultLength;
                    try {
                        resultLength = inflater.inflate(inflated);
                    }
                    catch (DataFormatException e) {
                        throw new BinaryPatchException(VcsBundle.message((String)"patch.binary.decoder.decompress.error", (Object[])new Object[0]));
                    }
                    output2.write(inflated, 0, resultLength);
                }
                if (!input.hasNext()) break;
                line = input.next();
            }
            if ((long)(count = output2.size()) != size) {
                throw new BinaryPatchException(VcsBundle.message((String)"patch.binary.decoder.content.error", (Object[])new Object[]{size > (long)count ? 0 : 1}));
            }
        }
        catch (Base85x.Base85FormatException e) {
            throw new BinaryPatchException(e);
        }
        finally {
            inflater.end();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/patch/BinaryEncoder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLenIsValid";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "encode";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "decode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class BinaryPatchException
    extends Exception {
        BinaryPatchException(String s) {
            super(s);
        }

        BinaryPatchException(Base85x.Base85FormatException e) {
            this(e.getMessage());
        }
    }
}

