/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.diff.util.Side;
import com.intellij.openapi.diff.impl.patch.AirContentRevision;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextPatchBuilder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.ex.PartialCommitHelper;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeaTextPatchBuilder {
    private IdeaTextPatchBuilder() {
    }

    private static List<BeforeAfter<AirContentRevision>> revisionsConvertor(@NotNull Project project, @NotNull List<? extends Change> changes, boolean honorExcludedFromCommit) {
        if (project == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(1);
        }
        ArrayList<BeforeAfter<AirContentRevision>> result2 = new ArrayList<BeforeAfter<AirContentRevision>>(changes.size());
        IdeaTextPatchBuilder.addConvertChanges(project, changes, result2, honorExcludedFromCommit);
        return result2;
    }

    private static void addConvertChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes, @NotNull List<? super BeforeAfter<AirContentRevision>> result2, boolean honorExcludedFromCommit) {
        if (project == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(2);
        }
        if (changes == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(4);
        }
        List<Change> otherChanges = PartialChangesUtil.processPartialChanges(project, changes, false, (PairFunction<? super List<ChangeListChange>, ? super PartialLocalLineStatusTracker, Boolean>)((PairFunction)(partialChanges, tracker2) -> {
            if (!tracker2.hasPartialChangesToCommit()) {
                return false;
            }
            List changelistIds = ContainerUtil.map((Collection)partialChanges, ChangeListChange::getChangeListId);
            Change change = ((ChangeListChange)partialChanges.get(0)).getChange();
            PartialCommitHelper helper2 = tracker2.handlePartialCommit(Side.LEFT, changelistIds, honorExcludedFromCommit);
            String actualText = helper2.getContent();
            result2.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevision(change.getBeforeRevision(), null), (Object)IdeaTextPatchBuilder.convertRevision(change.getAfterRevision(), actualText)));
            return true;
        }));
        for (Change change : otherChanges) {
            result2.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevision(change.getBeforeRevision(), null), (Object)IdeaTextPatchBuilder.convertRevision(change.getAfterRevision(), null)));
        }
    }

    @NotNull
    public static List<FilePatch> buildPatch(Project project, @NotNull Collection<? extends Change> changes, @NotNull String basePath, boolean reversePatch) throws VcsException {
        if (changes == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(5);
        }
        if (basePath == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(6);
        }
        return IdeaTextPatchBuilder.buildPatch(project, changes, Paths.get(basePath, new String[0]), reversePatch, false);
    }

    @NotNull
    public static List<FilePatch> buildPatch(Project project, @NotNull Collection<? extends Change> changes, @NotNull Path basePath, boolean reversePatch) throws VcsException {
        if (changes == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(7);
        }
        if (basePath == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(8);
        }
        return IdeaTextPatchBuilder.buildPatch(project, changes, basePath, reversePatch, false);
    }

    @NotNull
    public static List<FilePatch> buildPatch(@Nullable Project project, @NotNull Collection<? extends Change> changes, @NotNull Path basePath, boolean reversePatch, boolean honorExcludedFromCommit) throws VcsException {
        ArrayList<BeforeAfter<AirContentRevision>> revisions;
        if (changes == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(9);
        }
        if (basePath == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(10);
        }
        if (project != null) {
            revisions = IdeaTextPatchBuilder.revisionsConvertor(project, new ArrayList<Change>(changes), honorExcludedFromCommit);
        } else {
            revisions = new ArrayList(changes.size());
            for (Change change : changes) {
                revisions.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevision(change.getBeforeRevision()), (Object)IdeaTextPatchBuilder.convertRevision(change.getAfterRevision())));
            }
        }
        List<FilePatch> list2 = TextPatchBuilder.buildPatch(revisions, basePath, reversePatch, () -> ProgressManager.checkCanceled());
        if (list2 == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Nullable
    private static AirContentRevision convertRevision(@Nullable ContentRevision cr) {
        return IdeaTextPatchBuilder.convertRevision(cr, null);
    }

    @Nullable
    private static AirContentRevision convertRevision(@Nullable ContentRevision cr, @Nullable String actualTextContent) {
        if (cr == null) {
            return null;
        }
        FilePath filePath = cr.getFile();
        if (actualTextContent != null) {
            return new PartialTextAirContentRevision(actualTextContent, cr, filePath);
        }
        if (cr instanceof BinaryContentRevision) {
            return new BinaryAirContentRevision((BinaryContentRevision)cr, filePath);
        }
        return new TextAirContentRevision(cr, filePath);
    }

    @Nullable
    private static Long getRevisionTimestamp(@NotNull ContentRevision revision) {
        if (revision == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(12);
        }
        if (revision instanceof CurrentContentRevision) {
            try {
                FilePath filePath = revision.getFile();
                Path path2 = filePath.getIOFile().toPath();
                return Files.getLastModifiedTime(path2, new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "revisionsConvertor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addConvertChanges";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildPatch";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionTimestamp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PartialTextAirContentRevision
    extends TextAirContentRevision {
        @NotNull
        private final String myContent;

        PartialTextAirContentRevision(@NotNull String content2, @NotNull ContentRevision delegateRevision, @NotNull FilePath filePath) {
            if (content2 == null) {
                PartialTextAirContentRevision.$$$reportNull$$$0(0);
            }
            if (delegateRevision == null) {
                PartialTextAirContentRevision.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                PartialTextAirContentRevision.$$$reportNull$$$0(2);
            }
            super(delegateRevision, filePath);
            this.myContent = content2;
        }

        @Override
        public String getContentAsString() {
            return this.myContent;
        }

        @Override
        public byte[] getContentAsBytes() {
            return this.myContent.getBytes(this.getCharset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "content";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "delegateRevision";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$PartialTextAirContentRevision";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TextAirContentRevision
    implements AirContentRevision {
        @NotNull
        private final ContentRevision myRevision;
        @NotNull
        private final FilePath myFilePath;

        TextAirContentRevision(@NotNull ContentRevision revision, @NotNull FilePath filePath) {
            if (revision == null) {
                TextAirContentRevision.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                TextAirContentRevision.$$$reportNull$$$0(1);
            }
            this.myRevision = revision;
            this.myFilePath = filePath;
        }

        public boolean isBinary() {
            return false;
        }

        public String getContentAsString() throws VcsException {
            return this.myRevision.getContent();
        }

        public byte[] getContentAsBytes() throws VcsException {
            return ChangesUtil.loadContentRevision((ContentRevision)this.myRevision);
        }

        public String getRevisionNumber() {
            return this.myRevision.getRevisionNumber().asString();
        }

        @Nullable
        public Long getLastModifiedTimestamp() {
            return IdeaTextPatchBuilder.getRevisionTimestamp(this.myRevision);
        }

        @NotNull
        public FilePath getPath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                TextAirContentRevision.$$$reportNull$$$0(2);
            }
            return filePath;
        }

        @NotNull
        public Charset getCharset() {
            Charset charset = this.myRevision.getFile().getCharset();
            if (charset == null) {
                TextAirContentRevision.$$$reportNull$$$0(3);
            }
            return charset;
        }

        @Nullable
        public String getLineSeparator() {
            VirtualFile virtualFile2 = this.myRevision.getFile().getVirtualFile();
            return virtualFile2 != null ? virtualFile2.getDetectedLineSeparator() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$TextAirContentRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$TextAirContentRevision";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCharset";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class BinaryAirContentRevision
    implements AirContentRevision {
        @NotNull
        private final BinaryContentRevision myRevision;
        @NotNull
        private final FilePath myFilePath;

        BinaryAirContentRevision(@NotNull BinaryContentRevision revision, @NotNull FilePath filePath) {
            if (revision == null) {
                BinaryAirContentRevision.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                BinaryAirContentRevision.$$$reportNull$$$0(1);
            }
            this.myRevision = revision;
            this.myFilePath = filePath;
        }

        public boolean isBinary() {
            return true;
        }

        public String getContentAsString() {
            throw new IllegalStateException();
        }

        public byte[] getContentAsBytes() throws VcsException {
            return this.myRevision.getBinaryContent();
        }

        public String getRevisionNumber() {
            return this.myRevision.getRevisionNumber().asString();
        }

        @Nullable
        public Long getLastModifiedTimestamp() {
            return IdeaTextPatchBuilder.getRevisionTimestamp((ContentRevision)this.myRevision);
        }

        @NotNull
        public FilePath getPath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                BinaryAirContentRevision.$$$reportNull$$$0(2);
            }
            return filePath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$BinaryAirContentRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$BinaryAirContentRevision";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

